import os
import errno


LINK_FILE_TEMPLATE = """# Generated by LEAPP
[Match]
MACAddress={}

[Link]
Name={}
"""


def generate_link_file(interface):
    try:
        os.makedirs('/etc/systemd/network')
    except OSError as e:
        if e.errno != errno.EEXIST:
            raise

    link_file = '/etc/systemd/network/10-leapp-{}.link'.format(interface.name)
    with open(link_file, 'w') as f:
        f.write(LINK_FILE_TEMPLATE.format(interface.mac, interface.name))

    return link_file
