/*
  Copyright (C) 2013 Rocky Bernstein <rocky@gnu.org>
  Copyright (C) 2013 Pete Batard <pete@akeo.ie>

  This program is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

/* Tests reading UDF info from an UDF image.  */

#define UDF_IMAGE "/src/external-vcs/savannah/libcdio/test/data/udf102.iso"

#ifdef HAVE_CONFIG_H
#include "config.h"
#define __CDIO_CONFIG_H__ 1
#endif

#ifdef HAVE_STDIO_H
#include <stdio.h>
#endif
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif

#include <cdio/cdio.h>
#include <cdio/udf.h>

int
main(int argc, const char *argv[])
{
  char const *psz_fname = UDF_IMAGE;
  char volume_id[192];         /* 3*64 to account for UTF-8 */
  udf_t* p_udf = NULL;
  udf_dirent_t* p_udf_root;

  p_udf = udf_open(psz_fname);

  if (NULL == p_udf) {
    fprintf(stderr, "Sorry, couldn't open %s as an UDF image\n",
      psz_fname);
    return 1;
  }

  p_udf_root = udf_get_root(p_udf, true, 0);
  if (NULL == p_udf_root) {
    fprintf(stderr, "Could not locate UDF root directory\n");
    return 2;
  }

  if (udf_get_logical_volume_id(p_udf, volume_id, sizeof(volume_id)) <= 0) {
    fprintf(stderr, "UDF image %s has no logical volume ID\n",
      psz_fname);
    return 3;
  }
  printf("-- Volume id: %s\n", volume_id);

  udf_close(p_udf);

  return 0;
}
