/* sorted-bigram-language-model.c generated by valac 0.20.1.19-a6516, the Vala compiler
 * generated from sorted-bigram-language-model.vala, do not modify */

/*
 * Copyright (C) 2012-2013 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2012-2013 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <float.h>
#include <math.h>
#include <marisa-glib/marisa-glib.h>


#define KKC_TYPE_LANGUAGE_MODEL (kkc_language_model_get_type ())
#define KKC_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_LANGUAGE_MODEL, KkcLanguageModel))
#define KKC_LANGUAGE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_LANGUAGE_MODEL, KkcLanguageModelClass))
#define KKC_IS_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_LANGUAGE_MODEL))
#define KKC_IS_LANGUAGE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_LANGUAGE_MODEL))
#define KKC_LANGUAGE_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_LANGUAGE_MODEL, KkcLanguageModelClass))

typedef struct _KkcLanguageModel KkcLanguageModel;
typedef struct _KkcLanguageModelClass KkcLanguageModelClass;
typedef struct _KkcLanguageModelPrivate KkcLanguageModelPrivate;

#define KKC_TYPE_LANGUAGE_MODEL_ENTRY (kkc_language_model_entry_get_type ())
typedef struct _KkcLanguageModelEntry KkcLanguageModelEntry;

#define KKC_TYPE_UNIGRAM_LANGUAGE_MODEL (kkc_unigram_language_model_get_type ())
#define KKC_UNIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_UNIGRAM_LANGUAGE_MODEL, KkcUnigramLanguageModel))
#define KKC_IS_UNIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_UNIGRAM_LANGUAGE_MODEL))
#define KKC_UNIGRAM_LANGUAGE_MODEL_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), KKC_TYPE_UNIGRAM_LANGUAGE_MODEL, KkcUnigramLanguageModelIface))

typedef struct _KkcUnigramLanguageModel KkcUnigramLanguageModel;
typedef struct _KkcUnigramLanguageModelIface KkcUnigramLanguageModelIface;

#define KKC_TYPE_BIGRAM_LANGUAGE_MODEL (kkc_bigram_language_model_get_type ())
#define KKC_BIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_BIGRAM_LANGUAGE_MODEL, KkcBigramLanguageModel))
#define KKC_IS_BIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_BIGRAM_LANGUAGE_MODEL))
#define KKC_BIGRAM_LANGUAGE_MODEL_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), KKC_TYPE_BIGRAM_LANGUAGE_MODEL, KkcBigramLanguageModelIface))

typedef struct _KkcBigramLanguageModel KkcBigramLanguageModel;
typedef struct _KkcBigramLanguageModelIface KkcBigramLanguageModelIface;

#define KKC_TYPE_SORTED_BIGRAM_LANGUAGE_MODEL (kkc_sorted_bigram_language_model_get_type ())
#define KKC_SORTED_BIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_SORTED_BIGRAM_LANGUAGE_MODEL, KkcSortedBigramLanguageModel))
#define KKC_SORTED_BIGRAM_LANGUAGE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_SORTED_BIGRAM_LANGUAGE_MODEL, KkcSortedBigramLanguageModelClass))
#define KKC_IS_SORTED_BIGRAM_LANGUAGE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_SORTED_BIGRAM_LANGUAGE_MODEL))
#define KKC_IS_SORTED_BIGRAM_LANGUAGE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_SORTED_BIGRAM_LANGUAGE_MODEL))
#define KKC_SORTED_BIGRAM_LANGUAGE_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_SORTED_BIGRAM_LANGUAGE_MODEL, KkcSortedBigramLanguageModelClass))

typedef struct _KkcSortedBigramLanguageModel KkcSortedBigramLanguageModel;
typedef struct _KkcSortedBigramLanguageModelClass KkcSortedBigramLanguageModelClass;
typedef struct _KkcSortedBigramLanguageModelPrivate KkcSortedBigramLanguageModelPrivate;

#define KKC_TYPE_INDEX_FILE (kkc_index_file_get_type ())
#define KKC_INDEX_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_INDEX_FILE, KkcIndexFile))
#define KKC_IS_INDEX_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_INDEX_FILE))
#define KKC_INDEX_FILE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), KKC_TYPE_INDEX_FILE, KkcIndexFileIface))

typedef struct _KkcIndexFile KkcIndexFile;
typedef struct _KkcIndexFileIface KkcIndexFileIface;

#define KKC_TYPE_BLOOM_FILTER (kkc_bloom_filter_get_type ())
#define KKC_BLOOM_FILTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_BLOOM_FILTER, KkcBloomFilter))
#define KKC_BLOOM_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_BLOOM_FILTER, KkcBloomFilterClass))
#define KKC_IS_BLOOM_FILTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_BLOOM_FILTER))
#define KKC_IS_BLOOM_FILTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_BLOOM_FILTER))
#define KKC_BLOOM_FILTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_BLOOM_FILTER, KkcBloomFilterClass))

typedef struct _KkcBloomFilter KkcBloomFilter;
typedef struct _KkcBloomFilterClass KkcBloomFilterClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define KKC_TYPE_METADATA_FILE (kkc_metadata_file_get_type ())
#define KKC_METADATA_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_METADATA_FILE, KkcMetadataFile))
#define KKC_METADATA_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_METADATA_FILE, KkcMetadataFileClass))
#define KKC_IS_METADATA_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_METADATA_FILE))
#define KKC_IS_METADATA_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_METADATA_FILE))
#define KKC_METADATA_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_METADATA_FILE, KkcMetadataFileClass))

typedef struct _KkcMetadataFile KkcMetadataFile;
typedef struct _KkcMetadataFileClass KkcMetadataFileClass;

#define KKC_TYPE_LANGUAGE_MODEL_METADATA (kkc_language_model_metadata_get_type ())
#define KKC_LANGUAGE_MODEL_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_LANGUAGE_MODEL_METADATA, KkcLanguageModelMetadata))
#define KKC_LANGUAGE_MODEL_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_LANGUAGE_MODEL_METADATA, KkcLanguageModelMetadataClass))
#define KKC_IS_LANGUAGE_MODEL_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_LANGUAGE_MODEL_METADATA))
#define KKC_IS_LANGUAGE_MODEL_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_LANGUAGE_MODEL_METADATA))
#define KKC_LANGUAGE_MODEL_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_LANGUAGE_MODEL_METADATA, KkcLanguageModelMetadataClass))

typedef struct _KkcLanguageModelMetadata KkcLanguageModelMetadata;
typedef struct _KkcLanguageModelMetadataClass KkcLanguageModelMetadataClass;

#define KKC_TYPE_MAPPED_INDEX_FILE (kkc_mapped_index_file_get_type ())
#define KKC_MAPPED_INDEX_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_MAPPED_INDEX_FILE, KkcMappedIndexFile))
#define KKC_MAPPED_INDEX_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_MAPPED_INDEX_FILE, KkcMappedIndexFileClass))
#define KKC_IS_MAPPED_INDEX_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_MAPPED_INDEX_FILE))
#define KKC_IS_MAPPED_INDEX_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_MAPPED_INDEX_FILE))
#define KKC_MAPPED_INDEX_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_MAPPED_INDEX_FILE, KkcMappedIndexFileClass))

typedef struct _KkcMappedIndexFile KkcMappedIndexFile;
typedef struct _KkcMappedIndexFileClass KkcMappedIndexFileClass;

#define KKC_TYPE_LOADED_INDEX_FILE (kkc_loaded_index_file_get_type ())
#define KKC_LOADED_INDEX_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_LOADED_INDEX_FILE, KkcLoadedIndexFile))
#define KKC_LOADED_INDEX_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_LOADED_INDEX_FILE, KkcLoadedIndexFileClass))
#define KKC_IS_LOADED_INDEX_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_LOADED_INDEX_FILE))
#define KKC_IS_LOADED_INDEX_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_LOADED_INDEX_FILE))
#define KKC_LOADED_INDEX_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_LOADED_INDEX_FILE, KkcLoadedIndexFileClass))

typedef struct _KkcLoadedIndexFile KkcLoadedIndexFile;
typedef struct _KkcLoadedIndexFileClass KkcLoadedIndexFileClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _kkc_language_model_entry_free0(var) ((var == NULL) ? NULL : (var = (kkc_language_model_entry_free (var), NULL)))

struct _KkcLanguageModelEntry {
	gchar* input;
	gchar* output;
	guint id;
};

struct _KkcLanguageModel {
	GObject parent_instance;
	KkcLanguageModelPrivate * priv;
};

struct _KkcLanguageModelClass {
	GObjectClass parent_class;
	GeeCollection* (*unigram_entries) (KkcLanguageModel* self, const gchar* input);
	GeeCollection* (*entries) (KkcLanguageModel* self, const gchar* input);
	KkcLanguageModelEntry* (*get) (KkcLanguageModel* self, const gchar* input, const gchar* output);
	gboolean (*parse) (KkcLanguageModel* self, GError** error);
	void (*get_bos) (KkcLanguageModel* self, KkcLanguageModelEntry* result);
	void (*get_eos) (KkcLanguageModel* self, KkcLanguageModelEntry* result);
};

struct _KkcUnigramLanguageModelIface {
	GTypeInterface parent_iface;
	gdouble (*unigram_cost) (KkcUnigramLanguageModel* self, KkcLanguageModelEntry* entry);
	gdouble (*unigram_backoff) (KkcUnigramLanguageModel* self, KkcLanguageModelEntry* entry);
};

struct _KkcBigramLanguageModelIface {
	GTypeInterface parent_iface;
	gboolean (*has_bigram) (KkcBigramLanguageModel* self, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
	gdouble (*bigram_cost) (KkcBigramLanguageModel* self, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
	gdouble (*bigram_backoff) (KkcBigramLanguageModel* self, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
};

struct _KkcSortedBigramLanguageModel {
	KkcLanguageModel parent_instance;
	KkcSortedBigramLanguageModelPrivate * priv;
};

struct _KkcSortedBigramLanguageModelClass {
	KkcLanguageModelClass parent_class;
};

struct _KkcIndexFileIface {
	GTypeInterface parent_iface;
	gchar* (*get_contents) (KkcIndexFile* self);
	gsize (*get_length) (KkcIndexFile* self);
};

struct _KkcSortedBigramLanguageModelPrivate {
	KkcLanguageModelEntry _bos;
	KkcLanguageModelEntry _eos;
	MarisaTrie* input_trie;
	MarisaTrie* unigram_trie;
	KkcIndexFile* unigram_index;
	KkcIndexFile* bigram_index;
	KkcBloomFilter* bigram_filter;
	guint32 last_value;
	guint32 last_pvalue;
	glong last_offset;
};


static gpointer kkc_sorted_bigram_language_model_parent_class = NULL;
extern gboolean kkc_use_mapped_index_file;
static KkcUnigramLanguageModelIface* kkc_sorted_bigram_language_model_kkc_unigram_language_model_parent_iface = NULL;
static KkcBigramLanguageModelIface* kkc_sorted_bigram_language_model_kkc_bigram_language_model_parent_iface = NULL;

GType kkc_language_model_get_type (void) G_GNUC_CONST;
GType kkc_language_model_entry_get_type (void) G_GNUC_CONST;
KkcLanguageModelEntry* kkc_language_model_entry_dup (const KkcLanguageModelEntry* self);
void kkc_language_model_entry_free (KkcLanguageModelEntry* self);
void kkc_language_model_entry_copy (const KkcLanguageModelEntry* self, KkcLanguageModelEntry* dest);
void kkc_language_model_entry_destroy (KkcLanguageModelEntry* self);
GType kkc_unigram_language_model_get_type (void) G_GNUC_CONST;
GType kkc_bigram_language_model_get_type (void) G_GNUC_CONST;
GType kkc_sorted_bigram_language_model_get_type (void) G_GNUC_CONST;
GType kkc_index_file_get_type (void) G_GNUC_CONST;
GType kkc_bloom_filter_get_type (void) G_GNUC_CONST;
#define KKC_SORTED_BIGRAM_LANGUAGE_MODEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), KKC_TYPE_SORTED_BIGRAM_LANGUAGE_MODEL, KkcSortedBigramLanguageModelPrivate))
enum  {
	KKC_SORTED_BIGRAM_LANGUAGE_MODEL_DUMMY_PROPERTY,
	KKC_SORTED_BIGRAM_LANGUAGE_MODEL_BOS,
	KKC_SORTED_BIGRAM_LANGUAGE_MODEL_EOS,
	KKC_SORTED_BIGRAM_LANGUAGE_MODEL_MIN_COST
};
static GeeCollection* kkc_sorted_bigram_language_model_real_unigram_entries (KkcLanguageModel* base, const gchar* prefix);
static GeeCollection* kkc_sorted_bigram_language_model_real_entries (KkcLanguageModel* base, const gchar* input);
GeeCollection* kkc_language_model_unigram_entries (KkcLanguageModel* self, const gchar* input);
static KkcLanguageModelEntry* kkc_sorted_bigram_language_model_real_get (KkcLanguageModel* base, const gchar* input, const gchar* output);
glong kkc_sorted_bigram_language_model_bigram_offset (KkcSortedBigramLanguageModel* self, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
gboolean kkc_bloom_filter_contains (KkcBloomFilter* self, guint32 b0, guint32 b1);
glong kkc_language_model_utils_bsearch_ngram (void* memory, glong start_offset, glong end_offset, glong record_size, guint8* needle, int needle_length1);
gchar* kkc_index_file_get_contents (KkcIndexFile* self);
gsize kkc_index_file_get_length (KkcIndexFile* self);
static gdouble kkc_sorted_bigram_language_model_real_unigram_cost (KkcUnigramLanguageModel* base, KkcLanguageModelEntry* entry);
gdouble kkc_language_model_utils_decode_cost (guint16 cost, gdouble min_cost);
gdouble kkc_sorted_bigram_language_model_get_min_cost (KkcSortedBigramLanguageModel* self);
static gdouble kkc_sorted_bigram_language_model_real_unigram_backoff (KkcUnigramLanguageModel* base, KkcLanguageModelEntry* entry);
static gboolean kkc_sorted_bigram_language_model_real_has_bigram (KkcBigramLanguageModel* base, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
static gdouble kkc_sorted_bigram_language_model_real_bigram_cost (KkcBigramLanguageModel* base, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
static gdouble kkc_sorted_bigram_language_model_real_bigram_backoff (KkcBigramLanguageModel* base, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry);
static gboolean kkc_sorted_bigram_language_model_real_parse (KkcLanguageModel* base, GError** error);
GType kkc_metadata_file_get_type (void) G_GNUC_CONST;
GType kkc_language_model_metadata_get_type (void) G_GNUC_CONST;
KkcLanguageModelMetadata* kkc_language_model_get_metadata (KkcLanguageModel* self);
const gchar* kkc_metadata_file_get_filename (KkcMetadataFile* self);
GType kkc_mapped_index_file_get_type (void) G_GNUC_CONST;
KkcMappedIndexFile* kkc_mapped_index_file_new (const gchar* filename, GError** error);
KkcMappedIndexFile* kkc_mapped_index_file_construct (GType object_type, const gchar* filename, GError** error);
GType kkc_loaded_index_file_get_type (void) G_GNUC_CONST;
KkcLoadedIndexFile* kkc_loaded_index_file_new (const gchar* filename, GError** error);
KkcLoadedIndexFile* kkc_loaded_index_file_construct (GType object_type, const gchar* filename, GError** error);
KkcBloomFilter* kkc_bloom_filter_new (const gchar* filename, GError** error);
KkcBloomFilter* kkc_bloom_filter_construct (GType object_type, const gchar* filename, GError** error);
KkcLanguageModelEntry* kkc_language_model_get (KkcLanguageModel* self, const gchar* input, const gchar* output);
KkcSortedBigramLanguageModel* kkc_sorted_bigram_language_model_new (KkcLanguageModelMetadata* metadata, GError** error);
KkcSortedBigramLanguageModel* kkc_sorted_bigram_language_model_construct (GType object_type, KkcLanguageModelMetadata* metadata, GError** error);
KkcLanguageModel* kkc_language_model_construct (GType object_type, KkcLanguageModelMetadata* metadata, GError** error);
static void kkc_sorted_bigram_language_model_finalize (GObject* obj);
void kkc_language_model_get_bos (KkcLanguageModel* self, KkcLanguageModelEntry* result);
void kkc_language_model_get_eos (KkcLanguageModel* self, KkcLanguageModelEntry* result);
static void _vala_kkc_sorted_bigram_language_model_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static GeeCollection* kkc_sorted_bigram_language_model_real_unigram_entries (KkcLanguageModel* base, const gchar* prefix) {
	KkcSortedBigramLanguageModel * self;
	GeeCollection* result = NULL;
	GeeArrayList* entries = NULL;
	GeeArrayList* _tmp0_;
	MarisaAgent* agent = NULL;
	MarisaAgent* _tmp1_;
	gchar* query = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	MarisaAgent* _tmp4_;
	const gchar* _tmp5_;
	guint8* _tmp6_;
	gint _tmp6__length1;
	guint8* _tmp7_;
	gint _tmp7__length1;
	self = (KkcSortedBigramLanguageModel*) base;
	g_return_val_if_fail (prefix != NULL, NULL);
	_tmp0_ = gee_array_list_new (KKC_TYPE_LANGUAGE_MODEL_ENTRY, (GBoxedCopyFunc) kkc_language_model_entry_dup, kkc_language_model_entry_free, NULL);
	entries = _tmp0_;
	_tmp1_ = marisa_agent_new ();
	agent = _tmp1_;
	_tmp2_ = prefix;
	_tmp3_ = g_strconcat (_tmp2_, "/", NULL);
	query = _tmp3_;
	_tmp4_ = agent;
	_tmp5_ = query;
	_tmp6_ = string_get_data (_tmp5_, &_tmp6__length1);
	_tmp7_ = _tmp6_;
	_tmp7__length1 = _tmp6__length1;
	marisa_agent_set_query (_tmp4_, (const gchar*) _tmp7_, (gsize) _tmp7__length1);
	while (TRUE) {
		MarisaTrie* _tmp8_;
		MarisaAgent* _tmp9_;
		gboolean _tmp10_ = FALSE;
		MarisaKey* key = NULL;
		MarisaAgent* _tmp11_;
		MarisaKey* _tmp12_ = NULL;
		gchar** input_output = NULL;
		MarisaKey* _tmp13_;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		gchar** _tmp16_;
		gchar** _tmp17_ = NULL;
		gchar** _tmp18_;
		gint _tmp18__length1;
		gint input_output_length1;
		gint _input_output_size_;
		guint id = 0U;
		MarisaKey* _tmp19_;
		gsize _tmp20_ = 0UL;
		KkcLanguageModelEntry entry = {0};
		gchar** _tmp21_;
		gint _tmp21__length1;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		gchar** _tmp24_;
		gint _tmp24__length1;
		const gchar* _tmp25_;
		gchar* _tmp26_;
		guint _tmp27_;
		KkcLanguageModelEntry _tmp28_ = {0};
		GeeArrayList* _tmp29_;
		KkcLanguageModelEntry _tmp30_;
		_tmp8_ = self->priv->unigram_trie;
		_tmp9_ = agent;
		_tmp10_ = marisa_trie_predictive_search (_tmp8_, _tmp9_);
		if (!_tmp10_) {
			break;
		}
		_tmp11_ = agent;
		_tmp12_ = marisa_agent_get_key (_tmp11_);
		key = _tmp12_;
		_tmp13_ = key;
		_tmp14_ = marisa_key_get_string (_tmp13_, NULL);
		_tmp15_ = _tmp14_;
		_tmp17_ = _tmp16_ = g_strsplit (_tmp15_, "/", 0);
		_tmp18_ = _tmp17_;
		_tmp18__length1 = _vala_array_length (_tmp16_);
		_g_free0 (_tmp15_);
		input_output = _tmp18_;
		input_output_length1 = _tmp18__length1;
		_input_output_size_ = input_output_length1;
		_tmp19_ = key;
		_tmp20_ = marisa_key_get_id (_tmp19_);
		id = (guint) _tmp20_;
		_tmp21_ = input_output;
		_tmp21__length1 = input_output_length1;
		_tmp22_ = _tmp21_[0];
		_tmp23_ = g_strdup (_tmp22_);
		_tmp24_ = input_output;
		_tmp24__length1 = input_output_length1;
		_tmp25_ = _tmp24_[1];
		_tmp26_ = g_strdup (_tmp25_);
		_tmp27_ = id;
		_g_free0 (_tmp28_.input);
		_tmp28_.input = _tmp23_;
		_g_free0 (_tmp28_.output);
		_tmp28_.output = _tmp26_;
		_tmp28_.id = _tmp27_;
		entry = _tmp28_;
		_tmp29_ = entries;
		_tmp30_ = entry;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp29_, &_tmp30_);
		kkc_language_model_entry_destroy (&entry);
		input_output = (_vala_array_free (input_output, input_output_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (key);
	}
	result = (GeeCollection*) entries;
	_g_free0 (query);
	_g_object_unref0 (agent);
	return result;
}


static GeeCollection* kkc_sorted_bigram_language_model_real_entries (KkcLanguageModel* base, const gchar* input) {
	KkcSortedBigramLanguageModel * self;
	GeeCollection* result = NULL;
	GeeArrayList* entries = NULL;
	GeeArrayList* _tmp0_;
	MarisaAgent* agent = NULL;
	MarisaAgent* _tmp1_;
	MarisaAgent* _tmp2_;
	const gchar* _tmp3_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	guint8* _tmp5_;
	gint _tmp5__length1;
	self = (KkcSortedBigramLanguageModel*) base;
	g_return_val_if_fail (input != NULL, NULL);
	_tmp0_ = gee_array_list_new (KKC_TYPE_LANGUAGE_MODEL_ENTRY, (GBoxedCopyFunc) kkc_language_model_entry_dup, kkc_language_model_entry_free, NULL);
	entries = _tmp0_;
	_tmp1_ = marisa_agent_new ();
	agent = _tmp1_;
	_tmp2_ = agent;
	_tmp3_ = input;
	_tmp4_ = string_get_data (_tmp3_, &_tmp4__length1);
	_tmp5_ = _tmp4_;
	_tmp5__length1 = _tmp4__length1;
	marisa_agent_set_query (_tmp2_, (const gchar*) _tmp5_, (gsize) _tmp5__length1);
	while (TRUE) {
		MarisaTrie* _tmp6_;
		MarisaAgent* _tmp7_;
		gboolean _tmp8_ = FALSE;
		gchar* prefix = NULL;
		MarisaAgent* _tmp9_;
		MarisaKey* _tmp10_ = NULL;
		MarisaKey* _tmp11_;
		gchar* _tmp12_ = NULL;
		gchar* _tmp13_;
		GeeArrayList* _tmp14_;
		const gchar* _tmp15_;
		GeeCollection* _tmp16_ = NULL;
		GeeCollection* _tmp17_;
		_tmp6_ = self->priv->input_trie;
		_tmp7_ = agent;
		_tmp8_ = marisa_trie_common_prefix_search (_tmp6_, _tmp7_);
		if (!_tmp8_) {
			break;
		}
		_tmp9_ = agent;
		_tmp10_ = marisa_agent_get_key (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = marisa_key_get_string (_tmp11_, NULL);
		_tmp13_ = _tmp12_;
		_g_object_unref0 (_tmp11_);
		prefix = _tmp13_;
		_tmp14_ = entries;
		_tmp15_ = prefix;
		_tmp16_ = kkc_language_model_unigram_entries ((KkcLanguageModel*) self, _tmp15_);
		_tmp17_ = _tmp16_;
		gee_abstract_collection_add_all ((GeeAbstractCollection*) _tmp14_, _tmp17_);
		_g_object_unref0 (_tmp17_);
		_g_free0 (prefix);
	}
	result = (GeeCollection*) entries;
	_g_object_unref0 (agent);
	return result;
}


static gpointer _kkc_language_model_entry_dup0 (gpointer self) {
	return self ? kkc_language_model_entry_dup (self) : NULL;
}


static KkcLanguageModelEntry* kkc_sorted_bigram_language_model_real_get (KkcLanguageModel* base, const gchar* input, const gchar* output) {
	KkcSortedBigramLanguageModel * self;
	KkcLanguageModelEntry* result = NULL;
	MarisaAgent* agent = NULL;
	MarisaAgent* _tmp0_;
	gchar* query = NULL;
	const gchar* _tmp1_;
	MarisaAgent* _tmp7_;
	const gchar* _tmp8_;
	guint8* _tmp9_;
	gint _tmp9__length1;
	guint8* _tmp10_;
	gint _tmp10__length1;
	MarisaTrie* _tmp11_;
	MarisaAgent* _tmp12_;
	gboolean _tmp13_ = FALSE;
	self = (KkcSortedBigramLanguageModel*) base;
	g_return_val_if_fail (input != NULL, NULL);
	g_return_val_if_fail (output != NULL, NULL);
	_tmp0_ = marisa_agent_new ();
	agent = _tmp0_;
	_tmp1_ = input;
	if (g_strcmp0 (_tmp1_, " ") != 0) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		_tmp2_ = input;
		_tmp3_ = output;
		_tmp4_ = g_strdup_printf ("%s/%s", _tmp2_, _tmp3_);
		_g_free0 (query);
		query = _tmp4_;
	} else {
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = output;
		_tmp6_ = g_strdup (_tmp5_);
		_g_free0 (query);
		query = _tmp6_;
	}
	_tmp7_ = agent;
	_tmp8_ = query;
	_tmp9_ = string_get_data (_tmp8_, &_tmp9__length1);
	_tmp10_ = _tmp9_;
	_tmp10__length1 = _tmp9__length1;
	marisa_agent_set_query (_tmp7_, (const gchar*) _tmp10_, (gsize) _tmp10__length1);
	_tmp11_ = self->priv->unigram_trie;
	_tmp12_ = agent;
	_tmp13_ = marisa_trie_lookup (_tmp11_, _tmp12_);
	if (_tmp13_) {
		gsize id = 0UL;
		MarisaAgent* _tmp14_;
		MarisaKey* _tmp15_ = NULL;
		MarisaKey* _tmp16_;
		gsize _tmp17_ = 0UL;
		gsize _tmp18_;
		KkcLanguageModelEntry entry = {0};
		const gchar* _tmp19_;
		gchar* _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gsize _tmp23_;
		KkcLanguageModelEntry _tmp24_ = {0};
		KkcLanguageModelEntry _tmp25_;
		KkcLanguageModelEntry* _tmp26_;
		KkcLanguageModelEntry* _tmp27_;
		_tmp14_ = agent;
		_tmp15_ = marisa_agent_get_key (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = marisa_key_get_id (_tmp16_);
		_tmp18_ = _tmp17_;
		_g_object_unref0 (_tmp16_);
		id = _tmp18_;
		_tmp19_ = input;
		_tmp20_ = g_strdup (_tmp19_);
		_tmp21_ = output;
		_tmp22_ = g_strdup (_tmp21_);
		_tmp23_ = id;
		_g_free0 (_tmp24_.input);
		_tmp24_.input = _tmp20_;
		_g_free0 (_tmp24_.output);
		_tmp24_.output = _tmp22_;
		_tmp24_.id = (guint) _tmp23_;
		entry = _tmp24_;
		_tmp25_ = entry;
		_tmp26_ = _kkc_language_model_entry_dup0 (&_tmp25_);
		_tmp27_ = _tmp26_;
		kkc_language_model_entry_destroy (&_tmp25_);
		result = _tmp27_;
		_g_free0 (query);
		_g_object_unref0 (agent);
		return result;
	}
	result = NULL;
	_g_free0 (query);
	_g_object_unref0 (agent);
	return result;
}


glong kkc_sorted_bigram_language_model_bigram_offset (KkcSortedBigramLanguageModel* self, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry) {
	glong result = 0L;
	gboolean _tmp0_ = FALSE;
	KkcLanguageModelEntry _tmp1_;
	guint _tmp2_;
	guint32 _tmp3_;
	gboolean _tmp7_;
	gboolean _tmp9_ = FALSE;
	KkcBloomFilter* _tmp10_;
	gboolean _tmp17_;
	guint8* buffer = NULL;
	guint8* _tmp18_ = NULL;
	gint buffer_length1;
	gint _buffer_size_;
	guint8* p = NULL;
	guint8* _tmp19_;
	gint _tmp19__length1;
	guint32 value = 0U;
	KkcLanguageModelEntry _tmp20_;
	guint _tmp21_;
	guint8* _tmp22_;
	guint8* _tmp23_;
	guint32 pvalue = 0U;
	KkcLanguageModelEntry _tmp24_;
	guint _tmp25_;
	guint8* _tmp26_;
	gint record_size = 0;
	glong offset = 0L;
	KkcIndexFile* _tmp27_;
	gchar* _tmp28_ = NULL;
	KkcIndexFile* _tmp29_;
	gsize _tmp30_ = 0UL;
	gint _tmp31_;
	gint _tmp32_;
	guint8* _tmp33_;
	gint _tmp33__length1;
	glong _tmp34_ = 0L;
	KkcLanguageModelEntry _tmp35_;
	guint _tmp36_;
	KkcLanguageModelEntry _tmp37_;
	guint _tmp38_;
	glong _tmp39_;
	g_return_val_if_fail (self != NULL, 0L);
	g_return_val_if_fail (pentry != NULL, 0L);
	g_return_val_if_fail (entry != NULL, 0L);
	_tmp1_ = *pentry;
	_tmp2_ = _tmp1_.id;
	_tmp3_ = self->priv->last_pvalue;
	if (_tmp2_ == ((guint) _tmp3_)) {
		KkcLanguageModelEntry _tmp4_;
		guint _tmp5_;
		guint32 _tmp6_;
		_tmp4_ = *entry;
		_tmp5_ = _tmp4_.id;
		_tmp6_ = self->priv->last_value;
		_tmp0_ = _tmp5_ == ((guint) _tmp6_);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp7_ = _tmp0_;
	if (_tmp7_) {
		glong _tmp8_;
		_tmp8_ = self->priv->last_offset;
		result = _tmp8_;
		return result;
	}
	_tmp10_ = self->priv->bigram_filter;
	if (_tmp10_ != NULL) {
		KkcBloomFilter* _tmp11_;
		KkcLanguageModelEntry _tmp12_;
		guint _tmp13_;
		KkcLanguageModelEntry _tmp14_;
		guint _tmp15_;
		gboolean _tmp16_ = FALSE;
		_tmp11_ = self->priv->bigram_filter;
		_tmp12_ = *entry;
		_tmp13_ = _tmp12_.id;
		_tmp14_ = *pentry;
		_tmp15_ = _tmp14_.id;
		_tmp16_ = kkc_bloom_filter_contains (_tmp11_, (guint32) _tmp13_, (guint32) _tmp15_);
		_tmp9_ = !_tmp16_;
	} else {
		_tmp9_ = FALSE;
	}
	_tmp17_ = _tmp9_;
	if (_tmp17_) {
		result = (glong) (-1);
		return result;
	}
	_tmp18_ = g_new0 (guint8, 8);
	buffer = _tmp18_;
	buffer_length1 = 8;
	_buffer_size_ = buffer_length1;
	_tmp19_ = buffer;
	_tmp19__length1 = buffer_length1;
	p = _tmp19_;
	_tmp20_ = *entry;
	_tmp21_ = _tmp20_.id;
	value = (guint32) _tmp21_;
	_tmp22_ = p;
	memcpy (_tmp22_, &value, (gsize) sizeof (guint32));
	_tmp23_ = p;
	p = _tmp23_ + 4;
	_tmp24_ = *pentry;
	_tmp25_ = _tmp24_.id;
	pvalue = (guint32) _tmp25_;
	_tmp26_ = p;
	memcpy (_tmp26_, &pvalue, (gsize) sizeof (guint32));
	record_size = 12;
	_tmp27_ = self->priv->bigram_index;
	_tmp28_ = kkc_index_file_get_contents (_tmp27_);
	_tmp29_ = self->priv->bigram_index;
	_tmp30_ = kkc_index_file_get_length (_tmp29_);
	_tmp31_ = record_size;
	_tmp32_ = record_size;
	_tmp33_ = buffer;
	_tmp33__length1 = buffer_length1;
	_tmp34_ = kkc_language_model_utils_bsearch_ngram (_tmp28_, (glong) 0, ((glong) _tmp30_) / _tmp31_, (glong) _tmp32_, _tmp33_, _tmp33__length1);
	offset = _tmp34_;
	_tmp35_ = *entry;
	_tmp36_ = _tmp35_.id;
	self->priv->last_value = (guint32) _tmp36_;
	_tmp37_ = *pentry;
	_tmp38_ = _tmp37_.id;
	self->priv->last_pvalue = (guint32) _tmp38_;
	_tmp39_ = offset;
	self->priv->last_offset = _tmp39_;
	result = offset;
	buffer = (g_free (buffer), NULL);
	return result;
}


static gdouble kkc_sorted_bigram_language_model_real_unigram_cost (KkcUnigramLanguageModel* base, KkcLanguageModelEntry* entry) {
	KkcSortedBigramLanguageModel * self;
	gdouble result = 0.0;
	KkcLanguageModelEntry _tmp0_;
	guint _tmp1_;
	KkcIndexFile* _tmp2_;
	gsize _tmp3_ = 0UL;
	guint8* p = NULL;
	KkcIndexFile* _tmp4_;
	gchar* _tmp5_ = NULL;
	KkcLanguageModelEntry _tmp6_;
	guint _tmp7_;
	guint16 cost = 0U;
	guint8* _tmp8_;
	guint16 _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_ = 0.0;
	self = (KkcSortedBigramLanguageModel*) base;
	g_return_val_if_fail (entry != NULL, 0.0);
	_tmp0_ = *entry;
	_tmp1_ = _tmp0_.id;
	_tmp2_ = self->priv->unigram_index;
	_tmp3_ = kkc_index_file_get_length (_tmp2_);
	if (((gsize) _tmp1_) >= _tmp3_) {
		result = (gdouble) 0;
		return result;
	}
	_tmp4_ = self->priv->unigram_index;
	_tmp5_ = kkc_index_file_get_contents (_tmp4_);
	_tmp6_ = *entry;
	_tmp7_ = _tmp6_.id;
	p = ((guint8*) _tmp5_) + (_tmp7_ * 6);
	_tmp8_ = p;
	cost = *((guint16*) _tmp8_);
	_tmp9_ = cost;
	_tmp10_ = kkc_sorted_bigram_language_model_get_min_cost (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = kkc_language_model_utils_decode_cost (_tmp9_, _tmp11_);
	result = _tmp12_;
	return result;
}


static gdouble kkc_sorted_bigram_language_model_real_unigram_backoff (KkcUnigramLanguageModel* base, KkcLanguageModelEntry* entry) {
	KkcSortedBigramLanguageModel * self;
	gdouble result = 0.0;
	KkcLanguageModelEntry _tmp0_;
	guint _tmp1_;
	KkcIndexFile* _tmp2_;
	gsize _tmp3_ = 0UL;
	guint8* p = NULL;
	KkcIndexFile* _tmp4_;
	gchar* _tmp5_ = NULL;
	KkcLanguageModelEntry _tmp6_;
	guint _tmp7_;
	guint16 backoff = 0U;
	guint8* _tmp8_;
	guint16 _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	gdouble _tmp12_ = 0.0;
	self = (KkcSortedBigramLanguageModel*) base;
	g_return_val_if_fail (entry != NULL, 0.0);
	_tmp0_ = *entry;
	_tmp1_ = _tmp0_.id;
	_tmp2_ = self->priv->unigram_index;
	_tmp3_ = kkc_index_file_get_length (_tmp2_);
	if (((gsize) _tmp1_) >= _tmp3_) {
		result = (gdouble) 0;
		return result;
	}
	_tmp4_ = self->priv->unigram_index;
	_tmp5_ = kkc_index_file_get_contents (_tmp4_);
	_tmp6_ = *entry;
	_tmp7_ = _tmp6_.id;
	p = (((guint8*) _tmp5_) + (_tmp7_ * 6)) + 2;
	_tmp8_ = p;
	backoff = *((guint16*) _tmp8_);
	_tmp9_ = backoff;
	_tmp10_ = kkc_sorted_bigram_language_model_get_min_cost (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = kkc_language_model_utils_decode_cost (_tmp9_, _tmp11_);
	result = _tmp12_;
	return result;
}


static gboolean kkc_sorted_bigram_language_model_real_has_bigram (KkcBigramLanguageModel* base, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry) {
	KkcSortedBigramLanguageModel * self;
	gboolean result = FALSE;
	KkcLanguageModelEntry _tmp0_;
	KkcLanguageModelEntry _tmp1_;
	glong _tmp2_ = 0L;
	self = (KkcSortedBigramLanguageModel*) base;
	g_return_val_if_fail (pentry != NULL, FALSE);
	g_return_val_if_fail (entry != NULL, FALSE);
	_tmp0_ = *pentry;
	_tmp1_ = *entry;
	_tmp2_ = kkc_sorted_bigram_language_model_bigram_offset (self, &_tmp0_, &_tmp1_);
	result = _tmp2_ >= ((glong) 0);
	return result;
}


static gdouble kkc_sorted_bigram_language_model_real_bigram_cost (KkcBigramLanguageModel* base, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry) {
	KkcSortedBigramLanguageModel * self;
	gdouble result = 0.0;
	glong offset = 0L;
	KkcLanguageModelEntry _tmp0_;
	KkcLanguageModelEntry _tmp1_;
	glong _tmp2_ = 0L;
	glong _tmp3_;
	guint8* p = NULL;
	KkcIndexFile* _tmp4_;
	gchar* _tmp5_ = NULL;
	glong _tmp6_;
	guint16 cost = 0U;
	guint8* _tmp7_;
	guint16 _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_ = 0.0;
	self = (KkcSortedBigramLanguageModel*) base;
	g_return_val_if_fail (pentry != NULL, 0.0);
	g_return_val_if_fail (entry != NULL, 0.0);
	_tmp0_ = *pentry;
	_tmp1_ = *entry;
	_tmp2_ = kkc_sorted_bigram_language_model_bigram_offset (self, &_tmp0_, &_tmp1_);
	offset = _tmp2_;
	_tmp3_ = offset;
	if (_tmp3_ < ((glong) 0)) {
		result = (gdouble) 0;
		return result;
	}
	_tmp4_ = self->priv->bigram_index;
	_tmp5_ = kkc_index_file_get_contents (_tmp4_);
	_tmp6_ = offset;
	p = (((guint8*) _tmp5_) + (_tmp6_ * 12)) + 8;
	_tmp7_ = p;
	cost = *((guint16*) _tmp7_);
	_tmp8_ = cost;
	_tmp9_ = kkc_sorted_bigram_language_model_get_min_cost (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = kkc_language_model_utils_decode_cost (_tmp8_, _tmp10_);
	result = _tmp11_;
	return result;
}


static gdouble kkc_sorted_bigram_language_model_real_bigram_backoff (KkcBigramLanguageModel* base, KkcLanguageModelEntry* pentry, KkcLanguageModelEntry* entry) {
	KkcSortedBigramLanguageModel * self;
	gdouble result = 0.0;
	glong offset = 0L;
	KkcLanguageModelEntry _tmp0_;
	KkcLanguageModelEntry _tmp1_;
	glong _tmp2_ = 0L;
	glong _tmp3_;
	guint8* p = NULL;
	KkcIndexFile* _tmp4_;
	gchar* _tmp5_ = NULL;
	glong _tmp6_;
	guint16 backoff = 0U;
	guint8* _tmp7_;
	guint16 _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_ = 0.0;
	self = (KkcSortedBigramLanguageModel*) base;
	g_return_val_if_fail (pentry != NULL, 0.0);
	g_return_val_if_fail (entry != NULL, 0.0);
	_tmp0_ = *pentry;
	_tmp1_ = *entry;
	_tmp2_ = kkc_sorted_bigram_language_model_bigram_offset (self, &_tmp0_, &_tmp1_);
	offset = _tmp2_;
	_tmp3_ = offset;
	if (_tmp3_ < ((glong) 0)) {
		result = (gdouble) 0;
		return result;
	}
	_tmp4_ = self->priv->bigram_index;
	_tmp5_ = kkc_index_file_get_contents (_tmp4_);
	_tmp6_ = offset;
	p = (((guint8*) _tmp5_) + (_tmp6_ * 12)) + 10;
	_tmp7_ = p;
	backoff = *((guint16*) _tmp7_);
	_tmp8_ = backoff;
	_tmp9_ = kkc_sorted_bigram_language_model_get_min_cost (self);
	_tmp10_ = _tmp9_;
	_tmp11_ = kkc_language_model_utils_decode_cost (_tmp8_, _tmp10_);
	result = _tmp11_;
	return result;
}


static gboolean kkc_sorted_bigram_language_model_real_parse (KkcLanguageModel* base, GError** error) {
	KkcSortedBigramLanguageModel * self;
	gboolean result = FALSE;
	gchar* prefix = NULL;
	KkcLanguageModelMetadata* _tmp0_;
	KkcLanguageModelMetadata* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* input_trie_filename = NULL;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	MarisaTrie* _tmp10_;
	const gchar* _tmp11_;
	gchar* unigram_trie_filename = NULL;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	MarisaTrie* _tmp14_;
	const gchar* _tmp15_;
	gboolean _tmp16_;
	gchar* bigram_filter_filename = NULL;
	const gchar* _tmp41_;
	gchar* _tmp42_;
	KkcLanguageModelEntry* _tmp49_ = NULL;
	KkcLanguageModelEntry* _tmp50_;
	KkcLanguageModelEntry _tmp51_ = {0};
	KkcLanguageModelEntry* _tmp52_ = NULL;
	KkcLanguageModelEntry* _tmp53_;
	KkcLanguageModelEntry _tmp54_ = {0};
	GError * _inner_error_ = NULL;
	self = (KkcSortedBigramLanguageModel*) base;
	_tmp0_ = kkc_language_model_get_metadata ((KkcLanguageModel*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = kkc_metadata_file_get_filename ((KkcMetadataFile*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_path_get_dirname (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_build_filename (_tmp5_, "data", NULL);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	prefix = _tmp7_;
	_tmp8_ = prefix;
	_tmp9_ = g_strconcat (_tmp8_, ".input", NULL);
	input_trie_filename = _tmp9_;
	_tmp10_ = self->priv->input_trie;
	_tmp11_ = input_trie_filename;
	marisa_trie_mmap (_tmp10_, _tmp11_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (input_trie_filename);
		_g_free0 (prefix);
		return FALSE;
	}
	_tmp12_ = prefix;
	_tmp13_ = g_strconcat (_tmp12_, ".1gram.index", NULL);
	unigram_trie_filename = _tmp13_;
	_tmp14_ = self->priv->unigram_trie;
	_tmp15_ = unigram_trie_filename;
	marisa_trie_mmap (_tmp14_, _tmp15_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (unigram_trie_filename);
		_g_free0 (input_trie_filename);
		_g_free0 (prefix);
		return FALSE;
	}
	_tmp16_ = kkc_use_mapped_index_file;
	if (_tmp16_) {
		KkcMappedIndexFile* _tmp17_ = NULL;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		KkcMappedIndexFile* _tmp21_;
		KkcMappedIndexFile* _tmp22_;
		KkcMappedIndexFile* _tmp23_ = NULL;
		const gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		KkcMappedIndexFile* _tmp27_;
		KkcMappedIndexFile* _tmp28_;
		_tmp18_ = prefix;
		_tmp19_ = g_strconcat (_tmp18_, ".1gram", NULL);
		_tmp20_ = _tmp19_;
		_tmp21_ = kkc_mapped_index_file_new (_tmp20_, &_inner_error_);
		_tmp22_ = _tmp21_;
		_g_free0 (_tmp20_);
		_tmp17_ = _tmp22_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (unigram_trie_filename);
			_g_free0 (input_trie_filename);
			_g_free0 (prefix);
			return FALSE;
		}
		_g_object_unref0 (self->priv->unigram_index);
		self->priv->unigram_index = (KkcIndexFile*) _tmp17_;
		_tmp24_ = prefix;
		_tmp25_ = g_strconcat (_tmp24_, ".2gram", NULL);
		_tmp26_ = _tmp25_;
		_tmp27_ = kkc_mapped_index_file_new (_tmp26_, &_inner_error_);
		_tmp28_ = _tmp27_;
		_g_free0 (_tmp26_);
		_tmp23_ = _tmp28_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (unigram_trie_filename);
			_g_free0 (input_trie_filename);
			_g_free0 (prefix);
			return FALSE;
		}
		_g_object_unref0 (self->priv->bigram_index);
		self->priv->bigram_index = (KkcIndexFile*) _tmp23_;
	} else {
		KkcLoadedIndexFile* _tmp29_ = NULL;
		const gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		KkcLoadedIndexFile* _tmp33_;
		KkcLoadedIndexFile* _tmp34_;
		KkcLoadedIndexFile* _tmp35_ = NULL;
		const gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		KkcLoadedIndexFile* _tmp39_;
		KkcLoadedIndexFile* _tmp40_;
		_tmp30_ = prefix;
		_tmp31_ = g_strconcat (_tmp30_, ".1gram", NULL);
		_tmp32_ = _tmp31_;
		_tmp33_ = kkc_loaded_index_file_new (_tmp32_, &_inner_error_);
		_tmp34_ = _tmp33_;
		_g_free0 (_tmp32_);
		_tmp29_ = _tmp34_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (unigram_trie_filename);
			_g_free0 (input_trie_filename);
			_g_free0 (prefix);
			return FALSE;
		}
		_g_object_unref0 (self->priv->unigram_index);
		self->priv->unigram_index = (KkcIndexFile*) _tmp29_;
		_tmp36_ = prefix;
		_tmp37_ = g_strconcat (_tmp36_, ".2gram", NULL);
		_tmp38_ = _tmp37_;
		_tmp39_ = kkc_loaded_index_file_new (_tmp38_, &_inner_error_);
		_tmp40_ = _tmp39_;
		_g_free0 (_tmp38_);
		_tmp35_ = _tmp40_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (unigram_trie_filename);
			_g_free0 (input_trie_filename);
			_g_free0 (prefix);
			return FALSE;
		}
		_g_object_unref0 (self->priv->bigram_index);
		self->priv->bigram_index = (KkcIndexFile*) _tmp35_;
	}
	_tmp41_ = prefix;
	_tmp42_ = g_strconcat (_tmp41_, ".2gram.filter", NULL);
	bigram_filter_filename = _tmp42_;
	{
		KkcBloomFilter* _tmp43_ = NULL;
		const gchar* _tmp44_;
		KkcBloomFilter* _tmp45_;
		_tmp44_ = bigram_filter_filename;
		_tmp45_ = kkc_bloom_filter_new (_tmp44_, &_inner_error_);
		_tmp43_ = _tmp45_;
		if (_inner_error_ != NULL) {
			goto __catch1_g_error;
		}
		_g_object_unref0 (self->priv->bigram_filter);
		self->priv->bigram_filter = _tmp43_;
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp46_;
		GError* _tmp47_;
		const gchar* _tmp48_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp46_ = bigram_filter_filename;
		_tmp47_ = e;
		_tmp48_ = _tmp47_->message;
		g_warning ("sorted-bigram-language-model.vala:200: can't load %s: %s", _tmp46_, _tmp48_);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (bigram_filter_filename);
		_g_free0 (unigram_trie_filename);
		_g_free0 (input_trie_filename);
		_g_free0 (prefix);
		return FALSE;
	}
	_tmp49_ = kkc_language_model_get ((KkcLanguageModel*) self, " ", "<s>");
	_tmp50_ = _tmp49_;
	kkc_language_model_entry_copy (_tmp50_, &_tmp51_);
	kkc_language_model_entry_destroy (&self->priv->_bos);
	self->priv->_bos = _tmp51_;
	_kkc_language_model_entry_free0 (_tmp50_);
	_tmp52_ = kkc_language_model_get ((KkcLanguageModel*) self, " ", "</s>");
	_tmp53_ = _tmp52_;
	kkc_language_model_entry_copy (_tmp53_, &_tmp54_);
	kkc_language_model_entry_destroy (&self->priv->_eos);
	self->priv->_eos = _tmp54_;
	_kkc_language_model_entry_free0 (_tmp53_);
	result = TRUE;
	_g_free0 (bigram_filter_filename);
	_g_free0 (unigram_trie_filename);
	_g_free0 (input_trie_filename);
	_g_free0 (prefix);
	return result;
}


KkcSortedBigramLanguageModel* kkc_sorted_bigram_language_model_construct (GType object_type, KkcLanguageModelMetadata* metadata, GError** error) {
	KkcSortedBigramLanguageModel * self = NULL;
	KkcLanguageModelMetadata* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (metadata != NULL, NULL);
	_tmp0_ = metadata;
	self = (KkcSortedBigramLanguageModel*) kkc_language_model_construct (object_type, _tmp0_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	return self;
}


KkcSortedBigramLanguageModel* kkc_sorted_bigram_language_model_new (KkcLanguageModelMetadata* metadata, GError** error) {
	return kkc_sorted_bigram_language_model_construct (KKC_TYPE_SORTED_BIGRAM_LANGUAGE_MODEL, metadata, error);
}


static void kkc_sorted_bigram_language_model_real_get_bos (KkcLanguageModel* base, KkcLanguageModelEntry* result) {
	KkcSortedBigramLanguageModel* self;
	KkcLanguageModelEntry _tmp0_;
	self = (KkcSortedBigramLanguageModel*) base;
	_tmp0_ = self->priv->_bos;
	*result = _tmp0_;
	return;
}


static void kkc_sorted_bigram_language_model_real_get_eos (KkcLanguageModel* base, KkcLanguageModelEntry* result) {
	KkcSortedBigramLanguageModel* self;
	KkcLanguageModelEntry _tmp0_;
	self = (KkcSortedBigramLanguageModel*) base;
	_tmp0_ = self->priv->_eos;
	*result = _tmp0_;
	return;
}


gdouble kkc_sorted_bigram_language_model_get_min_cost (KkcSortedBigramLanguageModel* self) {
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = -8.0;
	return result;
}


static void kkc_sorted_bigram_language_model_class_init (KkcSortedBigramLanguageModelClass * klass) {
	kkc_sorted_bigram_language_model_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KkcSortedBigramLanguageModelPrivate));
	KKC_LANGUAGE_MODEL_CLASS (klass)->unigram_entries = kkc_sorted_bigram_language_model_real_unigram_entries;
	KKC_LANGUAGE_MODEL_CLASS (klass)->entries = kkc_sorted_bigram_language_model_real_entries;
	KKC_LANGUAGE_MODEL_CLASS (klass)->get = kkc_sorted_bigram_language_model_real_get;
	KKC_LANGUAGE_MODEL_CLASS (klass)->parse = kkc_sorted_bigram_language_model_real_parse;
	KKC_LANGUAGE_MODEL_CLASS (klass)->get_bos = kkc_sorted_bigram_language_model_real_get_bos;
	KKC_LANGUAGE_MODEL_CLASS (klass)->get_eos = kkc_sorted_bigram_language_model_real_get_eos;
	G_OBJECT_CLASS (klass)->get_property = _vala_kkc_sorted_bigram_language_model_get_property;
	G_OBJECT_CLASS (klass)->finalize = kkc_sorted_bigram_language_model_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_SORTED_BIGRAM_LANGUAGE_MODEL_BOS, g_param_spec_boxed ("bos", "bos", "bos", KKC_TYPE_LANGUAGE_MODEL_ENTRY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_SORTED_BIGRAM_LANGUAGE_MODEL_EOS, g_param_spec_boxed ("eos", "eos", "eos", KKC_TYPE_LANGUAGE_MODEL_ENTRY, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), KKC_SORTED_BIGRAM_LANGUAGE_MODEL_MIN_COST, g_param_spec_double ("min-cost", "min-cost", "min-cost", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void kkc_sorted_bigram_language_model_kkc_unigram_language_model_interface_init (KkcUnigramLanguageModelIface * iface) {
	kkc_sorted_bigram_language_model_kkc_unigram_language_model_parent_iface = g_type_interface_peek_parent (iface);
	iface->unigram_cost = (gdouble (*)(KkcUnigramLanguageModel*, KkcLanguageModelEntry*)) kkc_sorted_bigram_language_model_real_unigram_cost;
	iface->unigram_backoff = (gdouble (*)(KkcUnigramLanguageModel*, KkcLanguageModelEntry*)) kkc_sorted_bigram_language_model_real_unigram_backoff;
}


static void kkc_sorted_bigram_language_model_kkc_bigram_language_model_interface_init (KkcBigramLanguageModelIface * iface) {
	kkc_sorted_bigram_language_model_kkc_bigram_language_model_parent_iface = g_type_interface_peek_parent (iface);
	iface->has_bigram = (gboolean (*)(KkcBigramLanguageModel*, KkcLanguageModelEntry*, KkcLanguageModelEntry*)) kkc_sorted_bigram_language_model_real_has_bigram;
	iface->bigram_cost = (gdouble (*)(KkcBigramLanguageModel*, KkcLanguageModelEntry*, KkcLanguageModelEntry*)) kkc_sorted_bigram_language_model_real_bigram_cost;
	iface->bigram_backoff = (gdouble (*)(KkcBigramLanguageModel*, KkcLanguageModelEntry*, KkcLanguageModelEntry*)) kkc_sorted_bigram_language_model_real_bigram_backoff;
}


static void kkc_sorted_bigram_language_model_instance_init (KkcSortedBigramLanguageModel * self) {
	MarisaTrie* _tmp0_;
	MarisaTrie* _tmp1_;
	self->priv = KKC_SORTED_BIGRAM_LANGUAGE_MODEL_GET_PRIVATE (self);
	_tmp0_ = marisa_trie_new ();
	self->priv->input_trie = _tmp0_;
	_tmp1_ = marisa_trie_new ();
	self->priv->unigram_trie = _tmp1_;
	self->priv->bigram_filter = NULL;
	self->priv->last_value = (guint32) 0;
	self->priv->last_pvalue = (guint32) 0;
	self->priv->last_offset = (glong) 0;
}


static void kkc_sorted_bigram_language_model_finalize (GObject* obj) {
	KkcSortedBigramLanguageModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KKC_TYPE_SORTED_BIGRAM_LANGUAGE_MODEL, KkcSortedBigramLanguageModel);
	kkc_language_model_entry_destroy (&self->priv->_bos);
	kkc_language_model_entry_destroy (&self->priv->_eos);
	_g_object_unref0 (self->priv->input_trie);
	_g_object_unref0 (self->priv->unigram_trie);
	_g_object_unref0 (self->priv->unigram_index);
	_g_object_unref0 (self->priv->bigram_index);
	_g_object_unref0 (self->priv->bigram_filter);
	G_OBJECT_CLASS (kkc_sorted_bigram_language_model_parent_class)->finalize (obj);
}


GType kkc_sorted_bigram_language_model_get_type (void) {
	static volatile gsize kkc_sorted_bigram_language_model_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_sorted_bigram_language_model_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcSortedBigramLanguageModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kkc_sorted_bigram_language_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KkcSortedBigramLanguageModel), 0, (GInstanceInitFunc) kkc_sorted_bigram_language_model_instance_init, NULL };
		static const GInterfaceInfo kkc_unigram_language_model_info = { (GInterfaceInitFunc) kkc_sorted_bigram_language_model_kkc_unigram_language_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo kkc_bigram_language_model_info = { (GInterfaceInitFunc) kkc_sorted_bigram_language_model_kkc_bigram_language_model_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType kkc_sorted_bigram_language_model_type_id;
		kkc_sorted_bigram_language_model_type_id = g_type_register_static (KKC_TYPE_LANGUAGE_MODEL, "KkcSortedBigramLanguageModel", &g_define_type_info, 0);
		g_type_add_interface_static (kkc_sorted_bigram_language_model_type_id, KKC_TYPE_UNIGRAM_LANGUAGE_MODEL, &kkc_unigram_language_model_info);
		g_type_add_interface_static (kkc_sorted_bigram_language_model_type_id, KKC_TYPE_BIGRAM_LANGUAGE_MODEL, &kkc_bigram_language_model_info);
		g_once_init_leave (&kkc_sorted_bigram_language_model_type_id__volatile, kkc_sorted_bigram_language_model_type_id);
	}
	return kkc_sorted_bigram_language_model_type_id__volatile;
}


static void _vala_kkc_sorted_bigram_language_model_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	KkcSortedBigramLanguageModel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, KKC_TYPE_SORTED_BIGRAM_LANGUAGE_MODEL, KkcSortedBigramLanguageModel);
	switch (property_id) {
		case KKC_SORTED_BIGRAM_LANGUAGE_MODEL_BOS:
		{
			KkcLanguageModelEntry boxed;
			kkc_language_model_get_bos ((KkcLanguageModel*) self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		case KKC_SORTED_BIGRAM_LANGUAGE_MODEL_EOS:
		{
			KkcLanguageModelEntry boxed;
			kkc_language_model_get_eos ((KkcLanguageModel*) self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		case KKC_SORTED_BIGRAM_LANGUAGE_MODEL_MIN_COST:
		g_value_set_double (value, kkc_sorted_bigram_language_model_get_min_cost (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



