/* server.c generated by valac 0.20.1.19-a6516, the Vala compiler
 * generated from server.vala, do not modify */

/*
 * Copyright (C) 2012-2013 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2012-2013 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <json-glib/json-glib.h>
#include <libkkc/libkkc.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <config.h>


#define TYPE_SERVER_ERROR_CODE (server_error_code_get_type ())

#define TYPE_SERVER_ERROR (server_error_get_type ())
typedef struct _ServerError ServerError;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))

#define TYPE_SERVER_RESPONSE (server_response_get_type ())
typedef struct _ServerResponse ServerResponse;
#define _server_error_free0(var) ((var == NULL) ? NULL : (var = (server_error_free (var), NULL)))

#define TYPE_SERVER_NOTIFICATION (server_notification_get_type ())
typedef struct _ServerNotification ServerNotification;

#define TYPE_COMMAND_HANDLER (command_handler_get_type ())
#define COMMAND_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMMAND_HANDLER, CommandHandler))
#define COMMAND_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMMAND_HANDLER, CommandHandlerClass))
#define IS_COMMAND_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMMAND_HANDLER))
#define IS_COMMAND_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMMAND_HANDLER))
#define COMMAND_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMMAND_HANDLER, CommandHandlerClass))

typedef struct _CommandHandler CommandHandler;
typedef struct _CommandHandlerClass CommandHandlerClass;
typedef struct _CommandHandlerPrivate CommandHandlerPrivate;

#define TYPE_REPL (repl_get_type ())
#define REPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_REPL, Repl))
#define IS_REPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_REPL))
#define REPL_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_REPL, ReplIface))

typedef struct _Repl Repl;
typedef struct _ReplIface ReplIface;

#define TYPE_SERVER_REPL (server_repl_get_type ())
#define SERVER_REPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SERVER_REPL, ServerRepl))
#define SERVER_REPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SERVER_REPL, ServerReplClass))
#define IS_SERVER_REPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SERVER_REPL))
#define IS_SERVER_REPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SERVER_REPL))
#define SERVER_REPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SERVER_REPL, ServerReplClass))

typedef struct _ServerRepl ServerRepl;
typedef struct _ServerReplClass ServerReplClass;
typedef struct _ServerReplPrivate ServerReplPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define __vala_JsonObject_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonObject_free (var), NULL)))
#define __vala_JsonArray_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonArray_free (var), NULL)))

typedef enum  {
	SERVER_ERROR_CODE_PARSE_ERROR = -32700,
	SERVER_ERROR_CODE_INVALID_REQUEST = -32600,
	SERVER_ERROR_CODE_METHOD_NOT_FOUND = -32601,
	SERVER_ERROR_CODE_INVALID_PARAMS = -32602,
	SERVER_ERROR_CODE_INTERNAL_ERROR = -32603
} ServerErrorCode;

struct _ServerError {
	ServerErrorCode code;
	gchar* message;
	JsonNode* data;
};

struct _ServerResponse {
	JsonNode* result;
	ServerError* error;
};

struct _ServerNotification {
	gchar* method;
	JsonNode* params;
};

typedef void (*CommandCallback) (JsonNode* params, ServerResponse* result, void* user_data);
struct _CommandHandler {
	GObject parent_instance;
	CommandHandlerPrivate * priv;
};

struct _CommandHandlerClass {
	GObjectClass parent_class;
};

struct _CommandHandlerPrivate {
	CommandCallback cb;
	gpointer cb_target;
};

struct _ReplIface {
	GTypeInterface parent_iface;
	gboolean (*parse_arguments) (Repl* self, gchar** args, int args_length1, GError** error);
	gboolean (*run) (Repl* self, GError** error);
};

struct _ServerRepl {
	GObject parent_instance;
	ServerReplPrivate * priv;
};

struct _ServerReplClass {
	GObjectClass parent_class;
};

struct _ServerReplPrivate {
	KkcContext* context;
	GeeMap* command_handlers;
};


static gpointer command_handler_parent_class = NULL;
static gpointer server_repl_parent_class = NULL;
extern gchar* opt_system_dictionary;
extern gchar* opt_user_dictionary;
extern gchar* opt_typing_rule;
extern GOptionGroup* model_group;
extern gchar* opt_model;
static ReplIface* server_repl_repl_parent_iface = NULL;

GType server_error_code_get_type (void) G_GNUC_CONST;
GType server_error_get_type (void) G_GNUC_CONST;
ServerError* server_error_dup (const ServerError* self);
void server_error_free (ServerError* self);
void server_error_copy (const ServerError* self, ServerError* dest);
void server_error_destroy (ServerError* self);
static void _vala_JsonNode_free (JsonNode* self);
void server_error_append (ServerError *self, JsonBuilder* builder);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
GType server_response_get_type (void) G_GNUC_CONST;
ServerResponse* server_response_dup (const ServerResponse* self);
void server_response_free (ServerResponse* self);
void server_response_copy (const ServerResponse* self, ServerResponse* dest);
void server_response_destroy (ServerResponse* self);
void server_response_append (ServerResponse *self, JsonBuilder* builder, JsonNode* id);
GType server_notification_get_type (void) G_GNUC_CONST;
ServerNotification* server_notification_dup (const ServerNotification* self);
void server_notification_free (ServerNotification* self);
void server_notification_copy (const ServerNotification* self, ServerNotification* dest);
void server_notification_destroy (ServerNotification* self);
void server_notification_append (ServerNotification *self, JsonBuilder* builder);
GType command_handler_get_type (void) G_GNUC_CONST;
#define COMMAND_HANDLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_COMMAND_HANDLER, CommandHandlerPrivate))
enum  {
	COMMAND_HANDLER_DUMMY_PROPERTY
};
CommandHandler* command_handler_new (CommandCallback cb, void* cb_target);
CommandHandler* command_handler_construct (GType object_type, CommandCallback cb, void* cb_target);
void command_handler_call (CommandHandler* self, JsonNode* params, ServerResponse* result);
static void command_handler_finalize (GObject* obj);
GType repl_get_type (void) G_GNUC_CONST;
GType server_repl_get_type (void) G_GNUC_CONST;
#define SERVER_REPL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SERVER_REPL, ServerReplPrivate))
enum  {
	SERVER_REPL_DUMMY_PROPERTY
};
static gboolean server_repl_real_parse_arguments (Repl* base, gchar** args, int args_length1, GError** error);
static gboolean server_repl_real_run (Repl* base, GError** error);
static void server_repl_on_candidates_populated (ServerRepl* self);
static void _server_repl_on_candidates_populated_kkc_candidate_list_populated (KkcCandidateList* _sender, gpointer self);
static void server_repl_on_candidates_selected (ServerRepl* self, KkcCandidate* candidate);
static void _server_repl_on_candidates_selected_kkc_candidate_list_selected (KkcCandidateList* _sender, KkcCandidate* candidate, gpointer self);
static void server_repl_create_error_response (ServerRepl* self, ServerErrorCode code, const gchar* message, JsonNode* data, ServerResponse* result);
static JsonObject* _vala_JsonObject_copy (JsonObject* self);
static void _vala_JsonObject_free (JsonObject* self);
static void server_repl_do_process_key_events (ServerRepl* self, JsonNode* params, ServerResponse* result);
static JsonArray* _vala_JsonArray_copy (JsonArray* self);
static void _vala_JsonArray_free (JsonArray* self);
static void server_repl_do_poll_output (ServerRepl* self, JsonNode* params, ServerResponse* result);
static void server_repl_do_get_segments (ServerRepl* self, JsonNode* params, ServerResponse* result);
static void server_repl_do_get_input (ServerRepl* self, JsonNode* params, ServerResponse* result);
static void server_repl_do_reset (ServerRepl* self, JsonNode* params, ServerResponse* result);
ServerRepl* server_repl_new (void);
ServerRepl* server_repl_construct (GType object_type);
static GObject * server_repl_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _server_repl_do_process_key_events_command_callback (JsonNode* params, ServerResponse* result, gpointer self);
static void _server_repl_do_poll_output_command_callback (JsonNode* params, ServerResponse* result, gpointer self);
static void _server_repl_do_get_segments_command_callback (JsonNode* params, ServerResponse* result, gpointer self);
static void _server_repl_do_get_input_command_callback (JsonNode* params, ServerResponse* result, gpointer self);
static void _server_repl_do_reset_command_callback (JsonNode* params, ServerResponse* result, gpointer self);
static void server_repl_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

extern const GOptionEntry context_entries[4];

GType server_error_code_get_type (void) {
	static volatile gsize server_error_code_type_id__volatile = 0;
	if (g_once_init_enter (&server_error_code_type_id__volatile)) {
		static const GEnumValue values[] = {{SERVER_ERROR_CODE_PARSE_ERROR, "SERVER_ERROR_CODE_PARSE_ERROR", "parse-error"}, {SERVER_ERROR_CODE_INVALID_REQUEST, "SERVER_ERROR_CODE_INVALID_REQUEST", "invalid-request"}, {SERVER_ERROR_CODE_METHOD_NOT_FOUND, "SERVER_ERROR_CODE_METHOD_NOT_FOUND", "method-not-found"}, {SERVER_ERROR_CODE_INVALID_PARAMS, "SERVER_ERROR_CODE_INVALID_PARAMS", "invalid-params"}, {SERVER_ERROR_CODE_INTERNAL_ERROR, "SERVER_ERROR_CODE_INTERNAL_ERROR", "internal-error"}, {0, NULL, NULL}};
		GType server_error_code_type_id;
		server_error_code_type_id = g_enum_register_static ("ServerErrorCode", values);
		g_once_init_leave (&server_error_code_type_id__volatile, server_error_code_type_id);
	}
	return server_error_code_type_id__volatile;
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


void server_error_append (ServerError *self, JsonBuilder* builder) {
	JsonBuilder* _tmp0_;
	JsonBuilder* _tmp1_;
	JsonBuilder* _tmp2_;
	ServerErrorCode _tmp3_;
	JsonBuilder* _tmp4_;
	JsonBuilder* _tmp5_;
	const gchar* _tmp6_;
	JsonNode* _tmp7_;
	JsonBuilder* _tmp11_;
	g_return_if_fail (builder != NULL);
	_tmp0_ = builder;
	json_builder_begin_object (_tmp0_);
	_tmp1_ = builder;
	json_builder_set_member_name (_tmp1_, "code");
	_tmp2_ = builder;
	_tmp3_ = (*self).code;
	json_builder_add_int_value (_tmp2_, (gint64) _tmp3_);
	_tmp4_ = builder;
	json_builder_set_member_name (_tmp4_, "message");
	_tmp5_ = builder;
	_tmp6_ = (*self).message;
	json_builder_add_string_value (_tmp5_, _tmp6_);
	_tmp7_ = (*self).data;
	if (_tmp7_ != NULL) {
		JsonBuilder* _tmp8_;
		JsonBuilder* _tmp9_;
		JsonNode* _tmp10_;
		_tmp8_ = builder;
		json_builder_set_member_name (_tmp8_, "data");
		_tmp9_ = builder;
		_tmp10_ = (*self).data;
		json_builder_add_value (_tmp9_, _tmp10_);
	}
	_tmp11_ = builder;
	json_builder_end_object (_tmp11_);
}


static JsonNode* _vala_JsonNode_copy (JsonNode* self) {
	return g_boxed_copy (json_node_get_type (), self);
}


static gpointer __vala_JsonNode_copy0 (gpointer self) {
	return self ? _vala_JsonNode_copy (self) : NULL;
}


void server_error_copy (const ServerError* self, ServerError* dest) {
	ServerErrorCode _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	JsonNode* _tmp3_;
	JsonNode* _tmp4_;
	_tmp0_ = (*self).code;
	(*dest).code = _tmp0_;
	_tmp1_ = (*self).message;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 ((*dest).message);
	(*dest).message = _tmp2_;
	_tmp3_ = (*self).data;
	_tmp4_ = __vala_JsonNode_copy0 (_tmp3_);
	__vala_JsonNode_free0 ((*dest).data);
	(*dest).data = _tmp4_;
}


void server_error_destroy (ServerError* self) {
	_g_free0 ((*self).message);
	__vala_JsonNode_free0 ((*self).data);
}


ServerError* server_error_dup (const ServerError* self) {
	ServerError* dup;
	dup = g_new0 (ServerError, 1);
	server_error_copy (self, dup);
	return dup;
}


void server_error_free (ServerError* self) {
	server_error_destroy (self);
	g_free (self);
}


GType server_error_get_type (void) {
	static volatile gsize server_error_type_id__volatile = 0;
	if (g_once_init_enter (&server_error_type_id__volatile)) {
		GType server_error_type_id;
		server_error_type_id = g_boxed_type_register_static ("ServerError", (GBoxedCopyFunc) server_error_dup, (GBoxedFreeFunc) server_error_free);
		g_once_init_leave (&server_error_type_id__volatile, server_error_type_id);
	}
	return server_error_type_id__volatile;
}


void server_response_append (ServerResponse *self, JsonBuilder* builder, JsonNode* id) {
	gboolean _tmp0_ = FALSE;
	JsonNode* _tmp1_;
	gboolean _tmp3_;
	JsonBuilder* _tmp4_;
	JsonBuilder* _tmp5_;
	JsonBuilder* _tmp6_;
	JsonNode* _tmp7_;
	ServerError* _tmp11_;
	JsonNode* _tmp15_;
	JsonBuilder* _tmp19_;
	g_return_if_fail (builder != NULL);
	_tmp1_ = (*self).result;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ServerError* _tmp2_;
		_tmp2_ = (*self).error;
		_tmp0_ = _tmp2_ == NULL;
	}
	_tmp3_ = _tmp0_;
	g_return_if_fail (_tmp3_);
	_tmp4_ = builder;
	json_builder_begin_object (_tmp4_);
	_tmp5_ = builder;
	json_builder_set_member_name (_tmp5_, "jsonrpc");
	_tmp6_ = builder;
	json_builder_add_string_value (_tmp6_, "2.0");
	_tmp7_ = (*self).result;
	if (_tmp7_ != NULL) {
		JsonBuilder* _tmp8_;
		JsonBuilder* _tmp9_;
		JsonNode* _tmp10_;
		_tmp8_ = builder;
		json_builder_set_member_name (_tmp8_, "result");
		_tmp9_ = builder;
		_tmp10_ = (*self).result;
		json_builder_add_value (_tmp9_, _tmp10_);
	}
	_tmp11_ = (*self).error;
	if (_tmp11_ != NULL) {
		JsonBuilder* _tmp12_;
		ServerError* _tmp13_;
		JsonBuilder* _tmp14_;
		_tmp12_ = builder;
		json_builder_set_member_name (_tmp12_, "error");
		_tmp13_ = (*self).error;
		_tmp14_ = builder;
		server_error_append (_tmp13_, _tmp14_);
	}
	_tmp15_ = id;
	if (_tmp15_ != NULL) {
		JsonBuilder* _tmp16_;
		JsonBuilder* _tmp17_;
		JsonNode* _tmp18_;
		_tmp16_ = builder;
		json_builder_set_member_name (_tmp16_, "id");
		_tmp17_ = builder;
		_tmp18_ = id;
		json_builder_add_value (_tmp17_, _tmp18_);
	}
	_tmp19_ = builder;
	json_builder_end_object (_tmp19_);
}


static gpointer _server_error_dup0 (gpointer self) {
	return self ? server_error_dup (self) : NULL;
}


void server_response_copy (const ServerResponse* self, ServerResponse* dest) {
	JsonNode* _tmp0_;
	JsonNode* _tmp1_;
	ServerError* _tmp2_;
	ServerError* _tmp3_;
	_tmp0_ = (*self).result;
	_tmp1_ = __vala_JsonNode_copy0 (_tmp0_);
	__vala_JsonNode_free0 ((*dest).result);
	(*dest).result = _tmp1_;
	_tmp2_ = (*self).error;
	_tmp3_ = _server_error_dup0 (_tmp2_);
	_server_error_free0 ((*dest).error);
	(*dest).error = _tmp3_;
}


void server_response_destroy (ServerResponse* self) {
	__vala_JsonNode_free0 ((*self).result);
	_server_error_free0 ((*self).error);
}


ServerResponse* server_response_dup (const ServerResponse* self) {
	ServerResponse* dup;
	dup = g_new0 (ServerResponse, 1);
	server_response_copy (self, dup);
	return dup;
}


void server_response_free (ServerResponse* self) {
	server_response_destroy (self);
	g_free (self);
}


GType server_response_get_type (void) {
	static volatile gsize server_response_type_id__volatile = 0;
	if (g_once_init_enter (&server_response_type_id__volatile)) {
		GType server_response_type_id;
		server_response_type_id = g_boxed_type_register_static ("ServerResponse", (GBoxedCopyFunc) server_response_dup, (GBoxedFreeFunc) server_response_free);
		g_once_init_leave (&server_response_type_id__volatile, server_response_type_id);
	}
	return server_response_type_id__volatile;
}


void server_notification_append (ServerNotification *self, JsonBuilder* builder) {
	JsonBuilder* _tmp0_;
	JsonBuilder* _tmp1_;
	JsonBuilder* _tmp2_;
	const gchar* _tmp3_;
	JsonNode* _tmp7_;
	JsonBuilder* _tmp11_;
	g_return_if_fail (builder != NULL);
	_tmp0_ = builder;
	json_builder_begin_object (_tmp0_);
	_tmp1_ = builder;
	json_builder_set_member_name (_tmp1_, "jsonrpc");
	_tmp2_ = builder;
	json_builder_add_string_value (_tmp2_, "2.0");
	_tmp3_ = (*self).method;
	if (_tmp3_ != NULL) {
		JsonBuilder* _tmp4_;
		JsonBuilder* _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = builder;
		json_builder_set_member_name (_tmp4_, "method");
		_tmp5_ = builder;
		_tmp6_ = (*self).method;
		json_builder_add_string_value (_tmp5_, _tmp6_);
	}
	_tmp7_ = (*self).params;
	if (_tmp7_ != NULL) {
		JsonBuilder* _tmp8_;
		JsonBuilder* _tmp9_;
		JsonNode* _tmp10_;
		_tmp8_ = builder;
		json_builder_set_member_name (_tmp8_, "params");
		_tmp9_ = builder;
		_tmp10_ = (*self).params;
		json_builder_add_value (_tmp9_, _tmp10_);
	}
	_tmp11_ = builder;
	json_builder_end_object (_tmp11_);
}


void server_notification_copy (const ServerNotification* self, ServerNotification* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	JsonNode* _tmp2_;
	JsonNode* _tmp3_;
	_tmp0_ = (*self).method;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).method);
	(*dest).method = _tmp1_;
	_tmp2_ = (*self).params;
	_tmp3_ = __vala_JsonNode_copy0 (_tmp2_);
	__vala_JsonNode_free0 ((*dest).params);
	(*dest).params = _tmp3_;
}


void server_notification_destroy (ServerNotification* self) {
	_g_free0 ((*self).method);
	__vala_JsonNode_free0 ((*self).params);
}


ServerNotification* server_notification_dup (const ServerNotification* self) {
	ServerNotification* dup;
	dup = g_new0 (ServerNotification, 1);
	server_notification_copy (self, dup);
	return dup;
}


void server_notification_free (ServerNotification* self) {
	server_notification_destroy (self);
	g_free (self);
}


GType server_notification_get_type (void) {
	static volatile gsize server_notification_type_id__volatile = 0;
	if (g_once_init_enter (&server_notification_type_id__volatile)) {
		GType server_notification_type_id;
		server_notification_type_id = g_boxed_type_register_static ("ServerNotification", (GBoxedCopyFunc) server_notification_dup, (GBoxedFreeFunc) server_notification_free);
		g_once_init_leave (&server_notification_type_id__volatile, server_notification_type_id);
	}
	return server_notification_type_id__volatile;
}


CommandHandler* command_handler_construct (GType object_type, CommandCallback cb, void* cb_target) {
	CommandHandler * self = NULL;
	CommandCallback _tmp0_;
	void* _tmp0__target;
	self = (CommandHandler*) g_object_new (object_type, NULL);
	_tmp0_ = cb;
	_tmp0__target = cb_target;
	self->priv->cb = _tmp0_;
	self->priv->cb_target = _tmp0__target;
	return self;
}


CommandHandler* command_handler_new (CommandCallback cb, void* cb_target) {
	return command_handler_construct (TYPE_COMMAND_HANDLER, cb, cb_target);
}


void command_handler_call (CommandHandler* self, JsonNode* params, ServerResponse* result) {
	CommandCallback _tmp0_;
	void* _tmp0__target;
	JsonNode* _tmp1_;
	ServerResponse _tmp2_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cb;
	_tmp0__target = self->priv->cb_target;
	_tmp1_ = params;
	_tmp0_ (_tmp1_, &_tmp2_, _tmp0__target);
	*result = _tmp2_;
	return;
}


static void command_handler_class_init (CommandHandlerClass * klass) {
	command_handler_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CommandHandlerPrivate));
	G_OBJECT_CLASS (klass)->finalize = command_handler_finalize;
}


static void command_handler_instance_init (CommandHandler * self) {
	self->priv = COMMAND_HANDLER_GET_PRIVATE (self);
}


static void command_handler_finalize (GObject* obj) {
	CommandHandler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COMMAND_HANDLER, CommandHandler);
	G_OBJECT_CLASS (command_handler_parent_class)->finalize (obj);
}


GType command_handler_get_type (void) {
	static volatile gsize command_handler_type_id__volatile = 0;
	if (g_once_init_enter (&command_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CommandHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) command_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CommandHandler), 0, (GInstanceInitFunc) command_handler_instance_init, NULL };
		GType command_handler_type_id;
		command_handler_type_id = g_type_register_static (G_TYPE_OBJECT, "CommandHandler", &g_define_type_info, 0);
		g_once_init_leave (&command_handler_type_id__volatile, command_handler_type_id);
	}
	return command_handler_type_id__volatile;
}


static gboolean server_repl_real_parse_arguments (Repl* base, gchar** args, int args_length1, GError** error) {
	ServerRepl * self;
	gboolean result = FALSE;
	GOptionContext* o = NULL;
	const gchar* _tmp0_ = NULL;
	GOptionContext* _tmp1_;
	GOptionGroup* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GError * _inner_error_ = NULL;
	self = (ServerRepl*) base;
	_tmp0_ = _ ("- run context on the command line");
	_tmp1_ = g_option_context_new (_tmp0_);
	o = _tmp1_;
	g_option_context_add_main_entries (o, context_entries, "libkkc");
	_tmp2_ = model_group;
	model_group = NULL;
	g_option_context_add_group (o, _tmp2_);
	_tmp4_ = g_option_context_parse (o, &args_length1, &args, &_inner_error_);
	_tmp3_ = _tmp4_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_option_context_free0 (o);
		return FALSE;
	}
	result = _tmp3_;
	_g_option_context_free0 (o);
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _server_repl_on_candidates_populated_kkc_candidate_list_populated (KkcCandidateList* _sender, gpointer self) {
	server_repl_on_candidates_populated (self);
}


static void _server_repl_on_candidates_selected_kkc_candidate_list_selected (KkcCandidateList* _sender, KkcCandidate* candidate, gpointer self) {
	server_repl_on_candidates_selected (self, candidate);
}


static gchar* g_file_stream_read_line (FILE* self) {
	gchar* result = NULL;
	gint c = 0;
	GString* ret = NULL;
	GString* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	ret = NULL;
	while (TRUE) {
		gint _tmp0_ = 0;
		gint _tmp1_;
		GString* _tmp2_;
		gint _tmp4_;
		GString* _tmp5_;
		gint _tmp6_;
		_tmp0_ = fgetc (self);
		c = _tmp0_;
		_tmp1_ = c;
		if (!(_tmp1_ != EOF)) {
			break;
		}
		_tmp2_ = ret;
		if (_tmp2_ == NULL) {
			GString* _tmp3_;
			_tmp3_ = g_string_new ("");
			_g_string_free0 (ret);
			ret = _tmp3_;
		}
		_tmp4_ = c;
		if (_tmp4_ == ((gint) '\n')) {
			break;
		}
		_tmp5_ = ret;
		_tmp6_ = c;
		g_string_append_c ((GString*) _tmp5_, (gchar) _tmp6_);
	}
	_tmp7_ = ret;
	if (_tmp7_ == NULL) {
		result = NULL;
		_g_string_free0 (ret);
		return result;
	} else {
		GString* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = ret;
		_tmp9_ = ((GString*) _tmp8_)->str;
		_tmp10_ = g_strdup (_tmp9_);
		result = _tmp10_;
		_g_string_free0 (ret);
		return result;
	}
	_g_string_free0 (ret);
}


static JsonObject* _vala_JsonObject_copy (JsonObject* self) {
	return g_boxed_copy (json_object_get_type (), self);
}


static gpointer __vala_JsonObject_copy0 (gpointer self) {
	return self ? _vala_JsonObject_copy (self) : NULL;
}


static void _vala_JsonObject_free (JsonObject* self) {
	g_boxed_free (json_object_get_type (), self);
}


static gboolean server_repl_real_run (Repl* base, GError** error) {
	ServerRepl * self;
	gboolean result = FALSE;
	const gchar* _tmp0_;
	KkcLanguageModel* model = NULL;
	KkcLanguageModel* _tmp26_;
	KkcContext* _tmp27_;
	KkcContext* _tmp28_;
	KkcCandidateList* _tmp29_;
	KkcCandidateList* _tmp30_;
	KkcContext* _tmp31_;
	KkcCandidateList* _tmp32_;
	KkcCandidateList* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp46_;
	const gchar* _tmp59_;
	gchar* line = NULL;
	JsonGenerator* generator = NULL;
	JsonGenerator* _tmp71_;
	JsonParser* parser = NULL;
	JsonParser* _tmp72_;
	GError * _inner_error_ = NULL;
	self = (ServerRepl*) base;
	_tmp0_ = opt_typing_rule;
	if (g_strcmp0 (_tmp0_, "?") == 0) {
		KkcRuleMetadata** rules = NULL;
		gint _tmp1_ = 0;
		KkcRuleMetadata** _tmp2_ = NULL;
		gint rules_length1;
		gint _rules_size_;
		KkcRuleMetadata** _tmp3_;
		gint _tmp3__length1;
		_tmp2_ = kkc_rule_list (&_tmp1_);
		rules = _tmp2_;
		rules_length1 = _tmp1_;
		_rules_size_ = rules_length1;
		_tmp3_ = rules;
		_tmp3__length1 = rules_length1;
		{
			KkcRuleMetadata** rule_collection = NULL;
			gint rule_collection_length1 = 0;
			gint _rule_collection_size_ = 0;
			gint rule_it = 0;
			rule_collection = _tmp3_;
			rule_collection_length1 = _tmp3__length1;
			for (rule_it = 0; rule_it < _tmp3__length1; rule_it = rule_it + 1) {
				KkcRuleMetadata* _tmp4_;
				KkcRuleMetadata* rule = NULL;
				_tmp4_ = _g_object_ref0 (rule_collection[rule_it]);
				rule = _tmp4_;
				{
					FILE* _tmp5_;
					KkcRuleMetadata* _tmp6_;
					const gchar* _tmp7_;
					const gchar* _tmp8_;
					KkcRuleMetadata* _tmp9_;
					const gchar* _tmp10_;
					const gchar* _tmp11_;
					KkcRuleMetadata* _tmp12_;
					const gchar* _tmp13_;
					const gchar* _tmp14_;
					_tmp5_ = stdout;
					_tmp6_ = rule;
					_tmp7_ = kkc_metadata_file_get_name ((KkcMetadataFile*) _tmp6_);
					_tmp8_ = _tmp7_;
					_tmp9_ = rule;
					_tmp10_ = kkc_metadata_file_get_label ((KkcMetadataFile*) _tmp9_);
					_tmp11_ = _tmp10_;
					_tmp12_ = rule;
					_tmp13_ = kkc_metadata_file_get_description ((KkcMetadataFile*) _tmp12_);
					_tmp14_ = _tmp13_;
					fprintf (_tmp5_, "%s - %s: %s\n", _tmp8_, _tmp11_, _tmp14_);
					_g_object_unref0 (rule);
				}
			}
		}
		result = TRUE;
		rules = (_vala_array_free (rules, rules_length1, (GDestroyNotify) g_object_unref), NULL);
		return result;
	}
	{
		const gchar* _tmp15_ = NULL;
		const gchar* _tmp16_;
		gchar* name = NULL;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		KkcLanguageModel* _tmp20_ = NULL;
		const gchar* _tmp21_;
		KkcLanguageModel* _tmp22_ = NULL;
		_tmp16_ = opt_model;
		if (_tmp16_ == NULL) {
			_tmp15_ = "sorted3";
		} else {
			const gchar* _tmp17_;
			_tmp17_ = opt_model;
			_tmp15_ = _tmp17_;
		}
		_tmp18_ = _tmp15_;
		_tmp19_ = g_strdup (_tmp18_);
		name = _tmp19_;
		_tmp21_ = name;
		_tmp22_ = kkc_language_model_load (_tmp21_, &_inner_error_);
		_tmp20_ = _tmp22_;
		if (_inner_error_ != NULL) {
			_g_free0 (name);
			if (_inner_error_->domain == KKC_LANGUAGE_MODEL_ERROR) {
				goto __catch9_kkc_language_model_error;
			}
			goto __finally9;
		}
		_g_object_unref0 (model);
		model = _tmp20_;
		_g_free0 (name);
	}
	goto __finally9;
	__catch9_kkc_language_model_error:
	{
		GError* e = NULL;
		FILE* _tmp23_;
		GError* _tmp24_;
		const gchar* _tmp25_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp23_ = stderr;
		_tmp24_ = e;
		_tmp25_ = _tmp24_->message;
		fprintf (_tmp23_, "%s\n", _tmp25_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (model);
		return result;
	}
	__finally9:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (model);
		return FALSE;
	}
	_tmp26_ = model;
	_tmp27_ = kkc_context_new (_tmp26_);
	_g_object_unref0 (self->priv->context);
	self->priv->context = _tmp27_;
	_tmp28_ = self->priv->context;
	_tmp29_ = kkc_context_get_candidates (_tmp28_);
	_tmp30_ = _tmp29_;
	g_signal_connect_object (_tmp30_, "populated", (GCallback) _server_repl_on_candidates_populated_kkc_candidate_list_populated, self, 0);
	_tmp31_ = self->priv->context;
	_tmp32_ = kkc_context_get_candidates (_tmp31_);
	_tmp33_ = _tmp32_;
	g_signal_connect_object (_tmp33_, "selected", (GCallback) _server_repl_on_candidates_selected_kkc_candidate_list_selected, self, 0);
	_tmp34_ = opt_user_dictionary;
	if (_tmp34_ != NULL) {
		{
			KkcUserDictionary* _tmp35_ = NULL;
			const gchar* _tmp36_;
			KkcUserDictionary* _tmp37_;
			KkcContext* _tmp38_;
			KkcDictionaryList* _tmp39_;
			KkcDictionaryList* _tmp40_;
			KkcUserDictionary* _tmp41_;
			_tmp36_ = opt_user_dictionary;
			_tmp37_ = kkc_user_dictionary_new (_tmp36_, &_inner_error_);
			_tmp35_ = _tmp37_;
			if (_inner_error_ != NULL) {
				goto __catch10_g_error;
			}
			_tmp38_ = self->priv->context;
			_tmp39_ = kkc_context_get_dictionaries (_tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = _tmp35_;
			kkc_dictionary_list_add (_tmp40_, (KkcDictionary*) _tmp41_);
			_g_object_unref0 (_tmp41_);
		}
		goto __finally10;
		__catch10_g_error:
		{
			GError* e = NULL;
			FILE* _tmp42_;
			const gchar* _tmp43_;
			GError* _tmp44_;
			const gchar* _tmp45_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp42_ = stderr;
			_tmp43_ = opt_user_dictionary;
			_tmp44_ = e;
			_tmp45_ = _tmp44_->message;
			fprintf (_tmp42_, "can't open user dictionary %s: %s", _tmp43_, _tmp45_);
			result = FALSE;
			_g_error_free0 (e);
			_g_object_unref0 (model);
			return result;
		}
		__finally10:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (model);
			return FALSE;
		}
	}
	_tmp46_ = opt_system_dictionary;
	if (_tmp46_ == NULL) {
		gchar* _tmp47_ = NULL;
		_tmp47_ = g_build_filename (DATADIR, "skk", "SKK-JISYO.L", NULL);
		_g_free0 (opt_system_dictionary);
		opt_system_dictionary = _tmp47_;
	}
	{
		KkcSystemSegmentDictionary* _tmp48_ = NULL;
		const gchar* _tmp49_;
		KkcSystemSegmentDictionary* _tmp50_;
		KkcContext* _tmp51_;
		KkcDictionaryList* _tmp52_;
		KkcDictionaryList* _tmp53_;
		KkcSystemSegmentDictionary* _tmp54_;
		_tmp49_ = opt_system_dictionary;
		_tmp50_ = kkc_system_segment_dictionary_new (_tmp49_, "EUC-JP", &_inner_error_);
		_tmp48_ = _tmp50_;
		if (_inner_error_ != NULL) {
			goto __catch11_g_error;
		}
		_tmp51_ = self->priv->context;
		_tmp52_ = kkc_context_get_dictionaries (_tmp51_);
		_tmp53_ = _tmp52_;
		_tmp54_ = _tmp48_;
		kkc_dictionary_list_add (_tmp53_, (KkcDictionary*) _tmp54_);
		_g_object_unref0 (_tmp54_);
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* e = NULL;
		FILE* _tmp55_;
		const gchar* _tmp56_;
		GError* _tmp57_;
		const gchar* _tmp58_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp55_ = stderr;
		_tmp56_ = opt_system_dictionary;
		_tmp57_ = e;
		_tmp58_ = _tmp57_->message;
		fprintf (_tmp55_, "can't open system dictionary %s: %s", _tmp56_, _tmp58_);
		result = FALSE;
		_g_error_free0 (e);
		_g_object_unref0 (model);
		return result;
	}
	__finally11:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (model);
		return FALSE;
	}
	_tmp59_ = opt_typing_rule;
	if (_tmp59_ != NULL) {
		{
			KkcRuleMetadata* metadata = NULL;
			const gchar* _tmp60_;
			KkcRuleMetadata* _tmp61_ = NULL;
			KkcRule* _tmp62_ = NULL;
			KkcRuleMetadata* _tmp63_;
			KkcRule* _tmp64_;
			KkcContext* _tmp65_;
			KkcRule* _tmp66_;
			_tmp60_ = opt_typing_rule;
			_tmp61_ = kkc_rule_metadata_find (_tmp60_);
			metadata = _tmp61_;
			_tmp63_ = metadata;
			_tmp64_ = kkc_rule_new (_tmp63_, &_inner_error_);
			_tmp62_ = _tmp64_;
			if (_inner_error_ != NULL) {
				_g_object_unref0 (metadata);
				if (_inner_error_->domain == KKC_RULE_PARSE_ERROR) {
					goto __catch12_kkc_rule_parse_error;
				}
				goto __finally12;
			}
			_tmp65_ = self->priv->context;
			_tmp66_ = _tmp62_;
			kkc_context_set_typing_rule (_tmp65_, _tmp66_);
			_g_object_unref0 (_tmp66_);
			_g_object_unref0 (metadata);
		}
		goto __finally12;
		__catch12_kkc_rule_parse_error:
		{
			GError* e = NULL;
			FILE* _tmp67_;
			const gchar* _tmp68_;
			GError* _tmp69_;
			const gchar* _tmp70_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp67_ = stderr;
			_tmp68_ = opt_typing_rule;
			_tmp69_ = e;
			_tmp70_ = _tmp69_->message;
			fprintf (_tmp67_, "can't load rule \"%s\": %s\n", _tmp68_, _tmp70_);
			result = FALSE;
			_g_error_free0 (e);
			_g_object_unref0 (model);
			return result;
		}
		__finally12:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (model);
			return FALSE;
		}
	}
	_tmp71_ = json_generator_new ();
	generator = _tmp71_;
	_tmp72_ = json_parser_new ();
	parser = _tmp72_;
	while (TRUE) {
		FILE* _tmp73_;
		gchar* _tmp74_ = NULL;
		const gchar* _tmp75_;
		JsonNode* root = NULL;
		JsonParser* _tmp92_;
		JsonNode* _tmp93_ = NULL;
		JsonNode* _tmp94_;
		JsonNode* _tmp95_;
		JsonNodeType _tmp96_ = 0;
		JsonObject* object = NULL;
		JsonNode* _tmp109_;
		JsonObject* _tmp110_ = NULL;
		JsonObject* _tmp111_;
		JsonObject* _tmp112_;
		gboolean _tmp113_ = FALSE;
		gchar* jsonrpc = NULL;
		JsonObject* _tmp126_;
		const gchar* _tmp127_ = NULL;
		gchar* _tmp128_;
		const gchar* _tmp129_;
		JsonObject* _tmp146_;
		gboolean _tmp147_ = FALSE;
		gchar* method = NULL;
		JsonObject* _tmp160_;
		const gchar* _tmp161_ = NULL;
		gchar* _tmp162_;
		GeeMap* _tmp163_;
		const gchar* _tmp164_;
		gboolean _tmp165_ = FALSE;
		JsonNode* params = NULL;
		JsonObject* _tmp182_;
		gboolean _tmp183_ = FALSE;
		JsonNode* id = NULL;
		JsonObject* _tmp187_;
		gboolean _tmp188_ = FALSE;
		CommandHandler* handler = NULL;
		GeeMap* _tmp192_;
		const gchar* _tmp193_;
		gpointer _tmp194_ = NULL;
		ServerResponse response = {0};
		CommandHandler* _tmp195_;
		JsonNode* _tmp196_;
		ServerResponse _tmp197_ = {0};
		JsonBuilder* builder = NULL;
		JsonBuilder* _tmp198_;
		JsonBuilder* _tmp199_;
		JsonNode* _tmp200_;
		JsonGenerator* _tmp201_;
		JsonBuilder* _tmp202_;
		JsonNode* _tmp203_ = NULL;
		JsonNode* _tmp204_;
		gsize length = 0UL;
		FILE* _tmp205_;
		JsonGenerator* _tmp206_;
		gsize _tmp207_ = 0UL;
		gchar* _tmp208_ = NULL;
		gchar* _tmp209_;
		GMainContext* _tmp210_ = NULL;
		_tmp73_ = stdin;
		_tmp74_ = g_file_stream_read_line (_tmp73_);
		_g_free0 (line);
		line = _tmp74_;
		_tmp75_ = line;
		if (!(_tmp75_ != NULL)) {
			break;
		}
		{
			JsonParser* _tmp76_;
			const gchar* _tmp77_;
			_tmp76_ = parser;
			_tmp77_ = line;
			json_parser_load_from_data (_tmp76_, _tmp77_, (gssize) (-1), &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch13_g_error;
			}
		}
		goto __finally13;
		__catch13_g_error:
		{
			GError* e = NULL;
			ServerResponse response = {0};
			GError* _tmp78_;
			const gchar* _tmp79_;
			ServerResponse _tmp80_ = {0};
			JsonBuilder* builder = NULL;
			JsonBuilder* _tmp81_;
			JsonBuilder* _tmp82_;
			JsonGenerator* _tmp83_;
			JsonBuilder* _tmp84_;
			JsonNode* _tmp85_ = NULL;
			JsonNode* _tmp86_;
			gsize length = 0UL;
			FILE* _tmp87_;
			JsonGenerator* _tmp88_;
			gsize _tmp89_ = 0UL;
			gchar* _tmp90_ = NULL;
			gchar* _tmp91_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp78_ = e;
			_tmp79_ = _tmp78_->message;
			server_repl_create_error_response (self, SERVER_ERROR_CODE_PARSE_ERROR, _tmp79_, NULL, &_tmp80_);
			response = _tmp80_;
			_tmp81_ = json_builder_new ();
			builder = _tmp81_;
			_tmp82_ = builder;
			server_response_append (&response, _tmp82_, NULL);
			_tmp83_ = generator;
			_tmp84_ = builder;
			_tmp85_ = json_builder_get_root (_tmp84_);
			_tmp86_ = _tmp85_;
			json_generator_set_root (_tmp83_, _tmp86_);
			__vala_JsonNode_free0 (_tmp86_);
			_tmp87_ = stdout;
			_tmp88_ = generator;
			_tmp90_ = json_generator_to_data (_tmp88_, &_tmp89_);
			length = _tmp89_;
			_tmp91_ = _tmp90_;
			fprintf (_tmp87_, "%s\n", _tmp91_);
			_g_free0 (_tmp91_);
			_g_object_unref0 (builder);
			server_response_destroy (&response);
			_g_error_free0 (e);
			continue;
		}
		__finally13:
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (parser);
			_g_object_unref0 (generator);
			_g_free0 (line);
			_g_object_unref0 (model);
			return FALSE;
		}
		_tmp92_ = parser;
		_tmp93_ = json_parser_get_root (_tmp92_);
		_tmp94_ = __vala_JsonNode_copy0 (_tmp93_);
		root = _tmp94_;
		_tmp95_ = root;
		_tmp96_ = json_node_get_node_type (_tmp95_);
		if (_tmp96_ != JSON_NODE_OBJECT) {
			ServerResponse response = {0};
			ServerResponse _tmp97_ = {0};
			JsonBuilder* builder = NULL;
			JsonBuilder* _tmp98_;
			JsonBuilder* _tmp99_;
			JsonGenerator* _tmp100_;
			JsonBuilder* _tmp101_;
			JsonNode* _tmp102_ = NULL;
			JsonNode* _tmp103_;
			gsize length = 0UL;
			FILE* _tmp104_;
			JsonGenerator* _tmp105_;
			gsize _tmp106_ = 0UL;
			gchar* _tmp107_ = NULL;
			gchar* _tmp108_;
			server_repl_create_error_response (self, SERVER_ERROR_CODE_INVALID_REQUEST, "request is not an object", NULL, &_tmp97_);
			response = _tmp97_;
			_tmp98_ = json_builder_new ();
			builder = _tmp98_;
			_tmp99_ = builder;
			server_response_append (&response, _tmp99_, NULL);
			_tmp100_ = generator;
			_tmp101_ = builder;
			_tmp102_ = json_builder_get_root (_tmp101_);
			_tmp103_ = _tmp102_;
			json_generator_set_root (_tmp100_, _tmp103_);
			__vala_JsonNode_free0 (_tmp103_);
			_tmp104_ = stdout;
			_tmp105_ = generator;
			_tmp107_ = json_generator_to_data (_tmp105_, &_tmp106_);
			length = _tmp106_;
			_tmp108_ = _tmp107_;
			fprintf (_tmp104_, "%s\n", _tmp108_);
			_g_free0 (_tmp108_);
			_g_object_unref0 (builder);
			server_response_destroy (&response);
			__vala_JsonNode_free0 (root);
			continue;
		}
		_tmp109_ = root;
		_tmp110_ = json_node_get_object (_tmp109_);
		_tmp111_ = __vala_JsonObject_copy0 (_tmp110_);
		object = _tmp111_;
		_tmp112_ = object;
		_tmp113_ = json_object_has_member (_tmp112_, "jsonrpc");
		if (!_tmp113_) {
			ServerResponse response = {0};
			ServerResponse _tmp114_ = {0};
			JsonBuilder* builder = NULL;
			JsonBuilder* _tmp115_;
			JsonBuilder* _tmp116_;
			JsonGenerator* _tmp117_;
			JsonBuilder* _tmp118_;
			JsonNode* _tmp119_ = NULL;
			JsonNode* _tmp120_;
			gsize length = 0UL;
			FILE* _tmp121_;
			JsonGenerator* _tmp122_;
			gsize _tmp123_ = 0UL;
			gchar* _tmp124_ = NULL;
			gchar* _tmp125_;
			server_repl_create_error_response (self, SERVER_ERROR_CODE_INVALID_REQUEST, "missing jsonrpc member", NULL, &_tmp114_);
			response = _tmp114_;
			_tmp115_ = json_builder_new ();
			builder = _tmp115_;
			_tmp116_ = builder;
			server_response_append (&response, _tmp116_, NULL);
			_tmp117_ = generator;
			_tmp118_ = builder;
			_tmp119_ = json_builder_get_root (_tmp118_);
			_tmp120_ = _tmp119_;
			json_generator_set_root (_tmp117_, _tmp120_);
			__vala_JsonNode_free0 (_tmp120_);
			_tmp121_ = stdout;
			_tmp122_ = generator;
			_tmp124_ = json_generator_to_data (_tmp122_, &_tmp123_);
			length = _tmp123_;
			_tmp125_ = _tmp124_;
			fprintf (_tmp121_, "%s\n", _tmp125_);
			_g_free0 (_tmp125_);
			_g_object_unref0 (builder);
			server_response_destroy (&response);
			__vala_JsonObject_free0 (object);
			__vala_JsonNode_free0 (root);
			continue;
		}
		_tmp126_ = object;
		_tmp127_ = json_object_get_string_member (_tmp126_, "jsonrpc");
		_tmp128_ = g_strdup (_tmp127_);
		jsonrpc = _tmp128_;
		_tmp129_ = jsonrpc;
		if (g_strcmp0 (_tmp129_, "2.0") != 0) {
			ServerResponse response = {0};
			const gchar* _tmp130_;
			gchar* _tmp131_ = NULL;
			gchar* _tmp132_;
			ServerResponse _tmp133_ = {0};
			ServerResponse _tmp134_;
			JsonBuilder* builder = NULL;
			JsonBuilder* _tmp135_;
			JsonBuilder* _tmp136_;
			JsonGenerator* _tmp137_;
			JsonBuilder* _tmp138_;
			JsonNode* _tmp139_ = NULL;
			JsonNode* _tmp140_;
			gsize length = 0UL;
			FILE* _tmp141_;
			JsonGenerator* _tmp142_;
			gsize _tmp143_ = 0UL;
			gchar* _tmp144_ = NULL;
			gchar* _tmp145_;
			_tmp130_ = jsonrpc;
			_tmp131_ = g_strdup_printf ("unsupported jsonrpc version %s", _tmp130_);
			_tmp132_ = _tmp131_;
			server_repl_create_error_response (self, SERVER_ERROR_CODE_INVALID_REQUEST, _tmp132_, NULL, &_tmp133_);
			_tmp134_ = _tmp133_;
			_g_free0 (_tmp132_);
			response = _tmp134_;
			_tmp135_ = json_builder_new ();
			builder = _tmp135_;
			_tmp136_ = builder;
			server_response_append (&response, _tmp136_, NULL);
			_tmp137_ = generator;
			_tmp138_ = builder;
			_tmp139_ = json_builder_get_root (_tmp138_);
			_tmp140_ = _tmp139_;
			json_generator_set_root (_tmp137_, _tmp140_);
			__vala_JsonNode_free0 (_tmp140_);
			_tmp141_ = stdout;
			_tmp142_ = generator;
			_tmp144_ = json_generator_to_data (_tmp142_, &_tmp143_);
			length = _tmp143_;
			_tmp145_ = _tmp144_;
			fprintf (_tmp141_, "%s\n", _tmp145_);
			_g_free0 (_tmp145_);
			_g_object_unref0 (builder);
			server_response_destroy (&response);
			_g_free0 (jsonrpc);
			__vala_JsonObject_free0 (object);
			__vala_JsonNode_free0 (root);
			continue;
		}
		_tmp146_ = object;
		_tmp147_ = json_object_has_member (_tmp146_, "method");
		if (!_tmp147_) {
			ServerResponse response = {0};
			ServerResponse _tmp148_ = {0};
			JsonBuilder* builder = NULL;
			JsonBuilder* _tmp149_;
			JsonBuilder* _tmp150_;
			JsonGenerator* _tmp151_;
			JsonBuilder* _tmp152_;
			JsonNode* _tmp153_ = NULL;
			JsonNode* _tmp154_;
			gsize length = 0UL;
			FILE* _tmp155_;
			JsonGenerator* _tmp156_;
			gsize _tmp157_ = 0UL;
			gchar* _tmp158_ = NULL;
			gchar* _tmp159_;
			server_repl_create_error_response (self, SERVER_ERROR_CODE_INVALID_REQUEST, "no method member", NULL, &_tmp148_);
			response = _tmp148_;
			_tmp149_ = json_builder_new ();
			builder = _tmp149_;
			_tmp150_ = builder;
			server_response_append (&response, _tmp150_, NULL);
			_tmp151_ = generator;
			_tmp152_ = builder;
			_tmp153_ = json_builder_get_root (_tmp152_);
			_tmp154_ = _tmp153_;
			json_generator_set_root (_tmp151_, _tmp154_);
			__vala_JsonNode_free0 (_tmp154_);
			_tmp155_ = stdout;
			_tmp156_ = generator;
			_tmp158_ = json_generator_to_data (_tmp156_, &_tmp157_);
			length = _tmp157_;
			_tmp159_ = _tmp158_;
			fprintf (_tmp155_, "%s\n", _tmp159_);
			_g_free0 (_tmp159_);
			_g_object_unref0 (builder);
			server_response_destroy (&response);
			_g_free0 (jsonrpc);
			__vala_JsonObject_free0 (object);
			__vala_JsonNode_free0 (root);
			continue;
		}
		_tmp160_ = object;
		_tmp161_ = json_object_get_string_member (_tmp160_, "method");
		_tmp162_ = g_strdup (_tmp161_);
		method = _tmp162_;
		_tmp163_ = self->priv->command_handlers;
		_tmp164_ = method;
		_tmp165_ = gee_map_has_key (_tmp163_, _tmp164_);
		if (!_tmp165_) {
			ServerResponse response = {0};
			const gchar* _tmp166_;
			gchar* _tmp167_ = NULL;
			gchar* _tmp168_;
			ServerResponse _tmp169_ = {0};
			ServerResponse _tmp170_;
			JsonBuilder* builder = NULL;
			JsonBuilder* _tmp171_;
			JsonBuilder* _tmp172_;
			JsonGenerator* _tmp173_;
			JsonBuilder* _tmp174_;
			JsonNode* _tmp175_ = NULL;
			JsonNode* _tmp176_;
			gsize length = 0UL;
			FILE* _tmp177_;
			JsonGenerator* _tmp178_;
			gsize _tmp179_ = 0UL;
			gchar* _tmp180_ = NULL;
			gchar* _tmp181_;
			_tmp166_ = method;
			_tmp167_ = g_strdup_printf ("no such method %s", _tmp166_);
			_tmp168_ = _tmp167_;
			server_repl_create_error_response (self, SERVER_ERROR_CODE_METHOD_NOT_FOUND, _tmp168_, NULL, &_tmp169_);
			_tmp170_ = _tmp169_;
			_g_free0 (_tmp168_);
			response = _tmp170_;
			_tmp171_ = json_builder_new ();
			builder = _tmp171_;
			_tmp172_ = builder;
			server_response_append (&response, _tmp172_, NULL);
			_tmp173_ = generator;
			_tmp174_ = builder;
			_tmp175_ = json_builder_get_root (_tmp174_);
			_tmp176_ = _tmp175_;
			json_generator_set_root (_tmp173_, _tmp176_);
			__vala_JsonNode_free0 (_tmp176_);
			_tmp177_ = stdout;
			_tmp178_ = generator;
			_tmp180_ = json_generator_to_data (_tmp178_, &_tmp179_);
			length = _tmp179_;
			_tmp181_ = _tmp180_;
			fprintf (_tmp177_, "%s\n", _tmp181_);
			_g_free0 (_tmp181_);
			_g_object_unref0 (builder);
			server_response_destroy (&response);
			_g_free0 (method);
			_g_free0 (jsonrpc);
			__vala_JsonObject_free0 (object);
			__vala_JsonNode_free0 (root);
			continue;
		}
		params = NULL;
		_tmp182_ = object;
		_tmp183_ = json_object_has_member (_tmp182_, "params");
		if (_tmp183_) {
			JsonObject* _tmp184_;
			JsonNode* _tmp185_ = NULL;
			JsonNode* _tmp186_;
			_tmp184_ = object;
			_tmp185_ = json_object_get_member (_tmp184_, "params");
			_tmp186_ = __vala_JsonNode_copy0 (_tmp185_);
			__vala_JsonNode_free0 (params);
			params = _tmp186_;
		}
		id = NULL;
		_tmp187_ = object;
		_tmp188_ = json_object_has_member (_tmp187_, "id");
		if (_tmp188_) {
			JsonObject* _tmp189_;
			JsonNode* _tmp190_ = NULL;
			JsonNode* _tmp191_;
			_tmp189_ = object;
			_tmp190_ = json_object_get_member (_tmp189_, "id");
			_tmp191_ = __vala_JsonNode_copy0 (_tmp190_);
			__vala_JsonNode_free0 (id);
			id = _tmp191_;
		}
		_tmp192_ = self->priv->command_handlers;
		_tmp193_ = method;
		_tmp194_ = gee_map_get (_tmp192_, _tmp193_);
		handler = (CommandHandler*) _tmp194_;
		_tmp195_ = handler;
		_tmp196_ = params;
		command_handler_call (_tmp195_, _tmp196_, &_tmp197_);
		response = _tmp197_;
		_tmp198_ = json_builder_new ();
		builder = _tmp198_;
		_tmp199_ = builder;
		_tmp200_ = id;
		server_response_append (&response, _tmp199_, _tmp200_);
		_tmp201_ = generator;
		_tmp202_ = builder;
		_tmp203_ = json_builder_get_root (_tmp202_);
		_tmp204_ = _tmp203_;
		json_generator_set_root (_tmp201_, _tmp204_);
		__vala_JsonNode_free0 (_tmp204_);
		_tmp205_ = stdout;
		_tmp206_ = generator;
		_tmp208_ = json_generator_to_data (_tmp206_, &_tmp207_);
		length = _tmp207_;
		_tmp209_ = _tmp208_;
		fprintf (_tmp205_, "%s\n", _tmp209_);
		_g_free0 (_tmp209_);
		_tmp210_ = g_main_context_default ();
		g_main_context_iteration (_tmp210_, FALSE);
		_g_object_unref0 (builder);
		server_response_destroy (&response);
		_g_object_unref0 (handler);
		__vala_JsonNode_free0 (id);
		__vala_JsonNode_free0 (params);
		_g_free0 (method);
		_g_free0 (jsonrpc);
		__vala_JsonObject_free0 (object);
		__vala_JsonNode_free0 (root);
	}
	result = TRUE;
	_g_object_unref0 (parser);
	_g_object_unref0 (generator);
	_g_free0 (line);
	_g_object_unref0 (model);
	return result;
}


static void server_repl_create_error_response (ServerRepl* self, ServerErrorCode code, const gchar* message, JsonNode* data, ServerResponse* result) {
	ServerError _error_ = {0};
	ServerErrorCode _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	ServerError _tmp3_ = {0};
	ServerResponse response = {0};
	ServerError _tmp4_;
	ServerError _tmp5_;
	ServerError* _tmp6_;
	ServerResponse _tmp7_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = code;
	_tmp1_ = message;
	_tmp2_ = g_strdup (_tmp1_);
	memset (&_tmp3_, 0, sizeof (ServerError));
	_tmp3_.code = _tmp0_;
	_g_free0 (_tmp3_.message);
	_tmp3_.message = _tmp2_;
	__vala_JsonNode_free0 (_tmp3_.data);
	_tmp3_.data = NULL;
	_error_ = _tmp3_;
	_tmp4_ = _error_;
	_tmp5_ = _tmp4_;
	_tmp6_ = _server_error_dup0 (&_tmp5_);
	memset (&_tmp7_, 0, sizeof (ServerResponse));
	__vala_JsonNode_free0 (_tmp7_.result);
	_tmp7_.result = NULL;
	_server_error_free0 (_tmp7_.error);
	_tmp7_.error = _tmp6_;
	response = _tmp7_;
	*result = response;
	server_error_destroy (&_error_);
	return;
}


static JsonArray* _vala_JsonArray_copy (JsonArray* self) {
	return g_boxed_copy (json_array_get_type (), self);
}


static gpointer __vala_JsonArray_copy0 (gpointer self) {
	return self ? _vala_JsonArray_copy (self) : NULL;
}


static void _vala_JsonArray_free (JsonArray* self) {
	g_boxed_free (json_array_get_type (), self);
}


static void server_repl_do_process_key_events (ServerRepl* self, JsonNode* params, ServerResponse* result) {
	gboolean _tmp0_ = FALSE;
	JsonNode* _tmp1_;
	gboolean _tmp4_;
	gboolean retval = FALSE;
	JsonArray* array = NULL;
	JsonNode* _tmp6_;
	JsonArray* _tmp7_ = NULL;
	JsonArray* _tmp8_;
	JsonNode* node = NULL;
	JsonNode* _tmp25_;
	JsonNode* _tmp26_;
	gboolean _tmp27_;
	ServerResponse response = {0};
	JsonNode* _tmp28_;
	JsonNode* _tmp29_;
	ServerResponse _tmp30_ = {0};
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = params;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		JsonNode* _tmp2_;
		JsonNodeType _tmp3_ = 0;
		_tmp2_ = params;
		_tmp3_ = json_node_get_node_type (_tmp2_);
		_tmp0_ = _tmp3_ != JSON_NODE_ARRAY;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		ServerResponse _tmp5_ = {0};
		server_repl_create_error_response (self, SERVER_ERROR_CODE_INVALID_PARAMS, "params should be array", NULL, &_tmp5_);
		*result = _tmp5_;
		return;
	}
	retval = FALSE;
	_tmp6_ = params;
	_tmp7_ = json_node_get_array (_tmp6_);
	_tmp8_ = __vala_JsonArray_copy0 (_tmp7_);
	array = _tmp8_;
	{
		gint index = 0;
		index = 0;
		{
			gboolean _tmp9_ = FALSE;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp10_;
				gint _tmp12_;
				JsonArray* _tmp13_;
				guint _tmp14_ = 0U;
				gchar* str = NULL;
				JsonArray* _tmp15_;
				gint _tmp16_;
				const gchar* _tmp17_ = NULL;
				gchar* _tmp18_;
				KkcKeyEvent* key = NULL;
				KkcContext* _tmp22_;
				KkcKeyEvent* _tmp23_;
				gboolean _tmp24_ = FALSE;
				_tmp10_ = _tmp9_;
				if (!_tmp10_) {
					gint _tmp11_;
					_tmp11_ = index;
					index = _tmp11_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp12_ = index;
				_tmp13_ = array;
				_tmp14_ = json_array_get_length (_tmp13_);
				if (!(((guint) _tmp12_) < _tmp14_)) {
					break;
				}
				_tmp15_ = array;
				_tmp16_ = index;
				_tmp17_ = json_array_get_string_element (_tmp15_, (guint) _tmp16_);
				_tmp18_ = g_strdup (_tmp17_);
				str = _tmp18_;
				{
					KkcKeyEvent* _tmp19_ = NULL;
					const gchar* _tmp20_;
					KkcKeyEvent* _tmp21_;
					_tmp20_ = str;
					_tmp21_ = kkc_key_event_new_from_string (_tmp20_, &_inner_error_);
					_tmp19_ = _tmp21_;
					if (_inner_error_ != NULL) {
						if (_inner_error_->domain == KKC_KEY_EVENT_FORMAT_ERROR) {
							goto __catch14_kkc_key_event_format_error;
						}
						_g_object_unref0 (key);
						_g_free0 (str);
						__vala_JsonArray_free0 (array);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_g_object_unref0 (key);
					key = _tmp19_;
				}
				goto __finally14;
				__catch14_kkc_key_event_format_error:
				{
					GError* e = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_g_error_free0 (e);
					_g_object_unref0 (key);
					_g_free0 (str);
					break;
				}
				__finally14:
				if (_inner_error_ != NULL) {
					_g_object_unref0 (key);
					_g_free0 (str);
					__vala_JsonArray_free0 (array);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_tmp22_ = self->priv->context;
				_tmp23_ = key;
				_tmp24_ = kkc_context_process_key_event (_tmp22_, _tmp23_);
				if (_tmp24_) {
					retval = TRUE;
				}
				_g_object_unref0 (key);
				_g_free0 (str);
			}
		}
	}
	_tmp25_ = json_node_new (JSON_NODE_VALUE);
	node = _tmp25_;
	_tmp26_ = node;
	_tmp27_ = retval;
	json_node_set_boolean (_tmp26_, _tmp27_);
	_tmp28_ = node;
	_tmp29_ = __vala_JsonNode_copy0 (_tmp28_);
	memset (&_tmp30_, 0, sizeof (ServerResponse));
	__vala_JsonNode_free0 (_tmp30_.result);
	_tmp30_.result = _tmp29_;
	_server_error_free0 (_tmp30_.error);
	_tmp30_.error = NULL;
	response = _tmp30_;
	*result = response;
	__vala_JsonNode_free0 (node);
	__vala_JsonArray_free0 (array);
	return;
}


static void server_repl_do_poll_output (ServerRepl* self, JsonNode* params, ServerResponse* result) {
	gchar* output = NULL;
	KkcContext* _tmp0_;
	gchar* _tmp1_ = NULL;
	JsonNode* node = NULL;
	JsonNode* _tmp2_;
	ServerResponse response = {0};
	JsonNode* _tmp3_;
	ServerResponse _tmp4_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->context;
	_tmp1_ = kkc_context_poll_output (_tmp0_);
	output = _tmp1_;
	_tmp2_ = json_node_new (JSON_NODE_VALUE);
	node = _tmp2_;
	json_node_set_string (node, output);
	_tmp3_ = __vala_JsonNode_copy0 (node);
	memset (&_tmp4_, 0, sizeof (ServerResponse));
	__vala_JsonNode_free0 (_tmp4_.result);
	_tmp4_.result = _tmp3_;
	_server_error_free0 (_tmp4_.error);
	_tmp4_.error = NULL;
	response = _tmp4_;
	*result = response;
	__vala_JsonNode_free0 (node);
	_g_free0 (output);
	return;
}


static void server_repl_do_get_segments (ServerRepl* self, JsonNode* params, ServerResponse* result) {
	JsonArray* array = NULL;
	JsonArray* _tmp0_;
	JsonNode* node = NULL;
	JsonNode* _tmp26_;
	JsonArray* _tmp27_;
	ServerResponse response = {0};
	JsonNode* _tmp28_;
	ServerResponse _tmp29_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = json_array_new ();
	array = _tmp0_;
	{
		KkcSegmentList* _segment_list = NULL;
		KkcContext* _tmp1_;
		KkcSegmentList* _tmp2_;
		KkcSegmentList* _tmp3_;
		KkcSegmentList* _tmp4_;
		gint _segment_size = 0;
		KkcSegmentList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _segment_index = 0;
		_tmp1_ = self->priv->context;
		_tmp2_ = kkc_context_get_segments (_tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _g_object_ref0 (_tmp3_);
		_segment_list = _tmp4_;
		_tmp5_ = _segment_list;
		_tmp6_ = kkc_segment_list_get_size (_tmp5_);
		_tmp7_ = _tmp6_;
		_segment_size = _tmp7_;
		_segment_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			KkcSegment* segment = NULL;
			KkcSegmentList* _tmp11_;
			gint _tmp12_;
			KkcSegment* _tmp13_ = NULL;
			JsonObject* object = NULL;
			JsonObject* _tmp14_;
			JsonObject* _tmp15_;
			KkcSegment* _tmp16_;
			const gchar* _tmp17_;
			const gchar* _tmp18_;
			JsonObject* _tmp19_;
			KkcSegment* _tmp20_;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			JsonArray* _tmp23_;
			JsonObject* _tmp24_;
			JsonObject* _tmp25_;
			_tmp8_ = _segment_index;
			_segment_index = _tmp8_ + 1;
			_tmp9_ = _segment_index;
			_tmp10_ = _segment_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _segment_list;
			_tmp12_ = _segment_index;
			_tmp13_ = kkc_segment_list_get (_tmp11_, _tmp12_);
			segment = _tmp13_;
			_tmp14_ = json_object_new ();
			object = _tmp14_;
			_tmp15_ = object;
			_tmp16_ = segment;
			_tmp17_ = kkc_segment_get_input (_tmp16_);
			_tmp18_ = _tmp17_;
			json_object_set_string_member (_tmp15_, "input", _tmp18_);
			_tmp19_ = object;
			_tmp20_ = segment;
			_tmp21_ = kkc_segment_get_output (_tmp20_);
			_tmp22_ = _tmp21_;
			json_object_set_string_member (_tmp19_, "output", _tmp22_);
			_tmp23_ = array;
			_tmp24_ = object;
			_tmp25_ = __vala_JsonObject_copy0 (_tmp24_);
			json_array_add_object_element (_tmp23_, _tmp25_);
			__vala_JsonObject_free0 (object);
			_g_object_unref0 (segment);
		}
		_g_object_unref0 (_segment_list);
	}
	_tmp26_ = json_node_new (JSON_NODE_ARRAY);
	node = _tmp26_;
	_tmp27_ = array;
	json_node_set_array (node, _tmp27_);
	_tmp28_ = __vala_JsonNode_copy0 (node);
	memset (&_tmp29_, 0, sizeof (ServerResponse));
	__vala_JsonNode_free0 (_tmp29_.result);
	_tmp29_.result = _tmp28_;
	_server_error_free0 (_tmp29_.error);
	_tmp29_.error = NULL;
	response = _tmp29_;
	*result = response;
	__vala_JsonNode_free0 (node);
	__vala_JsonArray_free0 (array);
	return;
}


static void server_repl_do_get_input (ServerRepl* self, JsonNode* params, ServerResponse* result) {
	JsonNode* node = NULL;
	JsonNode* _tmp0_;
	KkcContext* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	ServerResponse response = {0};
	JsonNode* _tmp5_;
	ServerResponse _tmp6_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = json_node_new (JSON_NODE_VALUE);
	node = _tmp0_;
	_tmp1_ = self->priv->context;
	_tmp2_ = kkc_context_get_input (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	json_node_set_string (node, _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = __vala_JsonNode_copy0 (node);
	memset (&_tmp6_, 0, sizeof (ServerResponse));
	__vala_JsonNode_free0 (_tmp6_.result);
	_tmp6_.result = _tmp5_;
	_server_error_free0 (_tmp6_.error);
	_tmp6_.error = NULL;
	response = _tmp6_;
	*result = response;
	__vala_JsonNode_free0 (node);
	return;
}


static void server_repl_do_reset (ServerRepl* self, JsonNode* params, ServerResponse* result) {
	KkcContext* _tmp0_;
	JsonNode* node = NULL;
	JsonNode* _tmp1_;
	ServerResponse response = {0};
	JsonNode* _tmp2_;
	ServerResponse _tmp3_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->context;
	kkc_context_reset (_tmp0_);
	_tmp1_ = json_node_new (JSON_NODE_NULL);
	node = _tmp1_;
	_tmp2_ = __vala_JsonNode_copy0 (node);
	memset (&_tmp3_, 0, sizeof (ServerResponse));
	__vala_JsonNode_free0 (_tmp3_.result);
	_tmp3_.result = _tmp2_;
	_server_error_free0 (_tmp3_.error);
	_tmp3_.error = NULL;
	response = _tmp3_;
	*result = response;
	__vala_JsonNode_free0 (node);
	return;
}


static void server_repl_on_candidates_populated (ServerRepl* self) {
	ServerNotification notification = {0};
	gchar* _tmp0_;
	ServerNotification _tmp1_ = {0};
	JsonGenerator* generator = NULL;
	JsonGenerator* _tmp2_;
	JsonBuilder* builder = NULL;
	JsonBuilder* _tmp3_;
	JsonNode* _tmp4_ = NULL;
	JsonNode* _tmp5_;
	gsize length = 0UL;
	FILE* _tmp6_;
	gsize _tmp7_ = 0UL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("candidatesPopulated");
	memset (&_tmp1_, 0, sizeof (ServerNotification));
	_g_free0 (_tmp1_.method);
	_tmp1_.method = _tmp0_;
	notification = _tmp1_;
	_tmp2_ = json_generator_new ();
	generator = _tmp2_;
	_tmp3_ = json_builder_new ();
	builder = _tmp3_;
	server_notification_append (&notification, builder);
	_tmp4_ = json_builder_get_root (builder);
	_tmp5_ = _tmp4_;
	json_generator_set_root (generator, _tmp5_);
	__vala_JsonNode_free0 (_tmp5_);
	_tmp6_ = stdout;
	_tmp8_ = json_generator_to_data (generator, &_tmp7_);
	length = _tmp7_;
	_tmp9_ = _tmp8_;
	fprintf (_tmp6_, "%s\n", _tmp9_);
	_g_free0 (_tmp9_);
	_g_object_unref0 (builder);
	_g_object_unref0 (generator);
	server_notification_destroy (&notification);
}


static void server_repl_on_candidates_selected (ServerRepl* self, KkcCandidate* candidate) {
	ServerNotification notification = {0};
	gchar* _tmp0_;
	ServerNotification _tmp1_ = {0};
	JsonGenerator* generator = NULL;
	JsonGenerator* _tmp2_;
	JsonBuilder* builder = NULL;
	JsonBuilder* _tmp3_;
	JsonNode* _tmp4_ = NULL;
	JsonNode* _tmp5_;
	gsize length = 0UL;
	FILE* _tmp6_;
	gsize _tmp7_ = 0UL;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (candidate != NULL);
	_tmp0_ = g_strdup ("candidatesSelected");
	memset (&_tmp1_, 0, sizeof (ServerNotification));
	_g_free0 (_tmp1_.method);
	_tmp1_.method = _tmp0_;
	notification = _tmp1_;
	_tmp2_ = json_generator_new ();
	generator = _tmp2_;
	_tmp3_ = json_builder_new ();
	builder = _tmp3_;
	server_notification_append (&notification, builder);
	_tmp4_ = json_builder_get_root (builder);
	_tmp5_ = _tmp4_;
	json_generator_set_root (generator, _tmp5_);
	__vala_JsonNode_free0 (_tmp5_);
	_tmp6_ = stdout;
	_tmp8_ = json_generator_to_data (generator, &_tmp7_);
	length = _tmp7_;
	_tmp9_ = _tmp8_;
	fprintf (_tmp6_, "%s\n", _tmp9_);
	_g_free0 (_tmp9_);
	_g_object_unref0 (builder);
	_g_object_unref0 (generator);
	server_notification_destroy (&notification);
}


ServerRepl* server_repl_construct (GType object_type) {
	ServerRepl * self = NULL;
	self = (ServerRepl*) g_object_new (object_type, NULL);
	return self;
}


ServerRepl* server_repl_new (void) {
	return server_repl_construct (TYPE_SERVER_REPL);
}


static void _server_repl_do_process_key_events_command_callback (JsonNode* params, ServerResponse* result, gpointer self) {
	server_repl_do_process_key_events (self, params, result);
}


static void _server_repl_do_poll_output_command_callback (JsonNode* params, ServerResponse* result, gpointer self) {
	server_repl_do_poll_output (self, params, result);
}


static void _server_repl_do_get_segments_command_callback (JsonNode* params, ServerResponse* result, gpointer self) {
	server_repl_do_get_segments (self, params, result);
}


static void _server_repl_do_get_input_command_callback (JsonNode* params, ServerResponse* result, gpointer self) {
	server_repl_do_get_input (self, params, result);
}


static void _server_repl_do_reset_command_callback (JsonNode* params, ServerResponse* result, gpointer self) {
	server_repl_do_reset (self, params, result);
}


static GObject * server_repl_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	ServerRepl * self;
	GeeHashMap* _tmp0_;
	GeeMap* _tmp1_;
	CommandHandler* _tmp2_;
	CommandHandler* _tmp3_;
	GeeMap* _tmp4_;
	CommandHandler* _tmp5_;
	CommandHandler* _tmp6_;
	GeeMap* _tmp7_;
	CommandHandler* _tmp8_;
	CommandHandler* _tmp9_;
	GeeMap* _tmp10_;
	CommandHandler* _tmp11_;
	CommandHandler* _tmp12_;
	GeeMap* _tmp13_;
	CommandHandler* _tmp14_;
	CommandHandler* _tmp15_;
	parent_class = G_OBJECT_CLASS (server_repl_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SERVER_REPL, ServerRepl);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, TYPE_COMMAND_HANDLER, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->command_handlers);
	self->priv->command_handlers = (GeeMap*) _tmp0_;
	_tmp1_ = self->priv->command_handlers;
	_tmp2_ = command_handler_new (_server_repl_do_process_key_events_command_callback, self);
	_tmp3_ = _tmp2_;
	gee_map_set (_tmp1_, "processKeyEvents", _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = self->priv->command_handlers;
	_tmp5_ = command_handler_new (_server_repl_do_poll_output_command_callback, self);
	_tmp6_ = _tmp5_;
	gee_map_set (_tmp4_, "pollOutput", _tmp6_);
	_g_object_unref0 (_tmp6_);
	_tmp7_ = self->priv->command_handlers;
	_tmp8_ = command_handler_new (_server_repl_do_get_segments_command_callback, self);
	_tmp9_ = _tmp8_;
	gee_map_set (_tmp7_, "getSegments", _tmp9_);
	_g_object_unref0 (_tmp9_);
	_tmp10_ = self->priv->command_handlers;
	_tmp11_ = command_handler_new (_server_repl_do_get_input_command_callback, self);
	_tmp12_ = _tmp11_;
	gee_map_set (_tmp10_, "getInput", _tmp12_);
	_g_object_unref0 (_tmp12_);
	_tmp13_ = self->priv->command_handlers;
	_tmp14_ = command_handler_new (_server_repl_do_reset_command_callback, self);
	_tmp15_ = _tmp14_;
	gee_map_set (_tmp13_, "reset", _tmp15_);
	_g_object_unref0 (_tmp15_);
	return obj;
}


static void server_repl_class_init (ServerReplClass * klass) {
	server_repl_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ServerReplPrivate));
	G_OBJECT_CLASS (klass)->constructor = server_repl_constructor;
	G_OBJECT_CLASS (klass)->finalize = server_repl_finalize;
}


static void server_repl_repl_interface_init (ReplIface * iface) {
	server_repl_repl_parent_iface = g_type_interface_peek_parent (iface);
	iface->parse_arguments = (gboolean (*)(Repl*, gchar**, int, GError**)) server_repl_real_parse_arguments;
	iface->run = (gboolean (*)(Repl*, GError**)) server_repl_real_run;
}


static void server_repl_instance_init (ServerRepl * self) {
	self->priv = SERVER_REPL_GET_PRIVATE (self);
}


static void server_repl_finalize (GObject* obj) {
	ServerRepl * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SERVER_REPL, ServerRepl);
	_g_object_unref0 (self->priv->context);
	_g_object_unref0 (self->priv->command_handlers);
	G_OBJECT_CLASS (server_repl_parent_class)->finalize (obj);
}


GType server_repl_get_type (void) {
	static volatile gsize server_repl_type_id__volatile = 0;
	if (g_once_init_enter (&server_repl_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ServerReplClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) server_repl_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ServerRepl), 0, (GInstanceInitFunc) server_repl_instance_init, NULL };
		static const GInterfaceInfo repl_info = { (GInterfaceInitFunc) server_repl_repl_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType server_repl_type_id;
		server_repl_type_id = g_type_register_static (G_TYPE_OBJECT, "ServerRepl", &g_define_type_info, 0);
		g_type_add_interface_static (server_repl_type_id, TYPE_REPL, &repl_info);
		g_once_init_leave (&server_repl_type_id__volatile, server_repl_type_id);
	}
	return server_repl_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



