/* user-sentence-dictionary.c generated by valac 0.20.1.19-a6516, the Vala compiler
 * generated from user-sentence-dictionary.vala, do not modify */

/*
 * Copyright (C) 2011-2013 Daiki Ueno <ueno@gnu.org>
 * Copyright (C) 2011-2013 Red Hat, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib/gstdio.h>


#define KKC_TYPE_DICTIONARY (kkc_dictionary_get_type ())
#define KKC_DICTIONARY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_DICTIONARY, KkcDictionary))
#define KKC_IS_DICTIONARY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_DICTIONARY))
#define KKC_DICTIONARY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), KKC_TYPE_DICTIONARY, KkcDictionaryIface))

typedef struct _KkcDictionary KkcDictionary;
typedef struct _KkcDictionaryIface KkcDictionaryIface;

#define KKC_TYPE_SENTENCE_DICTIONARY (kkc_sentence_dictionary_get_type ())
#define KKC_SENTENCE_DICTIONARY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_SENTENCE_DICTIONARY, KkcSentenceDictionary))
#define KKC_IS_SENTENCE_DICTIONARY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_SENTENCE_DICTIONARY))
#define KKC_SENTENCE_DICTIONARY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), KKC_TYPE_SENTENCE_DICTIONARY, KkcSentenceDictionaryIface))

typedef struct _KkcSentenceDictionary KkcSentenceDictionary;
typedef struct _KkcSentenceDictionaryIface KkcSentenceDictionaryIface;

#define KKC_TYPE_SEGMENT (kkc_segment_get_type ())
#define KKC_SEGMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_SEGMENT, KkcSegment))
#define KKC_SEGMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_SEGMENT, KkcSegmentClass))
#define KKC_IS_SEGMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_SEGMENT))
#define KKC_IS_SEGMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_SEGMENT))
#define KKC_SEGMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_SEGMENT, KkcSegmentClass))

typedef struct _KkcSegment KkcSegment;
typedef struct _KkcSegmentClass KkcSegmentClass;

#define KKC_TYPE_USER_SENTENCE_DICTIONARY (kkc_user_sentence_dictionary_get_type ())
#define KKC_USER_SENTENCE_DICTIONARY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), KKC_TYPE_USER_SENTENCE_DICTIONARY, KkcUserSentenceDictionary))
#define KKC_USER_SENTENCE_DICTIONARY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), KKC_TYPE_USER_SENTENCE_DICTIONARY, KkcUserSentenceDictionaryClass))
#define KKC_IS_USER_SENTENCE_DICTIONARY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), KKC_TYPE_USER_SENTENCE_DICTIONARY))
#define KKC_IS_USER_SENTENCE_DICTIONARY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), KKC_TYPE_USER_SENTENCE_DICTIONARY))
#define KKC_USER_SENTENCE_DICTIONARY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), KKC_TYPE_USER_SENTENCE_DICTIONARY, KkcUserSentenceDictionaryClass))

typedef struct _KkcUserSentenceDictionary KkcUserSentenceDictionary;
typedef struct _KkcUserSentenceDictionaryClass KkcUserSentenceDictionaryClass;
typedef struct _KkcUserSentenceDictionaryPrivate KkcUserSentenceDictionaryPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define KKC_USER_SENTENCE_DICTIONARY_TYPE_USER_SENTENCE_STATE (kkc_user_sentence_dictionary_user_sentence_state_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _KkcDictionaryIface {
	GTypeInterface parent_iface;
	void (*reload) (KkcDictionary* self, GError** error);
	void (*save) (KkcDictionary* self, GError** error);
};

struct _KkcSentenceDictionaryIface {
	GTypeInterface parent_iface;
	gboolean (*lookup_constraint) (KkcSentenceDictionary* self, const gchar* input, gint** constraint, int* constraint_length1);
	gboolean (*lookup_phrase) (KkcSentenceDictionary* self, gchar** input, int input_length1, gchar*** phrase, int* phrase_length1);
	gboolean (*select_segments) (KkcSentenceDictionary* self, KkcSegment** input, int input_length1);
};

struct _KkcUserSentenceDictionary {
	GObject parent_instance;
	KkcUserSentenceDictionaryPrivate * priv;
};

struct _KkcUserSentenceDictionaryClass {
	GObjectClass parent_class;
};

struct _KkcUserSentenceDictionaryPrivate {
	GFile* file;
	gchar* etag;
	gboolean is_dirty;
	GeeMap* constraint_entries;
	GeeMap* phrase_entries;
};

typedef enum  {
	KKC_USER_SENTENCE_DICTIONARY_USER_SENTENCE_STATE_NONE,
	KKC_USER_SENTENCE_DICTIONARY_USER_SENTENCE_STATE_CONSTRAINT,
	KKC_USER_SENTENCE_DICTIONARY_USER_SENTENCE_STATE_PHRASE
} KkcUserSentenceDictionaryUserSentenceState;

typedef enum  {
	KKC_DICTIONARY_ERROR_NOT_READABLE,
	KKC_DICTIONARY_ERROR_MALFORMED_INPUT
} KkcDictionaryError;
#define KKC_DICTIONARY_ERROR kkc_dictionary_error_quark ()

static gpointer kkc_user_sentence_dictionary_parent_class = NULL;
static KkcDictionaryIface* kkc_user_sentence_dictionary_kkc_dictionary_parent_iface = NULL;
static KkcSentenceDictionaryIface* kkc_user_sentence_dictionary_kkc_sentence_dictionary_parent_iface = NULL;

GType kkc_dictionary_get_type (void) G_GNUC_CONST;
GType kkc_segment_get_type (void) G_GNUC_CONST;
GType kkc_sentence_dictionary_get_type (void) G_GNUC_CONST;
GType kkc_user_sentence_dictionary_get_type (void) G_GNUC_CONST;
#define KKC_USER_SENTENCE_DICTIONARY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), KKC_TYPE_USER_SENTENCE_DICTIONARY, KkcUserSentenceDictionaryPrivate))
enum  {
	KKC_USER_SENTENCE_DICTIONARY_DUMMY_PROPERTY
};
static GType kkc_user_sentence_dictionary_user_sentence_state_get_type (void) G_GNUC_UNUSED;
static void kkc_user_sentence_dictionary_load (KkcUserSentenceDictionary* self, GError** error);
static guint8* _vala_array_dup4 (guint8* self, int length);
GQuark kkc_dictionary_error_quark (void);
gchar* kkc_dictionary_utils_unescape (const gchar* input);
static gint kkc_user_sentence_dictionary_compare_constraint_entry (GeeMapEntry* a, GeeMapEntry* b);
static gint kkc_user_sentence_dictionary_compare_phrase_entry (GeeMapEntry* a, GeeMapEntry* b);
static void kkc_user_sentence_dictionary_write_constraint_entries (KkcUserSentenceDictionary* self, GString* builder, GeeArrayList* entries);
static void kkc_user_sentence_dictionary_write_phrase_entries (KkcUserSentenceDictionary* self, GString* builder, GeeArrayList* entries);
gchar* kkc_dictionary_utils_escape (const gchar* input);
static void kkc_user_sentence_dictionary_real_save (KkcDictionary* base, GError** error);
static void kkc_user_sentence_dictionary_real_reload (KkcDictionary* base, GError** error);
static gboolean kkc_user_sentence_dictionary_real_lookup_constraint (KkcSentenceDictionary* base, const gchar* input, gint** constraint, int* constraint_length1);
static gboolean kkc_user_sentence_dictionary_real_lookup_phrase (KkcSentenceDictionary* base, gchar** input, int input_length1, gchar*** phrase, int* phrase_length1);
static gboolean kkc_user_sentence_dictionary_real_select_segments (KkcSentenceDictionary* base, KkcSegment** segments, int segments_length1);
const gchar* kkc_segment_get_input (KkcSegment* self);
const gchar* kkc_segment_get_output (KkcSegment* self);
KkcUserSentenceDictionary* kkc_user_sentence_dictionary_new (const gchar* path, GError** error);
KkcUserSentenceDictionary* kkc_user_sentence_dictionary_construct (GType object_type, const gchar* path, GError** error);
void kkc_dictionary_reload (KkcDictionary* self, GError** error);
static void kkc_user_sentence_dictionary_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static GType kkc_user_sentence_dictionary_user_sentence_state_get_type (void) {
	static volatile gsize kkc_user_sentence_dictionary_user_sentence_state_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_user_sentence_dictionary_user_sentence_state_type_id__volatile)) {
		static const GEnumValue values[] = {{KKC_USER_SENTENCE_DICTIONARY_USER_SENTENCE_STATE_NONE, "KKC_USER_SENTENCE_DICTIONARY_USER_SENTENCE_STATE_NONE", "none"}, {KKC_USER_SENTENCE_DICTIONARY_USER_SENTENCE_STATE_CONSTRAINT, "KKC_USER_SENTENCE_DICTIONARY_USER_SENTENCE_STATE_CONSTRAINT", "constraint"}, {KKC_USER_SENTENCE_DICTIONARY_USER_SENTENCE_STATE_PHRASE, "KKC_USER_SENTENCE_DICTIONARY_USER_SENTENCE_STATE_PHRASE", "phrase"}, {0, NULL, NULL}};
		GType kkc_user_sentence_dictionary_user_sentence_state_type_id;
		kkc_user_sentence_dictionary_user_sentence_state_type_id = g_enum_register_static ("KkcUserSentenceDictionaryUserSentenceState", values);
		g_once_init_leave (&kkc_user_sentence_dictionary_user_sentence_state_type_id__volatile, kkc_user_sentence_dictionary_user_sentence_state_type_id);
	}
	return kkc_user_sentence_dictionary_user_sentence_state_type_id__volatile;
}


static guint8* _vala_array_dup4 (guint8* self, int length) {
	return g_memdup (self, length * sizeof (guint8));
}


static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gchar* _result_ = NULL;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void kkc_user_sentence_dictionary_load (KkcUserSentenceDictionary* self, GError** error) {
	guint8* contents = NULL;
	gint contents_length1 = 0;
	gint _contents_size_ = 0;
	GFile* _tmp0_;
	guint8* _tmp1_ = NULL;
	gsize _tmp2_;
	gchar* _tmp3_ = NULL;
	GMemoryInputStream* memory = NULL;
	guint8* _tmp4_;
	gint _tmp4__length1;
	guint8* _tmp5_;
	gint _tmp5__length1;
	GDestroyNotify _tmp6_;
	GMemoryInputStream* _tmp7_;
	GDataInputStream* data = NULL;
	GMemoryInputStream* _tmp8_;
	GDataInputStream* _tmp9_;
	gchar* line = NULL;
	gsize length = 0UL;
	gchar* _tmp10_ = NULL;
	GDataInputStream* _tmp11_;
	gsize _tmp12_ = 0UL;
	gchar* _tmp13_ = NULL;
	const gchar* _tmp14_;
	KkcUserSentenceDictionaryUserSentenceState state = 0;
	KkcUserSentenceDictionaryUserSentenceState _tmp23_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->file;
	g_file_load_contents (_tmp0_, NULL, &_tmp1_, &_tmp2_, &_tmp3_, &_inner_error_);
	contents = (g_free (contents), NULL);
	contents = _tmp1_;
	contents_length1 = _tmp2_;
	_contents_size_ = contents_length1;
	_g_free0 (self->priv->etag);
	self->priv->etag = _tmp3_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		contents = (g_free (contents), NULL);
		return;
	}
	_tmp4_ = contents;
	_tmp4__length1 = contents_length1;
	_tmp5_ = (_tmp4_ != NULL) ? _vala_array_dup4 (_tmp4_, _tmp4__length1) : ((gpointer) _tmp4_);
	_tmp5__length1 = _tmp4__length1;
	_tmp6_ = g_free;
	_tmp7_ = (GMemoryInputStream*) g_memory_input_stream_new_from_data (_tmp5_, _tmp5__length1, _tmp6_);
	memory = _tmp7_;
	_tmp8_ = memory;
	_tmp9_ = g_data_input_stream_new ((GInputStream*) _tmp8_);
	data = _tmp9_;
	line = NULL;
	_tmp11_ = data;
	_tmp13_ = g_data_input_stream_read_line (_tmp11_, &_tmp12_, NULL, &_inner_error_);
	length = _tmp12_;
	_tmp10_ = _tmp13_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (line);
		_g_object_unref0 (data);
		_g_object_unref0 (memory);
		contents = (g_free (contents), NULL);
		return;
	}
	_g_free0 (line);
	line = _tmp10_;
	_tmp14_ = line;
	if (_tmp14_ == NULL) {
		_g_free0 (line);
		_g_object_unref0 (data);
		_g_object_unref0 (memory);
		contents = (g_free (contents), NULL);
		return;
	}
	state = KKC_USER_SENTENCE_DICTIONARY_USER_SENTENCE_STATE_NONE;
	while (TRUE) {
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		gboolean _tmp17_ = FALSE;
		gchar* _tmp18_ = NULL;
		GDataInputStream* _tmp19_;
		gsize _tmp20_ = 0UL;
		gchar* _tmp21_ = NULL;
		const gchar* _tmp22_;
		_tmp15_ = line;
		if (!(_tmp15_ != NULL)) {
			break;
		}
		_tmp16_ = line;
		_tmp17_ = g_str_has_prefix (_tmp16_, ";; constraint entries.");
		if (_tmp17_) {
			state = KKC_USER_SENTENCE_DICTIONARY_USER_SENTENCE_STATE_CONSTRAINT;
			break;
		}
		_tmp19_ = data;
		_tmp21_ = g_data_input_stream_read_line (_tmp19_, &_tmp20_, NULL, &_inner_error_);
		length = _tmp20_;
		_tmp18_ = _tmp21_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (line);
			_g_object_unref0 (data);
			_g_object_unref0 (memory);
			contents = (g_free (contents), NULL);
			return;
		}
		_g_free0 (line);
		line = _tmp18_;
		_tmp22_ = line;
		if (_tmp22_ == NULL) {
			break;
		}
	}
	_tmp23_ = state;
	if (_tmp23_ == KKC_USER_SENTENCE_DICTIONARY_USER_SENTENCE_STATE_NONE) {
		GError* _tmp24_;
		_tmp24_ = g_error_new_literal (KKC_DICTIONARY_ERROR, KKC_DICTIONARY_ERROR_MALFORMED_INPUT, "no constraints boundary");
		_inner_error_ = _tmp24_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (line);
		_g_object_unref0 (data);
		_g_object_unref0 (memory);
		contents = (g_free (contents), NULL);
		return;
	}
	while (TRUE) {
		const gchar* _tmp25_;
		gchar* _tmp26_ = NULL;
		GDataInputStream* _tmp27_;
		gsize _tmp28_ = 0UL;
		gchar* _tmp29_ = NULL;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		gboolean _tmp32_ = FALSE;
		gint index = 0;
		const gchar* _tmp33_;
		gint _tmp34_ = 0;
		gint _tmp35_;
		gchar* midasi = NULL;
		const gchar* _tmp38_;
		gint _tmp39_;
		gchar* _tmp40_ = NULL;
		gchar* _tmp41_;
		gchar* _tmp42_ = NULL;
		gchar* _tmp43_;
		gchar* candidates_str = NULL;
		const gchar* _tmp44_;
		gint _tmp45_;
		const gchar* _tmp46_;
		gint _tmp47_;
		gint _tmp48_;
		gchar* _tmp49_ = NULL;
		gchar* _tmp50_;
		gchar* _tmp51_ = NULL;
		gchar* _tmp52_;
		gboolean _tmp53_ = FALSE;
		const gchar* _tmp54_;
		gboolean _tmp55_ = FALSE;
		gboolean _tmp58_;
		KkcUserSentenceDictionaryUserSentenceState _tmp61_;
		_tmp25_ = line;
		if (!(_tmp25_ != NULL)) {
			break;
		}
		_tmp27_ = data;
		_tmp29_ = g_data_input_stream_read_line (_tmp27_, &_tmp28_, NULL, &_inner_error_);
		length = _tmp28_;
		_tmp26_ = _tmp29_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (line);
			_g_object_unref0 (data);
			_g_object_unref0 (memory);
			contents = (g_free (contents), NULL);
			return;
		}
		_g_free0 (line);
		line = _tmp26_;
		_tmp30_ = line;
		if (_tmp30_ == NULL) {
			break;
		}
		_tmp31_ = line;
		_tmp32_ = g_str_has_prefix (_tmp31_, ";; phrase entries.");
		if (_tmp32_) {
			state = KKC_USER_SENTENCE_DICTIONARY_USER_SENTENCE_STATE_PHRASE;
			continue;
		}
		_tmp33_ = line;
		_tmp34_ = string_index_of (_tmp33_, "/", 0);
		index = _tmp34_;
		_tmp35_ = index;
		if (_tmp35_ < 2) {
			const gchar* _tmp36_;
			GError* _tmp37_;
			_tmp36_ = line;
			_tmp37_ = g_error_new (KKC_DICTIONARY_ERROR, KKC_DICTIONARY_ERROR_MALFORMED_INPUT, "can't extract midasi from line %s", _tmp36_);
			_inner_error_ = _tmp37_;
			g_propagate_error (error, _inner_error_);
			_g_free0 (line);
			_g_object_unref0 (data);
			_g_object_unref0 (memory);
			contents = (g_free (contents), NULL);
			return;
		}
		_tmp38_ = line;
		_tmp39_ = index;
		_tmp40_ = string_slice (_tmp38_, (glong) 0, (glong) _tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = string_strip (_tmp41_);
		_tmp43_ = _tmp42_;
		_g_free0 (_tmp41_);
		midasi = _tmp43_;
		_tmp44_ = line;
		_tmp45_ = index;
		_tmp46_ = line;
		_tmp47_ = strlen (_tmp46_);
		_tmp48_ = _tmp47_;
		_tmp49_ = string_slice (_tmp44_, (glong) _tmp45_, (glong) _tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = string_strip (_tmp50_);
		_tmp52_ = _tmp51_;
		_g_free0 (_tmp50_);
		candidates_str = _tmp52_;
		_tmp54_ = candidates_str;
		_tmp55_ = g_str_has_prefix (_tmp54_, "/");
		if (!_tmp55_) {
			_tmp53_ = TRUE;
		} else {
			const gchar* _tmp56_;
			gboolean _tmp57_ = FALSE;
			_tmp56_ = candidates_str;
			_tmp57_ = g_str_has_suffix (_tmp56_, "/");
			_tmp53_ = !_tmp57_;
		}
		_tmp58_ = _tmp53_;
		if (_tmp58_) {
			const gchar* _tmp59_;
			GError* _tmp60_;
			_tmp59_ = candidates_str;
			_tmp60_ = g_error_new (KKC_DICTIONARY_ERROR, KKC_DICTIONARY_ERROR_MALFORMED_INPUT, "can't parse candidates list %s", _tmp59_);
			_inner_error_ = _tmp60_;
			g_propagate_error (error, _inner_error_);
			_g_free0 (candidates_str);
			_g_free0 (midasi);
			_g_free0 (line);
			_g_object_unref0 (data);
			_g_object_unref0 (memory);
			contents = (g_free (contents), NULL);
			return;
		}
		_tmp61_ = state;
		switch (_tmp61_) {
			case KKC_USER_SENTENCE_DICTIONARY_USER_SENTENCE_STATE_CONSTRAINT:
			{
				GeeArrayList* numbers = NULL;
				GeeArrayList* _tmp62_;
				gchar** strv = NULL;
				const gchar* _tmp63_;
				gchar* _tmp64_ = NULL;
				gchar* _tmp65_;
				gchar** _tmp66_;
				gchar** _tmp67_ = NULL;
				gchar** _tmp68_;
				gint _tmp68__length1;
				gint strv_length1;
				gint _strv_size_;
				gchar** _tmp69_;
				gint _tmp69__length1;
				GeeMap* _tmp74_;
				const gchar* _tmp75_;
				GeeArrayList* _tmp76_;
				_tmp62_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL);
				numbers = _tmp62_;
				_tmp63_ = candidates_str;
				_tmp64_ = string_slice (_tmp63_, (glong) 1, (glong) (-1));
				_tmp65_ = _tmp64_;
				_tmp67_ = _tmp66_ = g_strsplit (_tmp65_, ",", 0);
				_tmp68_ = _tmp67_;
				_tmp68__length1 = _vala_array_length (_tmp66_);
				_g_free0 (_tmp65_);
				strv = _tmp68_;
				strv_length1 = _tmp68__length1;
				_strv_size_ = strv_length1;
				_tmp69_ = strv;
				_tmp69__length1 = strv_length1;
				{
					gchar** str_collection = NULL;
					gint str_collection_length1 = 0;
					gint _str_collection_size_ = 0;
					gint str_it = 0;
					str_collection = _tmp69_;
					str_collection_length1 = _tmp69__length1;
					for (str_it = 0; str_it < _tmp69__length1; str_it = str_it + 1) {
						gchar* _tmp70_;
						gchar* str = NULL;
						_tmp70_ = g_strdup (str_collection[str_it]);
						str = _tmp70_;
						{
							GeeArrayList* _tmp71_;
							const gchar* _tmp72_;
							gint _tmp73_ = 0;
							_tmp71_ = numbers;
							_tmp72_ = str;
							_tmp73_ = atoi (_tmp72_);
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp71_, (gpointer) ((gintptr) _tmp73_));
							_g_free0 (str);
						}
					}
				}
				_tmp74_ = self->priv->constraint_entries;
				_tmp75_ = midasi;
				_tmp76_ = numbers;
				gee_map_set (_tmp74_, _tmp75_, (GeeList*) _tmp76_);
				strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (numbers);
				break;
			}
			case KKC_USER_SENTENCE_DICTIONARY_USER_SENTENCE_STATE_PHRASE:
			{
				GeeArrayList* segments = NULL;
				GeeArrayList* _tmp77_;
				gchar** strv = NULL;
				const gchar* _tmp78_;
				gchar* _tmp79_ = NULL;
				gchar* _tmp80_;
				gchar** _tmp81_;
				gchar** _tmp82_ = NULL;
				gchar** _tmp83_;
				gint _tmp83__length1;
				gint strv_length1;
				gint _strv_size_;
				gchar** _tmp84_;
				gint _tmp84__length1;
				GeeMap* _tmp90_;
				const gchar* _tmp91_;
				GeeArrayList* _tmp92_;
				_tmp77_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
				segments = _tmp77_;
				_tmp78_ = candidates_str;
				_tmp79_ = string_slice (_tmp78_, (glong) 1, (glong) (-1));
				_tmp80_ = _tmp79_;
				_tmp82_ = _tmp81_ = g_strsplit (_tmp80_, "/", 0);
				_tmp83_ = _tmp82_;
				_tmp83__length1 = _vala_array_length (_tmp81_);
				_g_free0 (_tmp80_);
				strv = _tmp83_;
				strv_length1 = _tmp83__length1;
				_strv_size_ = strv_length1;
				_tmp84_ = strv;
				_tmp84__length1 = strv_length1;
				{
					gchar** str_collection = NULL;
					gint str_collection_length1 = 0;
					gint _str_collection_size_ = 0;
					gint str_it = 0;
					str_collection = _tmp84_;
					str_collection_length1 = _tmp84__length1;
					for (str_it = 0; str_it < _tmp84__length1; str_it = str_it + 1) {
						gchar* _tmp85_;
						gchar* str = NULL;
						_tmp85_ = g_strdup (str_collection[str_it]);
						str = _tmp85_;
						{
							GeeArrayList* _tmp86_;
							const gchar* _tmp87_;
							gchar* _tmp88_ = NULL;
							gchar* _tmp89_;
							_tmp86_ = segments;
							_tmp87_ = str;
							_tmp88_ = kkc_dictionary_utils_unescape (_tmp87_);
							_tmp89_ = _tmp88_;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp86_, _tmp89_);
							_g_free0 (_tmp89_);
							_g_free0 (str);
						}
					}
				}
				_tmp90_ = self->priv->phrase_entries;
				_tmp91_ = midasi;
				_tmp92_ = segments;
				gee_map_set (_tmp90_, _tmp91_, (GeeList*) _tmp92_);
				strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (segments);
				break;
			}
			default:
			break;
		}
		_g_free0 (candidates_str);
		_g_free0 (midasi);
	}
	_g_free0 (line);
	_g_object_unref0 (data);
	_g_object_unref0 (memory);
	contents = (g_free (contents), NULL);
}


static gint kkc_user_sentence_dictionary_compare_constraint_entry (GeeMapEntry* a, GeeMapEntry* b) {
	gint result = 0;
	GCompareFunc _tmp0_;
	GeeMapEntry* _tmp1_;
	gconstpointer _tmp2_;
	const gchar* _tmp3_;
	GeeMapEntry* _tmp4_;
	gconstpointer _tmp5_;
	const gchar* _tmp6_;
	gint _tmp7_ = 0;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = g_strcmp0;
	_tmp1_ = a;
	_tmp2_ = gee_map_entry_get_key (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = b;
	_tmp5_ = gee_map_entry_get_key (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp0_ ((const gchar*) _tmp3_, (const gchar*) _tmp6_);
	result = _tmp7_;
	return result;
}


static gint kkc_user_sentence_dictionary_compare_phrase_entry (GeeMapEntry* a, GeeMapEntry* b) {
	gint result = 0;
	GCompareFunc _tmp0_;
	GeeMapEntry* _tmp1_;
	gconstpointer _tmp2_;
	const gchar* _tmp3_;
	GeeMapEntry* _tmp4_;
	gconstpointer _tmp5_;
	const gchar* _tmp6_;
	gint _tmp7_ = 0;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = g_strcmp0;
	_tmp1_ = b;
	_tmp2_ = gee_map_entry_get_key (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = a;
	_tmp5_ = gee_map_entry_get_key (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp0_ ((const gchar*) _tmp3_, (const gchar*) _tmp6_);
	result = _tmp7_;
	return result;
}


static void kkc_user_sentence_dictionary_write_constraint_entries (KkcUserSentenceDictionary* self, GString* builder, GeeArrayList* entries) {
	GeeIterator* iter = NULL;
	GeeArrayList* _tmp0_;
	GeeIterator* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	g_return_if_fail (entries != NULL);
	_tmp0_ = entries;
	_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
	iter = _tmp1_;
	while (TRUE) {
		GeeIterator* _tmp2_;
		gboolean _tmp3_ = FALSE;
		GeeMapEntry* entry = NULL;
		GeeIterator* _tmp4_;
		gpointer _tmp5_ = NULL;
		gchar** strv = NULL;
		GeeMapEntry* _tmp6_;
		gconstpointer _tmp7_;
		GeeList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gchar** _tmp11_ = NULL;
		gint strv_length1;
		gint _strv_size_;
		gchar* line = NULL;
		GeeMapEntry* _tmp26_;
		gconstpointer _tmp27_;
		const gchar* _tmp28_;
		gchar** _tmp29_;
		gint _tmp29__length1;
		gchar* _tmp30_ = NULL;
		gchar* _tmp31_;
		gchar* _tmp32_ = NULL;
		gchar* _tmp33_;
		GString* _tmp34_;
		const gchar* _tmp35_;
		_tmp2_ = iter;
		_tmp3_ = gee_iterator_next (_tmp2_);
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = iter;
		_tmp5_ = gee_iterator_get (_tmp4_);
		entry = (GeeMapEntry*) _tmp5_;
		_tmp6_ = entry;
		_tmp7_ = gee_map_entry_get_value (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = gee_collection_get_size ((GeeCollection*) ((GeeList*) _tmp8_));
		_tmp10_ = _tmp9_;
		_tmp11_ = g_new0 (gchar*, _tmp10_ + 1);
		strv = _tmp11_;
		strv_length1 = _tmp10_;
		_strv_size_ = strv_length1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp12_ = FALSE;
				_tmp12_ = TRUE;
				while (TRUE) {
					gboolean _tmp13_;
					gint _tmp15_;
					gchar** _tmp16_;
					gint _tmp16__length1;
					gchar** _tmp17_;
					gint _tmp17__length1;
					gint _tmp18_;
					GeeMapEntry* _tmp19_;
					gconstpointer _tmp20_;
					GeeList* _tmp21_;
					gint _tmp22_;
					gpointer _tmp23_ = NULL;
					gchar* _tmp24_ = NULL;
					gchar* _tmp25_;
					_tmp13_ = _tmp12_;
					if (!_tmp13_) {
						gint _tmp14_;
						_tmp14_ = i;
						i = _tmp14_ + 1;
					}
					_tmp12_ = FALSE;
					_tmp15_ = i;
					_tmp16_ = strv;
					_tmp16__length1 = strv_length1;
					if (!(_tmp15_ < _tmp16__length1)) {
						break;
					}
					_tmp17_ = strv;
					_tmp17__length1 = strv_length1;
					_tmp18_ = i;
					_tmp19_ = entry;
					_tmp20_ = gee_map_entry_get_value (_tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = i;
					_tmp23_ = gee_list_get ((GeeList*) _tmp21_, _tmp22_);
					_tmp24_ = g_strdup_printf ("%i", (gint) ((gintptr) _tmp23_));
					_g_free0 (_tmp17_[_tmp18_]);
					_tmp17_[_tmp18_] = _tmp24_;
					_tmp25_ = _tmp17_[_tmp18_];
				}
			}
		}
		_tmp26_ = entry;
		_tmp27_ = gee_map_entry_get_key (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = strv;
		_tmp29__length1 = strv_length1;
		_tmp30_ = g_strjoinv (",", _tmp29_);
		_tmp31_ = _tmp30_;
		_tmp32_ = g_strdup_printf ("%s /%s/\n", (const gchar*) _tmp28_, _tmp31_);
		_tmp33_ = _tmp32_;
		_g_free0 (_tmp31_);
		line = _tmp33_;
		_tmp34_ = builder;
		_tmp35_ = line;
		g_string_append (_tmp34_, _tmp35_);
		_g_free0 (line);
		strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (entry);
	}
	_g_object_unref0 (iter);
}


static void kkc_user_sentence_dictionary_write_phrase_entries (KkcUserSentenceDictionary* self, GString* builder, GeeArrayList* entries) {
	GeeIterator* iter = NULL;
	GeeArrayList* _tmp0_;
	GeeIterator* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (builder != NULL);
	g_return_if_fail (entries != NULL);
	_tmp0_ = entries;
	_tmp1_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp0_);
	iter = _tmp1_;
	while (TRUE) {
		GeeIterator* _tmp2_;
		gboolean _tmp3_ = FALSE;
		GeeMapEntry* entry = NULL;
		GeeIterator* _tmp4_;
		gpointer _tmp5_ = NULL;
		gchar** strv = NULL;
		GeeMapEntry* _tmp6_;
		gconstpointer _tmp7_;
		GeeList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gchar** _tmp11_ = NULL;
		gint strv_length1;
		gint _strv_size_;
		gchar* line = NULL;
		GeeMapEntry* _tmp27_;
		gconstpointer _tmp28_;
		const gchar* _tmp29_;
		gchar** _tmp30_;
		gint _tmp30__length1;
		gchar* _tmp31_ = NULL;
		gchar* _tmp32_;
		gchar* _tmp33_ = NULL;
		gchar* _tmp34_;
		GString* _tmp35_;
		const gchar* _tmp36_;
		_tmp2_ = iter;
		_tmp3_ = gee_iterator_next (_tmp2_);
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = iter;
		_tmp5_ = gee_iterator_get (_tmp4_);
		entry = (GeeMapEntry*) _tmp5_;
		_tmp6_ = entry;
		_tmp7_ = gee_map_entry_get_value (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = gee_collection_get_size ((GeeCollection*) ((GeeList*) _tmp8_));
		_tmp10_ = _tmp9_;
		_tmp11_ = g_new0 (gchar*, _tmp10_ + 1);
		strv = _tmp11_;
		strv_length1 = _tmp10_;
		_strv_size_ = strv_length1;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp12_ = FALSE;
				_tmp12_ = TRUE;
				while (TRUE) {
					gboolean _tmp13_;
					gint _tmp15_;
					gchar** _tmp16_;
					gint _tmp16__length1;
					gchar** _tmp17_;
					gint _tmp17__length1;
					gint _tmp18_;
					GeeMapEntry* _tmp19_;
					gconstpointer _tmp20_;
					GeeList* _tmp21_;
					gint _tmp22_;
					gpointer _tmp23_ = NULL;
					gchar* _tmp24_;
					gchar* _tmp25_ = NULL;
					gchar* _tmp26_;
					_tmp13_ = _tmp12_;
					if (!_tmp13_) {
						gint _tmp14_;
						_tmp14_ = i;
						i = _tmp14_ + 1;
					}
					_tmp12_ = FALSE;
					_tmp15_ = i;
					_tmp16_ = strv;
					_tmp16__length1 = strv_length1;
					if (!(_tmp15_ < _tmp16__length1)) {
						break;
					}
					_tmp17_ = strv;
					_tmp17__length1 = strv_length1;
					_tmp18_ = i;
					_tmp19_ = entry;
					_tmp20_ = gee_map_entry_get_value (_tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = i;
					_tmp23_ = gee_list_get ((GeeList*) _tmp21_, _tmp22_);
					_tmp24_ = (gchar*) _tmp23_;
					_tmp25_ = kkc_dictionary_utils_escape (_tmp24_);
					_g_free0 (_tmp17_[_tmp18_]);
					_tmp17_[_tmp18_] = _tmp25_;
					_tmp26_ = _tmp17_[_tmp18_];
					_g_free0 (_tmp24_);
				}
			}
		}
		_tmp27_ = entry;
		_tmp28_ = gee_map_entry_get_key (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = strv;
		_tmp30__length1 = strv_length1;
		_tmp31_ = g_strjoinv ("/", _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = g_strdup_printf ("%s /%s/\n", (const gchar*) _tmp29_, _tmp32_);
		_tmp34_ = _tmp33_;
		_g_free0 (_tmp32_);
		line = _tmp34_;
		_tmp35_ = builder;
		_tmp36_ = line;
		g_string_append (_tmp35_, _tmp36_);
		_g_free0 (line);
		strv = (_vala_array_free (strv, strv_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (entry);
	}
	_g_object_unref0 (iter);
}


/**
         * {@inheritDoc}
         */
static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	guint8* _tmp4_;
	gint _tmp4__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static void kkc_user_sentence_dictionary_real_save (KkcDictionary* base, GError** error) {
	KkcUserSentenceDictionary * self;
	gboolean _tmp0_;
	GString* builder = NULL;
	GString* _tmp1_;
	GString* _tmp2_;
	GeeArrayList* _constraint_entries = NULL;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeMap* _tmp5_;
	GeeSet* _tmp6_;
	GeeSet* _tmp7_;
	GeeSet* _tmp8_;
	GeeArrayList* _tmp9_;
	GString* _tmp10_;
	GeeArrayList* _tmp11_;
	GString* _tmp12_;
	GeeArrayList* _phrase_entries = NULL;
	GeeArrayList* _tmp13_;
	GeeArrayList* _tmp14_;
	GeeMap* _tmp15_;
	GeeSet* _tmp16_;
	GeeSet* _tmp17_;
	GeeSet* _tmp18_;
	GeeArrayList* _tmp19_;
	GString* _tmp20_;
	GeeArrayList* _tmp21_;
	GFile* _tmp22_;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_;
	gchar* contents = NULL;
	GString* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	GFile* _tmp30_;
	const gchar* _tmp31_;
	guint8* _tmp32_;
	gint _tmp32__length1;
	guint8* _tmp33_;
	gint _tmp33__length1;
	const gchar* _tmp34_;
	gchar* _tmp35_ = NULL;
	GError * _inner_error_ = NULL;
	self = (KkcUserSentenceDictionary*) base;
	_tmp0_ = self->priv->is_dirty;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = g_string_new ("");
	builder = _tmp1_;
	_tmp2_ = builder;
	g_string_append (_tmp2_, ";; constraint entries.\n");
	_tmp3_ = gee_array_list_new (GEE_MAP_TYPE_ENTRY, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	_constraint_entries = _tmp3_;
	_tmp4_ = _constraint_entries;
	_tmp5_ = self->priv->constraint_entries;
	_tmp6_ = gee_map_get_entries (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_;
	gee_abstract_collection_add_all ((GeeAbstractCollection*) _tmp4_, (GeeCollection*) _tmp8_);
	_g_object_unref0 (_tmp8_);
	_tmp9_ = _constraint_entries;
	gee_list_sort ((GeeList*) _tmp9_, (GCompareFunc) kkc_user_sentence_dictionary_compare_constraint_entry);
	_tmp10_ = builder;
	_tmp11_ = _constraint_entries;
	kkc_user_sentence_dictionary_write_constraint_entries (self, _tmp10_, _tmp11_);
	_tmp12_ = builder;
	g_string_append (_tmp12_, ";; phrase entries.\n");
	_tmp13_ = gee_array_list_new (GEE_MAP_TYPE_ENTRY, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
	_phrase_entries = _tmp13_;
	_tmp14_ = _phrase_entries;
	_tmp15_ = self->priv->phrase_entries;
	_tmp16_ = gee_map_get_entries (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = _tmp17_;
	gee_abstract_collection_add_all ((GeeAbstractCollection*) _tmp14_, (GeeCollection*) _tmp18_);
	_g_object_unref0 (_tmp18_);
	_tmp19_ = _phrase_entries;
	gee_list_sort ((GeeList*) _tmp19_, (GCompareFunc) kkc_user_sentence_dictionary_compare_phrase_entry);
	_tmp20_ = builder;
	_tmp21_ = _phrase_entries;
	kkc_user_sentence_dictionary_write_phrase_entries (self, _tmp20_, _tmp21_);
	_tmp22_ = self->priv->file;
	_tmp23_ = g_file_get_path (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = g_path_get_dirname (_tmp24_);
	_tmp26_ = _tmp25_;
	g_mkdir_with_parents (_tmp26_, 448);
	_g_free0 (_tmp26_);
	_g_free0 (_tmp24_);
	_tmp27_ = builder;
	_tmp28_ = _tmp27_->str;
	_tmp29_ = g_strdup (_tmp28_);
	contents = _tmp29_;
	_tmp30_ = self->priv->file;
	_tmp31_ = contents;
	_tmp32_ = string_get_data (_tmp31_, &_tmp32__length1);
	_tmp33_ = _tmp32_;
	_tmp33__length1 = _tmp32__length1;
	_tmp34_ = self->priv->etag;
	g_file_replace_contents (_tmp30_, _tmp33_, (gsize) _tmp33__length1, _tmp34_, FALSE, G_FILE_CREATE_PRIVATE, &_tmp35_, NULL, &_inner_error_);
	_g_free0 (self->priv->etag);
	self->priv->etag = _tmp35_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (contents);
		_g_object_unref0 (_phrase_entries);
		_g_object_unref0 (_constraint_entries);
		_g_string_free0 (builder);
		return;
	}
	self->priv->is_dirty = FALSE;
	_g_free0 (contents);
	_g_object_unref0 (_phrase_entries);
	_g_object_unref0 (_constraint_entries);
	_g_string_free0 (builder);
}


/**
         * {@inheritDoc}
         */
static void kkc_user_sentence_dictionary_real_reload (KkcDictionary* base, GError** error) {
	KkcUserSentenceDictionary * self;
	gchar* attributes = NULL;
	gchar* _tmp0_;
	GFileInfo* info = NULL;
	GFile* _tmp1_;
	const gchar* _tmp2_;
	GFileInfo* _tmp3_ = NULL;
	GFileInfo* _tmp4_;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_;
	GError * _inner_error_ = NULL;
	self = (KkcUserSentenceDictionary*) base;
	_tmp0_ = g_strdup (G_FILE_ATTRIBUTE_ETAG_VALUE);
	attributes = _tmp0_;
	_tmp1_ = self->priv->file;
	_tmp2_ = attributes;
	_tmp3_ = g_file_query_info (_tmp1_, _tmp2_, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	info = _tmp3_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (attributes);
		return;
	}
	_tmp4_ = info;
	_tmp5_ = g_file_info_get_etag (_tmp4_);
	_tmp6_ = self->priv->etag;
	if (g_strcmp0 (_tmp5_, _tmp6_) != 0) {
		GeeMap* _tmp7_;
		GeeMap* _tmp8_;
		_tmp7_ = self->priv->constraint_entries;
		gee_map_clear (_tmp7_);
		_tmp8_ = self->priv->phrase_entries;
		gee_map_clear (_tmp8_);
		kkc_user_sentence_dictionary_load (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (info);
			_g_free0 (attributes);
			return;
		}
	}
	self->priv->is_dirty = FALSE;
	_g_object_unref0 (info);
	_g_free0 (attributes);
}


/**
         * {@inheritDoc}
         */
static gboolean kkc_user_sentence_dictionary_real_lookup_constraint (KkcSentenceDictionary* base, const gchar* input, gint** constraint, int* constraint_length1) {
	KkcUserSentenceDictionary * self;
	gint* _vala_constraint = NULL;
	int _vala_constraint_length1 = 0;
	gboolean result = FALSE;
	GeeList* entry = NULL;
	GeeMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_ = NULL;
	GeeList* _tmp3_;
	GeeList* _tmp5_;
	gint _tmp6_ = 0;
	gpointer* _tmp7_ = NULL;
	self = (KkcUserSentenceDictionary*) base;
	g_return_val_if_fail (input != NULL, FALSE);
	_tmp0_ = self->priv->constraint_entries;
	_tmp1_ = input;
	_tmp2_ = gee_map_get (_tmp0_, _tmp1_);
	entry = (GeeList*) _tmp2_;
	_tmp3_ = entry;
	if (_tmp3_ == NULL) {
		gint* _tmp4_ = NULL;
		_tmp4_ = g_new0 (gint, 0);
		_vala_constraint = (g_free (_vala_constraint), NULL);
		_vala_constraint = _tmp4_;
		_vala_constraint_length1 = 0;
		result = FALSE;
		_g_object_unref0 (entry);
		if (constraint) {
			*constraint = _vala_constraint;
		} else {
			_vala_constraint = (g_free (_vala_constraint), NULL);
		}
		if (constraint_length1) {
			*constraint_length1 = _vala_constraint_length1;
		}
		return result;
	}
	_tmp5_ = entry;
	_tmp7_ = gee_collection_to_array ((GeeCollection*) _tmp5_, &_tmp6_);
	_vala_constraint = (g_free (_vala_constraint), NULL);
	_vala_constraint = _tmp7_;
	_vala_constraint_length1 = _tmp6_;
	result = TRUE;
	_g_object_unref0 (entry);
	if (constraint) {
		*constraint = _vala_constraint;
	} else {
		_vala_constraint = (g_free (_vala_constraint), NULL);
	}
	if (constraint_length1) {
		*constraint_length1 = _vala_constraint_length1;
	}
	return result;
}


/**
         * {@inheritDoc}
         */
static gboolean kkc_user_sentence_dictionary_real_lookup_phrase (KkcSentenceDictionary* base, gchar** input, int input_length1, gchar*** phrase, int* phrase_length1) {
	KkcUserSentenceDictionary * self;
	gchar** _vala_phrase = NULL;
	int _vala_phrase_length1 = 0;
	gboolean result = FALSE;
	gchar* _input = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar* _tmp1_ = NULL;
	GeeList* entry = NULL;
	GeeMap* _tmp2_;
	const gchar* _tmp3_;
	gpointer _tmp4_ = NULL;
	GeeList* _tmp5_;
	GeeList* _tmp7_;
	gint _tmp8_ = 0;
	gpointer* _tmp9_ = NULL;
	self = (KkcUserSentenceDictionary*) base;
	_tmp0_ = input;
	_tmp0__length1 = input_length1;
	_tmp1_ = g_strjoinv (" ", _tmp0_);
	_input = _tmp1_;
	_tmp2_ = self->priv->phrase_entries;
	_tmp3_ = _input;
	_tmp4_ = gee_map_get (_tmp2_, _tmp3_);
	entry = (GeeList*) _tmp4_;
	_tmp5_ = entry;
	if (_tmp5_ == NULL) {
		gchar** _tmp6_ = NULL;
		_tmp6_ = g_new0 (gchar*, 0 + 1);
		_vala_phrase = (_vala_array_free (_vala_phrase, _vala_phrase_length1, (GDestroyNotify) g_free), NULL);
		_vala_phrase = _tmp6_;
		_vala_phrase_length1 = 0;
		result = FALSE;
		_g_object_unref0 (entry);
		_g_free0 (_input);
		if (phrase) {
			*phrase = _vala_phrase;
		} else {
			_vala_phrase = (_vala_array_free (_vala_phrase, _vala_phrase_length1, (GDestroyNotify) g_free), NULL);
		}
		if (phrase_length1) {
			*phrase_length1 = _vala_phrase_length1;
		}
		return result;
	}
	_tmp7_ = entry;
	_tmp9_ = gee_collection_to_array ((GeeCollection*) _tmp7_, &_tmp8_);
	_vala_phrase = (_vala_array_free (_vala_phrase, _vala_phrase_length1, (GDestroyNotify) g_free), NULL);
	_vala_phrase = _tmp9_;
	_vala_phrase_length1 = _tmp8_;
	result = TRUE;
	_g_object_unref0 (entry);
	_g_free0 (_input);
	if (phrase) {
		*phrase = _vala_phrase;
	} else {
		_vala_phrase = (_vala_array_free (_vala_phrase, _vala_phrase_length1, (GDestroyNotify) g_free), NULL);
	}
	if (phrase_length1) {
		*phrase_length1 = _vala_phrase_length1;
	}
	return result;
}


/**
         * {@inheritDoc}
         */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean kkc_user_sentence_dictionary_real_select_segments (KkcSentenceDictionary* base, KkcSegment** segments, int segments_length1) {
	KkcUserSentenceDictionary * self;
	gboolean result = FALSE;
	gint offset = 0;
	GeeArrayList* input = NULL;
	GeeArrayList* _tmp0_;
	GeeArrayList* constraint = NULL;
	GeeArrayList* _tmp1_;
	GeeArrayList* phrase = NULL;
	GeeArrayList* _tmp2_;
	KkcSegment** _tmp3_;
	gint _tmp3__length1;
	gint _tmp21_;
	GeeArrayList* _tmp22_;
	GeeMap* _tmp23_;
	GeeArrayList* _tmp24_;
	gint _tmp25_ = 0;
	gpointer* _tmp26_ = NULL;
	gchar** _tmp27_;
	gint _tmp27__length1;
	gchar* _tmp28_ = NULL;
	gchar* _tmp29_;
	GeeArrayList* _tmp30_;
	GeeMap* _tmp31_;
	GeeArrayList* _tmp32_;
	gint _tmp33_ = 0;
	gpointer* _tmp34_ = NULL;
	gchar** _tmp35_;
	gint _tmp35__length1;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_;
	GeeArrayList* _tmp38_;
	self = (KkcUserSentenceDictionary*) base;
	offset = 0;
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	input = _tmp0_;
	_tmp1_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL);
	constraint = _tmp1_;
	_tmp2_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	phrase = _tmp2_;
	_tmp3_ = segments;
	_tmp3__length1 = segments_length1;
	{
		KkcSegment** segment_collection = NULL;
		gint segment_collection_length1 = 0;
		gint _segment_collection_size_ = 0;
		gint segment_it = 0;
		segment_collection = _tmp3_;
		segment_collection_length1 = _tmp3__length1;
		for (segment_it = 0; segment_it < _tmp3__length1; segment_it = segment_it + 1) {
			KkcSegment* _tmp4_;
			KkcSegment* segment = NULL;
			_tmp4_ = _g_object_ref0 (segment_collection[segment_it]);
			segment = _tmp4_;
			{
				gint count = 0;
				KkcSegment* _tmp5_;
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				gint _tmp8_ = 0;
				gint _tmp9_;
				gint _tmp10_;
				GeeArrayList* _tmp11_;
				gint _tmp12_;
				GeeArrayList* _tmp13_;
				KkcSegment* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				GeeArrayList* _tmp17_;
				KkcSegment* _tmp18_;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				_tmp5_ = segment;
				_tmp6_ = kkc_segment_get_input (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = g_utf8_strlen (_tmp7_, (gssize) (-1));
				count = _tmp8_;
				_tmp9_ = offset;
				_tmp10_ = count;
				offset = _tmp9_ + _tmp10_;
				_tmp11_ = constraint;
				_tmp12_ = offset;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, (gpointer) ((gintptr) _tmp12_));
				_tmp13_ = phrase;
				_tmp14_ = segment;
				_tmp15_ = kkc_segment_get_output (_tmp14_);
				_tmp16_ = _tmp15_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp16_);
				_tmp17_ = input;
				_tmp18_ = segment;
				_tmp19_ = kkc_segment_get_input (_tmp18_);
				_tmp20_ = _tmp19_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, _tmp20_);
				_g_object_unref0 (segment);
			}
		}
	}
	_tmp21_ = offset;
	if (_tmp21_ < 3) {
		result = FALSE;
		_g_object_unref0 (phrase);
		_g_object_unref0 (constraint);
		_g_object_unref0 (input);
		return result;
	}
	_tmp22_ = input;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, NULL);
	_tmp23_ = self->priv->constraint_entries;
	_tmp24_ = input;
	_tmp26_ = gee_abstract_collection_to_array ((GeeAbstractCollection*) _tmp24_, &_tmp25_);
	_tmp27_ = _tmp26_;
	_tmp27__length1 = _tmp25_;
	_tmp28_ = g_strjoinv ("", _tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = constraint;
	gee_map_set (_tmp23_, _tmp29_, (GeeList*) _tmp30_);
	_g_free0 (_tmp29_);
	_tmp27_ = (_vala_array_free (_tmp27_, _tmp27__length1, (GDestroyNotify) g_free), NULL);
	_tmp31_ = self->priv->phrase_entries;
	_tmp32_ = input;
	_tmp34_ = gee_abstract_collection_to_array ((GeeAbstractCollection*) _tmp32_, &_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp35__length1 = _tmp33_;
	_tmp36_ = g_strjoinv (" ", _tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = phrase;
	gee_map_set (_tmp31_, _tmp37_, (GeeList*) _tmp38_);
	_g_free0 (_tmp37_);
	_tmp35_ = (_vala_array_free (_tmp35_, _tmp35__length1, (GDestroyNotify) g_free), NULL);
	self->priv->is_dirty = TRUE;
	result = TRUE;
	_g_object_unref0 (phrase);
	_g_object_unref0 (constraint);
	_g_object_unref0 (input);
	return result;
}


/**
         * Create a new UserSentenceDictionary.
         *
         * @param path a path to the file
         *
         * @return a new UserDictionary
         * @throws GLib.Error if opening the file is failed
         */
KkcUserSentenceDictionary* kkc_user_sentence_dictionary_construct (GType object_type, const gchar* path, GError** error) {
	KkcUserSentenceDictionary * self = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_ = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (path != NULL, NULL);
	self = (KkcUserSentenceDictionary*) g_object_new (object_type, NULL);
	_tmp0_ = path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp1_;
	_tmp2_ = g_strdup ("");
	_g_free0 (self->priv->etag);
	self->priv->etag = _tmp2_;
	_tmp3_ = path;
	_tmp4_ = g_file_test (_tmp3_, G_FILE_TEST_EXISTS);
	if (_tmp4_) {
		kkc_dictionary_reload ((KkcDictionary*) self, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (self);
			return NULL;
		}
	}
	return self;
}


KkcUserSentenceDictionary* kkc_user_sentence_dictionary_new (const gchar* path, GError** error) {
	return kkc_user_sentence_dictionary_construct (KKC_TYPE_USER_SENTENCE_DICTIONARY, path, error);
}


static void kkc_user_sentence_dictionary_class_init (KkcUserSentenceDictionaryClass * klass) {
	kkc_user_sentence_dictionary_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (KkcUserSentenceDictionaryPrivate));
	G_OBJECT_CLASS (klass)->finalize = kkc_user_sentence_dictionary_finalize;
}


static void kkc_user_sentence_dictionary_kkc_dictionary_interface_init (KkcDictionaryIface * iface) {
	kkc_user_sentence_dictionary_kkc_dictionary_parent_iface = g_type_interface_peek_parent (iface);
	iface->save = (void (*)(KkcDictionary*, GError**)) kkc_user_sentence_dictionary_real_save;
	iface->reload = (void (*)(KkcDictionary*, GError**)) kkc_user_sentence_dictionary_real_reload;
}


static void kkc_user_sentence_dictionary_kkc_sentence_dictionary_interface_init (KkcSentenceDictionaryIface * iface) {
	kkc_user_sentence_dictionary_kkc_sentence_dictionary_parent_iface = g_type_interface_peek_parent (iface);
	iface->lookup_constraint = (gboolean (*)(KkcSentenceDictionary*, const gchar*, gint**, int*)) kkc_user_sentence_dictionary_real_lookup_constraint;
	iface->lookup_phrase = (gboolean (*)(KkcSentenceDictionary*, gchar**, int, gchar***, int*)) kkc_user_sentence_dictionary_real_lookup_phrase;
	iface->select_segments = (gboolean (*)(KkcSentenceDictionary*, KkcSegment**, int)) kkc_user_sentence_dictionary_real_select_segments;
}


static void kkc_user_sentence_dictionary_instance_init (KkcUserSentenceDictionary * self) {
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	self->priv = KKC_USER_SENTENCE_DICTIONARY_GET_PRIVATE (self);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	self->priv->constraint_entries = (GeeMap*) _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	self->priv->phrase_entries = (GeeMap*) _tmp1_;
}


static void kkc_user_sentence_dictionary_finalize (GObject* obj) {
	KkcUserSentenceDictionary * self;
	GeeMapIterator* constraint_iter = NULL;
	GeeMap* _tmp0_;
	GeeMapIterator* _tmp1_ = NULL;
	GeeMap* _tmp7_;
	GeeMapIterator* phrase_iter = NULL;
	GeeMap* _tmp8_;
	GeeMapIterator* _tmp9_ = NULL;
	GeeMap* _tmp15_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, KKC_TYPE_USER_SENTENCE_DICTIONARY, KkcUserSentenceDictionary);
	_tmp0_ = self->priv->constraint_entries;
	_tmp1_ = gee_map_map_iterator (_tmp0_);
	constraint_iter = _tmp1_;
	while (TRUE) {
		GeeMapIterator* _tmp2_;
		gboolean _tmp3_ = FALSE;
		GeeMapIterator* _tmp4_;
		gpointer _tmp5_ = NULL;
		GeeList* _tmp6_;
		_tmp2_ = constraint_iter;
		_tmp3_ = gee_map_iterator_next (_tmp2_);
		if (!_tmp3_) {
			break;
		}
		_tmp4_ = constraint_iter;
		_tmp5_ = gee_map_iterator_get_value (_tmp4_);
		_tmp6_ = (GeeList*) _tmp5_;
		gee_collection_clear ((GeeCollection*) _tmp6_);
		_g_object_unref0 (_tmp6_);
	}
	_tmp7_ = self->priv->constraint_entries;
	gee_map_clear (_tmp7_);
	_tmp8_ = self->priv->phrase_entries;
	_tmp9_ = gee_map_map_iterator (_tmp8_);
	phrase_iter = _tmp9_;
	while (TRUE) {
		GeeMapIterator* _tmp10_;
		gboolean _tmp11_ = FALSE;
		GeeMapIterator* _tmp12_;
		gpointer _tmp13_ = NULL;
		GeeList* _tmp14_;
		_tmp10_ = phrase_iter;
		_tmp11_ = gee_map_iterator_next (_tmp10_);
		if (!_tmp11_) {
			break;
		}
		_tmp12_ = phrase_iter;
		_tmp13_ = gee_map_iterator_get_value (_tmp12_);
		_tmp14_ = (GeeList*) _tmp13_;
		gee_collection_clear ((GeeCollection*) _tmp14_);
		_g_object_unref0 (_tmp14_);
	}
	_tmp15_ = self->priv->phrase_entries;
	gee_map_clear (_tmp15_);
	_g_object_unref0 (phrase_iter);
	_g_object_unref0 (constraint_iter);
	_g_object_unref0 (self->priv->file);
	_g_free0 (self->priv->etag);
	_g_object_unref0 (self->priv->constraint_entries);
	_g_object_unref0 (self->priv->phrase_entries);
	G_OBJECT_CLASS (kkc_user_sentence_dictionary_parent_class)->finalize (obj);
}


/**
     * File based implementation of SentenceDictionary with write access.
     */
GType kkc_user_sentence_dictionary_get_type (void) {
	static volatile gsize kkc_user_sentence_dictionary_type_id__volatile = 0;
	if (g_once_init_enter (&kkc_user_sentence_dictionary_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (KkcUserSentenceDictionaryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) kkc_user_sentence_dictionary_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KkcUserSentenceDictionary), 0, (GInstanceInitFunc) kkc_user_sentence_dictionary_instance_init, NULL };
		static const GInterfaceInfo kkc_dictionary_info = { (GInterfaceInitFunc) kkc_user_sentence_dictionary_kkc_dictionary_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo kkc_sentence_dictionary_info = { (GInterfaceInitFunc) kkc_user_sentence_dictionary_kkc_sentence_dictionary_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType kkc_user_sentence_dictionary_type_id;
		kkc_user_sentence_dictionary_type_id = g_type_register_static (G_TYPE_OBJECT, "KkcUserSentenceDictionary", &g_define_type_info, 0);
		g_type_add_interface_static (kkc_user_sentence_dictionary_type_id, KKC_TYPE_DICTIONARY, &kkc_dictionary_info);
		g_type_add_interface_static (kkc_user_sentence_dictionary_type_id, KKC_TYPE_SENTENCE_DICTIONARY, &kkc_sentence_dictionary_info);
		g_once_init_leave (&kkc_user_sentence_dictionary_type_id__volatile, kkc_user_sentence_dictionary_type_id);
	}
	return kkc_user_sentence_dictionary_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



