# Default Makefile targets, for Libreswan
#
# Copyright (C) 2015 Andrew Cagney <cagney@gnu.org>
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2 of the License, or (at your
# option) any later version.  See <http://www.fsf.org/copyleft/gpl.txt>.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
# or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.

# Define a standard set of global (recursive) and local targets.

# Note: To prevent recursive explosion, recursive targets should
# depend directly on local targets, and not on other recursive
# targets.

# Note: To prevent a parallel recursion explosion, recursive targets
# should only depend on local targets.  For instance implementing
# "all" as "all: base manpages" would result in make attempting to, in
# parallel, recursively build both "base" and "manpages".  Rules
# building Makefile dependencies are not ready for this.
#
# Note: For reasons similar to the above target aliases should, at
# most, depend on on global (recursive) target.

# XXX: BROKEN_TARGETS, found in top-level/Makefile and mk/top.mk have
# custom rules and use ::.  They also, typically, descend into
# $(builddir) instead of $(srcdir).

# This is the default; unless your Makefile puts something earlier.

all:

# For historic reasons, "programs" also builds everything.

.PHONY: programs
programs: all

# All:

TARGETS = base manpages
LOCAL_TARGETS = $(addprefix local-, $(TARGETS))
GLOBAL_TARGETS += all $(TARGETS)
.PHONY: all $(TARGETS) $(LOCAL_TARGETS)

all: $(LOCAL_TARGETS)
base: local-base
manpages: local-manpages
$(LOCAL_TARGETS):

# Install:

INSTALL_TARGETS = $(addprefix install-,$(TARGETS))
INSTALL_LOCAL_TARGETS = $(addprefix install-,$(LOCAL_TARGETS))
GLOBAL_TARGETS += install $(INSTALL_TARGETS)
.PHONY: install $(INSTALL_TARGETS) $(INSTALL_LOCAL_TARGETS)

ifeq ($(filter install,$(BROKEN_TARGETS)),)
install: $(INSTALL_LOCAL_TARGETS)
else
install:: $(INSTALL_LOCAL_TARGETS)
endif
install-base: install-local-base
install-manpages: install-local-manpages
install-local-base: local-base
install-local-manpages: local-manpages
$(INSTALL_LOCAL_TARGETS):

# Clean:

CLEAN_TARGETS = $(addprefix clean-, $(TARGETS))
CLEAN_LOCAL_TARGETS = $(addprefix clean-, $(LOCAL_TARGETS))
GLOBAL_TARGETS += clean $(CLEAN_TARGETS)
.PHONY: clean $(CLEAN_TARGETS) $(CLEAN_LOCAL_TARGETS)

ifeq ($(filter clean,$(BROKEN_TARGETS)),)
clean: $(CLEAN_LOCAL_TARGETS)
else
clean:: $(CLEAN_LOCAL_TARGETS)
endif
clean-base: clean-local-base
clean-manpages: clean-local-manpages
$(CLEAN_LOCAL_TARGETS):

# The install_file_list target is special; the command:
#
#    $ make install_file_list > file-list
#
# must only contain the list of files that would be installed
# (generated by list-local-base et.al.).  Consequently:
#
# - to stop "Nothing to be done" messages, the target is never empty
#
# - to stop make's directory messages, --no-print-directory is
#   specified

LIST_TARGETS = $(addprefix list-, $(TARGETS))
LIST_LOCAL_TARGETS = $(addprefix list-, $(LOCAL_TARGETS))
.PHONY: install_file_list $(LIST_TARGETS) $(LIST_LOCAL_TARGETS)
install_file_list $(LIST_TARGETS):
	@set -eu ; $(foreach dir,$(SUBDIRS), \
		echo $(PWD)/$(dir): 1>&2 ; \
		$(MAKE) -C $(dir) --no-print-directory $@ ; \
	)
install_file_list: list-local-base list-local-manpages
list-base: list-local-base
list-manpages: list-local-manpages

# Check: much simpler

GLOBAL_TARGETS += check
ifeq ($(filter check,$(BROKEN_TARGETS)),)
check:
else
check:
endif

# Checkprograms: XXX: should this be deleted; it doesn't do anything?
GLOBAL_TARGETS += checkprograms
checkprograms:
