use 5.006;
use ExtUtils::MakeMaker;
# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
WriteMakefile(
    NAME              => 'Interface::TNC::IMC',
    VERSION_FROM      => 'lib/Interface/TNC/IMC.pm', # finds $VERSION
    PREREQ_PM         => {}, # e.g., Module::Name => 1.1
    ($] >= 5.005 ?     ## Add these new keywords supported since 5.005
      (ABSTRACT_FROM  => 'lib/Interface/TNC/IMC.pm', # retrieve abstract from module
       AUTHOR         => 'Mike McCauley <mikem@suse.de>') : ()),
    LIBS              => ['-ltnc'], # e.g., '-lm'
    DEFINE            => '', # e.g., '-DHAVE_SOMETHING'
    INC               => '-I.', # e.g., '-I. -I/usr/include/other'
	# Un-comment this if you add C files to link with later:
    # OBJECT            => '$(O_FILES)', # link all the C files too
);
if  (eval {require ExtUtils::Constant; 1}) {
  # If you edit these definitions to change the constants used by this module,
  # you will need to use the generated const-c.inc and const-xs.inc
  # files to replace their "fallback" counterparts before distributing your
  # changes.
  my @names = (qw(TNC_CONNECTIONID_ANY TNC_CONNECTION_STATE_ACCESS_ALLOWED
		 TNC_CONNECTION_STATE_ACCESS_ISOLATED
		 TNC_CONNECTION_STATE_ACCESS_NONE TNC_CONNECTION_STATE_CREATE
		 TNC_CONNECTION_STATE_DELETE TNC_CONNECTION_STATE_HANDSHAKE
		 TNC_IFIMC_VERSION_1 TNC_LOG_SEVERITY_DEBUG
		 TNC_LOG_SEVERITY_ERR TNC_LOG_SEVERITY_INFO
		 TNC_LOG_SEVERITY_NOTICE TNC_LOG_SEVERITY_WARNING
		 TNC_RESULT_ALREADY_INITIALIZED TNC_RESULT_CANT_RESPOND
		 TNC_RESULT_CANT_RETRY TNC_RESULT_FATAL
		 TNC_RESULT_ILLEGAL_OPERATION TNC_RESULT_INVALID_PARAMETER
		 TNC_RESULT_NOT_INITIALIZED TNC_RESULT_NO_COMMON_VERSION
		 TNC_RESULT_OTHER TNC_RESULT_SUCCESS TNC_RESULT_WONT_RETRY
		 TNC_RETRY_REASON_IMC_INFORMATIONAL_EVENT
		 TNC_RETRY_REASON_IMC_PERIODIC
		 TNC_RETRY_REASON_IMC_REMEDIATION_COMPLETE
		 TNC_RETRY_REASON_IMC_SERIOUS_EVENT TNC_SUBTYPE_ANY
		 TNC_VENDORID_ANY TNC_VENDORID_TCG));
  ExtUtils::Constant::WriteConstants(
                                     NAME         => 'Interface::TNC::IMC',
                                     NAMES        => \@names,
                                     DEFAULT_TYPE => 'IV',
                                     C_FILE       => 'const-c.inc',
                                     XS_FILE      => 'const-xs.inc',
                                  );

}
else {
  use File::Copy;
  use File::Spec;
  foreach my $file ('const-c.inc', 'const-xs.inc') {
    my $fallback = File::Spec->catfile('fallback', $file);
    copy ($fallback, $file) or die "Can't copy $fallback to $file: $!";
  }
}
