package Interface::TNC::IMV;

use 5.006;
use strict;
use warnings;
use Carp;

require Exporter;
use AutoLoader;

our @ISA = qw(Exporter);

# Items to export into callers namespace by default. Note: do not export
# names by default without a very good reason. Use EXPORT_OK instead.
# Do not simply export all your public functions/methods/constants.

# This allows declaration	use Interface::TNC::IMV ':all';
# If you do not need this, moving things directly into @EXPORT or @EXPORT_OK
# will save memory.
our %EXPORT_TAGS = ( 'all' => [ qw(
	TNC_CONNECTIONID_ANY
	TNC_CONNECTION_STATE_ACCESS_ALLOWED
	TNC_CONNECTION_STATE_ACCESS_ISOLATED
	TNC_CONNECTION_STATE_ACCESS_NONE
	TNC_CONNECTION_STATE_CREATE
	TNC_CONNECTION_STATE_DELETE
	TNC_CONNECTION_STATE_HANDSHAKE
	TNC_IFIMV_VERSION_1
	TNC_IMV_ACTION_RECOMMENDATION_ALLOW
	TNC_IMV_ACTION_RECOMMENDATION_ISOLATE
	TNC_IMV_ACTION_RECOMMENDATION_NO_ACCESS
	TNC_IMV_ACTION_RECOMMENDATION_NO_RECOMMENDATION
	TNC_IMV_EVALUATION_RESULT_COMPLIANT
	TNC_IMV_EVALUATION_RESULT_DONT_KNOW
	TNC_IMV_EVALUATION_RESULT_ERROR
	TNC_IMV_EVALUATION_RESULT_NONCOMPLIANT_MAJOR
	TNC_IMV_EVALUATION_RESULT_NONCOMPLIANT_MINOR
	TNC_LOG_SEVERITY_DEBUG
	TNC_LOG_SEVERITY_ERR
	TNC_LOG_SEVERITY_INFO
	TNC_LOG_SEVERITY_NOTICE
	TNC_LOG_SEVERITY_WARNING
	TNC_RESULT_ALREADY_INITIALIZED
	TNC_RESULT_CANT_RESPOND
	TNC_RESULT_CANT_RETRY
	TNC_RESULT_FATAL
	TNC_RESULT_ILLEGAL_OPERATION
	TNC_RESULT_INVALID_PARAMETER
	TNC_RESULT_NOT_INITIALIZED
	TNC_RESULT_NO_COMMON_VERSION
	TNC_RESULT_OTHER
	TNC_RESULT_SUCCESS
	TNC_RESULT_WONT_RETRY
	TNC_RETRY_REASON_IMV_IMPORTANT_POLICY_CHANGE
	TNC_RETRY_REASON_IMV_MINOR_EVENT
	TNC_RETRY_REASON_IMV_MINOR_POLICY_CHANGE
	TNC_RETRY_REASON_IMV_PERIODIC
	TNC_RETRY_REASON_IMV_SERIOUS_EVENT
	TNC_SUBTYPE_ANY
	TNC_VENDORID_ANY
	TNC_VENDORID_TCG
	BatchEnding
	NotifyConnectionChange
	ReceiveMessage
	Terminate
	destroy
	load_config
	load_modules
	load_std_config
	new
	unload
	libtnc_logMessage
	libtnc_logMessage
) ] );

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw(
	TNC_CONNECTIONID_ANY
	TNC_CONNECTION_STATE_ACCESS_ALLOWED
	TNC_CONNECTION_STATE_ACCESS_ISOLATED
	TNC_CONNECTION_STATE_ACCESS_NONE
	TNC_CONNECTION_STATE_CREATE
	TNC_CONNECTION_STATE_DELETE
	TNC_CONNECTION_STATE_HANDSHAKE
	TNC_IFIMV_VERSION_1
	TNC_IMV_ACTION_RECOMMENDATION_ALLOW
	TNC_IMV_ACTION_RECOMMENDATION_ISOLATE
	TNC_IMV_ACTION_RECOMMENDATION_NO_ACCESS
	TNC_IMV_ACTION_RECOMMENDATION_NO_RECOMMENDATION
	TNC_IMV_EVALUATION_RESULT_COMPLIANT
	TNC_IMV_EVALUATION_RESULT_DONT_KNOW
	TNC_IMV_EVALUATION_RESULT_ERROR
	TNC_IMV_EVALUATION_RESULT_NONCOMPLIANT_MAJOR
	TNC_IMV_EVALUATION_RESULT_NONCOMPLIANT_MINOR
	TNC_LOG_SEVERITY_DEBUG
	TNC_LOG_SEVERITY_ERR
	TNC_LOG_SEVERITY_INFO
	TNC_LOG_SEVERITY_NOTICE
	TNC_LOG_SEVERITY_WARNING
	TNC_RESULT_ALREADY_INITIALIZED
	TNC_RESULT_CANT_RESPOND
	TNC_RESULT_CANT_RETRY
	TNC_RESULT_FATAL
	TNC_RESULT_ILLEGAL_OPERATION
	TNC_RESULT_INVALID_PARAMETER
	TNC_RESULT_NOT_INITIALIZED
	TNC_RESULT_NO_COMMON_VERSION
	TNC_RESULT_OTHER
	TNC_RESULT_SUCCESS
	TNC_RESULT_WONT_RETRY
	TNC_RETRY_REASON_IMV_IMPORTANT_POLICY_CHANGE
	TNC_RETRY_REASON_IMV_MINOR_EVENT
	TNC_RETRY_REASON_IMV_MINOR_POLICY_CHANGE
	TNC_RETRY_REASON_IMV_PERIODIC
	TNC_RETRY_REASON_IMV_SERIOUS_EVENT
	TNC_SUBTYPE_ANY
	TNC_VENDORID_ANY
	TNC_VENDORID_TCG
);

our $VERSION = '0.01';

sub AUTOLOAD {
    # This AUTOLOAD is used to 'autoload' constants from the constant()
    # XS function.

    my $constname;
    our $AUTOLOAD;
    ($constname = $AUTOLOAD) =~ s/.*:://;
    croak "&Interface::TNC::IMV::constant not defined" if $constname eq 'constant';
    my ($error, $val) = constant($constname);
    if ($error) { croak $error; }
    {
	no strict 'refs';
	# Fixed between 5.005_53 and 5.005_61
#XXX	if ($] >= 5.00561) {
#XXX	    *$AUTOLOAD = sub () { $val };
#XXX	}
#XXX	else {
	    *$AUTOLOAD = sub { $val };
#XXX	}
    }
    goto &$AUTOLOAD;
}

require XSLoader;
XSLoader::load('Interface::TNC::IMV', $VERSION);

# Preloaded methods go here.

# Autoload methods go after =cut, and are processed by the autosplit program.

1;
__END__
# Below is stub documentation for your module. You'd better edit it!

=head1 NAME

Interface::TNC::IMV - Perl extension for blah blah blah

=head1 SYNOPSIS

  use Interface::TNC::IMV;
  blah blah blah

=head1 DESCRIPTION

Stub documentation for Interface::TNC::IMV, created by h2xs. It looks like the
author of the extension was negligent enough to leave the stub
unedited.

Blah blah blah.

=head2 EXPORT

None by default.

=head2 Exportable constants

  TNC_CONNECTIONID_ANY
  TNC_CONNECTION_STATE_ACCESS_ALLOWED
  TNC_CONNECTION_STATE_ACCESS_ISOLATED
  TNC_CONNECTION_STATE_ACCESS_NONE
  TNC_CONNECTION_STATE_CREATE
  TNC_CONNECTION_STATE_DELETE
  TNC_CONNECTION_STATE_HANDSHAKE
  TNC_IFIMV_VERSION_1
  TNC_IMV_ACTION_RECOMMENDATION_ALLOW
  TNC_IMV_ACTION_RECOMMENDATION_ISOLATE
  TNC_IMV_ACTION_RECOMMENDATION_NO_ACCESS
  TNC_IMV_ACTION_RECOMMENDATION_NO_RECOMMENDATION
  TNC_IMV_EVALUATION_RESULT_COMPLIANT
  TNC_IMV_EVALUATION_RESULT_DONT_KNOW
  TNC_IMV_EVALUATION_RESULT_ERROR
  TNC_IMV_EVALUATION_RESULT_NONCOMPLIANT_MAJOR
  TNC_IMV_EVALUATION_RESULT_NONCOMPLIANT_MINOR
  TNC_LOG_SEVERITY_DEBUG
  TNC_LOG_SEVERITY_ERR
  TNC_LOG_SEVERITY_INFO
  TNC_LOG_SEVERITY_NOTICE
  TNC_LOG_SEVERITY_WARNING
  TNC_RESULT_ALREADY_INITIALIZED
  TNC_RESULT_CANT_RESPOND
  TNC_RESULT_CANT_RETRY
  TNC_RESULT_FATAL
  TNC_RESULT_ILLEGAL_OPERATION
  TNC_RESULT_INVALID_PARAMETER
  TNC_RESULT_NOT_INITIALIZED
  TNC_RESULT_NO_COMMON_VERSION
  TNC_RESULT_OTHER
  TNC_RESULT_SUCCESS
  TNC_RESULT_WONT_RETRY
  TNC_RETRY_REASON_IMV_IMPORTANT_POLICY_CHANGE
  TNC_RETRY_REASON_IMV_MINOR_EVENT
  TNC_RETRY_REASON_IMV_MINOR_POLICY_CHANGE
  TNC_RETRY_REASON_IMV_PERIODIC
  TNC_RETRY_REASON_IMV_SERIOUS_EVENT
  TNC_SUBTYPE_ANY
  TNC_VENDORID_ANY
  TNC_VENDORID_TCG

=head2 Exportable functions

  TNC_Result BatchEnding(
           TNC_ConnectionID connectionID)
  TNC_Result NotifyConnectionChange(
           TNC_ConnectionID connectionID,
           TNC_ConnectionState newState)
  TNC_Result ReceiveMessage(
           TNC_ConnectionID connectionID,
           TNC_BufferReference messageBuffer,
           TNC_UInt32 messageLength,
           TNC_MessageType messageType)
  TNC_Result Terminate()
  TNC_Result destroy(
           libtnc_imv* self)
  int load_config(
           const char* filename)
  TNC_Result load_modules(
           const char* filenames[])
  int load_std_config()
  libtnc_imv* new(
           const char* filename)
  TNC_Result unload()
  TNC_Result libtnc_logMessage(
           TNC_UInt32 severity,
           const char* format, ...)
  TNC_Result libtnc_logMessage(
           TNC_UInt32 severity,
           const char* format, ...)



=head1 SEE ALSO

Mention other useful documentation such as the documentation of
related modules or operating system documentation (such as man pages
in UNIX), or any relevant external documentation such as RFCs or
standards.

If you have a mailing list set up for your module, mention it here.

If you have a web site set up for your module, mention it here.

=head1 AUTHOR

Mike McCauley, E<lt>mikem@suse.deE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2006 by Mike McCauley

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.7 or,
at your option, any later version of Perl 5 you may have available.


=cut
