/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaNamespaceSupport;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSAttributeDecl;
import org.apache.xerces.impl.xs.XSGrammarBucket;
import org.apache.xerces.impl.xs.XSWildcardDecl;
import org.apache.xerces.impl.xs.traversers.OneAttr;
import org.apache.xerces.impl.xs.traversers.OneElement;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import org.apache.xerces.impl.xs.util.XInt;
import org.apache.xerces.impl.xs.util.XIntPool;
import org.apache.xerces.util.DOMUtil;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public class XSAttributeChecker {
    private static final String ELEMENT_N = "element_n";
    private static final String ELEMENT_R = "element_r";
    private static final String ATTRIBUTE_N = "attribute_n";
    private static final String ATTRIBUTE_R = "attribute_r";
    public static int ATTIDX_COUNT = 0;
    public static final int ATTIDX_ABSTRACT = ATTIDX_COUNT++;
    public static final int ATTIDX_AFORMDEFAULT = ATTIDX_COUNT++;
    public static final int ATTIDX_BASE = ATTIDX_COUNT++;
    public static final int ATTIDX_BLOCK = ATTIDX_COUNT++;
    public static final int ATTIDX_BLOCKDEFAULT = ATTIDX_COUNT++;
    public static final int ATTIDX_DEFAULT = ATTIDX_COUNT++;
    public static final int ATTIDX_EFORMDEFAULT = ATTIDX_COUNT++;
    public static final int ATTIDX_FINAL = ATTIDX_COUNT++;
    public static final int ATTIDX_FINALDEFAULT = ATTIDX_COUNT++;
    public static final int ATTIDX_FIXED = ATTIDX_COUNT++;
    public static final int ATTIDX_FORM = ATTIDX_COUNT++;
    public static final int ATTIDX_ID = ATTIDX_COUNT++;
    public static final int ATTIDX_ITEMTYPE = ATTIDX_COUNT++;
    public static final int ATTIDX_MAXOCCURS = ATTIDX_COUNT++;
    public static final int ATTIDX_MEMBERTYPES = ATTIDX_COUNT++;
    public static final int ATTIDX_MINOCCURS = ATTIDX_COUNT++;
    public static final int ATTIDX_MIXED = ATTIDX_COUNT++;
    public static final int ATTIDX_NAME = ATTIDX_COUNT++;
    public static final int ATTIDX_NAMESPACE = ATTIDX_COUNT++;
    public static final int ATTIDX_NILLABLE = ATTIDX_COUNT++;
    public static final int ATTIDX_PROCESSCONTENTS = ATTIDX_COUNT++;
    public static final int ATTIDX_PUBLIC = ATTIDX_COUNT++;
    public static final int ATTIDX_REF = ATTIDX_COUNT++;
    public static final int ATTIDX_REFER = ATTIDX_COUNT++;
    public static final int ATTIDX_SCHEMALOCATION = ATTIDX_COUNT++;
    public static final int ATTIDX_SOURCE = ATTIDX_COUNT++;
    public static final int ATTIDX_SUBSGROUP = ATTIDX_COUNT++;
    public static final int ATTIDX_SYSTEM = ATTIDX_COUNT++;
    public static final int ATTIDX_TARGETNAMESPACE = ATTIDX_COUNT++;
    public static final int ATTIDX_TYPE = ATTIDX_COUNT++;
    public static final int ATTIDX_USE = ATTIDX_COUNT++;
    public static final int ATTIDX_VALUE = ATTIDX_COUNT++;
    public static final int ATTIDX_ENUMNSDECLS = ATTIDX_COUNT++;
    public static final int ATTIDX_VERSION = ATTIDX_COUNT++;
    public static final int ATTIDX_XPATH = ATTIDX_COUNT++;
    public static final int ATTIDX_FROMDEFAULT = ATTIDX_COUNT++;
    public static final int ATTIDX_ISRETURNED = ATTIDX_COUNT++;
    private static final XIntPool fXIntPool = new XIntPool();
    private static final XInt INT_QUALIFIED = fXIntPool.getXInt(1);
    private static final XInt INT_UNQUALIFIED = fXIntPool.getXInt(0);
    private static final XInt INT_EMPTY_SET = fXIntPool.getXInt(0);
    private static final XInt INT_ANY_STRICT = fXIntPool.getXInt(1);
    private static final XInt INT_ANY_LAX = fXIntPool.getXInt(3);
    private static final XInt INT_ANY_SKIP = fXIntPool.getXInt(2);
    private static final XInt INT_USE_OPTIONAL = fXIntPool.getXInt(0);
    private static final XInt INT_USE_REQUIRED = fXIntPool.getXInt(1);
    private static final XInt INT_USE_PROHIBITED = fXIntPool.getXInt(2);
    private static final XInt INT_WS_PRESERVE = fXIntPool.getXInt(0);
    private static final XInt INT_WS_REPLACE = fXIntPool.getXInt(1);
    private static final XInt INT_WS_COLLAPSE = fXIntPool.getXInt(2);
    private static final XInt INT_UNBOUNDED = fXIntPool.getXInt(-1);
    private static final XSWildcardDecl WC_ANY = new XSWildcardDecl();
    private final XSWildcardDecl fTempWC = new XSWildcardDecl();
    protected static Hashtable fEleAttrsMapG = new Hashtable();
    protected static Hashtable fEleAttrsMapL = new Hashtable();
    protected static final int DT_ANYURI = 0;
    protected static final int DT_ID = 1;
    protected static final int DT_QNAME = 2;
    protected static final int DT_STRING = 3;
    protected static final int DT_TOKEN = 4;
    protected static final int DT_NCNAME = 5;
    protected static final int DT_XPATH = 6;
    protected static final int DT_XPATH1 = 7;
    protected static final int DT_COUNT = 8;
    protected static XSSimpleType[] fExtraDVs = new XSSimpleType[8];
    protected static final int DT_BLOCK = -1;
    protected static final int DT_BLOCK1 = -2;
    protected static final int DT_FINAL = -3;
    protected static final int DT_FINAL1 = -4;
    protected static final int DT_FORM = -5;
    protected static final int DT_MAXOCCURS = -6;
    protected static final int DT_MAXOCCURS1 = -7;
    protected static final int DT_MEMBERTYPES = -8;
    protected static final int DT_MINOCCURS1 = -9;
    protected static final int DT_NAMESPACE = -10;
    protected static final int DT_PROCESSCONTENTS = -11;
    protected static final int DT_PUBLIC = -12;
    protected static final int DT_USE = -13;
    protected static final int DT_WHITESPACE = -14;
    protected static final int DT_BOOLEAN = -15;
    protected static final int DT_NONNEGINT = -16;
    protected XSDHandler fSchemaHandler = null;
    protected SymbolTable fSymbolTable = null;
    protected Hashtable fNonSchemaAttrs = new Hashtable();
    static final int INIT_POOL_SIZE = 10;
    static final int INC_POOL_SIZE = 10;
    Object[][] fArrayPool = new Object[10][ATTIDX_COUNT];
    private static Object[] fTempArray;
    int fPoolPos = 0;

    public XSAttributeChecker(XSDHandler xSDHandler) {
        this.fSchemaHandler = xSDHandler;
    }

    public void reset(SymbolTable symbolTable) {
        this.fSymbolTable = symbolTable;
        this.fNonSchemaAttrs.clear();
    }

    public Object[] checkAttributes(Element element, boolean bl, XSDocumentInfo xSDocumentInfo) {
        return this.checkAttributes(element, bl, xSDocumentInfo, false);
    }

    public Object[] checkAttributes(Element element, boolean bl, XSDocumentInfo xSDocumentInfo, boolean bl2) {
        Object object;
        Object object2;
        OneElement oneElement;
        if (element == null) {
            return null;
        }
        this.resolveNamespace(element, xSDocumentInfo.fNamespaceSupport);
        String string = DOMUtil.getNamespaceURI(element);
        String string2 = DOMUtil.getLocalName(element);
        if (string == null || !string.equals(SchemaSymbols.URI_SCHEMAFORSCHEMA)) {
            this.reportSchemaError("s4s-elt-schema-ns", new Object[]{string2}, element);
        }
        Hashtable hashtable = fEleAttrsMapG;
        String string3 = string2;
        if (!bl) {
            hashtable = fEleAttrsMapL;
            if (string2.equals(SchemaSymbols.ELT_ELEMENT)) {
                string3 = DOMUtil.getAttr(element, SchemaSymbols.ATT_REF) != null ? ELEMENT_R : ELEMENT_N;
            } else if (string2.equals(SchemaSymbols.ELT_ATTRIBUTE)) {
                string3 = DOMUtil.getAttr(element, SchemaSymbols.ATT_REF) != null ? ATTRIBUTE_R : ATTRIBUTE_N;
            }
        }
        if ((oneElement = (OneElement)hashtable.get(string3)) == null) {
            this.reportSchemaError("s4s-elt-invalid", new Object[]{string2}, element);
            return null;
        }
        Object[] objectArray = this.getAvailableArray();
        long l = 0L;
        Hashtable hashtable2 = oneElement.attrList;
        Attr[] attrArray = DOMUtil.getAttrs(element);
        Attr attr = null;
        int n = 0;
        while (n < attrArray.length) {
            attr = attrArray[n];
            object2 = attr.getName();
            String string4 = DOMUtil.getValue(attr);
            if (!((String)object2).toLowerCase().startsWith("xml")) {
                Vector vector;
                Object object3;
                object = DOMUtil.getNamespaceURI(attr);
                if (object != null && ((String)object).length() != 0) {
                    if (((String)object).equals(SchemaSymbols.URI_SCHEMAFORSCHEMA) || !oneElement.allowNonSchemaAttr) {
                        this.reportSchemaError("s4s-att-not-allowed", new Object[]{string2, object2}, element);
                    } else {
                        object3 = (String)object + "," + (String)object2;
                        vector = (Vector)this.fNonSchemaAttrs.get(object3);
                        if (vector == null) {
                            vector = new Vector();
                            vector.addElement(object2);
                            vector.addElement(string2);
                            vector.addElement(string4);
                            this.fNonSchemaAttrs.put(object3, vector);
                        } else {
                            vector.addElement(string2);
                            vector.addElement(string4);
                        }
                    }
                } else {
                    object3 = (OneAttr)hashtable2.get(object2);
                    if (object3 == null) {
                        this.reportSchemaError("s4s-att-not-allowed", new Object[]{string2, object2}, element);
                    } else {
                        block30: {
                            try {
                                if (((OneAttr)object3).dvIndex >= 0) {
                                    if (((OneAttr)object3).dvIndex != 3 && ((OneAttr)object3).dvIndex != 6 && ((OneAttr)object3).dvIndex != 7) {
                                        vector = fExtraDVs[((OneAttr)object3).dvIndex];
                                        Object object4 = vector.validate(string4, xSDocumentInfo.fValidationContext, null);
                                        if (((OneAttr)object3).dvIndex == 2) {
                                            QName qName = (QName)object4;
                                            if (qName.prefix == this.fSchemaHandler.EMPTY_STRING && qName.uri == null && xSDocumentInfo.fIsChameleonSchema) {
                                                qName.uri = xSDocumentInfo.fTargetNamespace;
                                            }
                                        }
                                        objectArray[((OneAttr)object3).valueIndex] = object4;
                                    } else {
                                        objectArray[((OneAttr)object3).valueIndex] = string4;
                                    }
                                } else {
                                    objectArray[((OneAttr)object3).valueIndex] = this.validate((String)object2, string4, ((OneAttr)object3).dvIndex, xSDocumentInfo);
                                }
                            }
                            catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                                this.reportSchemaError("s4s-att-invalid-value", new Object[]{string2, object2, invalidDatatypeValueException.getKey()}, element);
                                if (((OneAttr)object3).dfltValue == null) break block30;
                                objectArray[((OneAttr)object3).valueIndex] = ((OneAttr)object3).dfltValue;
                            }
                        }
                        if (string2.equals(SchemaSymbols.ELT_ENUMERATION) && bl2) {
                            objectArray[XSAttributeChecker.ATTIDX_ENUMNSDECLS] = new SchemaNamespaceSupport(xSDocumentInfo.fNamespaceSupport);
                        }
                    }
                }
            }
            ++n;
        }
        object2 = oneElement.attrArray;
        int n2 = 0;
        while (n2 < ((OneAttr[])object2).length) {
            object = object2[n2];
            if (((OneAttr)object).dfltValue != null && DOMUtil.getAttr(element, ((OneAttr)object).name) == null) {
                objectArray[((OneAttr)object).valueIndex] = ((OneAttr)object).dfltValue;
                l |= (long)(1 << ((OneAttr)object).valueIndex);
            }
            ++n2;
        }
        objectArray[XSAttributeChecker.ATTIDX_FROMDEFAULT] = new Long(l);
        if (objectArray[ATTIDX_MAXOCCURS] != null) {
            int n3 = ((XInt)objectArray[ATTIDX_MINOCCURS]).intValue();
            int n4 = ((XInt)objectArray[ATTIDX_MAXOCCURS]).intValue();
            if (n4 != -1 && n3 > n4) {
                this.reportSchemaError("p-props-correct.2.1", new Object[]{string2, objectArray[ATTIDX_MINOCCURS], objectArray[ATTIDX_MAXOCCURS]}, element);
                objectArray[XSAttributeChecker.ATTIDX_MINOCCURS] = objectArray[ATTIDX_MAXOCCURS];
            }
        }
        return objectArray;
    }

    private Object validate(String string, String string2, int n, XSDocumentInfo xSDocumentInfo) throws InvalidDatatypeValueException {
        if (string2 == null) {
            return null;
        }
        String string3 = XSAttributeChecker.normalize(string2, (short)2);
        Vector<QName> vector = string3;
        switch (n) {
            case -15: {
                if (string3.equals("false") || string3.equals("0")) {
                    vector = Boolean.FALSE;
                    break;
                }
                if (string3.equals("true") || string3.equals("1")) {
                    vector = Boolean.TRUE;
                    break;
                }
                throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{string3, "boolean"});
            }
            case -16: {
                try {
                    vector = fXIntPool.getXInt(Integer.parseInt(string3));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{string3, "nonNegativeInteger"});
                }
                if (((XInt)((Object)vector)).intValue() >= 0) break;
                throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{string3, "nonNegativeInteger"});
            }
            case -1: {
                int n2 = 0;
                if (string3.equals("#all")) {
                    n2 = 31;
                } else {
                    StringTokenizer stringTokenizer = new StringTokenizer(string3, " ");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string4 = stringTokenizer.nextToken();
                        if (string4.equals("substitution")) {
                            n2 |= 4;
                            continue;
                        }
                        if (string4.equals("extension")) {
                            n2 |= 1;
                            continue;
                        }
                        if (string4.equals("restriction")) {
                            n2 |= 2;
                            continue;
                        }
                        if (string4.equals("list")) {
                            n2 |= 0x10;
                            continue;
                        }
                        if (string4.equals("union")) {
                            n2 |= 2;
                            continue;
                        }
                        throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.3", new Object[]{string3, "(#all | List of (substitution | extension | restriction | list | union))"});
                    }
                }
                vector = fXIntPool.getXInt(n2);
                break;
            }
            case -3: 
            case -2: {
                int n3 = 0;
                if (string3.equals("#all")) {
                    n3 = 31;
                } else {
                    StringTokenizer stringTokenizer = new StringTokenizer(string3, " ");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string5 = stringTokenizer.nextToken();
                        if (string5.equals("extension")) {
                            n3 |= 1;
                            continue;
                        }
                        if (string5.equals("restriction")) {
                            n3 |= 2;
                            continue;
                        }
                        throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.3", new Object[]{string3, "(#all | List of (extension | restriction))"});
                    }
                }
                vector = fXIntPool.getXInt(n3);
                break;
            }
            case -4: {
                int n4 = 0;
                if (string3.equals("#all")) {
                    n4 = 31;
                } else if (string3.equals("list")) {
                    n4 = 16;
                } else if (string3.equals("union")) {
                    n4 = 8;
                } else if (string3.equals("restriction")) {
                    n4 = 2;
                } else {
                    throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.3", new Object[]{string3, "(#all | (list | union | restriction))"});
                }
                vector = fXIntPool.getXInt(n4);
                break;
            }
            case -5: {
                if (string3.equals("qualified")) {
                    vector = INT_QUALIFIED;
                    break;
                }
                if (string3.equals("unqualified")) {
                    vector = INT_UNQUALIFIED;
                    break;
                }
                throw new InvalidDatatypeValueException("cvc-enumeration-valid", new Object[]{string3, "(qualified | unqualified)"});
            }
            case -6: {
                if (string3.equals("unbounded")) {
                    vector = INT_UNBOUNDED;
                    break;
                }
                try {
                    vector = this.validate(string, string3, -16, xSDocumentInfo);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.3", new Object[]{string3, "(nonNegativeInteger | unbounded)"});
                }
            }
            case -7: {
                if (string3.equals("1")) {
                    vector = fXIntPool.getXInt(1);
                    break;
                }
                throw new InvalidDatatypeValueException("cvc-enumeration-valid", new Object[]{string3, "(1)"});
            }
            case -8: {
                Vector<QName> vector2 = new Vector<QName>();
                try {
                    StringTokenizer stringTokenizer = new StringTokenizer(string3, " ");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string6 = stringTokenizer.nextToken();
                        QName qName = (QName)fExtraDVs[2].validate(string6, xSDocumentInfo.fValidationContext, null);
                        if (qName.prefix == this.fSchemaHandler.EMPTY_STRING && qName.uri == null && xSDocumentInfo.fIsChameleonSchema) {
                            qName.uri = xSDocumentInfo.fTargetNamespace;
                        }
                        vector2.addElement(qName);
                    }
                    vector = vector2;
                    break;
                }
                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                    throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.2", new Object[]{string3, "(List of QName)"});
                }
            }
            case -9: {
                if (string3.equals("0")) {
                    vector = fXIntPool.getXInt(0);
                    break;
                }
                if (string3.equals("1")) {
                    vector = fXIntPool.getXInt(1);
                    break;
                }
                throw new InvalidDatatypeValueException("cvc-enumeration-valid", new Object[]{string3, "(0 | 1)"});
            }
            case -10: {
                XSWildcardDecl xSWildcardDecl = null;
                if (string3.equals("##any")) {
                    xSWildcardDecl = WC_ANY;
                } else if (string3.equals("##other")) {
                    xSWildcardDecl = this.fTempWC;
                    xSWildcardDecl.fType = (short)2;
                    xSWildcardDecl.fNamespaceList = new String[2];
                    xSWildcardDecl.fNamespaceList[0] = xSDocumentInfo.fTargetNamespace;
                    xSWildcardDecl.fNamespaceList[1] = null;
                } else {
                    xSWildcardDecl = this.fTempWC;
                    xSWildcardDecl.fType = (short)3;
                    StringTokenizer stringTokenizer = new StringTokenizer(string3);
                    String[] stringArray = new String[stringTokenizer.countTokens()];
                    int n5 = 0;
                    try {
                        while (stringTokenizer.hasMoreTokens()) {
                            String string7;
                            String string8 = stringTokenizer.nextToken();
                            if (string8.equals("##local")) {
                                string7 = null;
                            } else if (string8.equals("##targetNamespace")) {
                                string7 = xSDocumentInfo.fTargetNamespace;
                            } else {
                                fExtraDVs[0].validate(string8, xSDocumentInfo.fValidationContext, null);
                                string7 = this.fSymbolTable.addSymbol(string8);
                            }
                            int n6 = 0;
                            while (n6 < n5) {
                                if (string7 == stringArray[n6]) break;
                                ++n6;
                            }
                            if (n6 != n5) continue;
                            stringArray[n5++] = string7;
                        }
                    }
                    catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                        throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.3", new Object[]{string3, "((##any | ##other) | List of (anyURI | (##targetNamespace | ##local)) )"});
                    }
                    if (n5 == stringArray.length) {
                        xSWildcardDecl.fNamespaceList = stringArray;
                    } else {
                        xSWildcardDecl.fNamespaceList = new String[n5];
                        System.arraycopy(stringArray, 0, xSWildcardDecl.fNamespaceList, 0, n5);
                    }
                }
                vector = xSWildcardDecl;
                break;
            }
            case -11: {
                if (string3.equals("strict")) {
                    vector = INT_ANY_STRICT;
                    break;
                }
                if (string3.equals("lax")) {
                    vector = INT_ANY_LAX;
                    break;
                }
                if (string3.equals("skip")) {
                    vector = INT_ANY_SKIP;
                    break;
                }
                throw new InvalidDatatypeValueException("cvc-enumeration-valid", new Object[]{string3, "(lax | skip | strict)"});
            }
            case -12: {
                fExtraDVs[4].validate(string3, xSDocumentInfo.fValidationContext, null);
                break;
            }
            case -13: {
                if (string3.equals("optional")) {
                    vector = INT_USE_OPTIONAL;
                    break;
                }
                if (string3.equals("required")) {
                    vector = INT_USE_REQUIRED;
                    break;
                }
                if (string3.equals("prohibited")) {
                    vector = INT_USE_PROHIBITED;
                    break;
                }
                throw new InvalidDatatypeValueException("cvc-enumeration-valid", new Object[]{string3, "(optional | prohibited | required)"});
            }
            case -14: {
                if (string3.equals("preserve")) {
                    vector = INT_WS_PRESERVE;
                    break;
                }
                if (string3.equals("replace")) {
                    vector = INT_WS_REPLACE;
                    break;
                }
                if (string3.equals("collapse")) {
                    vector = INT_WS_COLLAPSE;
                    break;
                }
                throw new InvalidDatatypeValueException("cvc-enumeration-valid", new Object[]{string3, "(preserve | replace | collapse)"});
            }
        }
        return vector;
    }

    void reportSchemaError(String string, Object[] objectArray, Element element) {
        this.fSchemaHandler.reportSchemaError(string, objectArray, element);
    }

    public void checkNonSchemaAttributes(XSGrammarBucket xSGrammarBucket) {
        Enumeration enumeration = this.fNonSchemaAttrs.keys();
        while (enumeration.hasMoreElements()) {
            XSSimpleType xSSimpleType;
            XSAttributeDecl xSAttributeDecl;
            String string = (String)enumeration.nextElement();
            String string2 = string.substring(0, string.indexOf(44));
            String string3 = string.substring(string.indexOf(44) + 1);
            SchemaGrammar schemaGrammar = xSGrammarBucket.getGrammar(string2);
            if (schemaGrammar == null || (xSAttributeDecl = schemaGrammar.getGlobalAttributeDecl(string3)) == null || (xSSimpleType = xSAttributeDecl.fType) == null) continue;
            Vector vector = (Vector)this.fNonSchemaAttrs.get(string);
            String string4 = (String)vector.elementAt(0);
            int n = vector.size();
            int n2 = 1;
            while (n2 < n) {
                String string5 = (String)vector.elementAt(n2);
                try {
                    xSSimpleType.validate((String)vector.elementAt(n2 + 1), null, null);
                }
                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                    this.reportSchemaError("s4s-att-invalid-value", new Object[]{string5, string4, invalidDatatypeValueException.getKey()}, null);
                }
                n2 += 2;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static String normalize(String var0, short var1_1) {
        block8: {
            block7: {
                v0 = var2_2 = var0 == null ? 0 : var0.length();
                if (var2_2 == 0 || var1_1 == 0) {
                    return var0;
                }
                var3_3 = new StringBuffer();
                if (var1_1 != 1) break block7;
                var5_4 = 0;
                while (var5_4 < var2_2) {
                    var4_6 = var0.charAt(var5_4);
                    if (var4_6 != '\t' && var4_6 != '\n' && var4_6 != '\r') {
                        var3_3.append(var4_6);
                    } else {
                        var3_3.append(' ');
                    }
                    ++var5_4;
                }
                break block8;
            }
            var6_8 = true;
            var5_5 = 0;
            while (var5_5 < var2_2) {
                block9: {
                    var4_7 = var0.charAt(var5_5);
                    if (var4_7 == '\t' || var4_7 == '\n' || var4_7 == '\r' || var4_7 == ' ') ** GOTO lbl30
                    var3_3.append(var4_7);
                    var6_8 = false;
                    break block9;
                    while ((var4_7 = var0.charAt(var5_5 + 1)) == '\t' || var4_7 == '\n' || var4_7 == '\r' || var4_7 == ' ') {
                        ++var5_5;
lbl30:
                        // 2 sources

                        if (var5_5 < var2_2 - 1) continue;
                    }
                    if (var5_5 < var2_2 - 1 && !var6_8) {
                        var3_3.append(' ');
                    }
                }
                ++var5_5;
            }
        }
        return var3_3.toString();
    }

    protected Object[] getAvailableArray() {
        if (this.fArrayPool.length == this.fPoolPos) {
            this.fArrayPool = new Object[this.fPoolPos + 10][];
            int n = this.fPoolPos;
            while (n < this.fArrayPool.length) {
                this.fArrayPool[n] = new Object[ATTIDX_COUNT];
                ++n;
            }
        }
        Object[] objectArray = this.fArrayPool[this.fPoolPos];
        this.fArrayPool[this.fPoolPos++] = null;
        System.arraycopy(fTempArray, 0, objectArray, 0, ATTIDX_COUNT - 1);
        objectArray[XSAttributeChecker.ATTIDX_ISRETURNED] = Boolean.FALSE;
        return objectArray;
    }

    public void returnAttrArray(Object[] objectArray, XSDocumentInfo xSDocumentInfo) {
        if (xSDocumentInfo != null) {
            xSDocumentInfo.fNamespaceSupport.popContext();
        }
        if (this.fPoolPos == 0 || objectArray == null || objectArray.length != ATTIDX_COUNT || ((Boolean)objectArray[ATTIDX_ISRETURNED]).booleanValue()) {
            return;
        }
        objectArray[XSAttributeChecker.ATTIDX_ISRETURNED] = Boolean.TRUE;
        this.fArrayPool[--this.fPoolPos] = objectArray;
    }

    public void resolveNamespace(Element element, SchemaNamespaceSupport schemaNamespaceSupport) {
        schemaNamespaceSupport.pushContext();
        Attr[] attrArray = DOMUtil.getAttrs(element);
        Attr attr = null;
        int n = 0;
        while (n < attrArray.length) {
            attr = attrArray[n];
            String string = DOMUtil.getName(attr);
            if (string == SchemaSymbols.XMLNS || string.startsWith("xmlns:")) {
                String string2 = null;
                if (string.length() == 5) {
                    string2 = this.fSchemaHandler.EMPTY_STRING;
                } else if (string.charAt(5) == ':') {
                    string2 = this.fSymbolTable.addSymbol(DOMUtil.getLocalName(attr));
                }
                if (string2 != null) {
                    String string3 = this.fSymbolTable.addSymbol(DOMUtil.getValue(attr));
                    schemaNamespaceSupport.declarePrefix(string2, string3.length() != 0 ? string3 : null);
                }
            }
            ++n;
        }
    }

    static {
        SchemaGrammar schemaGrammar = SchemaGrammar.SG_SchemaNS;
        XSAttributeChecker.fExtraDVs[0] = (XSSimpleType)schemaGrammar.getGlobalTypeDecl("anyURI");
        XSAttributeChecker.fExtraDVs[1] = (XSSimpleType)schemaGrammar.getGlobalTypeDecl("ID");
        XSAttributeChecker.fExtraDVs[2] = (XSSimpleType)schemaGrammar.getGlobalTypeDecl("QName");
        XSAttributeChecker.fExtraDVs[3] = (XSSimpleType)schemaGrammar.getGlobalTypeDecl("string");
        XSAttributeChecker.fExtraDVs[4] = (XSSimpleType)schemaGrammar.getGlobalTypeDecl("token");
        XSAttributeChecker.fExtraDVs[5] = (XSSimpleType)schemaGrammar.getGlobalTypeDecl("NCName");
        XSAttributeChecker.fExtraDVs[6] = fExtraDVs[3];
        XSAttributeChecker.fExtraDVs[6] = fExtraDVs[3];
        int n = 0;
        int n2 = n++;
        int n3 = n++;
        int n4 = n++;
        int n5 = n++;
        int n6 = n++;
        int n7 = n++;
        int n8 = n++;
        int n9 = n++;
        int n10 = n++;
        int n11 = n++;
        int n12 = n++;
        int n13 = n++;
        int n14 = n++;
        int n15 = n++;
        int n16 = n++;
        int n17 = n++;
        int n18 = n++;
        int n19 = n++;
        int n20 = n++;
        int n21 = n++;
        int n22 = n++;
        int n23 = n++;
        int n24 = n++;
        int n25 = n++;
        int n26 = n++;
        int n27 = n++;
        int n28 = n++;
        int n29 = n++;
        int n30 = n++;
        int n31 = n++;
        int n32 = n++;
        int n33 = n++;
        int n34 = n++;
        int n35 = n++;
        int n36 = n++;
        int n37 = n++;
        int n38 = n++;
        int n39 = n++;
        int n40 = n++;
        int n41 = n++;
        int n42 = n++;
        int n43 = n++;
        int n44 = n++;
        int n45 = n++;
        int n46 = n++;
        int n47 = n++;
        OneAttr[] oneAttrArray = new OneAttr[n];
        oneAttrArray[n2] = new OneAttr(SchemaSymbols.ATT_ABSTRACT, -15, ATTIDX_ABSTRACT, Boolean.FALSE);
        oneAttrArray[n3] = new OneAttr(SchemaSymbols.ATT_ATTRIBUTEFORMDEFAULT, -5, ATTIDX_AFORMDEFAULT, INT_UNQUALIFIED);
        oneAttrArray[n4] = new OneAttr(SchemaSymbols.ATT_BASE, 2, ATTIDX_BASE, null);
        oneAttrArray[n5] = new OneAttr(SchemaSymbols.ATT_BASE, 2, ATTIDX_BASE, null);
        oneAttrArray[n6] = new OneAttr(SchemaSymbols.ATT_BLOCK, -1, ATTIDX_BLOCK, null);
        oneAttrArray[n7] = new OneAttr(SchemaSymbols.ATT_BLOCK, -2, ATTIDX_BLOCK, null);
        oneAttrArray[n8] = new OneAttr(SchemaSymbols.ATT_BLOCKDEFAULT, -1, ATTIDX_BLOCKDEFAULT, INT_EMPTY_SET);
        oneAttrArray[n9] = new OneAttr(SchemaSymbols.ATT_DEFAULT, 3, ATTIDX_DEFAULT, null);
        oneAttrArray[n10] = new OneAttr(SchemaSymbols.ATT_ELEMENTFORMDEFAULT, -5, ATTIDX_EFORMDEFAULT, INT_UNQUALIFIED);
        oneAttrArray[n11] = new OneAttr(SchemaSymbols.ATT_FINAL, -3, ATTIDX_FINAL, null);
        oneAttrArray[n12] = new OneAttr(SchemaSymbols.ATT_FINAL, -4, ATTIDX_FINAL, null);
        oneAttrArray[n13] = new OneAttr(SchemaSymbols.ATT_FINALDEFAULT, -3, ATTIDX_FINALDEFAULT, INT_EMPTY_SET);
        oneAttrArray[n14] = new OneAttr(SchemaSymbols.ATT_FIXED, 3, ATTIDX_FIXED, null);
        oneAttrArray[n15] = new OneAttr(SchemaSymbols.ATT_FIXED, -15, ATTIDX_FIXED, Boolean.FALSE);
        oneAttrArray[n16] = new OneAttr(SchemaSymbols.ATT_FORM, -5, ATTIDX_FORM, null);
        oneAttrArray[n17] = new OneAttr(SchemaSymbols.ATT_ID, 1, ATTIDX_ID, null);
        oneAttrArray[n18] = new OneAttr(SchemaSymbols.ATT_ITEMTYPE, 2, ATTIDX_ITEMTYPE, null);
        oneAttrArray[n19] = new OneAttr(SchemaSymbols.ATT_MAXOCCURS, -6, ATTIDX_MAXOCCURS, fXIntPool.getXInt(1));
        oneAttrArray[n20] = new OneAttr(SchemaSymbols.ATT_MAXOCCURS, -7, ATTIDX_MAXOCCURS, fXIntPool.getXInt(1));
        oneAttrArray[n21] = new OneAttr(SchemaSymbols.ATT_MEMBERTYPES, -8, ATTIDX_MEMBERTYPES, null);
        oneAttrArray[n22] = new OneAttr(SchemaSymbols.ATT_MINOCCURS, -16, ATTIDX_MINOCCURS, fXIntPool.getXInt(1));
        oneAttrArray[n23] = new OneAttr(SchemaSymbols.ATT_MINOCCURS, -9, ATTIDX_MINOCCURS, fXIntPool.getXInt(1));
        oneAttrArray[n24] = new OneAttr(SchemaSymbols.ATT_MIXED, -15, ATTIDX_MIXED, Boolean.FALSE);
        oneAttrArray[n25] = new OneAttr(SchemaSymbols.ATT_MIXED, -15, ATTIDX_MIXED, null);
        oneAttrArray[n26] = new OneAttr(SchemaSymbols.ATT_NAME, 5, ATTIDX_NAME, null);
        oneAttrArray[n27] = new OneAttr(SchemaSymbols.ATT_NAMESPACE, -10, ATTIDX_NAMESPACE, WC_ANY);
        oneAttrArray[n28] = new OneAttr(SchemaSymbols.ATT_NAMESPACE, 0, ATTIDX_NAMESPACE, null);
        oneAttrArray[n29] = new OneAttr(SchemaSymbols.ATT_NILLABLE, -15, ATTIDX_NILLABLE, Boolean.FALSE);
        oneAttrArray[n30] = new OneAttr(SchemaSymbols.ATT_PROCESSCONTENTS, -11, ATTIDX_PROCESSCONTENTS, INT_ANY_STRICT);
        oneAttrArray[n31] = new OneAttr(SchemaSymbols.ATT_PUBLIC, -12, ATTIDX_PUBLIC, null);
        oneAttrArray[n32] = new OneAttr(SchemaSymbols.ATT_REF, 2, ATTIDX_REF, null);
        oneAttrArray[n33] = new OneAttr(SchemaSymbols.ATT_REFER, 2, ATTIDX_REFER, null);
        oneAttrArray[n34] = new OneAttr(SchemaSymbols.ATT_SCHEMALOCATION, 0, ATTIDX_SCHEMALOCATION, null);
        oneAttrArray[n35] = new OneAttr(SchemaSymbols.ATT_SCHEMALOCATION, 0, ATTIDX_SCHEMALOCATION, null);
        oneAttrArray[n36] = new OneAttr(SchemaSymbols.ATT_SOURCE, 0, ATTIDX_SOURCE, null);
        oneAttrArray[n37] = new OneAttr(SchemaSymbols.ATT_SUBSTITUTIONGROUP, 2, ATTIDX_SUBSGROUP, null);
        oneAttrArray[n38] = new OneAttr(SchemaSymbols.ATT_SYSTEM, 0, ATTIDX_SYSTEM, null);
        oneAttrArray[n39] = new OneAttr(SchemaSymbols.ATT_TARGETNAMESPACE, 0, ATTIDX_TARGETNAMESPACE, null);
        oneAttrArray[n40] = new OneAttr(SchemaSymbols.ATT_TYPE, 2, ATTIDX_TYPE, null);
        oneAttrArray[n41] = new OneAttr(SchemaSymbols.ATT_USE, -13, ATTIDX_USE, INT_USE_OPTIONAL);
        oneAttrArray[n42] = new OneAttr(SchemaSymbols.ATT_VALUE, -16, ATTIDX_VALUE, null);
        oneAttrArray[n43] = new OneAttr(SchemaSymbols.ATT_VALUE, 3, ATTIDX_VALUE, null);
        oneAttrArray[n44] = new OneAttr(SchemaSymbols.ATT_VALUE, -14, ATTIDX_VALUE, null);
        oneAttrArray[n45] = new OneAttr(SchemaSymbols.ATT_VERSION, 4, ATTIDX_VERSION, null);
        oneAttrArray[n46] = new OneAttr(SchemaSymbols.ATT_XPATH, 6, ATTIDX_XPATH, null);
        oneAttrArray[n47] = new OneAttr(SchemaSymbols.ATT_XPATH, 7, ATTIDX_XPATH, null);
        Hashtable<String, OneAttr> hashtable = new Hashtable<String, OneAttr>();
        hashtable.put(SchemaSymbols.ATT_DEFAULT, oneAttrArray[n9]);
        hashtable.put(SchemaSymbols.ATT_FIXED, oneAttrArray[n14]);
        hashtable.put(SchemaSymbols.ATT_ID, oneAttrArray[n17]);
        hashtable.put(SchemaSymbols.ATT_NAME, oneAttrArray[n26]);
        hashtable.put(SchemaSymbols.ATT_TYPE, oneAttrArray[n40]);
        OneElement oneElement = new OneElement(hashtable);
        fEleAttrsMapG.put(SchemaSymbols.ELT_ATTRIBUTE, oneElement);
        hashtable = new Hashtable();
        hashtable.put(SchemaSymbols.ATT_DEFAULT, oneAttrArray[n9]);
        hashtable.put(SchemaSymbols.ATT_FIXED, oneAttrArray[n14]);
        hashtable.put(SchemaSymbols.ATT_FORM, oneAttrArray[n16]);
        hashtable.put(SchemaSymbols.ATT_ID, oneAttrArray[n17]);
        hashtable.put(SchemaSymbols.ATT_NAME, oneAttrArray[n26]);
        hashtable.put(SchemaSymbols.ATT_TYPE, oneAttrArray[n40]);
        hashtable.put(SchemaSymbols.ATT_USE, oneAttrArray[n41]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMapL.put(ATTRIBUTE_N, oneElement);
        hashtable = new Hashtable();
        hashtable.put(SchemaSymbols.ATT_DEFAULT, oneAttrArray[n9]);
        hashtable.put(SchemaSymbols.ATT_FIXED, oneAttrArray[n14]);
        hashtable.put(SchemaSymbols.ATT_ID, oneAttrArray[n17]);
        hashtable.put(SchemaSymbols.ATT_REF, oneAttrArray[n32]);
        hashtable.put(SchemaSymbols.ATT_USE, oneAttrArray[n41]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMapL.put(ATTRIBUTE_R, oneElement);
        hashtable = new Hashtable();
        hashtable.put(SchemaSymbols.ATT_ABSTRACT, oneAttrArray[n2]);
        hashtable.put(SchemaSymbols.ATT_BLOCK, oneAttrArray[n6]);
        hashtable.put(SchemaSymbols.ATT_DEFAULT, oneAttrArray[n9]);
        hashtable.put(SchemaSymbols.ATT_FINAL, oneAttrArray[n11]);
        hashtable.put(SchemaSymbols.ATT_FIXED, oneAttrArray[n14]);
        hashtable.put(SchemaSymbols.ATT_ID, oneAttrArray[n17]);
        hashtable.put(SchemaSymbols.ATT_NAME, oneAttrArray[n26]);
        hashtable.put(SchemaSymbols.ATT_NILLABLE, oneAttrArray[n29]);
        hashtable.put(SchemaSymbols.ATT_SUBSTITUTIONGROUP, oneAttrArray[n37]);
        hashtable.put(SchemaSymbols.ATT_TYPE, oneAttrArray[n40]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMapG.put(SchemaSymbols.ELT_ELEMENT, oneElement);
        hashtable = new Hashtable();
        hashtable.put(SchemaSymbols.ATT_BLOCK, oneAttrArray[n6]);
        hashtable.put(SchemaSymbols.ATT_DEFAULT, oneAttrArray[n9]);
        hashtable.put(SchemaSymbols.ATT_FIXED, oneAttrArray[n14]);
        hashtable.put(SchemaSymbols.ATT_FORM, oneAttrArray[n16]);
        hashtable.put(SchemaSymbols.ATT_ID, oneAttrArray[n17]);
        hashtable.put(SchemaSymbols.ATT_MAXOCCURS, oneAttrArray[n19]);
        hashtable.put(SchemaSymbols.ATT_MINOCCURS, oneAttrArray[n22]);
        hashtable.put(SchemaSymbols.ATT_NAME, oneAttrArray[n26]);
        hashtable.put(SchemaSymbols.ATT_NILLABLE, oneAttrArray[n29]);
        hashtable.put(SchemaSymbols.ATT_TYPE, oneAttrArray[n40]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMapL.put(ELEMENT_N, oneElement);
        hashtable = new Hashtable();
        hashtable.put(SchemaSymbols.ATT_ID, oneAttrArray[n17]);
        hashtable.put(SchemaSymbols.ATT_MAXOCCURS, oneAttrArray[n19]);
        hashtable.put(SchemaSymbols.ATT_MINOCCURS, oneAttrArray[n22]);
        hashtable.put(SchemaSymbols.ATT_REF, oneAttrArray[n32]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMapL.put(ELEMENT_R, oneElement);
        hashtable = new Hashtable();
        hashtable.put(SchemaSymbols.ATT_ABSTRACT, oneAttrArray[n2]);
        hashtable.put(SchemaSymbols.ATT_BLOCK, oneAttrArray[n7]);
        hashtable.put(SchemaSymbols.ATT_FINAL, oneAttrArray[n11]);
        hashtable.put(SchemaSymbols.ATT_ID, oneAttrArray[n17]);
        hashtable.put(SchemaSymbols.ATT_MIXED, oneAttrArray[n24]);
        hashtable.put(SchemaSymbols.ATT_NAME, oneAttrArray[n26]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMapG.put(SchemaSymbols.ELT_COMPLEXTYPE, oneElement);
        hashtable = new Hashtable();
        hashtable.put(SchemaSymbols.ATT_ID, oneAttrArray[n17]);
        hashtable.put(SchemaSymbols.ATT_NAME, oneAttrArray[n26]);
        hashtable.put(SchemaSymbols.ATT_PUBLIC, oneAttrArray[n31]);
        hashtable.put(SchemaSymbols.ATT_SYSTEM, oneAttrArray[n38]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMapG.put(SchemaSymbols.ELT_NOTATION, oneElement);
        hashtable = new Hashtable();
        hashtable.put(SchemaSymbols.ATT_ID, oneAttrArray[n17]);
        hashtable.put(SchemaSymbols.ATT_MIXED, oneAttrArray[n24]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMapL.put(SchemaSymbols.ELT_COMPLEXTYPE, oneElement);
        hashtable = new Hashtable();
        hashtable.put(SchemaSymbols.ATT_ID, oneAttrArray[n17]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMapL.put(SchemaSymbols.ELT_SIMPLECONTENT, oneElement);
        hashtable = new Hashtable();
        hashtable.put(SchemaSymbols.ATT_BASE, oneAttrArray[n5]);
        hashtable.put(SchemaSymbols.ATT_ID, oneAttrArray[n17]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMapL.put(SchemaSymbols.ELT_RESTRICTION, oneElement);
        hashtable = new Hashtable();
        hashtable.put(SchemaSymbols.ATT_BASE, oneAttrArray[n4]);
        hashtable.put(SchemaSymbols.ATT_ID, oneAttrArray[n17]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMapL.put(SchemaSymbols.ELT_EXTENSION, oneElement);
        hashtable = new Hashtable();
        hashtable.put(SchemaSymbols.ATT_ID, oneAttrArray[n17]);
        hashtable.put(SchemaSymbols.ATT_REF, oneAttrArray[n32]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMapL.put(SchemaSymbols.ELT_ATTRIBUTEGROUP, oneElement);
        hashtable = new Hashtable();
        hashtable.put(SchemaSymbols.ATT_ID, oneAttrArray[n17]);
        hashtable.put(SchemaSymbols.ATT_NAMESPACE, oneAttrArray[n27]);
        hashtable.put(SchemaSymbols.ATT_PROCESSCONTENTS, oneAttrArray[n30]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMapL.put(SchemaSymbols.ELT_ANYATTRIBUTE, oneElement);
        hashtable = new Hashtable();
        hashtable.put(SchemaSymbols.ATT_ID, oneAttrArray[n17]);
        hashtable.put(SchemaSymbols.ATT_MIXED, oneAttrArray[n25]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMapL.put(SchemaSymbols.ELT_COMPLEXCONTENT, oneElement);
        hashtable = new Hashtable();
        hashtable.put(SchemaSymbols.ATT_ID, oneAttrArray[n17]);
        hashtable.put(SchemaSymbols.ATT_NAME, oneAttrArray[n26]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMapG.put(SchemaSymbols.ELT_ATTRIBUTEGROUP, oneElement);
        hashtable = new Hashtable();
        hashtable.put(SchemaSymbols.ATT_ID, oneAttrArray[n17]);
        hashtable.put(SchemaSymbols.ATT_NAME, oneAttrArray[n26]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMapG.put(SchemaSymbols.ELT_GROUP, oneElement);
        hashtable = new Hashtable();
        hashtable.put(SchemaSymbols.ATT_ID, oneAttrArray[n17]);
        hashtable.put(SchemaSymbols.ATT_MAXOCCURS, oneAttrArray[n19]);
        hashtable.put(SchemaSymbols.ATT_MINOCCURS, oneAttrArray[n22]);
        hashtable.put(SchemaSymbols.ATT_REF, oneAttrArray[n32]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMapL.put(SchemaSymbols.ELT_GROUP, oneElement);
        hashtable = new Hashtable();
        hashtable.put(SchemaSymbols.ATT_ID, oneAttrArray[n17]);
        hashtable.put(SchemaSymbols.ATT_MAXOCCURS, oneAttrArray[n20]);
        hashtable.put(SchemaSymbols.ATT_MINOCCURS, oneAttrArray[n23]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMapL.put(SchemaSymbols.ELT_ALL, oneElement);
        hashtable = new Hashtable();
        hashtable.put(SchemaSymbols.ATT_ID, oneAttrArray[n17]);
        hashtable.put(SchemaSymbols.ATT_MAXOCCURS, oneAttrArray[n19]);
        hashtable.put(SchemaSymbols.ATT_MINOCCURS, oneAttrArray[n22]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMapL.put(SchemaSymbols.ELT_CHOICE, oneElement);
        fEleAttrsMapL.put(SchemaSymbols.ELT_SEQUENCE, oneElement);
        hashtable = new Hashtable();
        hashtable.put(SchemaSymbols.ATT_ID, oneAttrArray[n17]);
        hashtable.put(SchemaSymbols.ATT_MAXOCCURS, oneAttrArray[n19]);
        hashtable.put(SchemaSymbols.ATT_MINOCCURS, oneAttrArray[n22]);
        hashtable.put(SchemaSymbols.ATT_NAMESPACE, oneAttrArray[n27]);
        hashtable.put(SchemaSymbols.ATT_PROCESSCONTENTS, oneAttrArray[n30]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMapL.put(SchemaSymbols.ELT_ANY, oneElement);
        hashtable = new Hashtable();
        hashtable.put(SchemaSymbols.ATT_ID, oneAttrArray[n17]);
        hashtable.put(SchemaSymbols.ATT_NAME, oneAttrArray[n26]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMapL.put(SchemaSymbols.ELT_UNIQUE, oneElement);
        fEleAttrsMapL.put(SchemaSymbols.ELT_KEY, oneElement);
        hashtable = new Hashtable();
        hashtable.put(SchemaSymbols.ATT_ID, oneAttrArray[n17]);
        hashtable.put(SchemaSymbols.ATT_NAME, oneAttrArray[n26]);
        hashtable.put(SchemaSymbols.ATT_REFER, oneAttrArray[n33]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMapL.put(SchemaSymbols.ELT_KEYREF, oneElement);
        hashtable = new Hashtable();
        hashtable.put(SchemaSymbols.ATT_ID, oneAttrArray[n17]);
        hashtable.put(SchemaSymbols.ATT_XPATH, oneAttrArray[n46]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMapL.put(SchemaSymbols.ELT_SELECTOR, oneElement);
        hashtable = new Hashtable();
        hashtable.put(SchemaSymbols.ATT_ID, oneAttrArray[n17]);
        hashtable.put(SchemaSymbols.ATT_XPATH, oneAttrArray[n47]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMapL.put(SchemaSymbols.ELT_FIELD, oneElement);
        hashtable = new Hashtable();
        hashtable.put(SchemaSymbols.ATT_ID, oneAttrArray[n17]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMapG.put(SchemaSymbols.ELT_ANNOTATION, oneElement);
        fEleAttrsMapL.put(SchemaSymbols.ELT_ANNOTATION, oneElement);
        hashtable = new Hashtable();
        hashtable.put(SchemaSymbols.ATT_SOURCE, oneAttrArray[n36]);
        oneElement = new OneElement(hashtable, false);
        fEleAttrsMapG.put(SchemaSymbols.ELT_APPINFO, oneElement);
        fEleAttrsMapL.put(SchemaSymbols.ELT_APPINFO, oneElement);
        hashtable = new Hashtable();
        hashtable.put(SchemaSymbols.ATT_SOURCE, oneAttrArray[n36]);
        oneElement = new OneElement(hashtable, false);
        fEleAttrsMapG.put(SchemaSymbols.ELT_DOCUMENTATION, oneElement);
        fEleAttrsMapL.put(SchemaSymbols.ELT_DOCUMENTATION, oneElement);
        hashtable = new Hashtable();
        hashtable.put(SchemaSymbols.ATT_FINAL, oneAttrArray[n12]);
        hashtable.put(SchemaSymbols.ATT_ID, oneAttrArray[n17]);
        hashtable.put(SchemaSymbols.ATT_NAME, oneAttrArray[n26]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMapG.put(SchemaSymbols.ELT_SIMPLETYPE, oneElement);
        hashtable = new Hashtable();
        hashtable.put(SchemaSymbols.ATT_FINAL, oneAttrArray[n12]);
        hashtable.put(SchemaSymbols.ATT_ID, oneAttrArray[n17]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMapL.put(SchemaSymbols.ELT_SIMPLETYPE, oneElement);
        hashtable = new Hashtable();
        hashtable.put(SchemaSymbols.ATT_ID, oneAttrArray[n17]);
        hashtable.put(SchemaSymbols.ATT_ITEMTYPE, oneAttrArray[n18]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMapL.put(SchemaSymbols.ELT_LIST, oneElement);
        hashtable = new Hashtable();
        hashtable.put(SchemaSymbols.ATT_ID, oneAttrArray[n17]);
        hashtable.put(SchemaSymbols.ATT_MEMBERTYPES, oneAttrArray[n21]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMapL.put(SchemaSymbols.ELT_UNION, oneElement);
        hashtable = new Hashtable();
        hashtable.put(SchemaSymbols.ATT_ATTRIBUTEFORMDEFAULT, oneAttrArray[n3]);
        hashtable.put(SchemaSymbols.ATT_BLOCKDEFAULT, oneAttrArray[n8]);
        hashtable.put(SchemaSymbols.ATT_ELEMENTFORMDEFAULT, oneAttrArray[n10]);
        hashtable.put(SchemaSymbols.ATT_FINALDEFAULT, oneAttrArray[n13]);
        hashtable.put(SchemaSymbols.ATT_ID, oneAttrArray[n17]);
        hashtable.put(SchemaSymbols.ATT_TARGETNAMESPACE, oneAttrArray[n39]);
        hashtable.put(SchemaSymbols.ATT_VERSION, oneAttrArray[n45]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMapG.put(SchemaSymbols.ELT_SCHEMA, oneElement);
        hashtable = new Hashtable();
        hashtable.put(SchemaSymbols.ATT_ID, oneAttrArray[n17]);
        hashtable.put(SchemaSymbols.ATT_SCHEMALOCATION, oneAttrArray[n34]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMapG.put(SchemaSymbols.ELT_INCLUDE, oneElement);
        fEleAttrsMapG.put(SchemaSymbols.ELT_REDEFINE, oneElement);
        hashtable = new Hashtable();
        hashtable.put(SchemaSymbols.ATT_ID, oneAttrArray[n17]);
        hashtable.put(SchemaSymbols.ATT_NAMESPACE, oneAttrArray[n28]);
        hashtable.put(SchemaSymbols.ATT_SCHEMALOCATION, oneAttrArray[n35]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMapG.put(SchemaSymbols.ELT_IMPORT, oneElement);
        hashtable = new Hashtable();
        hashtable.put(SchemaSymbols.ATT_ID, oneAttrArray[n17]);
        hashtable.put(SchemaSymbols.ATT_VALUE, oneAttrArray[n42]);
        hashtable.put(SchemaSymbols.ATT_FIXED, oneAttrArray[n15]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMapL.put(SchemaSymbols.ELT_LENGTH, oneElement);
        fEleAttrsMapL.put(SchemaSymbols.ELT_MINLENGTH, oneElement);
        fEleAttrsMapL.put(SchemaSymbols.ELT_MAXLENGTH, oneElement);
        fEleAttrsMapL.put(SchemaSymbols.ELT_TOTALDIGITS, oneElement);
        fEleAttrsMapL.put(SchemaSymbols.ELT_FRACTIONDIGITS, oneElement);
        hashtable = new Hashtable();
        hashtable.put(SchemaSymbols.ATT_ID, oneAttrArray[n17]);
        hashtable.put(SchemaSymbols.ATT_VALUE, oneAttrArray[n43]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMapL.put(SchemaSymbols.ELT_PATTERN, oneElement);
        hashtable = new Hashtable();
        hashtable.put(SchemaSymbols.ATT_ID, oneAttrArray[n17]);
        hashtable.put(SchemaSymbols.ATT_VALUE, oneAttrArray[n43]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMapL.put(SchemaSymbols.ELT_ENUMERATION, oneElement);
        hashtable = new Hashtable();
        hashtable.put(SchemaSymbols.ATT_ID, oneAttrArray[n17]);
        hashtable.put(SchemaSymbols.ATT_VALUE, oneAttrArray[n44]);
        hashtable.put(SchemaSymbols.ATT_FIXED, oneAttrArray[n15]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMapL.put(SchemaSymbols.ELT_WHITESPACE, oneElement);
        hashtable = new Hashtable();
        hashtable.put(SchemaSymbols.ATT_ID, oneAttrArray[n17]);
        hashtable.put(SchemaSymbols.ATT_VALUE, oneAttrArray[n43]);
        hashtable.put(SchemaSymbols.ATT_FIXED, oneAttrArray[n15]);
        oneElement = new OneElement(hashtable);
        fEleAttrsMapL.put(SchemaSymbols.ELT_MAXINCLUSIVE, oneElement);
        fEleAttrsMapL.put(SchemaSymbols.ELT_MAXEXCLUSIVE, oneElement);
        fEleAttrsMapL.put(SchemaSymbols.ELT_MININCLUSIVE, oneElement);
        fEleAttrsMapL.put(SchemaSymbols.ELT_MINEXCLUSIVE, oneElement);
        fTempArray = new Object[ATTIDX_COUNT];
    }
}

