#===============================================================================
# Copyright 2014 NetApp, Inc. All Rights Reserved,
# contribution by Jorge Mora <mora@netapp.com>
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free Software
# Foundation; either version 2 of the License, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
#===============================================================================
# Generated by process_xdr.py from nfs3.x on Sun Oct 04 08:09:27 2015
"""
NFSv3 decoding module
"""
import nfstest_config as c
import nfs3_const as const
from packet.utils import *
from baseobj import BaseObj
from packet.unpack import Unpack

# Module constants
__author__    = "Jorge Mora (%s)" % c.NFSTEST_AUTHOR_EMAIL
__copyright__ = "Copyright (C) 2014 NetApp, Inc."
__license__   = "GPL v2"
__version__   = "3.0"

#
# Constants
class nfs_bool(Enum):
    """enum nfs_bool"""
    _enumdict = const.nfs_bool

# Basic data types
uint64      = Unpack.unpack_uint64
int64       = Unpack.unpack_int64
uint32      = Unpack.unpack_uint
int32       = Unpack.unpack_int
filename3   = Unpack.unpack_opaque
nfspath3    = Unpack.unpack_opaque
fileid3     = uint64
cookie3     = uint64
cookieverf3 = lambda unpack: StrHex(unpack.unpack_fopaque(const.NFS3_COOKIEVERFSIZE))
createverf3 = lambda unpack: StrHex(unpack.unpack_fopaque(const.NFS3_CREATEVERFSIZE))
writeverf3  = lambda unpack: StrHex(unpack.unpack_fopaque(const.NFS3_WRITEVERFSIZE))
uid3        = uint32
gid3        = uint32
size3       = uint64
offset3     = uint64
mode3       = uint32
count3      = uint32
nfs_fh3     = lambda unpack: StrHex(unpack.unpack_opaque(const.NFS3_FHSIZE))
access3     = uint32

# Error status
class nfsstat3(Enum):
    """enum nfsstat3"""
    _enumdict = const.nfsstat3

class ftype3(Enum):
    """enum ftype3"""
    _enumdict = const.ftype3

class specdata3(BaseObj):
    """
       struct specdata3 {
           uint32 specdata1;
           uint32 specdata2;
       };
    """
    # Class attributes
    _strfmt1  = "major:{0} minor:{1}"
    _attrlist = ("specdata1", "specdata2")

    def __init__(self, unpack):
        self.specdata1 = uint32(unpack)
        self.specdata2 = uint32(unpack)

class nfstime3(BaseObj):
    """
       struct nfstime3 {
           uint32 seconds;
           uint32 nseconds;
       };
    """
    # Class attributes
    _strfmt1  = "{0}.{1:09}"
    _attrlist = ("seconds", "nseconds")

    def __init__(self, unpack):
        self.seconds  = uint32(unpack)
        self.nseconds = uint32(unpack)

class fattr3(BaseObj):
    """
       struct fattr3 {
           ftype3    type;
           mode3     mode;
           uint32    nlink;
           uid3      uid;
           gid3      gid;
           size3     size;
           size3     used;
           specdata3 rdev;
           uint64    fsid;
           fileid3   fileid;
           nfstime3  atime;
           nfstime3  mtime;
           nfstime3  ctime;
       };
    """
    # Class attributes
    _strfmt1  = "{0} mode:{1:04o} nlink:{2} uid:{3} gid:{4} size:{5} fileid:{9}"
    _attrlist = ("type", "mode", "nlink", "uid", "gid", "size", "used", "rdev",
                 "fsid", "fileid", "atime", "mtime", "ctime")

    def __init__(self, unpack):
        self.type   = ftype3(unpack)
        self.mode   = mode3(unpack)
        self.nlink  = uint32(unpack)
        self.uid    = uid3(unpack)
        self.gid    = gid3(unpack)
        self.size   = size3(unpack)
        self.used   = size3(unpack)
        self.rdev   = specdata3(unpack)
        self.fsid   = uint64(unpack)
        self.fileid = fileid3(unpack)
        self.atime  = nfstime3(unpack)
        self.mtime  = nfstime3(unpack)
        self.ctime  = nfstime3(unpack)

class post_op_attr(BaseObj):
    """
       union switch post_op_attr (bool attributes_follow) {
           case const.TRUE:
               fattr3 attributes;
           case const.FALSE:
               void;
       };
    """
    def __init__(self, unpack):
        self.set_attr("attributes_follow", nfs_bool(unpack))
        if self.attributes_follow == const.TRUE:
            self.set_attr("attributes", fattr3(unpack), switch=True)

class wcc_attr(BaseObj):
    """
       struct wcc_attr {
           size3    size;
           nfstime3 mtime;
           nfstime3 ctime;
       };
    """
    # Class attributes
    _attrlist = ("size", "mtime", "ctime")

    def __init__(self, unpack):
        self.size  = size3(unpack)
        self.mtime = nfstime3(unpack)
        self.ctime = nfstime3(unpack)

class pre_op_attr(BaseObj):
    """
       union switch pre_op_attr (bool attributes_follow) {
           case const.TRUE:
               wcc_attr attributes;
           case const.FALSE:
               void;
       };
    """
    def __init__(self, unpack):
        self.set_attr("attributes_follow", nfs_bool(unpack))
        if self.attributes_follow == const.TRUE:
            self.set_attr("attributes", wcc_attr(unpack), switch=True)

class wcc_data(BaseObj):
    """
       struct wcc_data {
           pre_op_attr  before;
           post_op_attr after;
       };
    """
    # Class attributes
    _attrlist = ("before", "after")

    def __init__(self, unpack):
        self.before = pre_op_attr(unpack)
        self.after  = post_op_attr(unpack)

class post_op_fh3(BaseObj):
    """
       union switch post_op_fh3 (bool handle_follows) {
           case const.TRUE:
               nfs_fh3 fh;
           case const.FALSE:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "FH:{1:crc32}"

    def __init__(self, unpack):
        self.set_attr("handle_follows", nfs_bool(unpack))
        if self.handle_follows == const.TRUE:
            self.set_attr("fh", nfs_fh3(unpack), switch=True)
        elif self.handle_follows == const.FALSE:
            self.set_strfmt(1, "")

class time_how(Enum):
    """enum time_how"""
    _enumdict = const.time_how

class set_mode3(BaseObj):
    """
       union switch set_mode3 (bool set_it) {
           case const.TRUE:
               mode3 mode;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "mode:{1:04o}\x20"

    def __init__(self, unpack):
        self.set_attr("set_it", nfs_bool(unpack))
        if self.set_it == const.TRUE:
            self.set_attr("mode", mode3(unpack), switch=True)
        else:
            self.set_strfmt(1, "")

class set_uid3(BaseObj):
    """
       union switch set_uid3 (bool set_it) {
           case const.TRUE:
               uid3 uid;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "uid:{1}\x20"

    def __init__(self, unpack):
        self.set_attr("set_it", nfs_bool(unpack))
        if self.set_it == const.TRUE:
            self.set_attr("uid", uid3(unpack), switch=True)
        else:
            self.set_strfmt(1, "")

class set_gid3(BaseObj):
    """
       union switch set_gid3 (bool set_it) {
           case const.TRUE:
               gid3 gid;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "gid:{1}\x20"

    def __init__(self, unpack):
        self.set_attr("set_it", nfs_bool(unpack))
        if self.set_it == const.TRUE:
            self.set_attr("gid", gid3(unpack), switch=True)
        else:
            self.set_strfmt(1, "")

class set_size3(BaseObj):
    """
       union switch set_size3 (bool set_it) {
           case const.TRUE:
               size3 size;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "size:{1}\x20"

    def __init__(self, unpack):
        self.set_attr("set_it", nfs_bool(unpack))
        if self.set_it == const.TRUE:
            self.set_attr("size", size3(unpack), switch=True)
        else:
            self.set_strfmt(1, "")

class set_atime(BaseObj):
    """
       union switch set_atime (time_how set_it) {
           case const.SET_TO_CLIENT_TIME:
               nfstime3 atime;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "atime:{1}\x20"

    def __init__(self, unpack):
        self.set_attr("set_it", time_how(unpack))
        if self.set_it == const.SET_TO_CLIENT_TIME:
            self.set_attr("atime", nfstime3(unpack), switch=True)
        else:
            self.set_strfmt(1, "")

class set_mtime(BaseObj):
    """
       union switch set_mtime (time_how set_it) {
           case const.SET_TO_CLIENT_TIME:
               nfstime3 mtime;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "mtime:{1}\x20"

    def __init__(self, unpack):
        self.set_attr("set_it", time_how(unpack))
        if self.set_it == const.SET_TO_CLIENT_TIME:
            self.set_attr("mtime", nfstime3(unpack), switch=True)
        else:
            self.set_strfmt(1, "")

class sattr3(BaseObj):
    """
       struct sattr3 {
           set_mode3 mode;
           set_uid3  uid;
           set_gid3  gid;
           set_size3 size;
           set_atime atime;
           set_mtime mtime;
       };
    """
    # Class attributes
    _strfmt1  = "{0}{1}{2}{3}"
    _attrlist = ("mode", "uid", "gid", "size", "atime", "mtime")

    def __init__(self, unpack):
        self.mode  = set_mode3(unpack)
        self.uid   = set_uid3(unpack)
        self.gid   = set_gid3(unpack)
        self.size  = set_size3(unpack)
        self.atime = set_atime(unpack)
        self.mtime = set_mtime(unpack)

class diropargs3(BaseObj):
    """
       struct diropargs3 {
           nfs_fh3   fh;
           filename3 name;
       };
    """
    # Class attributes
    _strfmt1  = "DH:{0:crc32}/{1}"
    _attrlist = ("fh", "name")

    def __init__(self, unpack):
        self.fh   = nfs_fh3(unpack)
        self.name = filename3(unpack)

# GETATTR3res NFSPROC3_GETATTR(GETATTR3args) = 1;
class GETATTR3args(BaseObj):
    """
       struct GETATTR3args {
           nfs_fh3 fh;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{0:crc32}"
    _attrlist = ("fh",)

    def __init__(self, unpack):
        self.fh = nfs_fh3(unpack)

class GETATTR3resok(BaseObj):
    """
       struct GETATTR3resok {
           fattr3 attributes;
       };
    """
    # Class attributes
    _strfmt1  = "{0}"
    _attrlist = ("attributes",)

    def __init__(self, unpack):
        self.attributes = fattr3(unpack)

class GETATTR3res(BaseObj):
    """
       union switch GETATTR3res (nfsstat3 status) {
           case const.NFS3_OK:
               GETATTR3resok resok;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("status", nfsstat3(unpack))
        if self.status == const.NFS3_OK:
            self.set_attr("resok", GETATTR3resok(unpack), switch=True)

# SETATTR3res NFSPROC3_SETATTR(SETATTR3args) = 2;
class sattrguard3(BaseObj):
    """
       union switch sattrguard3 (bool check) {
           case const.TRUE:
               nfstime3 ctime;
           case const.FALSE:
               void;
       };
    """
    def __init__(self, unpack):
        self.set_attr("check", nfs_bool(unpack))
        if self.check == const.TRUE:
            self.set_attr("ctime", nfstime3(unpack), switch=True)

class SETATTR3args(BaseObj):
    """
       struct SETATTR3args {
           nfs_fh3     fh;
           sattr3      attributes;
           sattrguard3 guard;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{0:crc32} {1}"
    _attrlist = ("fh", "attributes", "guard")

    def __init__(self, unpack):
        self.fh         = nfs_fh3(unpack)
        self.attributes = sattr3(unpack)
        self.guard      = sattrguard3(unpack)

class SETATTR3resok(BaseObj):
    """
       struct SETATTR3resok {
           wcc_data wcc;
       };
    """
    # Class attributes
    _attrlist = ("wcc",)

    def __init__(self, unpack):
        self.wcc = wcc_data(unpack)

class SETATTR3resfail(BaseObj):
    """
       struct SETATTR3resfail {
           wcc_data wcc;
       };
    """
    # Class attributes
    _attrlist = ("wcc",)

    def __init__(self, unpack):
        self.wcc = wcc_data(unpack)

class SETATTR3res(BaseObj):
    """
       union switch SETATTR3res (nfsstat3 status) {
           case const.NFS3_OK:
               SETATTR3resok resok;
           default:
               SETATTR3resfail resfail;
       };
    """
    # Class attributes
    _strfmt1 = ""

    def __init__(self, unpack):
        self.set_attr("status", nfsstat3(unpack))
        if self.status == const.NFS3_OK:
            self.set_attr("resok", SETATTR3resok(unpack), switch=True)
        else:
            self.set_attr("resfail", SETATTR3resfail(unpack), switch=True)

# LOOKUP3res NFSPROC3_LOOKUP(LOOKUP3args) = 3;
class LOOKUP3args(BaseObj):
    """
       struct LOOKUP3args {
           diropargs3 what;
       };
    """
    # Class attributes
    _fattrs   = ("what",)
    _strfmt1  = "{0}"
    _attrlist = ("what",)

    def __init__(self, unpack):
        self.what = diropargs3(unpack)

class LOOKUP3resok(BaseObj):
    """
       struct LOOKUP3resok {
           nfs_fh3      fh;
           post_op_attr attributes;
           post_op_attr dir_attributes;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{0:crc32}"
    _attrlist = ("fh", "attributes", "dir_attributes")

    def __init__(self, unpack):
        self.fh             = nfs_fh3(unpack)
        self.attributes     = post_op_attr(unpack)
        self.dir_attributes = post_op_attr(unpack)

class LOOKUP3resfail(BaseObj):
    """
       struct LOOKUP3resfail {
           post_op_attr dir_attributes;
       };
    """
    # Class attributes
    _attrlist = ("dir_attributes",)

    def __init__(self, unpack):
        self.dir_attributes = post_op_attr(unpack)

class LOOKUP3res(BaseObj):
    """
       union switch LOOKUP3res (nfsstat3 status) {
           case const.NFS3_OK:
               LOOKUP3resok resok;
           default:
               LOOKUP3resfail resfail;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("status", nfsstat3(unpack))
        if self.status == const.NFS3_OK:
            self.set_attr("resok", LOOKUP3resok(unpack), switch=True)
        else:
            self.set_attr("resfail", LOOKUP3resfail(unpack), switch=True)
            self.set_strfmt(1, "")

class ACCESS3args(BaseObj):
    """
       struct ACCESS3args {
           nfs_fh3 fh;
           access3 access;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{0:crc32} acc:{1:#04x}"
    _attrlist = ("fh", "access")

    def __init__(self, unpack):
        self.fh     = nfs_fh3(unpack)
        self.access = access3(unpack)

class ACCESS3resok(BaseObj):
    """
       struct ACCESS3resok {
           post_op_attr attributes;
           access3      access;
       };
    """
    # Class attributes
    _strfmt1  = "acc:{1:#04x}"
    _attrlist = ("attributes", "access")

    def __init__(self, unpack):
        self.attributes = post_op_attr(unpack)
        self.access     = access3(unpack)

class ACCESS3resfail(BaseObj):
    """
       struct ACCESS3resfail {
           post_op_attr attributes;
       };
    """
    # Class attributes
    _attrlist = ("attributes",)

    def __init__(self, unpack):
        self.attributes = post_op_attr(unpack)

class ACCESS3res(BaseObj):
    """
       union switch ACCESS3res (nfsstat3 status) {
           case const.NFS3_OK:
               ACCESS3resok resok;
           default:
               ACCESS3resfail resfail;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("status", nfsstat3(unpack))
        if self.status == const.NFS3_OK:
            self.set_attr("resok", ACCESS3resok(unpack), switch=True)
        else:
            self.set_attr("resfail", ACCESS3resfail(unpack), switch=True)
            self.set_strfmt(1, "")

# READLINK3res NFSPROC3_READLINK(READLINK3args) = 5;
class READLINK3args(BaseObj):
    """
       struct READLINK3args {
           nfs_fh3 fh;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{0:crc32}"
    _attrlist = ("fh",)

    def __init__(self, unpack):
        self.fh = nfs_fh3(unpack)

class READLINK3resok(BaseObj):
    """
       struct READLINK3resok {
           post_op_attr attributes;
           nfspath3     link;
       };
    """
    # Class attributes
    _strfmt1  = "{1}"
    _attrlist = ("attributes", "link")

    def __init__(self, unpack):
        self.attributes = post_op_attr(unpack)
        self.link       = nfspath3(unpack)

class READLINK3resfail(BaseObj):
    """
       struct READLINK3resfail {
           post_op_attr attributes;
       };
    """
    # Class attributes
    _attrlist = ("attributes",)

    def __init__(self, unpack):
        self.attributes = post_op_attr(unpack)

class READLINK3res(BaseObj):
    """
       union switch READLINK3res (nfsstat3 status) {
           case const.NFS3_OK:
               READLINK3resok resok;
           default:
               READLINK3resfail resfail;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("status", nfsstat3(unpack))
        if self.status == const.NFS3_OK:
            self.set_attr("resok", READLINK3resok(unpack), switch=True)
        else:
            self.set_attr("resfail", READLINK3resfail(unpack), switch=True)
            self.set_strfmt(1, "")

# READ3res NFSPROC3_READ(READ3args) = 6;
class READ3args(BaseObj):
    """
       struct READ3args {
           nfs_fh3 fh;
           offset3 offset;
           count3  count;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{0:crc32} off:{1:umax64} len:{2:umax32}"
    _attrlist = ("fh", "offset", "count")

    def __init__(self, unpack):
        self.fh     = nfs_fh3(unpack)
        self.offset = offset3(unpack)
        self.count  = count3(unpack)

class READ3resok(BaseObj):
    """
       struct READ3resok {
           post_op_attr attributes;
           count3       count;
           bool         eof;
           opaque       data<>;
       };
    """
    # Class attributes
    _strfmt1  = "eof:{2} count:{1:umax32}"
    _attrlist = ("attributes", "count", "eof", "data")

    def __init__(self, unpack):
        self.attributes = post_op_attr(unpack)
        self.count      = count3(unpack)
        self.eof        = nfs_bool(unpack)
        self.data       = unpack.unpack_opaque()

class READ3resfail(BaseObj):
    """
       struct READ3resfail {
           post_op_attr file_attributes;
       };
    """
    # Class attributes
    _attrlist = ("file_attributes",)

    def __init__(self, unpack):
        self.file_attributes = post_op_attr(unpack)

class READ3res(BaseObj):
    """
       union switch READ3res (nfsstat3 status) {
           case const.NFS3_OK:
               READ3resok resok;
           default:
               READ3resfail resfail;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("status", nfsstat3(unpack))
        if self.status == const.NFS3_OK:
            self.set_attr("resok", READ3resok(unpack), switch=True)
        else:
            self.set_attr("resfail", READ3resfail(unpack), switch=True)
            self.set_strfmt(1, "")

# WRITE3res NFSPROC3_WRITE(WRITE3args) = 7;
class stable_how(Enum):
    """enum stable_how"""
    _enumdict = const.stable_how

class WRITE3args(BaseObj):
    """
       struct WRITE3args {
           nfs_fh3    fh;
           offset3    offset;
           count3     count;
           stable_how stable;
           opaque     data<>;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{0:crc32} off:{1:umax64} len:{2:umax32} {3}"
    _attrlist = ("fh", "offset", "count", "stable", "data")

    def __init__(self, unpack):
        self.fh     = nfs_fh3(unpack)
        self.offset = offset3(unpack)
        self.count  = count3(unpack)
        self.stable = stable_how(unpack)
        self.data   = unpack.unpack_opaque()

class WRITE3resok(BaseObj):
    """
       struct WRITE3resok {
           wcc_data   wcc;
           count3     count;
           stable_how committed;
           writeverf3 verifier;
       };
    """
    # Class attributes
    _strfmt1  = "count:{1:umax32} verf:{3} {2}"
    _attrlist = ("wcc", "count", "committed", "verifier")

    def __init__(self, unpack):
        self.wcc       = wcc_data(unpack)
        self.count     = count3(unpack)
        self.committed = stable_how(unpack)
        self.verifier  = writeverf3(unpack)

class WRITE3resfail(BaseObj):
    """
       struct WRITE3resfail {
           wcc_data wcc;
       };
    """
    # Class attributes
    _attrlist = ("wcc",)

    def __init__(self, unpack):
        self.wcc = wcc_data(unpack)

class WRITE3res(BaseObj):
    """
       union switch WRITE3res (nfsstat3 status) {
           case const.NFS3_OK:
               WRITE3resok resok;
           default:
               WRITE3resfail resfail;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("status", nfsstat3(unpack))
        if self.status == const.NFS3_OK:
            self.set_attr("resok", WRITE3resok(unpack), switch=True)
        else:
            self.set_attr("resfail", WRITE3resfail(unpack), switch=True)
            self.set_strfmt(1, "")

# CREATE3res NFSPROC3_CREATE(CREATE3args) = 8;
class createmode3(Enum):
    """enum createmode3"""
    _enumdict = const.createmode3

class createhow3(BaseObj):
    """
       union switch createhow3 (createmode3 mode) {
           case const.UNCHECKED:
           case const.GUARDED:
               sattr3 attributes;
           case const.EXCLUSIVE:
               createverf3 verifier;
       };
    """
    # Class attributes
    _strfmt1 = "{0}"

    def __init__(self, unpack):
        self.set_attr("mode", createmode3(unpack))
        if self.mode in [const.UNCHECKED, const.GUARDED]:
            self.set_attr("attributes", sattr3(unpack), switch=True)
        elif self.mode == const.EXCLUSIVE:
            self.set_attr("verifier", createverf3(unpack), switch=True)

class CREATE3args(BaseObj):
    """
       struct CREATE3args {
           diropargs3 where;
           createhow3 how;
       };
    """
    # Class attributes
    _fattrs   = ("where",)
    _strfmt1  = "{0} {1}"
    _attrlist = ("where", "how")

    def __init__(self, unpack):
        self.where = diropargs3(unpack)
        self.how   = createhow3(unpack)

class CREATE3resok(BaseObj):
    """
       struct CREATE3resok {
           post_op_fh3  obj;
           post_op_attr attributes;
           wcc_data     wcc;
       };
    """
    # Class attributes
    _fattrs   = ("obj",)
    _strfmt1  = "{0}"
    _attrlist = ("obj", "attributes", "wcc")

    def __init__(self, unpack):
        self.obj        = post_op_fh3(unpack)
        self.attributes = post_op_attr(unpack)
        self.wcc        = wcc_data(unpack)

class CREATE3resfail(BaseObj):
    """
       struct CREATE3resfail {
           wcc_data wcc;
       };
    """
    # Class attributes
    _attrlist = ("wcc",)

    def __init__(self, unpack):
        self.wcc = wcc_data(unpack)

class CREATE3res(BaseObj):
    """
       union switch CREATE3res (nfsstat3 status) {
           case const.NFS3_OK:
               CREATE3resok resok;
           default:
               CREATE3resfail resfail;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("status", nfsstat3(unpack))
        if self.status == const.NFS3_OK:
            self.set_attr("resok", CREATE3resok(unpack), switch=True)
        else:
            self.set_attr("resfail", CREATE3resfail(unpack), switch=True)
            self.set_strfmt(1, "")

# MKDIR3res NFSPROC3_MKDIR(MKDIR3args) = 9;
class MKDIR3args(BaseObj):
    """
       struct MKDIR3args {
           diropargs3 where;
           sattr3     attributes;
       };
    """
    # Class attributes
    _fattrs   = ("where",)
    _strfmt1  = "{0} {1}"
    _attrlist = ("where", "attributes")

    def __init__(self, unpack):
        self.where      = diropargs3(unpack)
        self.attributes = sattr3(unpack)

class MKDIR3resok(BaseObj):
    """
       struct MKDIR3resok {
           post_op_fh3  obj;
           post_op_attr attributes;
           wcc_data     wcc;
       };
    """
    # Class attributes
    _fattrs   = ("obj",)
    _strfmt1  = "{0}"
    _attrlist = ("obj", "attributes", "wcc")

    def __init__(self, unpack):
        self.obj        = post_op_fh3(unpack)
        self.attributes = post_op_attr(unpack)
        self.wcc        = wcc_data(unpack)

class MKDIR3resfail(BaseObj):
    """
       struct MKDIR3resfail {
           wcc_data wcc;
       };
    """
    # Class attributes
    _attrlist = ("wcc",)

    def __init__(self, unpack):
        self.wcc = wcc_data(unpack)

class MKDIR3res(BaseObj):
    """
       union switch MKDIR3res (nfsstat3 status) {
           case const.NFS3_OK:
               MKDIR3resok resok;
           default:
               MKDIR3resfail resfail;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("status", nfsstat3(unpack))
        if self.status == const.NFS3_OK:
            self.set_attr("resok", MKDIR3resok(unpack), switch=True)
        else:
            self.set_attr("resfail", MKDIR3resfail(unpack), switch=True)
            self.set_strfmt(1, "")

# SYMLINK3res NFSPROC3_SYMLINK(SYMLINK3args) = 10;
class symlinkdata3(BaseObj):
    """
       struct symlinkdata3 {
           sattr3   attributes;
           nfspath3 linkdata;
       };
    """
    # Class attributes
    _strfmt1  = "{1} {0}"
    _attrlist = ("attributes", "linkdata")

    def __init__(self, unpack):
        self.attributes = sattr3(unpack)
        self.linkdata   = nfspath3(unpack)

class SYMLINK3args(BaseObj):
    """
       struct SYMLINK3args {
           diropargs3   where;
           symlinkdata3 symlink;
       };
    """
    # Class attributes
    _fattrs   = ("where",)
    _strfmt1  = "{0} -> {1}"
    _attrlist = ("where", "symlink")

    def __init__(self, unpack):
        self.where   = diropargs3(unpack)
        self.symlink = symlinkdata3(unpack)

class SYMLINK3resok(BaseObj):
    """
       struct SYMLINK3resok {
           post_op_fh3  obj;
           post_op_attr attributes;
           wcc_data     wcc;
       };
    """
    # Class attributes
    _fattrs   = ("obj",)
    _strfmt1  = "{0}"
    _attrlist = ("obj", "attributes", "wcc")

    def __init__(self, unpack):
        self.obj        = post_op_fh3(unpack)
        self.attributes = post_op_attr(unpack)
        self.wcc        = wcc_data(unpack)

class SYMLINK3resfail(BaseObj):
    """
       struct SYMLINK3resfail {
           wcc_data dir_wcc;
       };
    """
    # Class attributes
    _attrlist = ("dir_wcc",)

    def __init__(self, unpack):
        self.dir_wcc = wcc_data(unpack)

class SYMLINK3res(BaseObj):
    """
       union switch SYMLINK3res (nfsstat3 status) {
           case const.NFS3_OK:
               SYMLINK3resok resok;
           default:
               SYMLINK3resfail resfail;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("status", nfsstat3(unpack))
        if self.status == const.NFS3_OK:
            self.set_attr("resok", SYMLINK3resok(unpack), switch=True)
        else:
            self.set_attr("resfail", SYMLINK3resfail(unpack), switch=True)
            self.set_strfmt(1, "")

# MKNOD3res NFSPROC3_MKNOD(MKNOD3args) = 11;
class devicedata3(BaseObj):
    """
       struct devicedata3 {
           sattr3    attributes;
           specdata3 spec;
       };
    """
    # Class attributes
    _strfmt1  = "{0} {1}"
    _attrlist = ("attributes", "spec")

    def __init__(self, unpack):
        self.attributes = sattr3(unpack)
        self.spec       = specdata3(unpack)

class mknoddata3(BaseObj):
    """
       union switch mknoddata3 (ftype3 type) {
           case const.NF3CHR:
           case const.NF3BLK:
               devicedata3 device;
           case const.NF3SOCK:
           case const.NF3FIFO:
               sattr3 attributes;
           default:
               void;
       };
    """
    # Class attributes
    _strfmt1 = ""

    def __init__(self, unpack):
        self.set_attr("type", ftype3(unpack))
        if self.type in [const.NF3CHR, const.NF3BLK]:
            self.set_attr("device", devicedata3(unpack), switch=True)
            self.set_strfmt(1, "{1}")
        elif self.type in [const.NF3SOCK, const.NF3FIFO]:
            self.set_attr("attributes", sattr3(unpack), switch=True)

class MKNOD3args(BaseObj):
    """
       struct MKNOD3args {
           diropargs3 where;
           mknoddata3 what;
       };
    """
    # Class attributes
    _fattrs   = ("where",)
    _strfmt1  = "{1.type} {0} {1}"
    _attrlist = ("where", "what")

    def __init__(self, unpack):
        self.where = diropargs3(unpack)
        self.what  = mknoddata3(unpack)

class MKNOD3resok(BaseObj):
    """
       struct MKNOD3resok {
           post_op_fh3  obj;
           post_op_attr attributes;
           wcc_data     wcc;
       };
    """
    # Class attributes
    _fattrs   = ("obj",)
    _strfmt1  = "{0}"
    _attrlist = ("obj", "attributes", "wcc")

    def __init__(self, unpack):
        self.obj        = post_op_fh3(unpack)
        self.attributes = post_op_attr(unpack)
        self.wcc        = wcc_data(unpack)

class MKNOD3resfail(BaseObj):
    """
       struct MKNOD3resfail {
           wcc_data wcc;
       };
    """
    # Class attributes
    _attrlist = ("wcc",)

    def __init__(self, unpack):
        self.wcc = wcc_data(unpack)

class MKNOD3res(BaseObj):
    """
       union switch MKNOD3res (nfsstat3 status) {
           case const.NFS3_OK:
               MKNOD3resok resok;
           default:
               MKNOD3resfail resfail;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("status", nfsstat3(unpack))
        if self.status == const.NFS3_OK:
            self.set_attr("resok", MKNOD3resok(unpack), switch=True)
        else:
            self.set_attr("resfail", MKNOD3resfail(unpack), switch=True)
            self.set_strfmt(1, "")

# REMOVE3res NFSPROC3_REMOVE(REMOVE3args) = 12;
class REMOVE3args(BaseObj):
    """
       struct REMOVE3args {
           diropargs3 object;
       };
    """
    # Class attributes
    _fattrs   = ("object",)
    _strfmt1  = "{0}"
    _attrlist = ("object",)

    def __init__(self, unpack):
        self.object = diropargs3(unpack)

class REMOVE3resok(BaseObj):
    """
       struct REMOVE3resok {
           wcc_data wcc;
       };
    """
    # Class attributes
    _attrlist = ("wcc",)

    def __init__(self, unpack):
        self.wcc = wcc_data(unpack)

class REMOVE3resfail(BaseObj):
    """
       struct REMOVE3resfail {
           wcc_data wcc;
       };
    """
    # Class attributes
    _attrlist = ("wcc",)

    def __init__(self, unpack):
        self.wcc = wcc_data(unpack)

class REMOVE3res(BaseObj):
    """
       union switch REMOVE3res (nfsstat3 status) {
           case const.NFS3_OK:
               REMOVE3resok resok;
           default:
               REMOVE3resfail resfail;
       };
    """
    # Class attributes
    _strfmt1 = ""

    def __init__(self, unpack):
        self.set_attr("status", nfsstat3(unpack))
        if self.status == const.NFS3_OK:
            self.set_attr("resok", REMOVE3resok(unpack), switch=True)
        else:
            self.set_attr("resfail", REMOVE3resfail(unpack), switch=True)

# RMDIR3res NFSPROC3_RMDIR(RMDIR3args) = 13;
class RMDIR3args(BaseObj):
    """
       struct RMDIR3args {
           diropargs3 object;
       };
    """
    # Class attributes
    _fattrs   = ("object",)
    _strfmt1  = "{0}"
    _attrlist = ("object",)

    def __init__(self, unpack):
        self.object = diropargs3(unpack)

class RMDIR3resok(BaseObj):
    """
       struct RMDIR3resok {
           wcc_data wcc;
       };
    """
    # Class attributes
    _attrlist = ("wcc",)

    def __init__(self, unpack):
        self.wcc = wcc_data(unpack)

class RMDIR3resfail(BaseObj):
    """
       struct RMDIR3resfail {
           wcc_data wcc;
       };
    """
    # Class attributes
    _attrlist = ("wcc",)

    def __init__(self, unpack):
        self.wcc = wcc_data(unpack)

class RMDIR3res(BaseObj):
    """
       union switch RMDIR3res (nfsstat3 status) {
           case const.NFS3_OK:
               RMDIR3resok resok;
           default:
               RMDIR3resfail resfail;
       };
    """
    # Class attributes
    _strfmt1 = ""

    def __init__(self, unpack):
        self.set_attr("status", nfsstat3(unpack))
        if self.status == const.NFS3_OK:
            self.set_attr("resok", RMDIR3resok(unpack), switch=True)
        else:
            self.set_attr("resfail", RMDIR3resfail(unpack), switch=True)

# RENAME3res NFSPROC3_RENAME(RENAME3args) = 14;
class RENAME3args(BaseObj):
    """
       struct RENAME3args {
           diropargs3 nfrom;
           diropargs3 nto;
       };
    """
    # Class attributes
    _fattrs   = ("nfrom",)
    _strfmt1  = "{0} -> {1}"
    _attrlist = ("nfrom", "nto")

    def __init__(self, unpack):
        self.nfrom   = diropargs3(unpack)
        self.nto     = diropargs3(unpack)
        self.newname = self.nto.name

class RENAME3resok(BaseObj):
    """
       struct RENAME3resok {
           wcc_data fromdir_wcc;
           wcc_data todir_wcc;
       };
    """
    # Class attributes
    _attrlist = ("fromdir_wcc", "todir_wcc")

    def __init__(self, unpack):
        self.fromdir_wcc = wcc_data(unpack)
        self.todir_wcc   = wcc_data(unpack)

class RENAME3resfail(BaseObj):
    """
       struct RENAME3resfail {
           wcc_data fromdir_wcc;
           wcc_data todir_wcc;
       };
    """
    # Class attributes
    _attrlist = ("fromdir_wcc", "todir_wcc")

    def __init__(self, unpack):
        self.fromdir_wcc = wcc_data(unpack)
        self.todir_wcc   = wcc_data(unpack)

class RENAME3res(BaseObj):
    """
       union switch RENAME3res (nfsstat3 status) {
           case const.NFS3_OK:
               RENAME3resok resok;
           default:
               RENAME3resfail resfail;
       };
    """
    # Class attributes
    _strfmt1 = ""

    def __init__(self, unpack):
        self.set_attr("status", nfsstat3(unpack))
        if self.status == const.NFS3_OK:
            self.set_attr("resok", RENAME3resok(unpack), switch=True)
        else:
            self.set_attr("resfail", RENAME3resfail(unpack), switch=True)

# LINK3res NFSPROC3_LINK(LINK3args) = 15;
class LINK3args(BaseObj):
    """
       struct LINK3args {
           nfs_fh3    fh;
           diropargs3 link;
       };
    """
    # Class attributes
    _fattrs   = ("link",)
    _strfmt1  = "{1} -> FH:{0:crc32}"
    _attrlist = ("fh", "link")

    def __init__(self, unpack):
        self.fh   = nfs_fh3(unpack)
        self.link = diropargs3(unpack)

class LINK3resok(BaseObj):
    """
       struct LINK3resok {
           post_op_attr attributes;
           wcc_data     wcc;
       };
    """
    # Class attributes
    _attrlist = ("attributes", "wcc")

    def __init__(self, unpack):
        self.attributes = post_op_attr(unpack)
        self.wcc        = wcc_data(unpack)

class LINK3resfail(BaseObj):
    """
       struct LINK3resfail {
           post_op_attr attributes;
           wcc_data     wcc;
       };
    """
    # Class attributes
    _attrlist = ("attributes", "wcc")

    def __init__(self, unpack):
        self.attributes = post_op_attr(unpack)
        self.wcc        = wcc_data(unpack)

class LINK3res(BaseObj):
    """
       union switch LINK3res (nfsstat3 status) {
           case const.NFS3_OK:
               LINK3resok resok;
           default:
               LINK3resfail resfail;
       };
    """
    # Class attributes
    _strfmt1 = ""

    def __init__(self, unpack):
        self.set_attr("status", nfsstat3(unpack))
        if self.status == const.NFS3_OK:
            self.set_attr("resok", LINK3resok(unpack), switch=True)
        else:
            self.set_attr("resfail", LINK3resfail(unpack), switch=True)

# READDIR3res NFSPROC3_READDIR(READDIR3args) = 16;
class READDIR3args(BaseObj):
    """
       struct READDIR3args {
           nfs_fh3     fh;
           cookie3     cookie;
           cookieverf3 verifier;
           count3      count;
       };
    """
    # Class attributes
    _strfmt1  = "DH:{0:crc32} cookie:{1} verf:{2} count:{3:umax32}"
    _attrlist = ("fh", "cookie", "verifier", "count")

    def __init__(self, unpack):
        self.fh       = nfs_fh3(unpack)
        self.cookie   = cookie3(unpack)
        self.verifier = cookieverf3(unpack)
        self.count    = count3(unpack)

class entry3(BaseObj):
    """
       struct entry3 {
           fileid3   fileid;
           filename3 name;
           cookie3   cookie;
           entry3    *nextentry;
       };
    """
    # Class attributes
    _attrlist = ("fileid", "name", "cookie")

    def __init__(self, unpack):
        self.fileid = fileid3(unpack)
        self.name   = filename3(unpack)
        self.cookie = cookie3(unpack)

class dirlist3(BaseObj):
    """
       struct dirlist3 {
           entry3 *entries;
           bool   eof;
       };
    """
    # Class attributes
    _strfmt1  = "eof:{1}"
    _attrlist = ("entries", "eof")

    def __init__(self, unpack):
        try:
            self.entries = unpack.unpack_list(entry3)
            self.eof     = nfs_bool(unpack)
        except:
            pass

class READDIR3resok(BaseObj):
    """
       struct READDIR3resok {
           post_op_attr attributes;
           cookieverf3  verifier;
           dirlist3     reply;
       };
    """
    # Class attributes
    _fattrs   = ("reply",)
    _strfmt1  = "verf:{1} {2}"
    _attrlist = ("attributes", "verifier", "reply")

    def __init__(self, unpack):
        self.attributes = post_op_attr(unpack)
        self.verifier   = cookieverf3(unpack)
        self.reply      = dirlist3(unpack)

class READDIR3resfail(BaseObj):
    """
       struct READDIR3resfail {
           post_op_attr attributes;
       };
    """
    # Class attributes
    _attrlist = ("attributes",)

    def __init__(self, unpack):
        self.attributes = post_op_attr(unpack)

class READDIR3res(BaseObj):
    """
       union switch READDIR3res (nfsstat3 status) {
           case const.NFS3_OK:
               READDIR3resok resok;
           default:
               READDIR3resfail resfail;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("status", nfsstat3(unpack))
        if self.status == const.NFS3_OK:
            self.set_attr("resok", READDIR3resok(unpack), switch=True)
        else:
            self.set_attr("resfail", READDIR3resfail(unpack), switch=True)
            self.set_strfmt(1, "")

# READDIRPLUS3res NFSPROC3_READDIRPLUS(READDIRPLUS3args) = 17;
class READDIRPLUS3args(BaseObj):
    """
       struct READDIRPLUS3args {
           nfs_fh3     fh;
           cookie3     cookie;
           cookieverf3 verifier;
           count3      dircount;
           count3      maxcount;
       };
    """
    # Class attributes
    _strfmt1  = "DH:{0:crc32} cookie:{1} verf:{2} count:{3:umax32}"
    _attrlist = ("fh", "cookie", "verifier", "dircount", "maxcount")

    def __init__(self, unpack):
        self.fh       = nfs_fh3(unpack)
        self.cookie   = cookie3(unpack)
        self.verifier = cookieverf3(unpack)
        self.dircount = count3(unpack)
        self.maxcount = count3(unpack)

class entryplus3(BaseObj):
    """
       struct entryplus3 {
           fileid3      fileid;
           filename3    name;
           cookie3      cookie;
           post_op_attr attributes;
           post_op_fh3  obj;
           entryplus3   *nextentry;
       };
    """
    # Class attributes
    _fattrs   = ("obj",)
    _attrlist = ("fileid", "name", "cookie", "attributes", "obj")

    def __init__(self, unpack):
        self.fileid     = fileid3(unpack)
        self.name       = filename3(unpack)
        self.cookie     = cookie3(unpack)
        self.attributes = post_op_attr(unpack)
        self.obj        = post_op_fh3(unpack)

class dirlistplus3(BaseObj):
    """
       struct dirlistplus3 {
           entryplus3 *entries;
           bool       eof;
       };
    """
    # Class attributes
    _strfmt1  = "eof:{1}"
    _attrlist = ("entries", "eof")

    def __init__(self, unpack):
        try:
            self.entries = unpack.unpack_list(entryplus3)
            self.eof     = nfs_bool(unpack)
        except:
            pass

class READDIRPLUS3resok(BaseObj):
    """
       struct READDIRPLUS3resok {
           post_op_attr attributes;
           cookieverf3  verifier;
           dirlistplus3 reply;
       };
    """
    # Class attributes
    _fattrs   = ("reply",)
    _strfmt1  = "verf:{1} {2}"
    _attrlist = ("attributes", "verifier", "reply")

    def __init__(self, unpack):
        self.attributes = post_op_attr(unpack)
        self.verifier   = cookieverf3(unpack)
        self.reply      = dirlistplus3(unpack)

class READDIRPLUS3resfail(BaseObj):
    """
       struct READDIRPLUS3resfail {
           post_op_attr attributes;
       };
    """
    # Class attributes
    _attrlist = ("attributes",)

    def __init__(self, unpack):
        self.attributes = post_op_attr(unpack)

class READDIRPLUS3res(BaseObj):
    """
       union switch READDIRPLUS3res (nfsstat3 status) {
           case const.NFS3_OK:
               READDIRPLUS3resok resok;
           default:
               READDIRPLUS3resfail resfail;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("status", nfsstat3(unpack))
        if self.status == const.NFS3_OK:
            self.set_attr("resok", READDIRPLUS3resok(unpack), switch=True)
        else:
            self.set_attr("resfail", READDIRPLUS3resfail(unpack), switch=True)
            self.set_strfmt(1, "")

# FSSTAT3res NFSPROC3_FSSTAT(FSSTAT3args) = 18;
class FSSTAT3args(BaseObj):
    """
       struct FSSTAT3args {
           nfs_fh3 fh;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{0:crc32}"
    _attrlist = ("fh",)

    def __init__(self, unpack):
        self.fh = nfs_fh3(unpack)

class FSSTAT3resok(BaseObj):
    """
       struct FSSTAT3resok {
           post_op_attr attributes;
           size3        tbytes;
           size3        fbytes;
           size3        abytes;
           size3        tfiles;
           size3        ffiles;
           size3        afiles;
           uint32       invarsec;
       };
    """
    # Class attributes
    _attrlist = ("attributes", "tbytes", "fbytes", "abytes", "tfiles", "ffiles",
                 "afiles", "invarsec")

    def __init__(self, unpack):
        self.attributes = post_op_attr(unpack)
        self.tbytes     = size3(unpack)
        self.fbytes     = size3(unpack)
        self.abytes     = size3(unpack)
        self.tfiles     = size3(unpack)
        self.ffiles     = size3(unpack)
        self.afiles     = size3(unpack)
        self.invarsec   = uint32(unpack)

class FSSTAT3resfail(BaseObj):
    """
       struct FSSTAT3resfail {
           post_op_attr attributes;
       };
    """
    # Class attributes
    _attrlist = ("attributes",)

    def __init__(self, unpack):
        self.attributes = post_op_attr(unpack)

class FSSTAT3res(BaseObj):
    """
       union switch FSSTAT3res (nfsstat3 status) {
           case const.NFS3_OK:
               FSSTAT3resok resok;
           default:
               FSSTAT3resfail resfail;
       };
    """
    # Class attributes
    _strfmt1 = ""

    def __init__(self, unpack):
        self.set_attr("status", nfsstat3(unpack))
        if self.status == const.NFS3_OK:
            self.set_attr("resok", FSSTAT3resok(unpack), switch=True)
        else:
            self.set_attr("resfail", FSSTAT3resfail(unpack), switch=True)

class FSINFO3args(BaseObj):
    """
       struct FSINFO3args {
           nfs_fh3 fh;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{0:crc32}"
    _attrlist = ("fh",)

    def __init__(self, unpack):
        self.fh = nfs_fh3(unpack)

class FSINFO3resok(BaseObj):
    """
       struct FSINFO3resok {
           post_op_attr attributes;
           uint32       rtmax;
           uint32       rtpref;
           uint32       rtmult;
           uint32       wtmax;
           uint32       wtpref;
           uint32       wtmult;
           uint32       dtpref;
           size3        maxfilesize;
           nfstime3     time_delta;
           uint32       properties;
       };
    """
    # Class attributes
    _attrlist = ("attributes", "rtmax", "rtpref", "rtmult", "wtmax", "wtpref",
                 "wtmult", "dtpref", "maxfilesize", "time_delta", "properties")

    def __init__(self, unpack):
        self.attributes  = post_op_attr(unpack)
        self.rtmax       = uint32(unpack)
        self.rtpref      = uint32(unpack)
        self.rtmult      = uint32(unpack)
        self.wtmax       = uint32(unpack)
        self.wtpref      = uint32(unpack)
        self.wtmult      = uint32(unpack)
        self.dtpref      = uint32(unpack)
        self.maxfilesize = size3(unpack)
        self.time_delta  = nfstime3(unpack)
        self.properties  = uint32(unpack)

class FSINFO3resfail(BaseObj):
    """
       struct FSINFO3resfail {
           post_op_attr attributes;
       };
    """
    # Class attributes
    _attrlist = ("attributes",)

    def __init__(self, unpack):
        self.attributes = post_op_attr(unpack)

class FSINFO3res(BaseObj):
    """
       union switch FSINFO3res (nfsstat3 status) {
           case const.NFS3_OK:
               FSINFO3resok resok;
           default:
               FSINFO3resfail resfail;
       };
    """
    # Class attributes
    _strfmt1 = ""

    def __init__(self, unpack):
        self.set_attr("status", nfsstat3(unpack))
        if self.status == const.NFS3_OK:
            self.set_attr("resok", FSINFO3resok(unpack), switch=True)
        else:
            self.set_attr("resfail", FSINFO3resfail(unpack), switch=True)

# PATHCONF3res NFSPROC3_PATHCONF(PATHCONF3args) = 20;
class PATHCONF3args(BaseObj):
    """
       struct PATHCONF3args {
           nfs_fh3 fh;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{0:crc32}"
    _attrlist = ("fh",)

    def __init__(self, unpack):
        self.fh = nfs_fh3(unpack)

class PATHCONF3resok(BaseObj):
    """
       struct PATHCONF3resok {
           post_op_attr attributes;
           uint32       linkmax;
           uint32       name_max;
           bool         no_trunc;
           bool         chown_restricted;
           bool         case_insensitive;
           bool         case_preserving;
       };
    """
    # Class attributes
    _attrlist = ("attributes", "linkmax", "name_max", "no_trunc",
                 "chown_restricted", "case_insensitive", "case_preserving")

    def __init__(self, unpack):
        self.attributes       = post_op_attr(unpack)
        self.linkmax          = uint32(unpack)
        self.name_max         = uint32(unpack)
        self.no_trunc         = nfs_bool(unpack)
        self.chown_restricted = nfs_bool(unpack)
        self.case_insensitive = nfs_bool(unpack)
        self.case_preserving  = nfs_bool(unpack)

class PATHCONF3resfail(BaseObj):
    """
       struct PATHCONF3resfail {
           post_op_attr attributes;
       };
    """
    # Class attributes
    _attrlist = ("attributes",)

    def __init__(self, unpack):
        self.attributes = post_op_attr(unpack)

class PATHCONF3res(BaseObj):
    """
       union switch PATHCONF3res (nfsstat3 status) {
           case const.NFS3_OK:
               PATHCONF3resok resok;
           default:
               PATHCONF3resfail resfail;
       };
    """
    # Class attributes
    _strfmt1 = ""

    def __init__(self, unpack):
        self.set_attr("status", nfsstat3(unpack))
        if self.status == const.NFS3_OK:
            self.set_attr("resok", PATHCONF3resok(unpack), switch=True)
        else:
            self.set_attr("resfail", PATHCONF3resfail(unpack), switch=True)

# COMMIT3res NFSPROC3_COMMIT(COMMIT3args) = 21;
class COMMIT3args(BaseObj):
    """
       struct COMMIT3args {
           nfs_fh3 fh;
           offset3 offset;
           count3  count;
       };
    """
    # Class attributes
    _strfmt1  = "FH:{0:crc32} off:{1:umax64} len:{2:umax32}"
    _attrlist = ("fh", "offset", "count")

    def __init__(self, unpack):
        self.fh     = nfs_fh3(unpack)
        self.offset = offset3(unpack)
        self.count  = count3(unpack)

class COMMIT3resok(BaseObj):
    """
       struct COMMIT3resok {
           wcc_data   wcc;
           writeverf3 verifier;
       };
    """
    # Class attributes
    _strfmt1  = "verf:{1}"
    _attrlist = ("wcc", "verifier")

    def __init__(self, unpack):
        self.wcc      = wcc_data(unpack)
        self.verifier = writeverf3(unpack)

class COMMIT3resfail(BaseObj):
    """
       struct COMMIT3resfail {
           wcc_data wcc;
       };
    """
    # Class attributes
    _attrlist = ("wcc",)

    def __init__(self, unpack):
        self.wcc = wcc_data(unpack)

class COMMIT3res(BaseObj):
    """
       union switch COMMIT3res (nfsstat3 status) {
           case const.NFS3_OK:
               COMMIT3resok resok;
           default:
               COMMIT3resfail resfail;
       };
    """
    # Class attributes
    _strfmt1 = "{1}"

    def __init__(self, unpack):
        self.set_attr("status", nfsstat3(unpack))
        if self.status == const.NFS3_OK:
            self.set_attr("resok", COMMIT3resok(unpack), switch=True)
        else:
            self.set_attr("resfail", COMMIT3resfail(unpack), switch=True)
            self.set_strfmt(1, "")

# Procedures
class nfs_proc3(Enum):
    """enum nfs_proc3"""
    _enumdict = const.nfs_proc3

class NFS3args(RPCload):
    """
       union switch NFS3args (nfs_proc3 procedure) {
           case const.NFSPROC3_NULL:
               void;
           case const.NFSPROC3_GETATTR:
               GETATTR3args opgetattr;
           case const.NFSPROC3_SETATTR:
               SETATTR3args opsetattr;
           case const.NFSPROC3_LOOKUP:
               LOOKUP3args oplookup;
           case const.NFSPROC3_ACCESS:
               ACCESS3args opaccess;
           case const.NFSPROC3_READLINK:
               READLINK3args opreadlink;
           case const.NFSPROC3_READ:
               READ3args opread;
           case const.NFSPROC3_WRITE:
               WRITE3args opwrite;
           case const.NFSPROC3_CREATE:
               CREATE3args opcreate;
           case const.NFSPROC3_MKDIR:
               MKDIR3args opmkdir;
           case const.NFSPROC3_SYMLINK:
               SYMLINK3args opsymlink;
           case const.NFSPROC3_MKNOD:
               MKNOD3args opmknod;
           case const.NFSPROC3_REMOVE:
               REMOVE3args opremove;
           case const.NFSPROC3_RMDIR:
               RMDIR3args oprmdir;
           case const.NFSPROC3_RENAME:
               RENAME3args oprename;
           case const.NFSPROC3_LINK:
               LINK3args oplink;
           case const.NFSPROC3_READDIR:
               READDIR3args opreaddir;
           case const.NFSPROC3_READDIRPLUS:
               READDIRPLUS3args opreaddirplus;
           case const.NFSPROC3_FSSTAT:
               FSSTAT3args opfsstat;
           case const.NFSPROC3_FSINFO:
               FSINFO3args opfsinfo;
           case const.NFSPROC3_PATHCONF:
               PATHCONF3args oppathconf;
           case const.NFSPROC3_COMMIT:
               COMMIT3args opcommit;
       };
    """
    # Class attributes
    _pindex  = 9
    _strname = "NFS"

    def __init__(self, unpack, procedure):
        self.set_attr("procedure", nfs_proc3(procedure))
        if self.procedure == const.NFSPROC3_GETATTR:
            self.set_attr("opgetattr", GETATTR3args(unpack), switch=True)
        elif self.procedure == const.NFSPROC3_SETATTR:
            self.set_attr("opsetattr", SETATTR3args(unpack), switch=True)
        elif self.procedure == const.NFSPROC3_LOOKUP:
            self.set_attr("oplookup", LOOKUP3args(unpack), switch=True)
        elif self.procedure == const.NFSPROC3_ACCESS:
            self.set_attr("opaccess", ACCESS3args(unpack), switch=True)
        elif self.procedure == const.NFSPROC3_READLINK:
            self.set_attr("opreadlink", READLINK3args(unpack), switch=True)
        elif self.procedure == const.NFSPROC3_READ:
            self.set_attr("opread", READ3args(unpack), switch=True)
        elif self.procedure == const.NFSPROC3_WRITE:
            self.set_attr("opwrite", WRITE3args(unpack), switch=True)
        elif self.procedure == const.NFSPROC3_CREATE:
            self.set_attr("opcreate", CREATE3args(unpack), switch=True)
        elif self.procedure == const.NFSPROC3_MKDIR:
            self.set_attr("opmkdir", MKDIR3args(unpack), switch=True)
        elif self.procedure == const.NFSPROC3_SYMLINK:
            self.set_attr("opsymlink", SYMLINK3args(unpack), switch=True)
        elif self.procedure == const.NFSPROC3_MKNOD:
            self.set_attr("opmknod", MKNOD3args(unpack), switch=True)
        elif self.procedure == const.NFSPROC3_REMOVE:
            self.set_attr("opremove", REMOVE3args(unpack), switch=True)
        elif self.procedure == const.NFSPROC3_RMDIR:
            self.set_attr("oprmdir", RMDIR3args(unpack), switch=True)
        elif self.procedure == const.NFSPROC3_RENAME:
            self.set_attr("oprename", RENAME3args(unpack), switch=True)
        elif self.procedure == const.NFSPROC3_LINK:
            self.set_attr("oplink", LINK3args(unpack), switch=True)
        elif self.procedure == const.NFSPROC3_READDIR:
            self.set_attr("opreaddir", READDIR3args(unpack), switch=True)
        elif self.procedure == const.NFSPROC3_READDIRPLUS:
            self.set_attr("opreaddirplus", READDIRPLUS3args(unpack), switch=True)
        elif self.procedure == const.NFSPROC3_FSSTAT:
            self.set_attr("opfsstat", FSSTAT3args(unpack), switch=True)
        elif self.procedure == const.NFSPROC3_FSINFO:
            self.set_attr("opfsinfo", FSINFO3args(unpack), switch=True)
        elif self.procedure == const.NFSPROC3_PATHCONF:
            self.set_attr("oppathconf", PATHCONF3args(unpack), switch=True)
        elif self.procedure == const.NFSPROC3_COMMIT:
            self.set_attr("opcommit", COMMIT3args(unpack), switch=True)
        self.argop = self.procedure
        self.op    = self.procedure

class NFS3res(RPCload):
    """
       union switch NFS3res (nfs_proc3 procedure) {
           case const.NFSPROC3_NULL:
               void;
           case const.NFSPROC3_GETATTR:
               GETATTR3res opgetattr;
           case const.NFSPROC3_SETATTR:
               SETATTR3res opsetattr;
           case const.NFSPROC3_LOOKUP:
               LOOKUP3res oplookup;
           case const.NFSPROC3_ACCESS:
               ACCESS3res opaccess;
           case const.NFSPROC3_READLINK:
               READLINK3res opreadlink;
           case const.NFSPROC3_READ:
               READ3res opread;
           case const.NFSPROC3_WRITE:
               WRITE3res opwrite;
           case const.NFSPROC3_CREATE:
               CREATE3res opcreate;
           case const.NFSPROC3_MKDIR:
               MKDIR3res opmkdir;
           case const.NFSPROC3_SYMLINK:
               SYMLINK3res opsymlink;
           case const.NFSPROC3_MKNOD:
               MKNOD3res opmknod;
           case const.NFSPROC3_REMOVE:
               REMOVE3res opremove;
           case const.NFSPROC3_RMDIR:
               RMDIR3res oprmdir;
           case const.NFSPROC3_RENAME:
               RENAME3res oprename;
           case const.NFSPROC3_LINK:
               LINK3res oplink;
           case const.NFSPROC3_READDIR:
               READDIR3res opreaddir;
           case const.NFSPROC3_READDIRPLUS:
               READDIRPLUS3res opreaddirplus;
           case const.NFSPROC3_FSSTAT:
               FSSTAT3res opfsstat;
           case const.NFSPROC3_FSINFO:
               FSINFO3res opfsinfo;
           case const.NFSPROC3_PATHCONF:
               PATHCONF3res oppathconf;
           case const.NFSPROC3_COMMIT:
               COMMIT3res opcommit;
       };
    """
    # Class attributes
    _pindex  = 9
    _strname = "NFS"

    def __init__(self, unpack, procedure):
        self.set_attr("procedure", nfs_proc3(procedure))
        if self.procedure == const.NFSPROC3_GETATTR:
            self.set_attr("opgetattr", GETATTR3res(unpack), switch=True)
        elif self.procedure == const.NFSPROC3_SETATTR:
            self.set_attr("opsetattr", SETATTR3res(unpack), switch=True)
        elif self.procedure == const.NFSPROC3_LOOKUP:
            self.set_attr("oplookup", LOOKUP3res(unpack), switch=True)
        elif self.procedure == const.NFSPROC3_ACCESS:
            self.set_attr("opaccess", ACCESS3res(unpack), switch=True)
        elif self.procedure == const.NFSPROC3_READLINK:
            self.set_attr("opreadlink", READLINK3res(unpack), switch=True)
        elif self.procedure == const.NFSPROC3_READ:
            self.set_attr("opread", READ3res(unpack), switch=True)
        elif self.procedure == const.NFSPROC3_WRITE:
            self.set_attr("opwrite", WRITE3res(unpack), switch=True)
        elif self.procedure == const.NFSPROC3_CREATE:
            self.set_attr("opcreate", CREATE3res(unpack), switch=True)
        elif self.procedure == const.NFSPROC3_MKDIR:
            self.set_attr("opmkdir", MKDIR3res(unpack), switch=True)
        elif self.procedure == const.NFSPROC3_SYMLINK:
            self.set_attr("opsymlink", SYMLINK3res(unpack), switch=True)
        elif self.procedure == const.NFSPROC3_MKNOD:
            self.set_attr("opmknod", MKNOD3res(unpack), switch=True)
        elif self.procedure == const.NFSPROC3_REMOVE:
            self.set_attr("opremove", REMOVE3res(unpack), switch=True)
        elif self.procedure == const.NFSPROC3_RMDIR:
            self.set_attr("oprmdir", RMDIR3res(unpack), switch=True)
        elif self.procedure == const.NFSPROC3_RENAME:
            self.set_attr("oprename", RENAME3res(unpack), switch=True)
        elif self.procedure == const.NFSPROC3_LINK:
            self.set_attr("oplink", LINK3res(unpack), switch=True)
        elif self.procedure == const.NFSPROC3_READDIR:
            self.set_attr("opreaddir", READDIR3res(unpack), switch=True)
        elif self.procedure == const.NFSPROC3_READDIRPLUS:
            self.set_attr("opreaddirplus", READDIRPLUS3res(unpack), switch=True)
        elif self.procedure == const.NFSPROC3_FSSTAT:
            self.set_attr("opfsstat", FSSTAT3res(unpack), switch=True)
        elif self.procedure == const.NFSPROC3_FSINFO:
            self.set_attr("opfsinfo", FSINFO3res(unpack), switch=True)
        elif self.procedure == const.NFSPROC3_PATHCONF:
            self.set_attr("oppathconf", PATHCONF3res(unpack), switch=True)
        elif self.procedure == const.NFSPROC3_COMMIT:
            self.set_attr("opcommit", COMMIT3res(unpack), switch=True)
        self.resop = self.procedure
        self.op    = self.procedure
