/*
 *  Author: bwilliams
 *  Created: April 6, 2012
 *
 *  Copyright (C) 2012-2016 VMware, Inc.  All rights reserved. -- VMware Confidential
 *
 *  This code was generated by the script "build/dev/codeGen/genCppXml". Please
 *  speak to Brian W. before modifying it by hand.
 *
 */

#include "stdafx.h"

#include "Doc/CafCoreTypesDoc/CProtocolCollectionDoc.h"
#include "Doc/CafCoreTypesDoc/CProtocolDoc.h"
#include "Xml/XmlUtils/CXmlElement.h"
#include "Doc/DocXml/CafCoreTypesXml/ProtocolCollectionXml.h"
#include "Doc/DocXml/CafCoreTypesXml/ProtocolXml.h"

using namespace Caf;

void ProtocolCollectionXml::add(
	const SmartPtrCProtocolCollectionDoc protocolCollectionDoc,
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("ProtocolCollectionXml", "add");

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(protocolCollectionDoc);
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const std::deque<SmartPtrCProtocolDoc> protocolVal =
			protocolCollectionDoc->getProtocol();
		CAF_CM_VALIDATE_STL(protocolVal);

		if (! protocolVal.empty()) {
			for (TConstIterator<std::deque<SmartPtrCProtocolDoc> > protocolIter(protocolVal);
				protocolIter; protocolIter++) {
				const SmartPtrCXmlElement protocolXml =
					thisXml->createAndAddElement("protocol");
				ProtocolXml::add(*protocolIter, protocolXml);
			}
		}
	}
	CAF_CM_EXIT;
}

SmartPtrCProtocolCollectionDoc ProtocolCollectionXml::parse(
	const SmartPtrCXmlElement thisXml) {
	CAF_CM_STATIC_FUNC_VALIDATE("ProtocolCollectionXml", "parse");

	SmartPtrCProtocolCollectionDoc protocolCollectionDoc;

	CAF_CM_ENTER {
		CAF_CM_VALIDATE_SMARTPTR(thisXml);

		const CXmlElement::SmartPtrCElementCollection protocolChildrenXml =
			thisXml->findRequiredChildren("protocol");

		std::deque<SmartPtrCProtocolDoc> protocolVal;
		if (! protocolChildrenXml.IsNull() && ! protocolChildrenXml->empty()) {
			for (TConstIterator<CXmlElement::CElementCollection> protocolXmlIter(*protocolChildrenXml);
				protocolXmlIter; protocolXmlIter++) {
				const SmartPtrCXmlElement protocolXml = protocolXmlIter->second;
				const SmartPtrCProtocolDoc protocolDoc =
					ProtocolXml::parse(protocolXml);
				protocolVal.push_back(protocolDoc);
			}
		}

		protocolCollectionDoc.CreateInstance();
		protocolCollectionDoc->initialize(
			protocolVal);
	}
	CAF_CM_EXIT;

	return protocolCollectionDoc;
}

