// Package v2 provides primitives to interact with the openapi HTTP API.
//
// Code generated by github.com/deepmap/oapi-codegen version v1.8.2 DO NOT EDIT.
package v2

import (
	"bytes"
	"compress/gzip"
	"encoding/base64"
	"fmt"
	"net/http"
	"net/url"
	"path"
	"strings"

	"github.com/deepmap/oapi-codegen/pkg/runtime"
	"github.com/getkin/kin-openapi/openapi3"
	"github.com/labstack/echo/v4"
)

const (
	BearerScopes = "Bearer.Scopes"
)

// Defines values for ComposeStatusValue.
const (
	ComposeStatusValueFailure ComposeStatusValue = "failure"

	ComposeStatusValuePending ComposeStatusValue = "pending"

	ComposeStatusValueSuccess ComposeStatusValue = "success"
)

// Defines values for ImageStatusValue.
const (
	ImageStatusValueBuilding ImageStatusValue = "building"

	ImageStatusValueFailure ImageStatusValue = "failure"

	ImageStatusValuePending ImageStatusValue = "pending"

	ImageStatusValueRegistering ImageStatusValue = "registering"

	ImageStatusValueSuccess ImageStatusValue = "success"

	ImageStatusValueUploading ImageStatusValue = "uploading"
)

// Defines values for ImageTypes.
const (
	ImageTypesAws ImageTypes = "aws"

	ImageTypesAwsHaRhui ImageTypes = "aws-ha-rhui"

	ImageTypesAwsRhui ImageTypes = "aws-rhui"

	ImageTypesAwsSapRhui ImageTypes = "aws-sap-rhui"

	ImageTypesAzure ImageTypes = "azure"

	ImageTypesAzureRhui ImageTypes = "azure-rhui"

	ImageTypesEdgeCommit ImageTypes = "edge-commit"

	ImageTypesEdgeContainer ImageTypes = "edge-container"

	ImageTypesEdgeInstaller ImageTypes = "edge-installer"

	ImageTypesGcp ImageTypes = "gcp"

	ImageTypesGcpRhui ImageTypes = "gcp-rhui"

	ImageTypesGuestImage ImageTypes = "guest-image"

	ImageTypesImageInstaller ImageTypes = "image-installer"

	ImageTypesIotCommit ImageTypes = "iot-commit"

	ImageTypesIotContainer ImageTypes = "iot-container"

	ImageTypesIotInstaller ImageTypes = "iot-installer"

	ImageTypesIotRawImage ImageTypes = "iot-raw-image"

	ImageTypesVsphere ImageTypes = "vsphere"
)

// Defines values for UploadStatusValue.
const (
	UploadStatusValueFailure UploadStatusValue = "failure"

	UploadStatusValuePending UploadStatusValue = "pending"

	UploadStatusValueRunning UploadStatusValue = "running"

	UploadStatusValueSuccess UploadStatusValue = "success"
)

// Defines values for UploadTypes.
const (
	UploadTypesAws UploadTypes = "aws"

	UploadTypesAwsS3 UploadTypes = "aws.s3"

	UploadTypesAzure UploadTypes = "azure"

	UploadTypesContainer UploadTypes = "container"

	UploadTypesGcp UploadTypes = "gcp"
)

// AWSEC2CloneCompose defines model for AWSEC2CloneCompose.
type AWSEC2CloneCompose struct {
	Region            string    `json:"region"`
	ShareWithAccounts *[]string `json:"share_with_accounts,omitempty"`
}

// AWSEC2UploadOptions defines model for AWSEC2UploadOptions.
type AWSEC2UploadOptions struct {
	Region            string   `json:"region"`
	ShareWithAccounts []string `json:"share_with_accounts"`
	SnapshotName      *string  `json:"snapshot_name,omitempty"`
}

// AWSEC2UploadStatus defines model for AWSEC2UploadStatus.
type AWSEC2UploadStatus struct {
	Ami    string `json:"ami"`
	Region string `json:"region"`
}

// AWSS3UploadOptions defines model for AWSS3UploadOptions.
type AWSS3UploadOptions struct {
	// If set to false (the default value), a long, obfuscated URL
	// is returned. Its expiration might be sooner than for other upload
	// targets.
	//
	// If set to true, a shorter URL is returned and
	// its expiration is the same as for the other upload targets.
	Public *bool  `json:"public,omitempty"`
	Region string `json:"region"`
}

// AWSS3UploadStatus defines model for AWSS3UploadStatus.
type AWSS3UploadStatus struct {
	Url string `json:"url"`
}

// AzureUploadOptions defines model for AzureUploadOptions.
type AzureUploadOptions struct {
	// Name of the uploaded image. It must be unique in the given resource group.
	// If name is omitted from the request, a random one based on a UUID is
	// generated.
	ImageName *string `json:"image_name,omitempty"`

	// Location of the provided resource_group, where the image should be uploaded and registered.
	// How to list all locations:
	// https://docs.microsoft.com/en-us/cli/azure/account?view=azure-cli-latest#az_account_list_locations'
	// If the location is not specified, it is deducted from the provided resource_group.
	Location *string `json:"location,omitempty"`

	// Name of the resource group where the image should be uploaded.
	ResourceGroup string `json:"resource_group"`

	// ID of subscription where the image should be uploaded.
	SubscriptionId string `json:"subscription_id"`

	// ID of the tenant where the image should be uploaded.
	// How to find it in the Azure Portal:
	// https://docs.microsoft.com/en-us/azure/active-directory/fundamentals/active-directory-how-to-find-tenant
	TenantId string `json:"tenant_id"`
}

// AzureUploadStatus defines model for AzureUploadStatus.
type AzureUploadStatus struct {
	ImageName string `json:"image_name"`
}

// CloneComposeBody defines model for CloneComposeBody.
type CloneComposeBody interface{}

// CloneComposeResponse defines model for CloneComposeResponse.
type CloneComposeResponse struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Id string `json:"id"`
}

// CloneStatus defines model for CloneStatus.
type CloneStatus struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded struct due to allOf(#/components/schemas/UploadStatus)
	UploadStatus `yaml:",inline"`
}

// ComposeId defines model for ComposeId.
type ComposeId struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Id string `json:"id"`
}

// ComposeLogs defines model for ComposeLogs.
type ComposeLogs struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	ImageBuilds []interface{} `json:"image_builds"`
	Koji        *KojiLogs     `json:"koji,omitempty"`
}

// ComposeManifests defines model for ComposeManifests.
type ComposeManifests struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Manifests []interface{} `json:"manifests"`
}

// ComposeMetadata defines model for ComposeMetadata.
type ComposeMetadata struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	// ID (hash) of the built commit
	OstreeCommit *string `json:"ostree_commit,omitempty"`

	// Package list including NEVRA
	Packages *[]PackageMetadata `json:"packages,omitempty"`
}

// ComposeRequest defines model for ComposeRequest.
type ComposeRequest struct {
	Customizations *Customizations `json:"customizations,omitempty"`
	Distribution   string          `json:"distribution"`
	ImageRequest   *ImageRequest   `json:"image_request,omitempty"`
	ImageRequests  *[]ImageRequest `json:"image_requests,omitempty"`
	Koji           *Koji           `json:"koji,omitempty"`
}

// ComposeStatus defines model for ComposeStatus.
type ComposeStatus struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	ImageStatus   ImageStatus        `json:"image_status"`
	ImageStatuses *[]ImageStatus     `json:"image_statuses,omitempty"`
	KojiStatus    *KojiStatus        `json:"koji_status,omitempty"`
	Status        ComposeStatusValue `json:"status"`
}

// ComposeStatusError defines model for ComposeStatusError.
type ComposeStatusError struct {
	Details *interface{} `json:"details,omitempty"`
	Id      int          `json:"id"`
	Reason  string       `json:"reason"`
}

// ComposeStatusValue defines model for ComposeStatusValue.
type ComposeStatusValue string

// Container defines model for Container.
type Container struct {
	// Name to use for the container from the image
	Name   *string `json:"name,omitempty"`
	Source string  `json:"source"`

	// Control TLS verifification
	TlsVerify *bool `json:"tls_verify,omitempty"`
}

// ContainerUploadOptions defines model for ContainerUploadOptions.
type ContainerUploadOptions struct {
	// Name for the created container image
	Name *string `json:"name,omitempty"`

	// Tag for the created container image
	Tag *string `json:"tag,omitempty"`
}

// ContainerUploadStatus defines model for ContainerUploadStatus.
type ContainerUploadStatus struct {
	// Digest of the manifest of the uploaded container on the registry
	Digest string `json:"digest"`

	// FQDN of the uploaded image
	Url string `json:"url"`
}

// Customizations defines model for Customizations.
type Customizations struct {
	Containers *[]Container  `json:"containers,omitempty"`
	Filesystem *[]Filesystem `json:"filesystem,omitempty"`
	Packages   *[]string     `json:"packages,omitempty"`

	// Extra repositories for packages specified in customizations. These
	// repositories will only be used to depsolve and retrieve packages
	// for the OS itself (they will not be available for the build root or
	// any other part of the build process). The package_sets field for these
	// repositories is ignored.
	PayloadRepositories *[]Repository `json:"payload_repositories,omitempty"`
	Services            *struct {
		// List of services to disable by default
		Disabled *[]string `json:"disabled,omitempty"`

		// List of services to enable by default
		Enabled *[]string `json:"enabled,omitempty"`
	} `json:"services,omitempty"`
	Subscription *Subscription `json:"subscription,omitempty"`
	Users        *[]User       `json:"users,omitempty"`
}

// Error defines model for Error.
type Error struct {
	// Embedded struct due to allOf(#/components/schemas/ObjectReference)
	ObjectReference `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Code        string       `json:"code"`
	Details     *interface{} `json:"details,omitempty"`
	OperationId string       `json:"operation_id"`
	Reason      string       `json:"reason"`
}

// ErrorList defines model for ErrorList.
type ErrorList struct {
	// Embedded struct due to allOf(#/components/schemas/List)
	List `yaml:",inline"`
	// Embedded fields due to inline allOf schema
	Items []Error `json:"items"`
}

// Filesystem defines model for Filesystem.
type Filesystem struct {
	MinSize    uint64 `json:"min_size"`
	Mountpoint string `json:"mountpoint"`
}

// GCPUploadOptions defines model for GCPUploadOptions.
type GCPUploadOptions struct {
	// Name of an existing STANDARD Storage class Bucket.
	Bucket *string `json:"bucket,omitempty"`

	// The name to use for the imported and shared Compute Engine image.
	// The image name must be unique within the GCP project, which is used
	// for the OS image upload and import. If not specified a random
	// 'composer-api-<uuid>' string is used as the image name.
	ImageName *string `json:"image_name,omitempty"`

	// The GCP region where the OS image will be imported to and shared from.
	// The value must be a valid GCP location. See https://cloud.google.com/storage/docs/locations.
	// If not specified, the multi-region location closest to the source
	// (source Storage Bucket location) is chosen automatically.
	Region string `json:"region"`

	// List of valid Google accounts to share the imported Compute Engine image with.
	// Each string must contain a specifier of the account type. Valid formats are:
	//   - 'user:{emailid}': An email address that represents a specific
	//     Google account. For example, 'alice@example.com'.
	//   - 'serviceAccount:{emailid}': An email address that represents a
	//     service account. For example, 'my-other-app@appspot.gserviceaccount.com'.
	//   - 'group:{emailid}': An email address that represents a Google group.
	//     For example, 'admins@example.com'.
	//   - 'domain:{domain}': The G Suite domain (primary) that represents all
	//     the users of that domain. For example, 'google.com' or 'example.com'.
	// If not specified, the imported Compute Engine image is not shared with any
	// account.
	ShareWithAccounts *[]string `json:"share_with_accounts,omitempty"`
}

// GCPUploadStatus defines model for GCPUploadStatus.
type GCPUploadStatus struct {
	ImageName string `json:"image_name"`
	ProjectId string `json:"project_id"`
}

// ImageRequest defines model for ImageRequest.
type ImageRequest struct {
	Architecture string       `json:"architecture"`
	ImageType    ImageTypes   `json:"image_type"`
	Ostree       *OSTree      `json:"ostree,omitempty"`
	Repositories []Repository `json:"repositories"`

	// This should really be oneOf but AWSS3UploadOptions is a subset of
	// AWSEC2UploadOptions. This means that all AWSEC2UploadOptions objects
	// are also valid AWSS3UploadOptionas objects which violates the oneOf
	// rules. Therefore, we have to use anyOf here but be aware that it isn't
	// possible to mix and match more schemas together.
	UploadOptions *UploadOptions `json:"upload_options,omitempty"`
}

// ImageStatus defines model for ImageStatus.
type ImageStatus struct {
	Error        *ComposeStatusError `json:"error,omitempty"`
	Status       ImageStatusValue    `json:"status"`
	UploadStatus *UploadStatus       `json:"upload_status,omitempty"`
}

// ImageStatusValue defines model for ImageStatusValue.
type ImageStatusValue string

// ImageTypes defines model for ImageTypes.
type ImageTypes string

// Koji defines model for Koji.
type Koji struct {
	Name    string `json:"name"`
	Release string `json:"release"`
	Server  string `json:"server"`
	TaskId  int    `json:"task_id"`
	Version string `json:"version"`
}

// KojiLogs defines model for KojiLogs.
type KojiLogs struct {
	Import interface{} `json:"import"`
	Init   interface{} `json:"init"`
}

// KojiStatus defines model for KojiStatus.
type KojiStatus struct {
	BuildId *int `json:"build_id,omitempty"`
}

// List defines model for List.
type List struct {
	Kind  string `json:"kind"`
	Page  int    `json:"page"`
	Size  int    `json:"size"`
	Total int    `json:"total"`
}

// OSTree defines model for OSTree.
type OSTree struct {
	// Can be either a commit (example: 02604b2da6e954bd34b8b82a835e5a77d2b60ffa), or a branch-like reference (example: rhel/8/x86_64/edge)
	Parent *string `json:"parent,omitempty"`
	Ref    *string `json:"ref,omitempty"`
	Url    *string `json:"url,omitempty"`
}

// ObjectReference defines model for ObjectReference.
type ObjectReference struct {
	Href string `json:"href"`
	Id   string `json:"id"`
	Kind string `json:"kind"`
}

// PackageMetadata defines model for PackageMetadata.
type PackageMetadata struct {
	Arch      string  `json:"arch"`
	Epoch     *string `json:"epoch,omitempty"`
	Name      string  `json:"name"`
	Release   string  `json:"release"`
	Sigmd5    string  `json:"sigmd5"`
	Signature *string `json:"signature,omitempty"`
	Type      string  `json:"type"`
	Version   string  `json:"version"`
}

// Repository defines model for Repository.
type Repository struct {
	Baseurl  *string `json:"baseurl,omitempty"`
	CheckGpg *bool   `json:"check_gpg,omitempty"`

	// GPG key used to sign packages in this repository.
	Gpgkey     *string `json:"gpgkey,omitempty"`
	IgnoreSsl  *bool   `json:"ignore_ssl,omitempty"`
	Metalink   *string `json:"metalink,omitempty"`
	Mirrorlist *string `json:"mirrorlist,omitempty"`

	// Naming package sets for a repository assigns it to a specific part
	// (pipeline) of the build process.
	PackageSets *[]string `json:"package_sets,omitempty"`

	// Determines whether a valid subscription is required to access this repository.
	Rhsm *bool `json:"rhsm,omitempty"`
}

// Subscription defines model for Subscription.
type Subscription struct {
	ActivationKey string `json:"activation_key"`
	BaseUrl       string `json:"base_url"`
	Insights      bool   `json:"insights"`
	Organization  string `json:"organization"`
	ServerUrl     string `json:"server_url"`
}

// This should really be oneOf but AWSS3UploadOptions is a subset of
// AWSEC2UploadOptions. This means that all AWSEC2UploadOptions objects
// are also valid AWSS3UploadOptionas objects which violates the oneOf
// rules. Therefore, we have to use anyOf here but be aware that it isn't
// possible to mix and match more schemas together.
type UploadOptions interface{}

// UploadStatus defines model for UploadStatus.
type UploadStatus struct {
	Options interface{}       `json:"options"`
	Status  UploadStatusValue `json:"status"`
	Type    UploadTypes       `json:"type"`
}

// UploadStatusValue defines model for UploadStatusValue.
type UploadStatusValue string

// UploadTypes defines model for UploadTypes.
type UploadTypes string

// User defines model for User.
type User struct {
	Groups *[]string `json:"groups,omitempty"`
	Key    *string   `json:"key,omitempty"`
	Name   string    `json:"name"`
}

// Page defines model for page.
type Page string

// Size defines model for size.
type Size string

// PostComposeJSONBody defines parameters for PostCompose.
type PostComposeJSONBody ComposeRequest

// PostCloneComposeJSONBody defines parameters for PostCloneCompose.
type PostCloneComposeJSONBody CloneComposeBody

// GetErrorListParams defines parameters for GetErrorList.
type GetErrorListParams struct {
	// Page index
	Page *Page `json:"page,omitempty"`

	// Number of items in each page
	Size *Size `json:"size,omitempty"`
}

// PostComposeJSONRequestBody defines body for PostCompose for application/json ContentType.
type PostComposeJSONRequestBody PostComposeJSONBody

// PostCloneComposeJSONRequestBody defines body for PostCloneCompose for application/json ContentType.
type PostCloneComposeJSONRequestBody PostCloneComposeJSONBody

// ServerInterface represents all server handlers.
type ServerInterface interface {
	// The status of a cloned compose
	// (GET /clones/{id})
	GetCloneStatus(ctx echo.Context, id string) error
	// Create compose
	// (POST /compose)
	PostCompose(ctx echo.Context) error
	// The status of a compose
	// (GET /composes/{id})
	GetComposeStatus(ctx echo.Context, id string) error
	// Clone an existing compose
	// (POST /composes/{id}/clone)
	PostCloneCompose(ctx echo.Context, id string) error
	// Get logs for a compose.
	// (GET /composes/{id}/logs)
	GetComposeLogs(ctx echo.Context, id string) error
	// Get the manifests for a compose.
	// (GET /composes/{id}/manifests)
	GetComposeManifests(ctx echo.Context, id string) error
	// Get the metadata for a compose.
	// (GET /composes/{id}/metadata)
	GetComposeMetadata(ctx echo.Context, id string) error
	// Get a list of all possible errors
	// (GET /errors)
	GetErrorList(ctx echo.Context, params GetErrorListParams) error
	// Get error description
	// (GET /errors/{id})
	GetError(ctx echo.Context, id string) error
	// Get the openapi spec in json format
	// (GET /openapi)
	GetOpenapi(ctx echo.Context) error
}

// ServerInterfaceWrapper converts echo contexts to parameters.
type ServerInterfaceWrapper struct {
	Handler ServerInterface
}

// GetCloneStatus converts echo context to params.
func (w *ServerInterfaceWrapper) GetCloneStatus(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetCloneStatus(ctx, id)
	return err
}

// PostCompose converts echo context to params.
func (w *ServerInterfaceWrapper) PostCompose(ctx echo.Context) error {
	var err error

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.PostCompose(ctx)
	return err
}

// GetComposeStatus converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeStatus(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeStatus(ctx, id)
	return err
}

// PostCloneCompose converts echo context to params.
func (w *ServerInterfaceWrapper) PostCloneCompose(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.PostCloneCompose(ctx, id)
	return err
}

// GetComposeLogs converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeLogs(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeLogs(ctx, id)
	return err
}

// GetComposeManifests converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeManifests(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeManifests(ctx, id)
	return err
}

// GetComposeMetadata converts echo context to params.
func (w *ServerInterfaceWrapper) GetComposeMetadata(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetComposeMetadata(ctx, id)
	return err
}

// GetErrorList converts echo context to params.
func (w *ServerInterfaceWrapper) GetErrorList(ctx echo.Context) error {
	var err error

	ctx.Set(BearerScopes, []string{""})

	// Parameter object where we will unmarshal all parameters from the context
	var params GetErrorListParams
	// ------------- Optional query parameter "page" -------------

	err = runtime.BindQueryParameter("form", true, false, "page", ctx.QueryParams(), &params.Page)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter page: %s", err))
	}

	// ------------- Optional query parameter "size" -------------

	err = runtime.BindQueryParameter("form", true, false, "size", ctx.QueryParams(), &params.Size)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter size: %s", err))
	}

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetErrorList(ctx, params)
	return err
}

// GetError converts echo context to params.
func (w *ServerInterfaceWrapper) GetError(ctx echo.Context) error {
	var err error
	// ------------- Path parameter "id" -------------
	var id string

	err = runtime.BindStyledParameterWithLocation("simple", false, "id", runtime.ParamLocationPath, ctx.Param("id"), &id)
	if err != nil {
		return echo.NewHTTPError(http.StatusBadRequest, fmt.Sprintf("Invalid format for parameter id: %s", err))
	}

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetError(ctx, id)
	return err
}

// GetOpenapi converts echo context to params.
func (w *ServerInterfaceWrapper) GetOpenapi(ctx echo.Context) error {
	var err error

	ctx.Set(BearerScopes, []string{""})

	// Invoke the callback with all the unmarshalled arguments
	err = w.Handler.GetOpenapi(ctx)
	return err
}

// This is a simple interface which specifies echo.Route addition functions which
// are present on both echo.Echo and echo.Group, since we want to allow using
// either of them for path registration
type EchoRouter interface {
	CONNECT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	DELETE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	GET(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	HEAD(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	OPTIONS(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PATCH(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	POST(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	PUT(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
	TRACE(path string, h echo.HandlerFunc, m ...echo.MiddlewareFunc) *echo.Route
}

// RegisterHandlers adds each server route to the EchoRouter.
func RegisterHandlers(router EchoRouter, si ServerInterface) {
	RegisterHandlersWithBaseURL(router, si, "")
}

// Registers handlers, and prepends BaseURL to the paths, so that the paths
// can be served under a prefix.
func RegisterHandlersWithBaseURL(router EchoRouter, si ServerInterface, baseURL string) {

	wrapper := ServerInterfaceWrapper{
		Handler: si,
	}

	router.GET(baseURL+"/clones/:id", wrapper.GetCloneStatus)
	router.POST(baseURL+"/compose", wrapper.PostCompose)
	router.GET(baseURL+"/composes/:id", wrapper.GetComposeStatus)
	router.POST(baseURL+"/composes/:id/clone", wrapper.PostCloneCompose)
	router.GET(baseURL+"/composes/:id/logs", wrapper.GetComposeLogs)
	router.GET(baseURL+"/composes/:id/manifests", wrapper.GetComposeManifests)
	router.GET(baseURL+"/composes/:id/metadata", wrapper.GetComposeMetadata)
	router.GET(baseURL+"/errors", wrapper.GetErrorList)
	router.GET(baseURL+"/errors/:id", wrapper.GetError)
	router.GET(baseURL+"/openapi", wrapper.GetOpenapi)

}

// Base64 encoded, gzipped, json marshaled Swagger object
var swaggerSpec = []string{

	"H4sIAAAAAAAC/+x9+XPiuPL4v6Lifatmp8J9BJKqrfeAkIQAOYCcy1RK2LItsCVHkjmyNf/7tyQfGDCB",
	"7M7uOz6zP0ywLXW3Wt2tVndL+3tKo45LCSKCp05/T7mQQQcJxIInE8m/OuIaw67AlKROU7fQRAATHS1S",
	"6RRaQMe10VrzGbQ9lDpNFVLfv6dTWPZ58xBbptIpAh35RbVMp7hmIQfKLmLpyvdcMExM1Y3j9wTc154z",
	"RgxQA2CBHA4wAQhqFggAxqkJAUTU5PM76VFtP6Lne/hRga4/DlrNYtOmBDUl+7hC5DLqIiawj54hU5G8",
	"BSud4hZk6HWOhfUKNY16Ae8D4lOnv6UKxVK5clytneQLxdS3dEoNNhFW8AIyBpdqeAy9eZghXYIJaPgW",
	"NaPjCdKE7OcP4d61KdRvFHf5R2OIaEshLzNHXGQKqfTfObJ0ihPocouKV3/O4jQ5y0z4dZuqZJ4k07qP",
	"UwMBhZfAKOjgdYqggzN5rVbKV09K1WqlclLRy+Mkjn2SxRuDkXjTe6Z5UNozy643trHm65oBPVukTg1o",
	"c5Te0L22ATgSQFCgPoNfhIVA0AUoLfuaBhDYlJhpQMeGxzUokA7u+90RwRwwJDxGkJ4FbcEBWriYQQka",
	"ONi0BBgjwCkliAFhQQIMygAVFmLAU+SPiIDMRIJnR2REVrQI5iGJlluUCcQkNhBDBiDRRwSvI8QcSNo5",
	"dBCAXKGSz3F0YIVtNQtjSm0EyZ+ft8NmbJe0ecxOtplxFLJRIvx3j6E9EoEdaKJIzzYssGQaNRTDfFYh",
	"HagOcl6B43E1lR7Bb55cJlRDE88QAQxx6jENAZNRz82qWZRI5HxQBwspLAajjuoix4K4kFPLINGpAyhB",
	"YAw50gElAIL7+/YZwHxETEQQk5Lmz9WaWVCEJemdTTUoghlcH2A3+BIO0mV0huUgQ/JfFflpMLcQQ6qJ",
	"wiIl0LN1NfiQL5DIbibmAjFF3yWdS6G1MRcA2jYIyeCnI2IJ4fLTXE6nGs86WGOUU0NkNerkEMl4PKfZ",
	"OAfl9OUCg/XPGUbzX9WrjGbjjA0F4uIf8D20aK8S0WuE5ItiuaQ4fCVZT6gA3EUaNjDS0wAL+VJHuqet",
	"TcgOPmwyXWoA8qQ4JZu7eN+PpWtdXA5g9yYpQ+ppkPQDMBcKY9Ki5Y0jEl6xvk1U+0ySFG/2B4gpo4pe",
	"Gxe1DBwXy5lyuVDKnOS1Sua4UCzlj1Etf4KKSdQJRCARH9AlifAbHUZVIIIGJrqaa19DlVkAt5QJaB8i",
	"i6EcCjxDGR0zpAnKljnDIzp0EBHQ5ltfMxadZwTNSNQZn+QNJlW0KjIq4+NMQSsZmbIO8xl4XCxm8uP8",
	"cb5YOtGrenWvcV1xbHtutyRwj4ncZYLXLeQhJmeDyBiAJBLivmWD6kuJhRJ0Y6ROf/s99f8YMlKnqX/k",
	"Vs57LnBPcwm+6fdvGxD7iLuU+F4rtO0DoN4oyvrIQAwRDaW+p7c4oq9zolAsIenpZVDtZJwpFPVSBpYr",
	"x5ly8fi4UimX8/l8PpVOGZQ5UKROU56npmcP1/QEbkWjW03WHx/UR+3XRMJH6/Ozrf8PcdIfUpea/IcO",
	"Ssn72MO27j9v+P0BCenUImPSTPASE4GYATX0+/ekHcGUTpTb/RFlHTrBaizJChgQ9CErepBgA3HxQ/nh",
	"xIH+eWZsDG4F/eORIQF1KOCPHBjlgiH0qlHHwSJxzfrFgtz6Gi5dcgYECJonrH8u1KbQ9GFvxiHUF9+Z",
	"wkSzPR0TE1y3Hvr1VGxn+dF4AhgRI5IYu5t/fd9H3V4eNI8L6uB3GDnYHxHRXG/9PZ3SsWTA2BNbewxm",
	"ITtTS2KUL9BsRdJHKNuycUj+Zud1mfwMmD+qoVsCvMaAGMd/hIlPMkw8grt3uKH9T691RZ9k2gpKEs8O",
	"pEeybgXosD5rjHxQsbFN5geA1gf4sSXxwbUYo2xbG3QkILblT8k0PWbopE0zEfN3BpAnxsu2F66o8RYB",
	"/nikwhDPUUPxNA1xORYDYttj0jFzEZGGQg5opVerhluK1aREQExQwsg+2CILCjyOotiCFgJZbah27k19",
	"BzWAuwIbSbEKe6zBFBQgZ4z0NWfa33iyZTZ4pbx3hfRUQDNxr2Hz1xli2FhuD0pygVEbDLsDoNpgAwdb",
	"6BhSFY3ZCpdsypc/vkS/NxzSVoQC6jqWD9C+jU1BEKg6eFai6WBIxaZWLFSM2diOUK78g0RWQXMbxRCa",
	"n8Tg79gTvbV9vImZwsNZo2MzWB3WKT9T78M1OXQftuI8q8FQEuzRfRmLR8lWTAoCVeuozu/OrpMDSBu8",
	"efPgMotpzlkG0YxcMB+nH3BtMwSWDoecKG1by/TGMh4O93DjvjIWCabdwDbiSy6QczC881WXBIBx5ygW",
	"ZHcpFyZD/HMBdhcu5Wy8MuRSjgVlOMnrai0EgyDeRol8SMkqkgQwAet+UBYMLcTRiKz1nmPbBpTYSxWn",
	"4EiX1kxHLqf2DAURNMEwmqEIyYiEWnYzAFhwZBsqGr30gRGqQpBwBrENx/ZK65X0AEapAJSNCCTLIObr",
	"QibiDqkOXEblevBV0RwifuVIcGBgZOshzK3hYA6wSSgLI0AHzXI/hLBMzHwgNsMa+ryuczn6hMBRF/u6",
	"HQJWHPdbg/EyjOnHiV9ppYEZmkM72So6mLT9LoXtYSDyCXL8xnupIYaQ7fgniUkyr/FQ0b75GsTbSkPH",
	"P2Mj7nmSeUiiKXKofpS3q1EdJRqDNR9N9oCxcGhCGPcwZ02hi5pvAE52KNWQpUQcPmzVOsGzD+fioEnx",
	"Wb1vY+2DSqb8fM26b2z3MXkNE9KR9BbyxfL6Ht/DRByXlfDKBc+lmIh1gc/NINu78MU6p1eok1bAi+bt",
	"nlzQ2NOmSOyO1EMC0AJzIbfeg2H9+qzePwMDQZncmms25Bw0FIjsZm4meMgEGHZuaZPdOWmWSYKjjR2X",
	"MhHkXlSOVwdyj+AJBFrExCRwvLMjMowC5QrQRupqjoUVBMcvmrdyQZBMS4O5hTVLmnm5Vq2vRApWkD+U",
	"6H1asqBtrCdZopzWiHzR/P0Ly0AXZ0ZePl/SPA/r6hf6AnxmhOgA5LHwvqT6MzmvVc5ym5VyiP73WBYh",
	"GpNaVscx5goa56/c0gT8VHngiJVQPmNdQQ9TTlkwQAiECQbNpp6eNSk1gw0K90VHZR5yUeYqSBauZ6qU",
	"q+rZAmcCyqOslmZTLv3XYKPkbzhG5JcgoRSKpy+YUbevks2aRTkiAHqCOlBgDdr2cpPJyPtE8UPyWhfw",
	"RY0bhM0lvQrKuiQnia8Sz+yItKBmhUKiuB74rABGnGKhZxOgAZLyLHhQFPhRYw4gQ6cjAkAGfJGL2env",
	"yIHYxvr3L6egToB6AlDXGeJSBKGQLiBDXNrQFS5NggAbw8qCc8pAwL00+AJtrKF/xTalX7IB5sABqPv9",
	"PkmDjzoAsQu3s8wojy8DXfdf0HW5S0XWDDqFfeIkqSzRZ7kRjD/Mj0q6NligO5jwRB7o1IGYnP7u/5UI",
	"lXqCgYcFAv5b8IvLsAPZ8us2ctv2EartlXRL/NmHIui7yZGV6n0BlIEvGzQla93HohnmlH3jIAUVQLIc",
	"kZC/69r0m/KeTrekIhU5vqE8HDp5qXTKn7ZtNsv9oM/g+Mu/pMIqWlp/XA5RefgS/utmjghyDREdEpEZ",
	"M4j1TClfqhRKex2FGLj0vpTkWqx3uwKKaRYWSBMe2xjOonb8elzevbz7rw8ImQ6XLlKBTj/FsK/PzWAo",
	"W6kRr29of8CWzF/kX6l7UIB/3cXaKuKKs26NKxukfwtnYZdEoXC7cHAAOPJ6Px0AD0LHESsOA7CeQk2O",
	"O28M81Mx3XRKbd/9nz5l/u+wCicI/G7JYkzCYqjgXKKBc56xYIZZHg6eYj85dKPHd58YvyAneIl0E2Wi",
	"9FbwFMaIgheYcAFtW70wNdf/NwRgSoWLLIL6u9YBU7GC7z+swMvnzcYMziNwM+5Kby+RJZ0geZMcXF0p",
	"+DnSKYOZpvTkMg3Id/ieNoJ8o2cxX8znT/LVbD7Rn0Js5gfdVz1Ct3FKJzhrKMSBDctSZqrXljdey4Yz",
	"nBy/5dNNK1ouphMSEzPE+FYarrS/xi8gf4UqqDZeQVxxJcneRpnrhIVDrr5BOoWoLOvWPpX44uC33AV+",
	"lx1ROnQId5JiFuHefR3kFJPkUEJYNL7N+HC/vP1FUAHtpE8bXFBI01G1uV/k7XdO79zKp1PByrFdKAsZ",
	"Iglb4SYkcrODsIolwiCZDX4JWHcK8sXjfHlc1OExOqmUx3qpPK6Na0VYK1VQBVarenF8nDcM+DUtXTAI",
	"xgwSzcrYeIoAi7I+K3jMQnaulvNX1pw0IV83dijbLZKV0tjOLu/vtrP+dJuTGwGpLZZaAQnbvkGytOwQ",
	"o6QcYTD5CkPSLG+m/hNdmkQikEt3fAmN40fmb9vOYdPRK7s+ERi6VDs804QPMZO1p1TO9zJ22qW0z4SI",
	"Rrk0xxyjbcMBOQqkY9tmazrJMqRb0K8jlMsUIiKnYy5yUvBqK8mTcCjPUZ47wJRrFtKmr6ZrxsYbq9Q2",
	"XXOKEhKaF7cXYIqWUcpB8nqVxlCRH1VHHo52PX6Vkf81Whfta3B7cQtu7xvddhN0Ws+g0b1pdtTnERkR",
	"56593bioawONNlr1s65Re76coverY6jbved5FV5ctO0raIva1aS4yDWKnSOrbbS9xYVwHyZVNCLdvnl2",
	"Xz2ewGHFfTirOOe9q5I7RQT1c9rQeXu7m14v77j1VKR3T/PW+/1gXGhe95pG88KcPtXuiiPy/jJlba3J",
	"zvN3xTnrjG3o6db9EX6ApH7GnULtufXGx5X6famqi3vWK90964/mSf/oCd8aD7X+iHQak2G+NHto3Oi9",
	"AX8unXRhkxy33cLNzK21WzTXRq2H58Kb07y5rcNOfnx1WfIMs9z00JQfDQcjMr97HKJmd+G9dI9vek/0",
	"5rYzn/XujMXYLDyd1WbeS74jJjnt+rK4gF5+4fC6d3J55aLp7Oa2v7BHZPkmJssXg9EHjM6X7vzFnN3N",
	"BSG9Ws4ctLzc1cOQPecrRad1P6w2tXG1PNUuz4fnRm9qk+lFbkTyxn253oeVfPmytJjkp2KMSrOOdvtE",
	"b2+8TuOBXw5m+fz9xXN9eYu85VGtqt3nnltWrzotDR46kxE5Ru0Xc4l7N/m5XXi+OOt3NM+eT/lJ/ciz",
	"p2aBDsdlXnp3Xma3+eoFHS4ey8UJ7FQeB0fX1gtCI1I7zj/RB2usFTru4GhivNAJZy3xUrsd378cPc/O",
	"a32X6Y91NrkcX02LV26/U18MrQW/q/OGdVEYkXzXWxQfYa+RN4vtyq3W069y2tuE5muaxiaNJw8vHhmu",
	"YO+k9+TW3oY5Y/B+7XC9bZJa7u2lMyK4dufZhletem/WY24uimNBsDD7/G1iLXre5Pm+/DIuW1NxXrM6",
	"97mnp2q5+GZ1K515vV+/qzdGRJydX7w89mea0zI7Z71CZ1CvvTgP03HpyuoOe4XuU2MJHwuWRux6+F67",
	"vJpB52GiNyuzEdEc7QjfXd00Gr1Gs14vn+NWC10eO8w6v6x6D/yu2+sV888V7cUii+faed1ROtS8mNfO",
	"m/Npe0Qa8/bF+R29atZ5s9F4btbnreal2Wqel+v1pjm9W/U+un6u56qNZ9e0l4P6y/OlNVl2rBHJHRnH",
	"77fGw2x8Wcy33krTdvXmvHGdJ92no8Z9wfFmg6O3oTcoPXZZo+SULjxbuJ1+66rTFU6ldTYiBXbx/lSn",
	"w8LSPXlu17r1M73XbN4sJ/UJp4/3terzvdc8yo3JhA1Rv9jt3zSN5W2zevx4Uqvgm4cRcSqDozG/O5tX",
	"m8Uus/V6r9w78+jypTDA4gK+lDt33QdxNGzBQhnz58FFc/JOq7fPtYfS1c20kh8R8+3RrBWvc2On2Hof",
	"VIe10mPrbFywZ5Ny254tzPZbB5mFwvvT88Jhz4OXq6umMXs3juzrwbG3MC9HZLLIXeWX9kuxi8cX7Pii",
	"Xl/enNw/svrLYD7o5VvaZFibt5pkMR2cecs353H+MLtuPHmt9kPtBpWeR6SH7wvG1XWN69Uzl58vKr2j",
	"J530yN3g6JJNhreds5LzyOy6TlpDS39+qE1epu6jdbbkpdzJCboZEWuaZ12yzE+u51PoGTl8X7vRjp9m",
	"vemk2+9dmZX7k4fO8sp7fBTv8ycy6V1XHvvnjbdOmb9Qp9cbEUOMh5eFo8py3H/M1Uuzxhgu+o9FUb1/",
	"v55o72g6eGlh2L0+6eYutatmu1+4O68d14pnet1unZ/oIzItmnf4eXBXh/Aqf3VVf7+c9af9q27X7BSf",
	"757x5fXDsihKV8tzgzPoVOaD5uONYd2i9rLbGL5cjciMudf27RgZfHhSqQ6NYuO67ZnvL6xZeVicDTrT",
	"F7NvFR4uZoP2HWku36d3y+PWffHt1sWPlRNpo6zb9tML61CtU+p0Byc5/H51N+zbYtKr/zoiv94aw+qI",
	"qNWldX320dKTGHBRielXzu3kpdJBAtqYTJPXbwczRhlP2HaF/f4pV8tf/e+ZUnHk5fPFY+lB/BoFgfYt",
	"5j4SO9hDrBMR0SA/ZzVEBOUK/z8Df+XXWoYLhqATwwzlv8dl/42iT25RbwYH0BLP+icmwDAxQ48B+KUB",
	"yn1f+QwAculWcIBVLmIVJ1cVByPyi4tdZGOCviZWH2xFSsNyJPrJ0g5mcWf/Ab8zJBBzMEEczC0UbGb8",
	"RMXa4RflFvlOpBqVCsckuUsJdWBbbvhgI+2+4YNrAs/8jHHgxK2f+kQaQyIjP8Wm04WczylLrFCQnuVr",
	"oou67aEeICKYcGxaG6dck4vg0inKTEiCYpjNQEg5XyqWd0dBtkmOz0hWzm+M8r2Eb2wD1ghLbzJ9jYYY",
	"B2OjT9pfbVfwkeXB51c2IqbpvX02T7nu67KV+N6LY/vc5L4uO4oZv39LbyVgMQ8PazEEbb8WSp33AWNP",
	"gO3xSR2ESiuRANQYkQS2ZYGC6yBIgiQVtG2Q0BD4k8ZHBDIEoM1poPVbeGHUNkiDzzBVxXj++VlJ8Igw",
	"z0Z+rRdDBmUoDeYIWHAWpeqVIACVZZajGyMA537SEwr/+CH5IkbEpZzjsa26OXihEs4OFJoFHMoQCLgM",
	"BDWVrZLGMhK7XZGtWMD+M8ep1sPWh0vjgT02U0WfkMUDeyTXjqqylc8H7qPQ/yGpG79jkLvZVWgexCHC",
	"2fm2MY+fTAEwj5Bdcf44OUmB/iwvRUH4MJ6/CqgnQuRJleEqAbmebVrZbvUx8QKFrcMAm4se51YG6cVK",
	"pXAC6vV6vVm6fofNgv1y1i5cD1sV+a59zS46LdZ7xke93v3cu4T9+pXT79L2e98ovp0V9bPKe74xXOSO",
	"F0lEbIf4PY7Y/oj3jtShWsQ0j2GxHEih8BnUQJD5jBurX+fhgnX1OAyv4lDrp98ugiqXav9CDkwMuu2W",
	"DYICAEEDX0oV4vgpED8/zaVrYmMNBScggztA6i7ULASKKhmhltvI853P51moPit3M+jLc912s3U9aGWK",
	"2XzWEo6tZhALxbKbQUOhD9JtDKhKFwBdHIu0naaKKb/ejsgPp6lSNp8tqJC1sBSbcppNCeK537H+XclV",
	"Ui3WBRJ+nYvSFlWVBQIlAJQBqZU2EmGZtX8CQYWpJWWqcAfz4ARVzPejTKXxV/VGqqRdOoBK/ZCO9Gy8",
	"pq+t+6TEz2Km126U+S35BHNwWNknXlBgqmowdU+L5MPqmpbg7Ecocb6ftbq05Ycfmfymjguro7JqMor5",
	"fFgWHiQCoOvawTGI3CQoiVwR9KFFjnFJifM6Z+I8kSJS/oGog6TvNtI28df9QDIA1n3Uhb8edd0TFhB0",
	"itT2AvuE+NhLfz32ewI9YVGG3/0tjYuYlA0QybZPSfnvoGRK6JxsTEHl75j9e4IWLlKXPqhCAkA1zWNS",
	"0+ImXGlxaLx/+yZ1hHuOA9kyqCSMGyFlvCJ5UnByWuzGJJp0FqWpTs4ACAiah13TwKVy6Fg5xxolPCg5",
	"VWXjM8RgaNyVvQ9qMNXVUH4NIGZAR7JLUE+4ZbhuKRfhgXnfyCAuwqP3P0bj1w+Nfl9fPqUx+75lbwo/",
	"GntbT5r64COwIJfzxwTS/21Gh62Ok/60PD8tz4GWJzAaSZbmRzlPn/CXQh7ucZTWzjQf5CpFgP+POUtr",
	"nEqQoHW+/HSYfpqt/1KHaaf98jeCca8pwX+J3/pzkD2JGav/ICvyF/hem/cp/d3eV9LtSwkipU41ofmq",
	"kH6M5DoUHCZPtmsCLUTOtSHeoCfhDtPDrFf5RyFI0s3va6u2ZMvaEbIPFMAOiiH/yCpuYIK5FVvEwYdr",
	"OBarpTutdhQqKu4gAQEmvgxjSgAcU0+El9V5tvhomVe1nD8X+b2LfHBbU6JqSBGITvr5l0pGG0RMAKEq",
	"r4o1z4YsONoEfhEW9UwrSGlcDW6uv2b/5xTpQh1jM8MMdCjlSWq0dvPUh7oUtTxAnfrqvlWuLumMro+Q",
	"xKg9eGDOSPxmzyxQZ9eixhpVisXDQ3vB9OnIwOoeVwHi4djgKgi//ACS8GqITAguW/lAFVc3ev3Ux736",
	"uGLWDqVcm+4txfzf1LV19ThA6WJVxh/rXNDQV7ktPfMP2aIF1MTaQhRdd6wjFxGdr+5nUboWhf7V0c+P",
	"NCOk86di7FeM6NK4HXoRTuVn9OLnJvXnJvU/bZO6ZZuS7J0CHvcptkzM6maPLeOSNLJVk5w6wLOrxCHW",
	"Tp3w+UtVfzWGJGn3r6KkBgiY8VPN/j1q5gv6f5+SwUiAoG2DqP4plKaVmu2PaEPiFz0QLbpP3adsdQnJ",
	"eAnU0pmsqIfHj1DQ/E+t+qW/eQ3fOZXqA4i/+6nFP7X4M1qMtiVIam5U5LN7hbwJmiTL/TqxATilz3Jn",
	"LXkQ7Jn/G32LD4fzPaqDTrJEveBGFKp7mn+NT3T0er2MC7o4K/FwCwf/LwPoYv9G1IyKHiCWCa9jys2K",
	"yuPYKC4T0MTE/AgBF9BEfxKNYiIJb2yJ0OyD8+37/w8AAP//w/Kpq89rAAA=",
}

// GetSwagger returns the content of the embedded swagger specification file
// or error if failed to decode
func decodeSpec() ([]byte, error) {
	zipped, err := base64.StdEncoding.DecodeString(strings.Join(swaggerSpec, ""))
	if err != nil {
		return nil, fmt.Errorf("error base64 decoding spec: %s", err)
	}
	zr, err := gzip.NewReader(bytes.NewReader(zipped))
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %s", err)
	}
	var buf bytes.Buffer
	_, err = buf.ReadFrom(zr)
	if err != nil {
		return nil, fmt.Errorf("error decompressing spec: %s", err)
	}

	return buf.Bytes(), nil
}

var rawSpec = decodeSpecCached()

// a naive cached of a decoded swagger spec
func decodeSpecCached() func() ([]byte, error) {
	data, err := decodeSpec()
	return func() ([]byte, error) {
		return data, err
	}
}

// Constructs a synthetic filesystem for resolving external references when loading openapi specifications.
func PathToRawSpec(pathToFile string) map[string]func() ([]byte, error) {
	var res = make(map[string]func() ([]byte, error))
	if len(pathToFile) > 0 {
		res[pathToFile] = rawSpec
	}

	return res
}

// GetSwagger returns the Swagger specification corresponding to the generated code
// in this file. The external references of Swagger specification are resolved.
// The logic of resolving external references is tightly connected to "import-mapping" feature.
// Externally referenced files must be embedded in the corresponding golang packages.
// Urls can be supported but this task was out of the scope.
func GetSwagger() (swagger *openapi3.T, err error) {
	var resolvePath = PathToRawSpec("")

	loader := openapi3.NewLoader()
	loader.IsExternalRefsAllowed = true
	loader.ReadFromURIFunc = func(loader *openapi3.Loader, url *url.URL) ([]byte, error) {
		var pathToFile = url.String()
		pathToFile = path.Clean(pathToFile)
		getSpec, ok := resolvePath[pathToFile]
		if !ok {
			err1 := fmt.Errorf("path not found: %s", pathToFile)
			return nil, err1
		}
		return getSpec()
	}
	var specData []byte
	specData, err = rawSpec()
	if err != nil {
		return
	}
	swagger, err = loader.LoadFromData(specData)
	if err != nil {
		return
	}
	return
}
