import { FenceAgentMetadata } from "dev/types";

export const ok: FenceAgentMetadata = {
  name: "stonith:fence_apc",
  shortdesc: "Fence agent for APC over telnet/ssh",
  longdesc:
    "fence_apc is an I/O Fencing agent which can be used with the APC network power switch. It logs into device via telnet/ssh  and reboots a specified outlet. Lengthy telnet/ssh connections should be avoided while a GFS cluster  is  running  because  the  connection will block any necessary fencing actions.",
  actions: [
    { automatic: "0", name: "on" },
    { name: "off" },
    { name: "reboot" },
    { name: "status" },
    { name: "list" },
    { name: "list-status" },
    { name: "monitor" },
    { name: "metadata" },
    { name: "manpage" },
    { name: "validate-all" },
    { name: "stop", timeout: "20s" },
    { name: "start", timeout: "20s" },
  ],
  default_actions: [{ interval: "60s", name: "monitor" }],
  parameters: [
    {
      advanced: true,
      default: "reboot",
      deprecated: false,
      deprecated_by: [],
      longdesc: "",
      name: "action",
      obsoletes: null,
      pcs_deprecated_warning:
        "Specifying 'action' is deprecated and not necessary with current Pacemaker versions. Use 'pcmk_off_action', 'pcmk_reboot_action' instead.",
      required: false,
      shortdesc: "Fencing action",
      type: "string",
      unique: false,
    },
    {
      advanced: false,
      default: "['\\n>', '\\napc>']",
      deprecated: true,
      deprecated_by: ["command_prompt"],
      longdesc: "",
      name: "cmd_prompt",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc: "Force Python regex for command prompt",
      type: "string",
      unique: false,
    },
    {
      advanced: false,
      default: "['\\n>', '\\napc>']",
      deprecated: false,
      deprecated_by: [],
      longdesc: "",
      name: "command_prompt",
      obsoletes: "cmd_prompt",
      pcs_deprecated_warning: "",
      required: false,
      shortdesc: "Force Python regex for command prompt",
      type: "string",
      unique: false,
    },
    {
      advanced: false,
      default: null,
      deprecated: false,
      deprecated_by: [],
      longdesc: "",
      name: "identity_file",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc: "Identity file (private key) for SSH",
      type: "string",
      unique: false,
    },
    {
      advanced: false,
      default: null,
      deprecated: false,
      deprecated_by: [],
      longdesc: "",
      name: "inet4_only",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc: "Forces agent to use IPv4 addresses only",
      type: "boolean",
      unique: false,
    },
    {
      advanced: false,
      default: null,
      deprecated: false,
      deprecated_by: [],
      longdesc: "",
      name: "inet6_only",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc: "Forces agent to use IPv6 addresses only",
      type: "boolean",
      unique: false,
    },
    {
      advanced: false,
      default: null,
      deprecated: false,
      deprecated_by: [],
      longdesc: "",
      name: "ip",
      obsoletes: "ipaddr",
      pcs_deprecated_warning: "",
      required: true,
      shortdesc: "IP address or hostname of fencing device",
      type: "string",
      unique: false,
    },
    {
      advanced: false,
      default: null,
      deprecated: true,
      deprecated_by: ["ip"],
      longdesc: "",
      name: "ipaddr",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: true,
      shortdesc: "IP address or hostname of fencing device",
      type: "string",
      unique: false,
    },
    {
      advanced: false,
      default: "23",
      deprecated: false,
      deprecated_by: [],
      longdesc: "",
      name: "ipport",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc: "TCP/UDP port to use for connection with device",
      type: "integer",
      unique: false,
    },
    {
      advanced: false,
      default: null,
      deprecated: true,
      deprecated_by: ["username"],
      longdesc: "",
      name: "login",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: true,
      shortdesc: "Login name",
      type: "string",
      unique: false,
    },
    {
      advanced: false,
      default: null,
      deprecated: true,
      deprecated_by: ["password"],
      longdesc: "",
      name: "passwd",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc: "Login password or passphrase",
      type: "string",
      unique: false,
    },
    {
      advanced: false,
      default: null,
      deprecated: true,
      deprecated_by: ["password_script"],
      longdesc: "",
      name: "passwd_script",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc: "Script to run to retrieve password",
      type: "string",
      unique: false,
    },
    {
      advanced: false,
      default: null,
      deprecated: false,
      deprecated_by: [],
      longdesc: "",
      name: "password",
      obsoletes: "passwd",
      pcs_deprecated_warning: "",
      required: false,
      shortdesc: "Login password or passphrase",
      type: "string",
      unique: false,
    },
    {
      advanced: false,
      default: null,
      deprecated: false,
      deprecated_by: [],
      longdesc: "",
      name: "password_script",
      obsoletes: "passwd_script",
      pcs_deprecated_warning: "",
      required: false,
      shortdesc: "Script to run to retrieve password",
      type: "string",
      unique: false,
    },
    {
      advanced: false,
      default: null,
      deprecated: false,
      deprecated_by: [],
      longdesc: "",
      name: "plug",
      obsoletes: "port",
      pcs_deprecated_warning: "",
      required: false,
      shortdesc:
        "Physical plug number on device, UUID or identification of machine",
      type: "string",
      unique: false,
    },
    {
      advanced: false,
      default: null,
      deprecated: true,
      deprecated_by: ["plug"],
      longdesc: "",
      name: "port",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc:
        "Physical plug number on device, UUID or identification of machine",
      type: "string",
      unique: false,
    },
    {
      advanced: false,
      default: null,
      deprecated: true,
      deprecated_by: ["ssh"],
      longdesc: "",
      name: "secure",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc: "Use SSH connection",
      type: "boolean",
      unique: false,
    },
    {
      advanced: false,
      default: null,
      deprecated: false,
      deprecated_by: [],
      longdesc: "",
      name: "ssh",
      obsoletes: "secure",
      pcs_deprecated_warning: "",
      required: false,
      shortdesc: "Use SSH connection",
      type: "boolean",
      unique: false,
    },
    {
      advanced: false,
      default: "-1 -c blowfish",
      deprecated: false,
      deprecated_by: [],
      longdesc: "",
      name: "ssh_options",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc: "SSH options to use",
      type: "string",
      unique: false,
    },
    {
      advanced: false,
      default: null,
      deprecated: false,
      deprecated_by: [],
      longdesc: "",
      name: "switch",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc: "Physical switch number on device",
      type: "string",
      unique: false,
    },
    {
      advanced: false,
      default: null,
      deprecated: false,
      deprecated_by: [],
      longdesc: "",
      name: "username",
      obsoletes: "login",
      pcs_deprecated_warning: "",
      required: true,
      shortdesc: "Login name",
      type: "string",
      unique: false,
    },
    {
      advanced: false,
      default: null,
      deprecated: false,
      deprecated_by: [],
      longdesc: "",
      name: "quiet",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc:
        "Disable logging to stderr. Does not affect --verbose or --debug-file or logging to syslog.",
      type: "boolean",
      unique: false,
    },
    {
      advanced: false,
      default: null,
      deprecated: false,
      deprecated_by: [],
      longdesc: "",
      name: "verbose",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc: "Verbose mode",
      type: "boolean",
      unique: false,
    },
    {
      advanced: false,
      default: null,
      deprecated: true,
      deprecated_by: ["debug_file"],
      longdesc: "",
      name: "debug",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc: "Write debug information to given file",
      type: "string",
      unique: false,
    },
    {
      advanced: false,
      default: null,
      deprecated: false,
      deprecated_by: [],
      longdesc: "",
      name: "debug_file",
      obsoletes: "debug",
      pcs_deprecated_warning: "",
      required: false,
      shortdesc: "Write debug information to given file",
      type: "string",
      unique: false,
    },
    {
      advanced: false,
      default: ",",
      deprecated: false,
      deprecated_by: [],
      longdesc: "",
      name: "separator",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc: "Separator for CSV created by 'list' operation",
      type: "string",
      unique: false,
    },
    {
      advanced: false,
      default: "0",
      deprecated: false,
      deprecated_by: [],
      longdesc: "",
      name: "delay",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc: "Wait X seconds before fencing is started",
      type: "second",
      unique: false,
    },
    {
      advanced: false,
      default: "5",
      deprecated: false,
      deprecated_by: [],
      longdesc: "",
      name: "login_timeout",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc: "Wait X seconds for cmd prompt after login",
      type: "second",
      unique: false,
    },
    {
      advanced: false,
      default: "20",
      deprecated: false,
      deprecated_by: [],
      longdesc: "",
      name: "power_timeout",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc: "Test X seconds for status change after ON/OFF",
      type: "second",
      unique: false,
    },
    {
      advanced: false,
      default: "0",
      deprecated: false,
      deprecated_by: [],
      longdesc: "",
      name: "power_wait",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc: "Wait X seconds after issuing ON/OFF",
      type: "second",
      unique: false,
    },
    {
      advanced: false,
      default: "3",
      deprecated: false,
      deprecated_by: [],
      longdesc: "",
      name: "shell_timeout",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc: "Wait X seconds for cmd prompt after issuing command",
      type: "second",
      unique: false,
    },
    {
      advanced: false,
      default: "1",
      deprecated: false,
      deprecated_by: [],
      longdesc: "",
      name: "retry_on",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc: "Count of attempts to retry power on",
      type: "integer",
      unique: false,
    },
    {
      advanced: false,
      default: "/usr/bin/ssh",
      deprecated: false,
      deprecated_by: [],
      longdesc: "",
      name: "ssh_path",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc: "Path to ssh binary",
      type: "string",
      unique: false,
    },
    {
      advanced: false,
      default: "/usr/bin/telnet",
      deprecated: false,
      deprecated_by: [],
      longdesc: "",
      name: "telnet_path",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc: "Path to telnet binary",
      type: "string",
      unique: false,
    },
    {
      advanced: true,
      default: "port",
      deprecated: false,
      deprecated_by: [],
      longdesc:
        "Advanced use only: An alternate parameter to supply instead of 'port'\nSome devices do not support the standard 'port' parameter or may provide additional ones.\nUse this to specify an alternate, device-specific, parameter that should indicate the machine to be fenced.\nA value of 'none' can be used to tell the cluster not to supply any additional parameters.",
      name: "pcmk_host_argument",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc:
        "Advanced use only: An alternate parameter to supply instead of 'port'",
      type: "string",
      unique: false,
    },
    {
      advanced: false,
      default: "",
      deprecated: false,
      deprecated_by: [],
      longdesc:
        "A mapping of host names to ports numbers for devices that do not support host names.\nEg. node1:1;node2:2,3 would tell the cluster to use port 1 for node1 and ports 2 and 3 for node2",
      name: "pcmk_host_map",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc:
        "A mapping of host names to ports numbers for devices that do not support host names.",
      type: "string",
      unique: false,
    },
    {
      advanced: false,
      default: "",
      deprecated: false,
      deprecated_by: [],
      longdesc:
        "A list of machines controlled by this device (Optional unless pcmk_host_check=static-list).",
      name: "pcmk_host_list",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc:
        "A list of machines controlled by this device (Optional unless pcmk_host_check=static-list).",
      type: "string",
      unique: false,
    },
    {
      advanced: false,
      default: "dynamic-list",
      deprecated: false,
      deprecated_by: [],
      longdesc:
        "How to determine which machines are controlled by the device.\nAllowed values: dynamic-list (query the device via the 'list' command), static-list (check the pcmk_host_list attribute), status (query the device via the 'status' command), none (assume every device can fence every machine)",
      name: "pcmk_host_check",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc:
        "How to determine which machines are controlled by the device.",
      type: "string",
      unique: false,
    },
    {
      advanced: false,
      default: "0s",
      deprecated: false,
      deprecated_by: [],
      longdesc:
        "Enable a random delay for stonith actions and specify the maximum of random delay.\nThis prevents double fencing when using slow devices such as sbd.\nUse this to enable a random delay for stonith actions.\nThe overall delay is derived from this random delay value adding a static delay so that the sum is kept below the maximum delay.",
      name: "pcmk_delay_max",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc:
        "Enable a random delay for stonith actions and specify the maximum of random delay.",
      type: "time",
      unique: false,
    },
    {
      advanced: false,
      default: "0s",
      deprecated: false,
      deprecated_by: [],
      longdesc:
        "Enable a base delay for stonith actions and specify base delay value.\nThis prevents double fencing when different delays are configured on the nodes.\nUse this to enable a static delay for stonith actions.\nThe overall delay is derived from a random delay value adding this static delay so that the sum is kept below the maximum delay.",
      name: "pcmk_delay_base",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc:
        "Enable a base delay for stonith actions and specify base delay value.",
      type: "time",
      unique: false,
    },
    {
      advanced: false,
      default: "1",
      deprecated: false,
      deprecated_by: [],
      longdesc:
        "The maximum number of actions can be performed in parallel on this device\nCluster property concurrent-fencing=true needs to be configured first.\nThen use this to specify the maximum number of actions can be performed in parallel on this device. -1 is unlimited.",
      name: "pcmk_action_limit",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc:
        "The maximum number of actions can be performed in parallel on this device",
      type: "integer",
      unique: false,
    },
    {
      advanced: true,
      default: "reboot",
      deprecated: false,
      deprecated_by: [],
      longdesc:
        "Advanced use only: An alternate command to run instead of 'reboot'\nSome devices do not support the standard commands or may provide additional ones.\nUse this to specify an alternate, device-specific, command that implements the 'reboot' action.",
      name: "pcmk_reboot_action",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc:
        "Advanced use only: An alternate command to run instead of 'reboot'",
      type: "string",
      unique: false,
    },
    {
      advanced: true,
      default: "60s",
      deprecated: false,
      deprecated_by: [],
      longdesc:
        "Advanced use only: Specify an alternate timeout to use for reboot actions instead of stonith-timeout\nSome devices need much more/less time to complete than normal.\nUse this to specify an alternate, device-specific, timeout for 'reboot' actions.",
      name: "pcmk_reboot_timeout",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc:
        "Advanced use only: Specify an alternate timeout to use for reboot actions instead of stonith-timeout",
      type: "time",
      unique: false,
    },
    {
      advanced: true,
      default: "2",
      deprecated: false,
      deprecated_by: [],
      longdesc:
        "Advanced use only: The maximum number of times to retry the 'reboot' command within the timeout period\nSome devices do not support multiple connections. Operations may 'fail' if the device is busy with another task so Pacemaker will automatically retry the operation, if there is time remaining. Use this option to alter the number of times Pacemaker retries 'reboot' actions before giving up.",
      name: "pcmk_reboot_retries",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc:
        "Advanced use only: The maximum number of times to retry the 'reboot' command within the timeout period",
      type: "integer",
      unique: false,
    },
    {
      advanced: true,
      default: "off",
      deprecated: false,
      deprecated_by: [],
      longdesc:
        "Advanced use only: An alternate command to run instead of 'off'\nSome devices do not support the standard commands or may provide additional ones.\nUse this to specify an alternate, device-specific, command that implements the 'off' action.",
      name: "pcmk_off_action",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc:
        "Advanced use only: An alternate command to run instead of 'off'",
      type: "string",
      unique: false,
    },
    {
      advanced: true,
      default: "60s",
      deprecated: false,
      deprecated_by: [],
      longdesc:
        "Advanced use only: Specify an alternate timeout to use for off actions instead of stonith-timeout\nSome devices need much more/less time to complete than normal.\nUse this to specify an alternate, device-specific, timeout for 'off' actions.",
      name: "pcmk_off_timeout",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc:
        "Advanced use only: Specify an alternate timeout to use for off actions instead of stonith-timeout",
      type: "time",
      unique: false,
    },
    {
      advanced: true,
      default: "2",
      deprecated: false,
      deprecated_by: [],
      longdesc:
        "Advanced use only: The maximum number of times to retry the 'off' command within the timeout period\nSome devices do not support multiple connections. Operations may 'fail' if the device is busy with another task so Pacemaker will automatically retry the operation, if there is time remaining. Use this option to alter the number of times Pacemaker retries 'off' actions before giving up.",
      name: "pcmk_off_retries",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc:
        "Advanced use only: The maximum number of times to retry the 'off' command within the timeout period",
      type: "integer",
      unique: false,
    },
    {
      advanced: true,
      default: "on",
      deprecated: false,
      deprecated_by: [],
      longdesc:
        "Advanced use only: An alternate command to run instead of 'on'\nSome devices do not support the standard commands or may provide additional ones.\nUse this to specify an alternate, device-specific, command that implements the 'on' action.",
      name: "pcmk_on_action",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc:
        "Advanced use only: An alternate command to run instead of 'on'",
      type: "string",
      unique: false,
    },
    {
      advanced: true,
      default: "60s",
      deprecated: false,
      deprecated_by: [],
      longdesc:
        "Advanced use only: Specify an alternate timeout to use for on actions instead of stonith-timeout\nSome devices need much more/less time to complete than normal.\nUse this to specify an alternate, device-specific, timeout for 'on' actions.",
      name: "pcmk_on_timeout",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc:
        "Advanced use only: Specify an alternate timeout to use for on actions instead of stonith-timeout",
      type: "time",
      unique: false,
    },
    {
      advanced: true,
      default: "2",
      deprecated: false,
      deprecated_by: [],
      longdesc:
        "Advanced use only: The maximum number of times to retry the 'on' command within the timeout period\nSome devices do not support multiple connections. Operations may 'fail' if the device is busy with another task so Pacemaker will automatically retry the operation, if there is time remaining. Use this option to alter the number of times Pacemaker retries 'on' actions before giving up.",
      name: "pcmk_on_retries",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc:
        "Advanced use only: The maximum number of times to retry the 'on' command within the timeout period",
      type: "integer",
      unique: false,
    },
    {
      advanced: true,
      default: "list",
      deprecated: false,
      deprecated_by: [],
      longdesc:
        "Advanced use only: An alternate command to run instead of 'list'\nSome devices do not support the standard commands or may provide additional ones.\nUse this to specify an alternate, device-specific, command that implements the 'list' action.",
      name: "pcmk_list_action",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc:
        "Advanced use only: An alternate command to run instead of 'list'",
      type: "string",
      unique: false,
    },
    {
      advanced: true,
      default: "60s",
      deprecated: false,
      deprecated_by: [],
      longdesc:
        "Advanced use only: Specify an alternate timeout to use for list actions instead of stonith-timeout\nSome devices need much more/less time to complete than normal.\nUse this to specify an alternate, device-specific, timeout for 'list' actions.",
      name: "pcmk_list_timeout",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc:
        "Advanced use only: Specify an alternate timeout to use for list actions instead of stonith-timeout",
      type: "time",
      unique: false,
    },
    {
      advanced: true,
      default: "2",
      deprecated: false,
      deprecated_by: [],
      longdesc:
        "Advanced use only: The maximum number of times to retry the 'list' command within the timeout period\nSome devices do not support multiple connections. Operations may 'fail' if the device is busy with another task so Pacemaker will automatically retry the operation, if there is time remaining. Use this option to alter the number of times Pacemaker retries 'list' actions before giving up.",
      name: "pcmk_list_retries",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc:
        "Advanced use only: The maximum number of times to retry the 'list' command within the timeout period",
      type: "integer",
      unique: false,
    },
    {
      advanced: true,
      default: "monitor",
      deprecated: false,
      deprecated_by: [],
      longdesc:
        "Advanced use only: An alternate command to run instead of 'monitor'\nSome devices do not support the standard commands or may provide additional ones.\nUse this to specify an alternate, device-specific, command that implements the 'monitor' action.",
      name: "pcmk_monitor_action",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc:
        "Advanced use only: An alternate command to run instead of 'monitor'",
      type: "string",
      unique: false,
    },
    {
      advanced: true,
      default: "60s",
      deprecated: false,
      deprecated_by: [],
      longdesc:
        "Advanced use only: Specify an alternate timeout to use for monitor actions instead of stonith-timeout\nSome devices need much more/less time to complete than normal.\nUse this to specify an alternate, device-specific, timeout for 'monitor' actions.",
      name: "pcmk_monitor_timeout",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc:
        "Advanced use only: Specify an alternate timeout to use for monitor actions instead of stonith-timeout",
      type: "time",
      unique: false,
    },
    {
      advanced: true,
      default: "2",
      deprecated: false,
      deprecated_by: [],
      longdesc:
        "Advanced use only: The maximum number of times to retry the 'monitor' command within the timeout period\nSome devices do not support multiple connections. Operations may 'fail' if the device is busy with another task so Pacemaker will automatically retry the operation, if there is time remaining. Use this option to alter the number of times Pacemaker retries 'monitor' actions before giving up.",
      name: "pcmk_monitor_retries",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc:
        "Advanced use only: The maximum number of times to retry the 'monitor' command within the timeout period",
      type: "integer",
      unique: false,
    },
    {
      advanced: true,
      default: "status",
      deprecated: false,
      deprecated_by: [],
      longdesc:
        "Advanced use only: An alternate command to run instead of 'status'\nSome devices do not support the standard commands or may provide additional ones.\nUse this to specify an alternate, device-specific, command that implements the 'status' action.",
      name: "pcmk_status_action",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc:
        "Advanced use only: An alternate command to run instead of 'status'",
      type: "string",
      unique: false,
    },
    {
      advanced: true,
      default: "60s",
      deprecated: false,
      deprecated_by: [],
      longdesc:
        "Advanced use only: Specify an alternate timeout to use for status actions instead of stonith-timeout\nSome devices need much more/less time to complete than normal.\nUse this to specify an alternate, device-specific, timeout for 'status' actions.",
      name: "pcmk_status_timeout",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc:
        "Advanced use only: Specify an alternate timeout to use for status actions instead of stonith-timeout",
      type: "time",
      unique: false,
    },
    {
      advanced: true,
      default: "2",
      deprecated: false,
      deprecated_by: [],
      longdesc:
        "Advanced use only: The maximum number of times to retry the 'status' command within the timeout period\nSome devices do not support multiple connections. Operations may 'fail' if the device is busy with another task so Pacemaker will automatically retry the operation, if there is time remaining. Use this option to alter the number of times Pacemaker retries 'status' actions before giving up.",
      name: "pcmk_status_retries",
      obsoletes: null,
      pcs_deprecated_warning: "",
      required: false,
      shortdesc:
        "Advanced use only: The maximum number of times to retry the 'status' command within the timeout period",
      type: "integer",
      unique: false,
    },
  ],
};
