import { ResourceAgentMetadata } from "dev/types";

export const ocfHeartbeatApache: ResourceAgentMetadata = {
  name: "ocf:heartbeat:apache",
  shortdesc: "Manages an Apache Web server instance",
  longdesc:
    "This is the resource agent for the Apache Web server.\nThis resource agent operates both version 1.x and version 2.x Apache\nservers.\n\nThe start operation ends with a loop in which monitor is\nrepeatedly called to make sure that the server started and that\nit is operational. Hence, if the monitor operation does not\nsucceed within the start operation timeout, the apache resource\nwill end with an error status.\n\nThe monitor operation by default loads the server status page\nwhich depends on the mod_status module and the corresponding\nconfiguration file (usually /etc/apache2/mod_status.conf).\nMake sure that the server status page works and that the access\nis allowed *only* from localhost (address 127.0.0.1).\nSee the statusurl and testregex attributes for more details.\n\nSee also http://httpd.apache.org/",
  parameters: [
    {
      name: "configfile",
      longdesc:
        "The full pathname of the Apache configuration file.\nThis file is parsed to provide defaults for various other\nresource agent parameters.",
      shortdesc: "configuration file path",
      type: "string",
      default: "/etc/httpd/conf/httpd.conf",
      required: false,
      advanced: false,
      deprecated: false,
      deprecated_by: [],
      obsoletes: null,
      pcs_deprecated_warning: "",
    },
    {
      name: "httpd",
      longdesc: "The full pathname of the httpd binary (optional).",
      shortdesc: "httpd binary path",
      type: "string",
      default: "/usr/sbin/httpd",
      required: false,
      advanced: false,
      deprecated: false,
      deprecated_by: [],
      obsoletes: null,
      pcs_deprecated_warning: "",
    },
    {
      name: "port",
      longdesc:
        "A port number that we can probe for status information\nusing the statusurl.\nThis will default to the port number found in the\nconfiguration file, or 80, if none can be found\nin the configuration file.",
      shortdesc: "httpd port",
      type: "integer",
      default: null,
      required: false,
      advanced: false,
      deprecated: false,
      deprecated_by: [],
      obsoletes: null,
      pcs_deprecated_warning: "",
    },
    {
      name: "statusurl",
      longdesc:
        "The URL to monitor (the apache server status page by default).\nIf left unspecified, it will be inferred from\nthe apache configuration file.\n\nIf you set this, make sure that it succeeds *only* from the\nlocalhost (127.0.0.1). Otherwise, it may happen that the cluster\ncomplains about the resource being active on multiple nodes.",
      shortdesc: "url name",
      type: "string",
      default: null,
      required: false,
      advanced: false,
      deprecated: false,
      deprecated_by: [],
      obsoletes: null,
      pcs_deprecated_warning: "",
    },
    {
      name: "testregex",
      longdesc:
        "Regular expression to match in the output of statusurl.\nCase insensitive.",
      shortdesc: "monitor regular expression",
      type: "string",
      default:
        "exists, but impossible to show in a human readable format (try grep testregex)",
      required: false,
      advanced: false,
      deprecated: false,
      deprecated_by: [],
      obsoletes: null,
      pcs_deprecated_warning: "",
    },
    {
      name: "client",
      longdesc:
        'Client to use to query to Apache. If not specified, the RA will\ntry to find one on the system. Currently, wget and curl are\nsupported. For example, you can set this parameter to "curl" if\nyou prefer that to wget.',
      shortdesc: "http client",
      type: "string",
      default: "",
      required: false,
      advanced: false,
      deprecated: false,
      deprecated_by: [],
      obsoletes: null,
      pcs_deprecated_warning: "",
    },
    {
      name: "testurl",
      longdesc:
        'URL to test. If it does not start with "http", then it\'s\nconsidered to be relative to the Listen address.',
      shortdesc: "test url",
      type: "string",
      default: null,
      required: false,
      advanced: false,
      deprecated: false,
      deprecated_by: [],
      obsoletes: null,
      pcs_deprecated_warning: "",
    },
    {
      name: "testregex10",
      longdesc:
        "Regular expression to match in the output of testurl.\nCase insensitive.",
      shortdesc: "extended monitor regular expression",
      type: "string",
      default: null,
      required: false,
      advanced: false,
      deprecated: false,
      deprecated_by: [],
      obsoletes: null,
      pcs_deprecated_warning: "",
    },
    {
      name: "testconffile",
      longdesc:
        "A file which contains test configuration. Could be useful if\nyou have to check more than one web application or in case sensitive\ninfo should be passed as arguments (passwords). Furthermore, \nusing a config file is the only way to specify certain\nparameters.\n\nPlease see README.webapps for examples and file description.",
      shortdesc: "test configuration file",
      type: "string",
      default: null,
      required: false,
      advanced: false,
      deprecated: false,
      deprecated_by: [],
      obsoletes: null,
      pcs_deprecated_warning: "",
    },
    {
      name: "testname",
      longdesc: "Name of the test within the test configuration file.",
      shortdesc: "test name",
      type: "string",
      default: null,
      required: false,
      advanced: false,
      deprecated: false,
      deprecated_by: [],
      obsoletes: null,
      pcs_deprecated_warning: "",
    },
    {
      name: "options",
      longdesc:
        "Extra options to apply when starting apache. See man httpd(8).",
      shortdesc: "command line options",
      type: "string",
      default: null,
      required: false,
      advanced: false,
      deprecated: false,
      deprecated_by: [],
      obsoletes: null,
      pcs_deprecated_warning: "",
    },
    {
      name: "envfiles",
      longdesc:
        "Files (one or more) which contain extra environment variables.\nIf you want to prevent script from reading the default file, set\nthis parameter to empty string.",
      shortdesc: "environment settings files",
      type: "string",
      default: "/etc/apache2/envvars",
      required: false,
      advanced: false,
      deprecated: false,
      deprecated_by: [],
      obsoletes: null,
      pcs_deprecated_warning: "",
    },
    {
      name: "use_ipv6",
      longdesc:
        "We will try to detect if the URL (for monitor) is IPv6, but if\nthat doesn't work set this to true to enforce IPv6.",
      shortdesc: "use ipv6 with http clients",
      type: "boolean",
      default: "false",
      required: false,
      advanced: false,
      deprecated: false,
      deprecated_by: [],
      obsoletes: null,
      pcs_deprecated_warning: "",
    },
    {
      name: "trace_ra",
      longdesc:
        "Set to 1 to turn on resource agent tracing (expect large output) The trace output will be saved to trace_file, if set, or by default to $HA_VARRUN/ra_trace/<type>/<id>.<action>.<timestamp> e.g. $HA_VARRUN/ra_trace/oracle/db.start.2012-11-27.08:37:08",
      shortdesc:
        "Set to 1 to turn on resource agent tracing (expect large output)",
      type: "integer",
      default: 0,
      required: false,
      advanced: true,
      deprecated: false,
      deprecated_by: [],
      obsoletes: null,
      pcs_deprecated_warning: "",
    },
    {
      name: "trace_file",
      longdesc: "Path to a file to store resource agent tracing log",
      shortdesc: "Path to a file to store resource agent tracing log",
      type: "string",
      default: "",
      required: false,
      advanced: true,
      deprecated: false,
      deprecated_by: [],
      obsoletes: null,
      pcs_deprecated_warning: "",
    },
  ],
};
