package org.codehaus.plexus.mailsender;

/*
 * The MIT License
 *
 * Copyright (c) 2005, The Codehaus
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is furnished to do
 * so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

import junit.framework.TestCase;

/**
 * @author <a href="mailto:trygvis@inamo.no">Trygve Laugst&oslash;l</a>
 * @version $Id: MailMessageTest.java 1650 2005-04-01 22:53:43Z trygvis $
 */
public class MailMessageTest
    extends TestCase
{
    public void testMakeRfc2822Address()
        throws Exception
    {
        assertEquals( "\"name\" <mailbox>", new MailMessage.Address( "mailbox", "name" ).getRfc2822Address() );

        assertEquals( "<mailbox>", new MailMessage.Address( "mailbox" ).getRfc2822Address() );

        assertEquals( "<mailbox>", new MailMessage.Address( "mailbox", null ).getRfc2822Address() );

        try
        {
            new MailMessage.Address( null, "name" ).getRfc2822Address();

            fail( "Expected MailSenderException." );
        }
        catch ( MailSenderException e )
        {
            // expected
        }

        try
        {
            new MailMessage.Address( null, null ).getRfc2822Address();

            fail( "Expected MailSenderException." );
        }
        catch ( MailSenderException e )
        {
            // expected
        }
    }
}
