#
# Copyright 2017, Intel Corporation
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
#     * Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#
#     * Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in
#       the documentation and/or other materials provided with the
#       distribution.
#
#     * Neither the name of the copyright holder nor the names of its
#       contributors may be used to endorse or promote products derived
#       from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

#
# src/test/obj_ctl_config/TEST0 -- unit test for ctl configuration
#
[CmdletBinding(PositionalBinding=$false)]
Param(
    [alias("d")]
    $DIR = ""
    )
$Env:UNITTEST_NAME = "obj_ctl_config/TEST0"
$Env:UNITTEST_NUM = "0"


# standard unit test setup

. ..\unittest\unittest.ps1

require_test_type short

setup

expect_normal_exit $PMEMPOOL create --layout obj_ctl_config obj $DIR\testfile

$CONFIG_ID = 0

Do {
	$Env:UNITTEST_NUM = $CONFIG_ID
	$CONFIG_FILE = "config" + $CONFIG_ID

	if (!(Test-Path $CONFIG_FILE -PathType Leaf)) {
		break
	}

	if (!(Get-Content $CONFIG_FILE | Select-String "#" -quiet)) {
		$Env:PMEMOBJ_CONF = Get-Content $CONFIG_FILE -Raw
		expect_normal_exit $Env:EXE_DIR\obj_ctl_config$Env:EXESUFFIX $DIR\testfile
		$Env:PMEMOBJ_CONF = ""
		check
	}

	$Env:PMEMOBJ_CONF_FILE = $CONFIG_FILE
	expect_normal_exit $Env:EXE_DIR\obj_ctl_config$Env:EXESUFFIX $DIR\testfile
	$Env:PMEMOBJ_CONF_FILE = ""
	check

	$CONFIG_ID = $CONFIG_ID + 1
} While ($true)

pass
