#!/bin/bash


#Preupgrade Assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Ondrej Vasik <ovasik@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_applies_to "pam"
COMPONENT="pam"
#END GENERATED SECTION

POSTUPGRADE_DIR="$VALUE_TMP_PREUPGRADE/postupgrade.d/pam"
if [[ ! -d "$POSTUPGRADE_DIR" ]]; then
    mkdir -p "$POSTUPGRADE_DIR"
fi
SCRIPT_NAME="postupgrade-pam.sh"
POST_SCRIPT="postupgrade.d/$SCRIPT_NAME"
cp -f $POST_SCRIPT $POSTUPGRADE_DIR/$SCRIPT_NAME
fail=0

#pam_passwdqc and pam_ecryptfs were removed
for file in /etc/pam.d/*;
do
  grep pam_passwdqc "$file" | grep -q -v ^# && sed -e '/pam_passwdqc/s/^/#/g' >"$VALUE_TMP_PREUPGRADE/cleanconf/$file" && log_medium_risk "PAM: $file contains no longer supported pam_passwdqc module" && fail=1
  grep pam_ecryptfs "$file" | grep -q -v ^# && sed -e '/pam_ecryptfs/s/^/#/g' >"$VALUE_TMP_PREUPGRADE/cleanconf/$file" && log_high_risk "PAM: $file contains no longer supported pam_ecryptfs module. Your ecryptfs encrypted files will not work after the upgrade, you will have to decrypt the files before the upgrade and possibly switch to other encryption!" && fail=1
done

test $fail = 1 && exit_fail

exit_pass
