#!/bin/bash


#Preupgrade Assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Petr Stodulka <pstodulk@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_applies_to "filesystem"
COMPONENT="filesystem"
#END GENERATED SECTION

RESULT=$RESULT_INFORMATIONAL
rm -f solution.txt
if [[ -d /run ]]; then
  log_medium_risk "Conflict with file structure: directory '/run' already exists!"
  echo \
"Actual data in '/run' directory will not be accessible from upgraded OS,
because tmpfs will be mounted on this directory. Please move it.
" >> solution.txt
  RESULT=$RESULT_FAIL
elif [[ -e /run ]];then
  # improbably situation
  log_medium_risk "Conflict with file structure: file '/run' already exists!"
  echo \
"File '/run' can't be used as mountpoint and it will be removed during inplace
upgrade and will be created '/run' directory instead.
" >> solution.txt
  RESULT=$RESULT_FAIL
fi

echo \
"Since RHEL 7 exists '/run' directory where tmpfs is mounted for runtime data.
Original '/var/run' is symlink to this directory and likewise '/var/lock' points
to the '/run/lock/' now. '/run' directory is emptied on reboot, so all runtime
files must be created on boot again. See RHEL 7 Migration Planning Guidelines." \
  >> solution.txt

exit $RESULT
