#!/bin/bash


#Preupgrade Assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Jan Safranek <jsafrane@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_applies_to "net-snmp"
COMPONENT="net-snmp"
#END GENERATED SECTION

if service_is_enabled snmpd; then
    log_slight_risk "Net-SNMP daemon is enabled. Please check Knowledge Base article for known incompatibilities."
    cat <<_EOF_ >solution.txt
Net-SNMP in Red Hat Enterprise Linux 7 has been updated to version 5.7.2. It
includes many fixes and new features.

In most configurations, no changes to configuration files should be necessary,
check following Knowledge Base article for known incompatibilities:

https://access.redhat.com/site/articles/696163

All applications consuming SNMP data from this system should be carefully
retested with the updated Net-SNMP package.
_EOF_
    exit $RESULT_INFORMATIONAL
fi

exit $RESULT_PASS
