#!/bin/bash


#Preupgrade Assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Ondrej Vasik <ovasik@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_rpm_to "" ""
COMPONENT="distribution"
#END GENERATED SECTION

COMPONENT="distribution"
[ ! -f "$VALUE_RPM_QA" ] && exit $RESULT_NOT_APPLICABLE

#check for Red Hat RHEL 6 keys and filter them out.
#based on https://access.redhat.com/site/security/team/key/
get_dist_non_native_list() {
  local pkg
  while read line; do
    pkg=$(echo $line | cut -d " " -f1 )
    is_dist_native $pkg >/dev/null || echo $pkg
  done < "$VALUE_RPM_QA"
}

echo " * nonrhpkgs - this file contains all RHEL 6 packages not signed by RH keys - you will have to handle them yourself." >>"$KICKSTART_README"
get_dist_non_native_list > "$KICKSTART_DIR/nonrhpkgs"
[ -s "$KICKSTART_DIR/nonrhpkgs" ] || {
  log_info "All packages are RH signed, no 3rd party keys detected"
  exit $RESULT_PASS;
}

#We detected some non-redhat package
log_high_risk "We detected some non-RH signed packages, you can find the list in [link:kickstart/nonrhpkgs]. You need to handle them yourself!"
exit $RESULT_FAIL
