#!/bin/bash


#Preupgrade Assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Benjamin Marzinski <bmarzins@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_applies_to "device-mapper-multipath"
COMPONENT="device-mapper-multipath"
#END GENERATED SECTION

OLD_MULTIPATH_RULES=/lib/udev/rules.d/40-multipath.rules
MULTIPATH_CONF=/etc/multipath.conf
ERR=0
FIX=0

mkdir -p $VALUE_TMP_PREUPGRADE/postupgrade.d/multipath
cp -R postupgrade.d/* $VALUE_TMP_PREUPGRADE/postupgrade.d/multipath

if [ -e "$OLD_MULTIPATH_RULES" ]; then
	log_warning "Multipath's udev rules file has moved in RHEL7. The old file, $OLD_MULTIPATH_RULES must be removed"
	FIX=1
fi	
 
if [ -f "$MULTIPATH_CONF" ]; then
	if grep -q "getuid_callout" $MULTIPATH_CONF ; then
		log_medium_risk "Multipath no longer uses the getuid_callout config option"
		ERR=1
	fi
	if grep -q "devices[[:space:]]*{" $MULTIPATH_CONF; then
		log_high_risk "Multipath matches user device configs with builtin deivces configs differently on RHEL7."
		FIX=1
	fi
fi
log_medium_risk "a number of default configuation settings have changed in RHEL7. Users should verify that their devices are still optimally configured"

test "$ERR" -ne 0 && exit $RESULT_FAIL
test "$FIX" -ne 0 && exit $RESULT_FIXED
exit $RESULT_PASS
