#!/bin/bash
#
# Author: Honza Horak <hhorak@redhat.com>
#
# Description:
# This script checks if there are some maps generated and generates
# a warning that maps should be re-generated after upgrade.


#Preupgrade Assistant performs system upgradability assessment
#and gathers information required for successful operating system upgrade.
#Copyright (C) 2013 Red Hat Inc.
#Honza Horak <hhorak@redhat.com>
#
#This program is free software: you can redistribute it and/or modify
#it under the terms of the GNU General Public License as published by
#the Free Software Foundation, either version 3 of the License, or
#(at your option) any later version.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details.
#
#You should have received a copy of the GNU General Public License
#along with this program.  If not, see <http://www.gnu.org/licenses/>.
. /usr/share/preupgrade/common.sh
check_applies_to "ypserv"
COMPONENT="ypserv"
#END GENERATED SECTION

check_root

. ../common.sh

ypserv_maps_exist || exit $RESULT_NOT_APPLICABLE

read -r -d '' PROBLEM_MESSAGE <<'EOF'
Package ypserv in RHEL 7 uses TokyoCabinet as a back-end library to store
generated NIS maps, while GDBM has been used in RHEL 6. As a consequence,
map files generated on RHEL 6 won't be readable on RHEL 7.

It is advised to re-generate maps after upgrading.
EOF

log_high_risk "$PROBLEM_MESSAGE"

read -r -d '' PROBLEM_SOLUTION <<EOF
${PROBLEM_MESSAGE}

In order to re-generate maps you should run manually:
root #> systemctl start ypserv.service
root #> make NOPUSH=true -C /var/yp all
EOF

solution_file "$PROBLEM_SOLUTION"

exit $RESULT_FAILED
