# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.service_client import ServiceClient
from msrest import Configuration, Serializer, Deserializer
from .version import VERSION
from .operations.face_operations import FaceOperations
from .operations.person_group_person_operations import PersonGroupPersonOperations
from .operations.person_group_operations import PersonGroupOperations
from .operations.face_list_operations import FaceListOperations
from . import models


class FaceAPIConfiguration(Configuration):
    """Configuration for FaceAPI
    Note that all parameters used to create this instance are saved as instance
    attributes.

    :param azure_region: Supported Azure regions for Cognitive Services
     endpoints. Possible values include: 'westus', 'westeurope',
     'southeastasia', 'eastus2', 'westcentralus', 'westus2', 'eastus',
     'southcentralus', 'northeurope', 'eastasia', 'australiaeast',
     'brazilsouth'
    :type azure_region: str or
     ~azure.cognitiveservices.vision.face.models.AzureRegions
    :param credentials: Subscription credentials which uniquely identify
     client subscription.
    :type credentials: None
    """

    def __init__(
            self, azure_region, credentials):

        if azure_region is None:
            raise ValueError("Parameter 'azure_region' must not be None.")
        if credentials is None:
            raise ValueError("Parameter 'credentials' must not be None.")
        base_url = 'https://{AzureRegion}.api.cognitive.microsoft.com/face/v1.0'

        super(FaceAPIConfiguration, self).__init__(base_url)

        self.add_user_agent('azure-cognitiveservices-vision-face/{}'.format(VERSION))

        self.azure_region = azure_region
        self.credentials = credentials


class FaceAPI(object):
    """An API for face detection, verification, and identification.

    :ivar config: Configuration for client.
    :vartype config: FaceAPIConfiguration

    :ivar face: Face operations
    :vartype face: azure.cognitiveservices.vision.face.operations.FaceOperations
    :ivar person_group_person: PersonGroupPerson operations
    :vartype person_group_person: azure.cognitiveservices.vision.face.operations.PersonGroupPersonOperations
    :ivar person_group: PersonGroup operations
    :vartype person_group: azure.cognitiveservices.vision.face.operations.PersonGroupOperations
    :ivar face_list: FaceList operations
    :vartype face_list: azure.cognitiveservices.vision.face.operations.FaceListOperations

    :param azure_region: Supported Azure regions for Cognitive Services
     endpoints. Possible values include: 'westus', 'westeurope',
     'southeastasia', 'eastus2', 'westcentralus', 'westus2', 'eastus',
     'southcentralus', 'northeurope', 'eastasia', 'australiaeast',
     'brazilsouth'
    :type azure_region: str or
     ~azure.cognitiveservices.vision.face.models.AzureRegions
    :param credentials: Subscription credentials which uniquely identify
     client subscription.
    :type credentials: None
    """

    def __init__(
            self, azure_region, credentials):

        self.config = FaceAPIConfiguration(azure_region, credentials)
        self._client = ServiceClient(self.config.credentials, self.config)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self.api_version = '1.0'
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)

        self.face = FaceOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.person_group_person = PersonGroupPersonOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.person_group = PersonGroupOperations(
            self._client, self.config, self._serialize, self._deserialize)
        self.face_list = FaceListOperations(
            self._client, self.config, self._serialize, self._deserialize)
