# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .storage_bundle import StorageBundle


class DeletedStorageBundle(StorageBundle):
    """A deleted storage account bundle consisting of its previous id, attributes
    and its tags, as well as information on when it will be purged.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The storage account id.
    :vartype id: str
    :ivar resource_id: The storage account resource id.
    :vartype resource_id: str
    :ivar active_key_name: The current active storage account key name.
    :vartype active_key_name: str
    :ivar auto_regenerate_key: whether keyvault should manage the storage
     account for the user.
    :vartype auto_regenerate_key: bool
    :ivar regeneration_period: The key regeneration time duration specified in
     ISO-8601 format.
    :vartype regeneration_period: str
    :ivar attributes: The storage account attributes.
    :vartype attributes: ~azure.keyvault.models.StorageAccountAttributes
    :ivar tags: Application specific metadata in the form of key-value pairs
    :vartype tags: dict[str, str]
    :param recovery_id: The url of the recovery object, used to identify and
     recover the deleted storage account.
    :type recovery_id: str
    :ivar scheduled_purge_date: The time when the storage account is scheduled
     to be purged, in UTC
    :vartype scheduled_purge_date: datetime
    :ivar deleted_date: The time when the storage account was deleted, in UTC
    :vartype deleted_date: datetime
    """

    _validation = {
        'id': {'readonly': True},
        'resource_id': {'readonly': True},
        'active_key_name': {'readonly': True},
        'auto_regenerate_key': {'readonly': True},
        'regeneration_period': {'readonly': True},
        'attributes': {'readonly': True},
        'tags': {'readonly': True},
        'scheduled_purge_date': {'readonly': True},
        'deleted_date': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'active_key_name': {'key': 'activeKeyName', 'type': 'str'},
        'auto_regenerate_key': {'key': 'autoRegenerateKey', 'type': 'bool'},
        'regeneration_period': {'key': 'regenerationPeriod', 'type': 'str'},
        'attributes': {'key': 'attributes', 'type': 'StorageAccountAttributes'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'recovery_id': {'key': 'recoveryId', 'type': 'str'},
        'scheduled_purge_date': {'key': 'scheduledPurgeDate', 'type': 'unix-time'},
        'deleted_date': {'key': 'deletedDate', 'type': 'unix-time'},
    }

    def __init__(self, **kwargs):
        super(DeletedStorageBundle, self).__init__(**kwargs)
        self.recovery_id = kwargs.get('recovery_id', None)
        self.scheduled_purge_date = None
        self.deleted_date = None
