# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class AppInsightsReference(Model):
    """Specifies Azure Application Insights information for performance counters
    reporting.

    All required parameters must be populated in order to send to Azure.

    :param component: Required. Specifies the Azure Application Insights
     component resource id.
    :type component: ~azure.mgmt.batchai.models.ResourceId
    :param instrumentation_key: Value of the Azure Application Insights
     instrumentation key.
    :type instrumentation_key: str
    :param instrumentation_key_secret_reference: Specifies a KeyVault Secret
     containing Azure Application Insights instrumentation key. Specifies
     KeyVault Store and Secret which contains Azure Application Insights
     instrumentation key. One of instumentationKey or
     instrumentationKeySecretReference must be specified.
    :type instrumentation_key_secret_reference:
     ~azure.mgmt.batchai.models.KeyVaultSecretReference
    """

    _validation = {
        'component': {'required': True},
    }

    _attribute_map = {
        'component': {'key': 'component', 'type': 'ResourceId'},
        'instrumentation_key': {'key': 'instrumentationKey', 'type': 'str'},
        'instrumentation_key_secret_reference': {'key': 'instrumentationKeySecretReference', 'type': 'KeyVaultSecretReference'},
    }

    def __init__(self, *, component, instrumentation_key: str=None, instrumentation_key_secret_reference=None, **kwargs) -> None:
        super(AppInsightsReference, self).__init__(**kwargs)
        self.component = component
        self.instrumentation_key = instrumentation_key
        self.instrumentation_key_secret_reference = instrumentation_key_secret_reference
