# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .proxy_resource_py3 import ProxyResource


class DatabaseVulnerabilityAssessment(ProxyResource):
    """A database vulnerability assessment.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param storage_container_path: Required. A blob storage container path to
     hold the scan results (e.g.
     https://myStorage.blob.core.windows.net/VaScans/).
    :type storage_container_path: str
    :param storage_container_sas_key: Required. A shared access signature (SAS
     Key) that has write access to the blob container specified in
     'storageContainerPath' parameter.
    :type storage_container_sas_key: str
    :param recurring_scans: The recurring scans settings
    :type recurring_scans:
     ~azure.mgmt.sql.models.VulnerabilityAssessmentRecurringScansProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'storage_container_path': {'required': True},
        'storage_container_sas_key': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'storage_container_path': {'key': 'properties.storageContainerPath', 'type': 'str'},
        'storage_container_sas_key': {'key': 'properties.storageContainerSasKey', 'type': 'str'},
        'recurring_scans': {'key': 'properties.recurringScans', 'type': 'VulnerabilityAssessmentRecurringScansProperties'},
    }

    def __init__(self, *, storage_container_path: str, storage_container_sas_key: str, recurring_scans=None, **kwargs) -> None:
        super(DatabaseVulnerabilityAssessment, self).__init__(**kwargs)
        self.storage_container_path = storage_container_path
        self.storage_container_sas_key = storage_container_sas_key
        self.recurring_scans = recurring_scans
