# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .scaling_mechanism_description import ScalingMechanismDescription


class PartitionInstanceCountScaleMechanism(ScalingMechanismDescription):
    """Represents a scaling mechanism for adding or removing instances of
    stateless service partition.

    All required parameters must be populated in order to send to Azure.

    :param kind: Required. Constant filled by server.
    :type kind: str
    :param min_instance_count: Required. Minimum number of instances of the
     partition.
    :type min_instance_count: int
    :param max_instance_count: Required. Maximum number of instances of the
     partition.
    :type max_instance_count: int
    :param scale_increment: Required. The number of instances to add or remove
     during a scaling operation.
    :type scale_increment: int
    """

    _validation = {
        'kind': {'required': True},
        'min_instance_count': {'required': True},
        'max_instance_count': {'required': True},
        'scale_increment': {'required': True},
    }

    _attribute_map = {
        'kind': {'key': 'Kind', 'type': 'str'},
        'min_instance_count': {'key': 'MinInstanceCount', 'type': 'int'},
        'max_instance_count': {'key': 'MaxInstanceCount', 'type': 'int'},
        'scale_increment': {'key': 'ScaleIncrement', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(PartitionInstanceCountScaleMechanism, self).__init__(**kwargs)
        self.min_instance_count = kwargs.get('min_instance_count', None)
        self.max_instance_count = kwargs.get('max_instance_count', None)
        self.scale_increment = kwargs.get('scale_increment', None)
        self.kind = 'PartitionInstanceCount'
