# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ExecutionStatistics(Model):
    """Description about the errors happen while performing migration validation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar execution_count: No. of query executions
    :vartype execution_count: long
    :ivar cpu_time_ms: CPU Time in millisecond(s) for the query execution
    :vartype cpu_time_ms: float
    :ivar elapsed_time_ms: Time taken in millisecond(s) for executing the
     query
    :vartype elapsed_time_ms: float
    :param wait_stats: Dictionary of sql query execution wait types and the
     respective statistics
    :type wait_stats: dict[str,
     ~azure.mgmt.datamigration.models.WaitStatistics]
    :ivar has_errors: Indicates whether the query resulted in an error
    :vartype has_errors: bool
    :ivar sql_errors: List of sql Errors
    :vartype sql_errors: list[str]
    """

    _validation = {
        'execution_count': {'readonly': True},
        'cpu_time_ms': {'readonly': True},
        'elapsed_time_ms': {'readonly': True},
        'has_errors': {'readonly': True},
        'sql_errors': {'readonly': True},
    }

    _attribute_map = {
        'execution_count': {'key': 'executionCount', 'type': 'long'},
        'cpu_time_ms': {'key': 'cpuTimeMs', 'type': 'float'},
        'elapsed_time_ms': {'key': 'elapsedTimeMs', 'type': 'float'},
        'wait_stats': {'key': 'waitStats', 'type': '{WaitStatistics}'},
        'has_errors': {'key': 'hasErrors', 'type': 'bool'},
        'sql_errors': {'key': 'sqlErrors', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(ExecutionStatistics, self).__init__(**kwargs)
        self.execution_count = None
        self.cpu_time_ms = None
        self.elapsed_time_ms = None
        self.wait_stats = kwargs.get('wait_stats', None)
        self.has_errors = None
        self.sql_errors = None
