# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ReportableException(Model):
    """Exception object for all custom exceptions.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar message: Error message
    :vartype message: str
    :ivar file_path: The path to the file where exception occurred
    :vartype file_path: str
    :ivar line_number: The line number where exception occurred
    :vartype line_number: str
    :ivar h_result: Coded numerical value that is assigned to a specific
     exception
    :vartype h_result: int
    :ivar stack_trace: Stack trace
    :vartype stack_trace: str
    """

    _validation = {
        'message': {'readonly': True},
        'file_path': {'readonly': True},
        'line_number': {'readonly': True},
        'h_result': {'readonly': True},
        'stack_trace': {'readonly': True},
    }

    _attribute_map = {
        'message': {'key': 'message', 'type': 'str'},
        'file_path': {'key': 'filePath', 'type': 'str'},
        'line_number': {'key': 'lineNumber', 'type': 'str'},
        'h_result': {'key': 'hResult', 'type': 'int'},
        'stack_trace': {'key': 'stackTrace', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ReportableException, self).__init__(**kwargs)
        self.message = None
        self.file_path = None
        self.line_number = None
        self.h_result = None
        self.stack_trace = None
