# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class UpgradePolicy(Model):
    """Describes an upgrade policy - automatic, manual, or rolling.

    :param mode: Specifies the mode of an upgrade to virtual machines in the
     scale set.<br /><br /> Possible values are:<br /><br /> **Manual** - You
     control the application of updates to virtual machines in the scale set.
     You do this by using the manualUpgrade action.<br /><br /> **Automatic** -
     All virtual machines in the scale set are  automatically updated at the
     same time. Possible values include: 'Automatic', 'Manual', 'Rolling'
    :type mode: str or ~azure.mgmt.compute.v2019_03_01.models.UpgradeMode
    :param rolling_upgrade_policy: The configuration parameters used while
     performing a rolling upgrade.
    :type rolling_upgrade_policy:
     ~azure.mgmt.compute.v2019_03_01.models.RollingUpgradePolicy
    :param automatic_os_upgrade_policy: Configuration parameters used for
     performing automatic OS Upgrade.
    :type automatic_os_upgrade_policy:
     ~azure.mgmt.compute.v2019_03_01.models.AutomaticOSUpgradePolicy
    """

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'UpgradeMode'},
        'rolling_upgrade_policy': {'key': 'rollingUpgradePolicy', 'type': 'RollingUpgradePolicy'},
        'automatic_os_upgrade_policy': {'key': 'automaticOSUpgradePolicy', 'type': 'AutomaticOSUpgradePolicy'},
    }

    def __init__(self, **kwargs):
        super(UpgradePolicy, self).__init__(**kwargs)
        self.mode = kwargs.get('mode', None)
        self.rolling_upgrade_policy = kwargs.get('rolling_upgrade_policy', None)
        self.automatic_os_upgrade_policy = kwargs.get('automatic_os_upgrade_policy', None)
