# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class AccountListNodeAgentSkusOptions(Model):
    """Additional parameters for list_node_agent_skus operation.

    :param filter: An OData $filter clause. For more information on
     constructing this filter, see
     https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-node-agent-skus.
    :type filter: str
    :param max_results: The maximum number of items to return in the response.
     A maximum of 1000 results will be returned. Default value: 1000 .
    :type max_results: int
    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    """

    _attribute_map = {
        'filter': {'key': '', 'type': 'str'},
        'max_results': {'key': '', 'type': 'int'},
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(AccountListNodeAgentSkusOptions, self).__init__(**kwargs)
        self.filter = kwargs.get('filter', None)
        self.max_results = kwargs.get('max_results', 1000)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)


class AccountListPoolNodeCountsOptions(Model):
    """Additional parameters for list_pool_node_counts operation.

    :param filter: An OData $filter clause. For more information on
     constructing this filter, see
     https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch.
    :type filter: str
    :param max_results: The maximum number of items to return in the response.
     Default value: 10 .
    :type max_results: int
    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    """

    _attribute_map = {
        'filter': {'key': '', 'type': 'str'},
        'max_results': {'key': '', 'type': 'int'},
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(AccountListPoolNodeCountsOptions, self).__init__(**kwargs)
        self.filter = kwargs.get('filter', None)
        self.max_results = kwargs.get('max_results', 10)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)


class AffinityInformation(Model):
    """A locality hint that can be used by the Batch service to select a compute
    node on which to start a task.

    All required parameters must be populated in order to send to Azure.

    :param affinity_id: Required. An opaque string representing the location
     of a compute node or a task that has run previously. You can pass the
     affinityId of a compute node to indicate that this task needs to run on
     that compute node. Note that this is just a soft affinity. If the target
     node is busy or unavailable at the time the task is scheduled, then the
     task will be scheduled elsewhere.
    :type affinity_id: str
    """

    _validation = {
        'affinity_id': {'required': True},
    }

    _attribute_map = {
        'affinity_id': {'key': 'affinityId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AffinityInformation, self).__init__(**kwargs)
        self.affinity_id = kwargs.get('affinity_id', None)


class ApplicationGetOptions(Model):
    """Additional parameters for get operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(ApplicationGetOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)


class ApplicationListOptions(Model):
    """Additional parameters for list operation.

    :param max_results: The maximum number of items to return in the response.
     A maximum of 1000 applications can be returned. Default value: 1000 .
    :type max_results: int
    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    """

    _attribute_map = {
        'max_results': {'key': '', 'type': 'int'},
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(ApplicationListOptions, self).__init__(**kwargs)
        self.max_results = kwargs.get('max_results', 1000)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)


class ApplicationPackageReference(Model):
    """A reference to an application package to be deployed to compute nodes.

    All required parameters must be populated in order to send to Azure.

    :param application_id: Required. The ID of the application to deploy.
    :type application_id: str
    :param version: The version of the application to deploy. If omitted, the
     default version is deployed. If this is omitted on a pool, and no default
     version is specified for this application, the request fails with the
     error code InvalidApplicationPackageReferences and HTTP status code 409.
     If this is omitted on a task, and no default version is specified for this
     application, the task fails with a pre-processing error.
    :type version: str
    """

    _validation = {
        'application_id': {'required': True},
    }

    _attribute_map = {
        'application_id': {'key': 'applicationId', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ApplicationPackageReference, self).__init__(**kwargs)
        self.application_id = kwargs.get('application_id', None)
        self.version = kwargs.get('version', None)


class ApplicationSummary(Model):
    """Contains information about an application in an Azure Batch account.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. A string that uniquely identifies the application
     within the account.
    :type id: str
    :param display_name: Required. The display name for the application.
    :type display_name: str
    :param versions: Required. The list of available versions of the
     application.
    :type versions: list[str]
    """

    _validation = {
        'id': {'required': True},
        'display_name': {'required': True},
        'versions': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'versions': {'key': 'versions', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(ApplicationSummary, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.display_name = kwargs.get('display_name', None)
        self.versions = kwargs.get('versions', None)


class AuthenticationTokenSettings(Model):
    """The settings for an authentication token that the task can use to perform
    Batch service operations.

    :param access: The Batch resources to which the token grants access. The
     authentication token grants access to a limited set of Batch service
     operations. Currently the only supported value for the access property is
     'job', which grants access to all operations related to the job which
     contains the task.
    :type access: list[str or ~azure.batch.models.AccessScope]
    """

    _attribute_map = {
        'access': {'key': 'access', 'type': '[AccessScope]'},
    }

    def __init__(self, **kwargs):
        super(AuthenticationTokenSettings, self).__init__(**kwargs)
        self.access = kwargs.get('access', None)


class AutoPoolSpecification(Model):
    """Specifies characteristics for a temporary 'auto pool'. The Batch service
    will create this auto pool when the job is submitted.

    All required parameters must be populated in order to send to Azure.

    :param auto_pool_id_prefix: A prefix to be added to the unique identifier
     when a pool is automatically created. The Batch service assigns each auto
     pool a unique identifier on creation. To distinguish between pools created
     for different purposes, you can specify this element to add a prefix to
     the ID that is assigned. The prefix can be up to 20 characters long.
    :type auto_pool_id_prefix: str
    :param pool_lifetime_option: Required. The minimum lifetime of created
     auto pools, and how multiple jobs on a schedule are assigned to pools.
     Possible values include: 'jobSchedule', 'job'
    :type pool_lifetime_option: str or ~azure.batch.models.PoolLifetimeOption
    :param keep_alive: Whether to keep an auto pool alive after its lifetime
     expires. If false, the Batch service deletes the pool once its lifetime
     (as determined by the poolLifetimeOption setting) expires; that is, when
     the job or job schedule completes. If true, the Batch service does not
     delete the pool automatically. It is up to the user to delete auto pools
     created with this option.
    :type keep_alive: bool
    :param pool: The pool specification for the auto pool.
    :type pool: ~azure.batch.models.PoolSpecification
    """

    _validation = {
        'pool_lifetime_option': {'required': True},
    }

    _attribute_map = {
        'auto_pool_id_prefix': {'key': 'autoPoolIdPrefix', 'type': 'str'},
        'pool_lifetime_option': {'key': 'poolLifetimeOption', 'type': 'PoolLifetimeOption'},
        'keep_alive': {'key': 'keepAlive', 'type': 'bool'},
        'pool': {'key': 'pool', 'type': 'PoolSpecification'},
    }

    def __init__(self, **kwargs):
        super(AutoPoolSpecification, self).__init__(**kwargs)
        self.auto_pool_id_prefix = kwargs.get('auto_pool_id_prefix', None)
        self.pool_lifetime_option = kwargs.get('pool_lifetime_option', None)
        self.keep_alive = kwargs.get('keep_alive', None)
        self.pool = kwargs.get('pool', None)


class AutoScaleRun(Model):
    """The results and errors from an execution of a pool autoscale formula.

    All required parameters must be populated in order to send to Azure.

    :param timestamp: Required. The time at which the autoscale formula was
     last evaluated.
    :type timestamp: datetime
    :param results: The final values of all variables used in the evaluation
     of the autoscale formula. Each variable value is returned in the form
     $variable=value, and variables are separated by semicolons.
    :type results: str
    :param error: Details of the error encountered evaluating the autoscale
     formula on the pool, if the evaluation was unsuccessful.
    :type error: ~azure.batch.models.AutoScaleRunError
    """

    _validation = {
        'timestamp': {'required': True},
    }

    _attribute_map = {
        'timestamp': {'key': 'timestamp', 'type': 'iso-8601'},
        'results': {'key': 'results', 'type': 'str'},
        'error': {'key': 'error', 'type': 'AutoScaleRunError'},
    }

    def __init__(self, **kwargs):
        super(AutoScaleRun, self).__init__(**kwargs)
        self.timestamp = kwargs.get('timestamp', None)
        self.results = kwargs.get('results', None)
        self.error = kwargs.get('error', None)


class AutoScaleRunError(Model):
    """An error that occurred when executing or evaluating a pool autoscale
    formula.

    :param code: An identifier for the autoscale error. Codes are invariant
     and are intended to be consumed programmatically.
    :type code: str
    :param message: A message describing the autoscale error, intended to be
     suitable for display in a user interface.
    :type message: str
    :param values: A list of additional error details related to the autoscale
     error.
    :type values: list[~azure.batch.models.NameValuePair]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'values': {'key': 'values', 'type': '[NameValuePair]'},
    }

    def __init__(self, **kwargs):
        super(AutoScaleRunError, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.values = kwargs.get('values', None)


class AutoUserSpecification(Model):
    """Specifies the parameters for the auto user that runs a task on the Batch
    service.

    :param scope: The scope for the auto user. The default value is task.
     Possible values include: 'task', 'pool'
    :type scope: str or ~azure.batch.models.AutoUserScope
    :param elevation_level: The elevation level of the auto user. The default
     value is nonAdmin. Possible values include: 'nonAdmin', 'admin'
    :type elevation_level: str or ~azure.batch.models.ElevationLevel
    """

    _attribute_map = {
        'scope': {'key': 'scope', 'type': 'AutoUserScope'},
        'elevation_level': {'key': 'elevationLevel', 'type': 'ElevationLevel'},
    }

    def __init__(self, **kwargs):
        super(AutoUserSpecification, self).__init__(**kwargs)
        self.scope = kwargs.get('scope', None)
        self.elevation_level = kwargs.get('elevation_level', None)


class BatchError(Model):
    """An error response received from the Azure Batch service.

    :param code: An identifier for the error. Codes are invariant and are
     intended to be consumed programmatically.
    :type code: str
    :param message: A message describing the error, intended to be suitable
     for display in a user interface.
    :type message: ~azure.batch.models.ErrorMessage
    :param values: A collection of key-value pairs containing additional
     details about the error.
    :type values: list[~azure.batch.models.BatchErrorDetail]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'ErrorMessage'},
        'values': {'key': 'values', 'type': '[BatchErrorDetail]'},
    }

    def __init__(self, **kwargs):
        super(BatchError, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.values = kwargs.get('values', None)


class BatchErrorException(HttpOperationError):
    """Server responsed with exception of type: 'BatchError'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(BatchErrorException, self).__init__(deserialize, response, 'BatchError', *args)


class BatchErrorDetail(Model):
    """An item of additional information included in an Azure Batch error
    response.

    :param key: An identifier specifying the meaning of the Value property.
    :type key: str
    :param value: The additional information included with the error response.
    :type value: str
    """

    _attribute_map = {
        'key': {'key': 'key', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(BatchErrorDetail, self).__init__(**kwargs)
        self.key = kwargs.get('key', None)
        self.value = kwargs.get('value', None)


class Certificate(Model):
    """A certificate that can be installed on compute nodes and can be used to
    authenticate operations on the machine.

    :param thumbprint: The X.509 thumbprint of the certificate. This is a
     sequence of up to 40 hex digits.
    :type thumbprint: str
    :param thumbprint_algorithm: The algorithm used to derive the thumbprint.
    :type thumbprint_algorithm: str
    :param url: The URL of the certificate.
    :type url: str
    :param state: The current state of the certificate. Possible values
     include: 'active', 'deleting', 'deleteFailed'
    :type state: str or ~azure.batch.models.CertificateState
    :param state_transition_time: The time at which the certificate entered
     its current state.
    :type state_transition_time: datetime
    :param previous_state: The previous state of the certificate. This
     property is not set if the certificate is in its initial active state.
     Possible values include: 'active', 'deleting', 'deleteFailed'
    :type previous_state: str or ~azure.batch.models.CertificateState
    :param previous_state_transition_time: The time at which the certificate
     entered its previous state. This property is not set if the certificate is
     in its initial Active state.
    :type previous_state_transition_time: datetime
    :param public_data: The public part of the certificate as a base-64
     encoded .cer file.
    :type public_data: str
    :param delete_certificate_error: The error that occurred on the last
     attempt to delete this certificate. This property is set only if the
     certificate is in the DeleteFailed state.
    :type delete_certificate_error: ~azure.batch.models.DeleteCertificateError
    """

    _attribute_map = {
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'thumbprint_algorithm': {'key': 'thumbprintAlgorithm', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'state': {'key': 'state', 'type': 'CertificateState'},
        'state_transition_time': {'key': 'stateTransitionTime', 'type': 'iso-8601'},
        'previous_state': {'key': 'previousState', 'type': 'CertificateState'},
        'previous_state_transition_time': {'key': 'previousStateTransitionTime', 'type': 'iso-8601'},
        'public_data': {'key': 'publicData', 'type': 'str'},
        'delete_certificate_error': {'key': 'deleteCertificateError', 'type': 'DeleteCertificateError'},
    }

    def __init__(self, **kwargs):
        super(Certificate, self).__init__(**kwargs)
        self.thumbprint = kwargs.get('thumbprint', None)
        self.thumbprint_algorithm = kwargs.get('thumbprint_algorithm', None)
        self.url = kwargs.get('url', None)
        self.state = kwargs.get('state', None)
        self.state_transition_time = kwargs.get('state_transition_time', None)
        self.previous_state = kwargs.get('previous_state', None)
        self.previous_state_transition_time = kwargs.get('previous_state_transition_time', None)
        self.public_data = kwargs.get('public_data', None)
        self.delete_certificate_error = kwargs.get('delete_certificate_error', None)


class CertificateAddOptions(Model):
    """Additional parameters for add operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(CertificateAddOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)


class CertificateAddParameter(Model):
    """A certificate that can be installed on compute nodes and can be used to
    authenticate operations on the machine.

    All required parameters must be populated in order to send to Azure.

    :param thumbprint: Required. The X.509 thumbprint of the certificate. This
     is a sequence of up to 40 hex digits (it may include spaces but these are
     removed).
    :type thumbprint: str
    :param thumbprint_algorithm: Required. The algorithm used to derive the
     thumbprint. This must be sha1.
    :type thumbprint_algorithm: str
    :param data: Required. The base64-encoded contents of the certificate. The
     maximum size is 10KB.
    :type data: str
    :param certificate_format: The format of the certificate data. Possible
     values include: 'pfx', 'cer'
    :type certificate_format: str or ~azure.batch.models.CertificateFormat
    :param password: The password to access the certificate's private key.
     This is required if the certificate format is pfx. It should be omitted if
     the certificate format is cer.
    :type password: str
    """

    _validation = {
        'thumbprint': {'required': True},
        'thumbprint_algorithm': {'required': True},
        'data': {'required': True},
    }

    _attribute_map = {
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'thumbprint_algorithm': {'key': 'thumbprintAlgorithm', 'type': 'str'},
        'data': {'key': 'data', 'type': 'str'},
        'certificate_format': {'key': 'certificateFormat', 'type': 'CertificateFormat'},
        'password': {'key': 'password', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CertificateAddParameter, self).__init__(**kwargs)
        self.thumbprint = kwargs.get('thumbprint', None)
        self.thumbprint_algorithm = kwargs.get('thumbprint_algorithm', None)
        self.data = kwargs.get('data', None)
        self.certificate_format = kwargs.get('certificate_format', None)
        self.password = kwargs.get('password', None)


class CertificateCancelDeletionOptions(Model):
    """Additional parameters for cancel_deletion operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(CertificateCancelDeletionOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)


class CertificateDeleteOptions(Model):
    """Additional parameters for delete operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(CertificateDeleteOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)


class CertificateGetOptions(Model):
    """Additional parameters for get operation.

    :param select: An OData $select clause.
    :type select: str
    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    """

    _attribute_map = {
        'select': {'key': '', 'type': 'str'},
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(CertificateGetOptions, self).__init__(**kwargs)
        self.select = kwargs.get('select', None)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)


class CertificateListOptions(Model):
    """Additional parameters for list operation.

    :param filter: An OData $filter clause. For more information on
     constructing this filter, see
     https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-certificates.
    :type filter: str
    :param select: An OData $select clause.
    :type select: str
    :param max_results: The maximum number of items to return in the response.
     A maximum of 1000 certificates can be returned. Default value: 1000 .
    :type max_results: int
    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    """

    _attribute_map = {
        'filter': {'key': '', 'type': 'str'},
        'select': {'key': '', 'type': 'str'},
        'max_results': {'key': '', 'type': 'int'},
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(CertificateListOptions, self).__init__(**kwargs)
        self.filter = kwargs.get('filter', None)
        self.select = kwargs.get('select', None)
        self.max_results = kwargs.get('max_results', 1000)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)


class CertificateReference(Model):
    """A reference to a certificate to be installed on compute nodes in a pool.

    All required parameters must be populated in order to send to Azure.

    :param thumbprint: Required. The thumbprint of the certificate.
    :type thumbprint: str
    :param thumbprint_algorithm: Required. The algorithm with which the
     thumbprint is associated. This must be sha1.
    :type thumbprint_algorithm: str
    :param store_location: The location of the certificate store on the
     compute node into which to install the certificate. The default value is
     currentuser. This property is applicable only for pools configured with
     Windows nodes (that is, created with cloudServiceConfiguration, or with
     virtualMachineConfiguration using a Windows image reference). For Linux
     compute nodes, the certificates are stored in a directory inside the task
     working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is
     supplied to the task to query for this location. For certificates with
     visibility of 'remoteUser', a 'certs' directory is created in the user's
     home directory (e.g., /home/{user-name}/certs) and certificates are placed
     in that directory. Possible values include: 'currentUser', 'localMachine'
    :type store_location: str or ~azure.batch.models.CertificateStoreLocation
    :param store_name: The name of the certificate store on the compute node
     into which to install the certificate. This property is applicable only
     for pools configured with Windows nodes (that is, created with
     cloudServiceConfiguration, or with virtualMachineConfiguration using a
     Windows image reference). Common store names include: My, Root, CA, Trust,
     Disallowed, TrustedPeople, TrustedPublisher, AuthRoot, AddressBook, but
     any custom store name can also be used. The default value is My.
    :type store_name: str
    :param visibility: Which user accounts on the compute node should have
     access to the private data of the certificate. You can specify more than
     one visibility in this collection. The default is all accounts.
    :type visibility: list[str or ~azure.batch.models.CertificateVisibility]
    """

    _validation = {
        'thumbprint': {'required': True},
        'thumbprint_algorithm': {'required': True},
    }

    _attribute_map = {
        'thumbprint': {'key': 'thumbprint', 'type': 'str'},
        'thumbprint_algorithm': {'key': 'thumbprintAlgorithm', 'type': 'str'},
        'store_location': {'key': 'storeLocation', 'type': 'CertificateStoreLocation'},
        'store_name': {'key': 'storeName', 'type': 'str'},
        'visibility': {'key': 'visibility', 'type': '[CertificateVisibility]'},
    }

    def __init__(self, **kwargs):
        super(CertificateReference, self).__init__(**kwargs)
        self.thumbprint = kwargs.get('thumbprint', None)
        self.thumbprint_algorithm = kwargs.get('thumbprint_algorithm', None)
        self.store_location = kwargs.get('store_location', None)
        self.store_name = kwargs.get('store_name', None)
        self.visibility = kwargs.get('visibility', None)


class CloudJob(Model):
    """An Azure Batch job.

    :param id: A string that uniquely identifies the job within the account.
     The ID is case-preserving and case-insensitive (that is, you may not have
     two IDs within an account that differ only by case).
    :type id: str
    :param display_name: The display name for the job.
    :type display_name: str
    :param uses_task_dependencies: Whether tasks in the job can define
     dependencies on each other. The default is false.
    :type uses_task_dependencies: bool
    :param url: The URL of the job.
    :type url: str
    :param e_tag: The ETag of the job. This is an opaque string. You can use
     it to detect whether the job has changed between requests. In particular,
     you can be pass the ETag when updating a job to specify that your changes
     should take effect only if nobody else has modified the job in the
     meantime.
    :type e_tag: str
    :param last_modified: The last modified time of the job. This is the last
     time at which the job level data, such as the job state or priority,
     changed. It does not factor in task-level changes such as adding new tasks
     or tasks changing state.
    :type last_modified: datetime
    :param creation_time: The creation time of the job.
    :type creation_time: datetime
    :param state: The current state of the job. Possible values include:
     'active', 'disabling', 'disabled', 'enabling', 'terminating', 'completed',
     'deleting'
    :type state: str or ~azure.batch.models.JobState
    :param state_transition_time: The time at which the job entered its
     current state.
    :type state_transition_time: datetime
    :param previous_state: The previous state of the job. This property is not
     set if the job is in its initial Active state. Possible values include:
     'active', 'disabling', 'disabled', 'enabling', 'terminating', 'completed',
     'deleting'
    :type previous_state: str or ~azure.batch.models.JobState
    :param previous_state_transition_time: The time at which the job entered
     its previous state. This property is not set if the job is in its initial
     Active state.
    :type previous_state_transition_time: datetime
    :param priority: The priority of the job. Priority values can range from
     -1000 to 1000, with -1000 being the lowest priority and 1000 being the
     highest priority. The default value is 0.
    :type priority: int
    :param constraints: The execution constraints for the job.
    :type constraints: ~azure.batch.models.JobConstraints
    :param job_manager_task: Details of a Job Manager task to be launched when
     the job is started.
    :type job_manager_task: ~azure.batch.models.JobManagerTask
    :param job_preparation_task: The Job Preparation task. The Job Preparation
     task is a special task run on each node before any other task of the job.
    :type job_preparation_task: ~azure.batch.models.JobPreparationTask
    :param job_release_task: The Job Release task. The Job Release task is a
     special task run at the end of the job on each node that has run any other
     task of the job.
    :type job_release_task: ~azure.batch.models.JobReleaseTask
    :param common_environment_settings: The list of common environment
     variable settings. These environment variables are set for all tasks in
     the job (including the Job Manager, Job Preparation and Job Release
     tasks). Individual tasks can override an environment setting specified
     here by specifying the same setting name with a different value.
    :type common_environment_settings:
     list[~azure.batch.models.EnvironmentSetting]
    :param pool_info: The pool settings associated with the job.
    :type pool_info: ~azure.batch.models.PoolInformation
    :param on_all_tasks_complete: The action the Batch service should take
     when all tasks in the job are in the completed state. The default is
     noaction. Possible values include: 'noAction', 'terminateJob'
    :type on_all_tasks_complete: str or ~azure.batch.models.OnAllTasksComplete
    :param on_task_failure: The action the Batch service should take when any
     task in the job fails. A task is considered to have failed if has a
     failureInfo. A failureInfo is set if the task completes with a non-zero
     exit code after exhausting its retry count, or if there was an error
     starting the task, for example due to a resource file download error. The
     default is noaction. Possible values include: 'noAction',
     'performExitOptionsJobAction'
    :type on_task_failure: str or ~azure.batch.models.OnTaskFailure
    :param network_configuration: The network configuration for the job.
    :type network_configuration: ~azure.batch.models.JobNetworkConfiguration
    :param metadata: A list of name-value pairs associated with the job as
     metadata. The Batch service does not assign any meaning to metadata; it is
     solely for the use of user code.
    :type metadata: list[~azure.batch.models.MetadataItem]
    :param execution_info: The execution information for the job.
    :type execution_info: ~azure.batch.models.JobExecutionInformation
    :param stats: Resource usage statistics for the entire lifetime of the
     job. The statistics may not be immediately available. The Batch service
     performs periodic roll-up of statistics. The typical delay is about 30
     minutes.
    :type stats: ~azure.batch.models.JobStatistics
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'uses_task_dependencies': {'key': 'usesTaskDependencies', 'type': 'bool'},
        'url': {'key': 'url', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'last_modified': {'key': 'lastModified', 'type': 'iso-8601'},
        'creation_time': {'key': 'creationTime', 'type': 'iso-8601'},
        'state': {'key': 'state', 'type': 'JobState'},
        'state_transition_time': {'key': 'stateTransitionTime', 'type': 'iso-8601'},
        'previous_state': {'key': 'previousState', 'type': 'JobState'},
        'previous_state_transition_time': {'key': 'previousStateTransitionTime', 'type': 'iso-8601'},
        'priority': {'key': 'priority', 'type': 'int'},
        'constraints': {'key': 'constraints', 'type': 'JobConstraints'},
        'job_manager_task': {'key': 'jobManagerTask', 'type': 'JobManagerTask'},
        'job_preparation_task': {'key': 'jobPreparationTask', 'type': 'JobPreparationTask'},
        'job_release_task': {'key': 'jobReleaseTask', 'type': 'JobReleaseTask'},
        'common_environment_settings': {'key': 'commonEnvironmentSettings', 'type': '[EnvironmentSetting]'},
        'pool_info': {'key': 'poolInfo', 'type': 'PoolInformation'},
        'on_all_tasks_complete': {'key': 'onAllTasksComplete', 'type': 'OnAllTasksComplete'},
        'on_task_failure': {'key': 'onTaskFailure', 'type': 'OnTaskFailure'},
        'network_configuration': {'key': 'networkConfiguration', 'type': 'JobNetworkConfiguration'},
        'metadata': {'key': 'metadata', 'type': '[MetadataItem]'},
        'execution_info': {'key': 'executionInfo', 'type': 'JobExecutionInformation'},
        'stats': {'key': 'stats', 'type': 'JobStatistics'},
    }

    def __init__(self, **kwargs):
        super(CloudJob, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.display_name = kwargs.get('display_name', None)
        self.uses_task_dependencies = kwargs.get('uses_task_dependencies', None)
        self.url = kwargs.get('url', None)
        self.e_tag = kwargs.get('e_tag', None)
        self.last_modified = kwargs.get('last_modified', None)
        self.creation_time = kwargs.get('creation_time', None)
        self.state = kwargs.get('state', None)
        self.state_transition_time = kwargs.get('state_transition_time', None)
        self.previous_state = kwargs.get('previous_state', None)
        self.previous_state_transition_time = kwargs.get('previous_state_transition_time', None)
        self.priority = kwargs.get('priority', None)
        self.constraints = kwargs.get('constraints', None)
        self.job_manager_task = kwargs.get('job_manager_task', None)
        self.job_preparation_task = kwargs.get('job_preparation_task', None)
        self.job_release_task = kwargs.get('job_release_task', None)
        self.common_environment_settings = kwargs.get('common_environment_settings', None)
        self.pool_info = kwargs.get('pool_info', None)
        self.on_all_tasks_complete = kwargs.get('on_all_tasks_complete', None)
        self.on_task_failure = kwargs.get('on_task_failure', None)
        self.network_configuration = kwargs.get('network_configuration', None)
        self.metadata = kwargs.get('metadata', None)
        self.execution_info = kwargs.get('execution_info', None)
        self.stats = kwargs.get('stats', None)


class CloudJobSchedule(Model):
    """A job schedule that allows recurring jobs by specifying when to run jobs
    and a specification used to create each job.

    :param id: A string that uniquely identifies the schedule within the
     account.
    :type id: str
    :param display_name: The display name for the schedule.
    :type display_name: str
    :param url: The URL of the job schedule.
    :type url: str
    :param e_tag: The ETag of the job schedule. This is an opaque string. You
     can use it to detect whether the job schedule has changed between
     requests. In particular, you can be pass the ETag with an Update Job
     Schedule request to specify that your changes should take effect only if
     nobody else has modified the schedule in the meantime.
    :type e_tag: str
    :param last_modified: The last modified time of the job schedule. This is
     the last time at which the schedule level data, such as the job
     specification or recurrence information, changed. It does not factor in
     job-level changes such as new jobs being created or jobs changing state.
    :type last_modified: datetime
    :param creation_time: The creation time of the job schedule.
    :type creation_time: datetime
    :param state: The current state of the job schedule. Possible values
     include: 'active', 'completed', 'disabled', 'terminating', 'deleting'
    :type state: str or ~azure.batch.models.JobScheduleState
    :param state_transition_time: The time at which the job schedule entered
     the current state.
    :type state_transition_time: datetime
    :param previous_state: The previous state of the job schedule. This
     property is not present if the job schedule is in its initial active
     state. Possible values include: 'active', 'completed', 'disabled',
     'terminating', 'deleting'
    :type previous_state: str or ~azure.batch.models.JobScheduleState
    :param previous_state_transition_time: The time at which the job schedule
     entered its previous state. This property is not present if the job
     schedule is in its initial active state.
    :type previous_state_transition_time: datetime
    :param schedule: The schedule according to which jobs will be created.
    :type schedule: ~azure.batch.models.Schedule
    :param job_specification: The details of the jobs to be created on this
     schedule.
    :type job_specification: ~azure.batch.models.JobSpecification
    :param execution_info: Information about jobs that have been and will be
     run under this schedule.
    :type execution_info: ~azure.batch.models.JobScheduleExecutionInformation
    :param metadata: A list of name-value pairs associated with the schedule
     as metadata. The Batch service does not assign any meaning to metadata; it
     is solely for the use of user code.
    :type metadata: list[~azure.batch.models.MetadataItem]
    :param stats: The lifetime resource usage statistics for the job schedule.
     The statistics may not be immediately available. The Batch service
     performs periodic roll-up of statistics. The typical delay is about 30
     minutes.
    :type stats: ~azure.batch.models.JobScheduleStatistics
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'last_modified': {'key': 'lastModified', 'type': 'iso-8601'},
        'creation_time': {'key': 'creationTime', 'type': 'iso-8601'},
        'state': {'key': 'state', 'type': 'JobScheduleState'},
        'state_transition_time': {'key': 'stateTransitionTime', 'type': 'iso-8601'},
        'previous_state': {'key': 'previousState', 'type': 'JobScheduleState'},
        'previous_state_transition_time': {'key': 'previousStateTransitionTime', 'type': 'iso-8601'},
        'schedule': {'key': 'schedule', 'type': 'Schedule'},
        'job_specification': {'key': 'jobSpecification', 'type': 'JobSpecification'},
        'execution_info': {'key': 'executionInfo', 'type': 'JobScheduleExecutionInformation'},
        'metadata': {'key': 'metadata', 'type': '[MetadataItem]'},
        'stats': {'key': 'stats', 'type': 'JobScheduleStatistics'},
    }

    def __init__(self, **kwargs):
        super(CloudJobSchedule, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.display_name = kwargs.get('display_name', None)
        self.url = kwargs.get('url', None)
        self.e_tag = kwargs.get('e_tag', None)
        self.last_modified = kwargs.get('last_modified', None)
        self.creation_time = kwargs.get('creation_time', None)
        self.state = kwargs.get('state', None)
        self.state_transition_time = kwargs.get('state_transition_time', None)
        self.previous_state = kwargs.get('previous_state', None)
        self.previous_state_transition_time = kwargs.get('previous_state_transition_time', None)
        self.schedule = kwargs.get('schedule', None)
        self.job_specification = kwargs.get('job_specification', None)
        self.execution_info = kwargs.get('execution_info', None)
        self.metadata = kwargs.get('metadata', None)
        self.stats = kwargs.get('stats', None)


class CloudPool(Model):
    """A pool in the Azure Batch service.

    :param id: A string that uniquely identifies the pool within the account.
     The ID can contain any combination of alphanumeric characters including
     hyphens and underscores, and cannot contain more than 64 characters. The
     ID is case-preserving and case-insensitive (that is, you may not have two
     IDs within an account that differ only by case).
    :type id: str
    :param display_name: The display name for the pool. The display name need
     not be unique and can contain any Unicode characters up to a maximum
     length of 1024.
    :type display_name: str
    :param url: The URL of the pool.
    :type url: str
    :param e_tag: The ETag of the pool. This is an opaque string. You can use
     it to detect whether the pool has changed between requests. In particular,
     you can be pass the ETag when updating a pool to specify that your changes
     should take effect only if nobody else has modified the pool in the
     meantime.
    :type e_tag: str
    :param last_modified: The last modified time of the pool. This is the last
     time at which the pool level data, such as the targetDedicatedNodes or
     enableAutoscale settings, changed. It does not factor in node-level
     changes such as a compute node changing state.
    :type last_modified: datetime
    :param creation_time: The creation time of the pool.
    :type creation_time: datetime
    :param state: The current state of the pool. Possible values include:
     'active', 'deleting'
    :type state: str or ~azure.batch.models.PoolState
    :param state_transition_time: The time at which the pool entered its
     current state.
    :type state_transition_time: datetime
    :param allocation_state: Whether the pool is resizing. Possible values
     include: 'steady', 'resizing', 'stopping'
    :type allocation_state: str or ~azure.batch.models.AllocationState
    :param allocation_state_transition_time: The time at which the pool
     entered its current allocation state.
    :type allocation_state_transition_time: datetime
    :param vm_size: The size of virtual machines in the pool. All virtual
     machines in a pool are the same size. For information about available
     sizes of virtual machines in pools, see Choose a VM size for compute nodes
     in an Azure Batch pool
     (https://docs.microsoft.com/azure/batch/batch-pool-vm-sizes).
    :type vm_size: str
    :param cloud_service_configuration: The cloud service configuration for
     the pool. This property and virtualMachineConfiguration are mutually
     exclusive and one of the properties must be specified. This property
     cannot be specified if the Batch account was created with its
     poolAllocationMode property set to 'UserSubscription'.
    :type cloud_service_configuration:
     ~azure.batch.models.CloudServiceConfiguration
    :param virtual_machine_configuration: The virtual machine configuration
     for the pool. This property and cloudServiceConfiguration are mutually
     exclusive and one of the properties must be specified.
    :type virtual_machine_configuration:
     ~azure.batch.models.VirtualMachineConfiguration
    :param resize_timeout: The timeout for allocation of compute nodes to the
     pool. This is the timeout for the most recent resize operation. (The
     initial sizing when the pool is created counts as a resize.) The default
     value is 15 minutes.
    :type resize_timeout: timedelta
    :param resize_errors: A list of errors encountered while performing the
     last resize on the pool. This property is set only if one or more errors
     occurred during the last pool resize, and only when the pool
     allocationState is Steady.
    :type resize_errors: list[~azure.batch.models.ResizeError]
    :param current_dedicated_nodes: The number of dedicated compute nodes
     currently in the pool.
    :type current_dedicated_nodes: int
    :param current_low_priority_nodes: The number of low-priority compute
     nodes currently in the pool. Low-priority compute nodes which have been
     preempted are included in this count.
    :type current_low_priority_nodes: int
    :param target_dedicated_nodes: The desired number of dedicated compute
     nodes in the pool.
    :type target_dedicated_nodes: int
    :param target_low_priority_nodes: The desired number of low-priority
     compute nodes in the pool.
    :type target_low_priority_nodes: int
    :param enable_auto_scale: Whether the pool size should automatically
     adjust over time. If false, at least one of targetDedicateNodes and
     targetLowPriorityNodes must be specified. If true, the autoScaleFormula
     property is required and the pool automatically resizes according to the
     formula. The default value is false.
    :type enable_auto_scale: bool
    :param auto_scale_formula: A formula for the desired number of compute
     nodes in the pool. This property is set only if the pool automatically
     scales, i.e. enableAutoScale is true.
    :type auto_scale_formula: str
    :param auto_scale_evaluation_interval: The time interval at which to
     automatically adjust the pool size according to the autoscale formula.
     This property is set only if the pool automatically scales, i.e.
     enableAutoScale is true.
    :type auto_scale_evaluation_interval: timedelta
    :param auto_scale_run: The results and errors from the last execution of
     the autoscale formula. This property is set only if the pool automatically
     scales, i.e. enableAutoScale is true.
    :type auto_scale_run: ~azure.batch.models.AutoScaleRun
    :param enable_inter_node_communication: Whether the pool permits direct
     communication between nodes. This imposes restrictions on which nodes can
     be assigned to the pool. Specifying this value can reduce the chance of
     the requested number of nodes to be allocated in the pool.
    :type enable_inter_node_communication: bool
    :param network_configuration: The network configuration for the pool.
    :type network_configuration: ~azure.batch.models.NetworkConfiguration
    :param start_task: A task specified to run on each compute node as it
     joins the pool.
    :type start_task: ~azure.batch.models.StartTask
    :param certificate_references: The list of certificates to be installed on
     each compute node in the pool. For Windows compute nodes, the Batch
     service installs the certificates to the specified certificate store and
     location. For Linux compute nodes, the certificates are stored in a
     directory inside the task working directory and an environment variable
     AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this
     location. For certificates with visibility of 'remoteUser', a 'certs'
     directory is created in the user's home directory (e.g.,
     /home/{user-name}/certs) and certificates are placed in that directory.
    :type certificate_references:
     list[~azure.batch.models.CertificateReference]
    :param application_package_references: The list of application packages to
     be installed on each compute node in the pool.
    :type application_package_references:
     list[~azure.batch.models.ApplicationPackageReference]
    :param application_licenses: The list of application licenses the Batch
     service will make available on each compute node in the pool. The list of
     application licenses must be a subset of available Batch service
     application licenses. If a license is requested which is not supported,
     pool creation will fail.
    :type application_licenses: list[str]
    :param max_tasks_per_node: The maximum number of tasks that can run
     concurrently on a single compute node in the pool.
    :type max_tasks_per_node: int
    :param task_scheduling_policy: How tasks are distributed across compute
     nodes in a pool.
    :type task_scheduling_policy: ~azure.batch.models.TaskSchedulingPolicy
    :param user_accounts: The list of user accounts to be created on each node
     in the pool.
    :type user_accounts: list[~azure.batch.models.UserAccount]
    :param metadata: A list of name-value pairs associated with the pool as
     metadata.
    :type metadata: list[~azure.batch.models.MetadataItem]
    :param stats: Utilization and resource usage statistics for the entire
     lifetime of the pool. The statistics may not be immediately available. The
     Batch service performs periodic roll-up of statistics. The typical delay
     is about 30 minutes.
    :type stats: ~azure.batch.models.PoolStatistics
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'last_modified': {'key': 'lastModified', 'type': 'iso-8601'},
        'creation_time': {'key': 'creationTime', 'type': 'iso-8601'},
        'state': {'key': 'state', 'type': 'PoolState'},
        'state_transition_time': {'key': 'stateTransitionTime', 'type': 'iso-8601'},
        'allocation_state': {'key': 'allocationState', 'type': 'AllocationState'},
        'allocation_state_transition_time': {'key': 'allocationStateTransitionTime', 'type': 'iso-8601'},
        'vm_size': {'key': 'vmSize', 'type': 'str'},
        'cloud_service_configuration': {'key': 'cloudServiceConfiguration', 'type': 'CloudServiceConfiguration'},
        'virtual_machine_configuration': {'key': 'virtualMachineConfiguration', 'type': 'VirtualMachineConfiguration'},
        'resize_timeout': {'key': 'resizeTimeout', 'type': 'duration'},
        'resize_errors': {'key': 'resizeErrors', 'type': '[ResizeError]'},
        'current_dedicated_nodes': {'key': 'currentDedicatedNodes', 'type': 'int'},
        'current_low_priority_nodes': {'key': 'currentLowPriorityNodes', 'type': 'int'},
        'target_dedicated_nodes': {'key': 'targetDedicatedNodes', 'type': 'int'},
        'target_low_priority_nodes': {'key': 'targetLowPriorityNodes', 'type': 'int'},
        'enable_auto_scale': {'key': 'enableAutoScale', 'type': 'bool'},
        'auto_scale_formula': {'key': 'autoScaleFormula', 'type': 'str'},
        'auto_scale_evaluation_interval': {'key': 'autoScaleEvaluationInterval', 'type': 'duration'},
        'auto_scale_run': {'key': 'autoScaleRun', 'type': 'AutoScaleRun'},
        'enable_inter_node_communication': {'key': 'enableInterNodeCommunication', 'type': 'bool'},
        'network_configuration': {'key': 'networkConfiguration', 'type': 'NetworkConfiguration'},
        'start_task': {'key': 'startTask', 'type': 'StartTask'},
        'certificate_references': {'key': 'certificateReferences', 'type': '[CertificateReference]'},
        'application_package_references': {'key': 'applicationPackageReferences', 'type': '[ApplicationPackageReference]'},
        'application_licenses': {'key': 'applicationLicenses', 'type': '[str]'},
        'max_tasks_per_node': {'key': 'maxTasksPerNode', 'type': 'int'},
        'task_scheduling_policy': {'key': 'taskSchedulingPolicy', 'type': 'TaskSchedulingPolicy'},
        'user_accounts': {'key': 'userAccounts', 'type': '[UserAccount]'},
        'metadata': {'key': 'metadata', 'type': '[MetadataItem]'},
        'stats': {'key': 'stats', 'type': 'PoolStatistics'},
    }

    def __init__(self, **kwargs):
        super(CloudPool, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.display_name = kwargs.get('display_name', None)
        self.url = kwargs.get('url', None)
        self.e_tag = kwargs.get('e_tag', None)
        self.last_modified = kwargs.get('last_modified', None)
        self.creation_time = kwargs.get('creation_time', None)
        self.state = kwargs.get('state', None)
        self.state_transition_time = kwargs.get('state_transition_time', None)
        self.allocation_state = kwargs.get('allocation_state', None)
        self.allocation_state_transition_time = kwargs.get('allocation_state_transition_time', None)
        self.vm_size = kwargs.get('vm_size', None)
        self.cloud_service_configuration = kwargs.get('cloud_service_configuration', None)
        self.virtual_machine_configuration = kwargs.get('virtual_machine_configuration', None)
        self.resize_timeout = kwargs.get('resize_timeout', None)
        self.resize_errors = kwargs.get('resize_errors', None)
        self.current_dedicated_nodes = kwargs.get('current_dedicated_nodes', None)
        self.current_low_priority_nodes = kwargs.get('current_low_priority_nodes', None)
        self.target_dedicated_nodes = kwargs.get('target_dedicated_nodes', None)
        self.target_low_priority_nodes = kwargs.get('target_low_priority_nodes', None)
        self.enable_auto_scale = kwargs.get('enable_auto_scale', None)
        self.auto_scale_formula = kwargs.get('auto_scale_formula', None)
        self.auto_scale_evaluation_interval = kwargs.get('auto_scale_evaluation_interval', None)
        self.auto_scale_run = kwargs.get('auto_scale_run', None)
        self.enable_inter_node_communication = kwargs.get('enable_inter_node_communication', None)
        self.network_configuration = kwargs.get('network_configuration', None)
        self.start_task = kwargs.get('start_task', None)
        self.certificate_references = kwargs.get('certificate_references', None)
        self.application_package_references = kwargs.get('application_package_references', None)
        self.application_licenses = kwargs.get('application_licenses', None)
        self.max_tasks_per_node = kwargs.get('max_tasks_per_node', None)
        self.task_scheduling_policy = kwargs.get('task_scheduling_policy', None)
        self.user_accounts = kwargs.get('user_accounts', None)
        self.metadata = kwargs.get('metadata', None)
        self.stats = kwargs.get('stats', None)


class CloudServiceConfiguration(Model):
    """The configuration for nodes in a pool based on the Azure Cloud Services
    platform.

    All required parameters must be populated in order to send to Azure.

    :param os_family: Required. The Azure Guest OS family to be installed on
     the virtual machines in the pool. Possible values are:
     2 - OS Family 2, equivalent to Windows Server 2008 R2 SP1.
     3 - OS Family 3, equivalent to Windows Server 2012.
     4 - OS Family 4, equivalent to Windows Server 2012 R2.
     5 - OS Family 5, equivalent to Windows Server 2016. For more information,
     see Azure Guest OS Releases
     (https://azure.microsoft.com/documentation/articles/cloud-services-guestos-update-matrix/#releases).
    :type os_family: str
    :param os_version: The Azure Guest OS version to be installed on the
     virtual machines in the pool. The default value is * which specifies the
     latest operating system version for the specified OS family.
    :type os_version: str
    """

    _validation = {
        'os_family': {'required': True},
    }

    _attribute_map = {
        'os_family': {'key': 'osFamily', 'type': 'str'},
        'os_version': {'key': 'osVersion', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CloudServiceConfiguration, self).__init__(**kwargs)
        self.os_family = kwargs.get('os_family', None)
        self.os_version = kwargs.get('os_version', None)


class CloudTask(Model):
    """An Azure Batch task.

    Batch will retry tasks when a recovery operation is triggered on a compute
    node. Examples of recovery operations include (but are not limited to) when
    an unhealthy compute node is rebooted or a compute node disappeared due to
    host failure. Retries due to recovery operations are independent of and are
    not counted against the maxTaskRetryCount. Even if the maxTaskRetryCount is
    0, an internal retry due to a recovery operation may occur. Because of
    this, all tasks should be idempotent. This means tasks need to tolerate
    being interrupted and restarted without causing any corruption or duplicate
    data. The best practice for long running tasks is to use some form of
    checkpointing.

    :param id: A string that uniquely identifies the task within the job. The
     ID can contain any combination of alphanumeric characters including
     hyphens and underscores, and cannot contain more than 64 characters.
    :type id: str
    :param display_name: A display name for the task. The display name need
     not be unique and can contain any Unicode characters up to a maximum
     length of 1024.
    :type display_name: str
    :param url: The URL of the task.
    :type url: str
    :param e_tag: The ETag of the task. This is an opaque string. You can use
     it to detect whether the task has changed between requests. In particular,
     you can be pass the ETag when updating a task to specify that your changes
     should take effect only if nobody else has modified the task in the
     meantime.
    :type e_tag: str
    :param last_modified: The last modified time of the task.
    :type last_modified: datetime
    :param creation_time: The creation time of the task.
    :type creation_time: datetime
    :param exit_conditions: How the Batch service should respond when the task
     completes.
    :type exit_conditions: ~azure.batch.models.ExitConditions
    :param state: The current state of the task. Possible values include:
     'active', 'preparing', 'running', 'completed'
    :type state: str or ~azure.batch.models.TaskState
    :param state_transition_time: The time at which the task entered its
     current state.
    :type state_transition_time: datetime
    :param previous_state: The previous state of the task. This property is
     not set if the task is in its initial Active state. Possible values
     include: 'active', 'preparing', 'running', 'completed'
    :type previous_state: str or ~azure.batch.models.TaskState
    :param previous_state_transition_time: The time at which the task entered
     its previous state. This property is not set if the task is in its initial
     Active state.
    :type previous_state_transition_time: datetime
    :param command_line: The command line of the task. For multi-instance
     tasks, the command line is executed as the primary task, after the primary
     task and all subtasks have finished executing the coordination command
     line. The command line does not run under a shell, and therefore cannot
     take advantage of shell features such as environment variable expansion.
     If you want to take advantage of such features, you should invoke the
     shell in the command line, for example using "cmd /c MyCommand" in Windows
     or "/bin/sh -c MyCommand" in Linux. If the command line refers to file
     paths, it should use a relative path (relative to the task working
     directory), or use the Batch provided environment variable
     (https://docs.microsoft.com/en-us/azure/batch/batch-compute-node-environment-variables).
    :type command_line: str
    :param container_settings: The settings for the container under which the
     task runs. If the pool that will run this task has containerConfiguration
     set, this must be set as well. If the pool that will run this task doesn't
     have containerConfiguration set, this must not be set. When this is
     specified, all directories recursively below the AZ_BATCH_NODE_ROOT_DIR
     (the root of Azure Batch directories on the node) are mapped into the
     container, all task environment variables are mapped into the container,
     and the task command line is executed in the container.
    :type container_settings: ~azure.batch.models.TaskContainerSettings
    :param resource_files: A list of files that the Batch service will
     download to the compute node before running the command line. For
     multi-instance tasks, the resource files will only be downloaded to the
     compute node on which the primary task is executed. There is a maximum
     size for the list of resource files.  When the max size is exceeded, the
     request will fail and the response error code will be
     RequestEntityTooLarge. If this occurs, the collection of ResourceFiles
     must be reduced in size. This can be achieved using .zip files,
     Application Packages, or Docker Containers.
    :type resource_files: list[~azure.batch.models.ResourceFile]
    :param output_files: A list of files that the Batch service will upload
     from the compute node after running the command line. For multi-instance
     tasks, the files will only be uploaded from the compute node on which the
     primary task is executed.
    :type output_files: list[~azure.batch.models.OutputFile]
    :param environment_settings: A list of environment variable settings for
     the task.
    :type environment_settings: list[~azure.batch.models.EnvironmentSetting]
    :param affinity_info: A locality hint that can be used by the Batch
     service to select a compute node on which to start the new task.
    :type affinity_info: ~azure.batch.models.AffinityInformation
    :param constraints: The execution constraints that apply to this task.
    :type constraints: ~azure.batch.models.TaskConstraints
    :param user_identity: The user identity under which the task runs. If
     omitted, the task runs as a non-administrative user unique to the task.
    :type user_identity: ~azure.batch.models.UserIdentity
    :param execution_info: Information about the execution of the task.
    :type execution_info: ~azure.batch.models.TaskExecutionInformation
    :param node_info: Information about the compute node on which the task
     ran.
    :type node_info: ~azure.batch.models.ComputeNodeInformation
    :param multi_instance_settings: An object that indicates that the task is
     a multi-instance task, and contains information about how to run the
     multi-instance task.
    :type multi_instance_settings: ~azure.batch.models.MultiInstanceSettings
    :param stats: Resource usage statistics for the task.
    :type stats: ~azure.batch.models.TaskStatistics
    :param depends_on: The tasks that this task depends on. This task will not
     be scheduled until all tasks that it depends on have completed
     successfully. If any of those tasks fail and exhaust their retry counts,
     this task will never be scheduled.
    :type depends_on: ~azure.batch.models.TaskDependencies
    :param application_package_references: A list of application packages that
     the Batch service will deploy to the compute node before running the
     command line. Application packages are downloaded and deployed to a shared
     directory, not the task working directory. Therefore, if a referenced
     package is already on the compute node, and is up to date, then it is not
     re-downloaded; the existing copy on the compute node is used. If a
     referenced application package cannot be installed, for example because
     the package has been deleted or because download failed, the task fails.
    :type application_package_references:
     list[~azure.batch.models.ApplicationPackageReference]
    :param authentication_token_settings: The settings for an authentication
     token that the task can use to perform Batch service operations. If this
     property is set, the Batch service provides the task with an
     authentication token which can be used to authenticate Batch service
     operations without requiring an account access key. The token is provided
     via the AZ_BATCH_AUTHENTICATION_TOKEN environment variable. The operations
     that the task can carry out using the token depend on the settings. For
     example, a task can request job permissions in order to add other tasks to
     the job, or check the status of the job or of other tasks under the job.
    :type authentication_token_settings:
     ~azure.batch.models.AuthenticationTokenSettings
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'last_modified': {'key': 'lastModified', 'type': 'iso-8601'},
        'creation_time': {'key': 'creationTime', 'type': 'iso-8601'},
        'exit_conditions': {'key': 'exitConditions', 'type': 'ExitConditions'},
        'state': {'key': 'state', 'type': 'TaskState'},
        'state_transition_time': {'key': 'stateTransitionTime', 'type': 'iso-8601'},
        'previous_state': {'key': 'previousState', 'type': 'TaskState'},
        'previous_state_transition_time': {'key': 'previousStateTransitionTime', 'type': 'iso-8601'},
        'command_line': {'key': 'commandLine', 'type': 'str'},
        'container_settings': {'key': 'containerSettings', 'type': 'TaskContainerSettings'},
        'resource_files': {'key': 'resourceFiles', 'type': '[ResourceFile]'},
        'output_files': {'key': 'outputFiles', 'type': '[OutputFile]'},
        'environment_settings': {'key': 'environmentSettings', 'type': '[EnvironmentSetting]'},
        'affinity_info': {'key': 'affinityInfo', 'type': 'AffinityInformation'},
        'constraints': {'key': 'constraints', 'type': 'TaskConstraints'},
        'user_identity': {'key': 'userIdentity', 'type': 'UserIdentity'},
        'execution_info': {'key': 'executionInfo', 'type': 'TaskExecutionInformation'},
        'node_info': {'key': 'nodeInfo', 'type': 'ComputeNodeInformation'},
        'multi_instance_settings': {'key': 'multiInstanceSettings', 'type': 'MultiInstanceSettings'},
        'stats': {'key': 'stats', 'type': 'TaskStatistics'},
        'depends_on': {'key': 'dependsOn', 'type': 'TaskDependencies'},
        'application_package_references': {'key': 'applicationPackageReferences', 'type': '[ApplicationPackageReference]'},
        'authentication_token_settings': {'key': 'authenticationTokenSettings', 'type': 'AuthenticationTokenSettings'},
    }

    def __init__(self, **kwargs):
        super(CloudTask, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.display_name = kwargs.get('display_name', None)
        self.url = kwargs.get('url', None)
        self.e_tag = kwargs.get('e_tag', None)
        self.last_modified = kwargs.get('last_modified', None)
        self.creation_time = kwargs.get('creation_time', None)
        self.exit_conditions = kwargs.get('exit_conditions', None)
        self.state = kwargs.get('state', None)
        self.state_transition_time = kwargs.get('state_transition_time', None)
        self.previous_state = kwargs.get('previous_state', None)
        self.previous_state_transition_time = kwargs.get('previous_state_transition_time', None)
        self.command_line = kwargs.get('command_line', None)
        self.container_settings = kwargs.get('container_settings', None)
        self.resource_files = kwargs.get('resource_files', None)
        self.output_files = kwargs.get('output_files', None)
        self.environment_settings = kwargs.get('environment_settings', None)
        self.affinity_info = kwargs.get('affinity_info', None)
        self.constraints = kwargs.get('constraints', None)
        self.user_identity = kwargs.get('user_identity', None)
        self.execution_info = kwargs.get('execution_info', None)
        self.node_info = kwargs.get('node_info', None)
        self.multi_instance_settings = kwargs.get('multi_instance_settings', None)
        self.stats = kwargs.get('stats', None)
        self.depends_on = kwargs.get('depends_on', None)
        self.application_package_references = kwargs.get('application_package_references', None)
        self.authentication_token_settings = kwargs.get('authentication_token_settings', None)


class CloudTaskListSubtasksResult(Model):
    """The result of listing the subtasks of a task.

    :param value: The list of subtasks.
    :type value: list[~azure.batch.models.SubtaskInformation]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SubtaskInformation]'},
    }

    def __init__(self, **kwargs):
        super(CloudTaskListSubtasksResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class ComputeNode(Model):
    """A compute node in the Batch service.

    :param id: The ID of the compute node. Every node that is added to a pool
     is assigned a unique ID. Whenever a node is removed from a pool, all of
     its local files are deleted, and the ID is reclaimed and could be reused
     for new nodes.
    :type id: str
    :param url: The URL of the compute node.
    :type url: str
    :param state: The current state of the compute node. The low-priority node
     has been preempted. Tasks which were running on the node when it was
     pre-empted will be rescheduled when another node becomes available.
     Possible values include: 'idle', 'rebooting', 'reimaging', 'running',
     'unusable', 'creating', 'starting', 'waitingForStartTask',
     'startTaskFailed', 'unknown', 'leavingPool', 'offline', 'preempted'
    :type state: str or ~azure.batch.models.ComputeNodeState
    :param scheduling_state: Whether the compute node is available for task
     scheduling. Possible values include: 'enabled', 'disabled'
    :type scheduling_state: str or ~azure.batch.models.SchedulingState
    :param state_transition_time: The time at which the compute node entered
     its current state.
    :type state_transition_time: datetime
    :param last_boot_time: The last time at which the compute node was
     started. This property may not be present if the node state is unusable.
    :type last_boot_time: datetime
    :param allocation_time: The time at which this compute node was allocated
     to the pool. This is the time when the node was initially allocated and
     doesn't change once set. It is not updated when the node is service healed
     or preempted.
    :type allocation_time: datetime
    :param ip_address: The IP address that other compute nodes can use to
     communicate with this compute node. Every node that is added to a pool is
     assigned a unique IP address. Whenever a node is removed from a pool, all
     of its local files are deleted, and the IP address is reclaimed and could
     be reused for new nodes.
    :type ip_address: str
    :param affinity_id: An identifier which can be passed when adding a task
     to request that the task be scheduled on this node. Note that this is just
     a soft affinity. If the target node is busy or unavailable at the time the
     task is scheduled, then the task will be scheduled elsewhere.
    :type affinity_id: str
    :param vm_size: The size of the virtual machine hosting the compute node.
     For information about available sizes of virtual machines in pools, see
     Choose a VM size for compute nodes in an Azure Batch pool
     (https://docs.microsoft.com/azure/batch/batch-pool-vm-sizes).
    :type vm_size: str
    :param total_tasks_run: The total number of job tasks completed on the
     compute node. This includes Job Manager tasks and normal tasks, but not
     Job Preparation, Job Release or Start tasks.
    :type total_tasks_run: int
    :param running_tasks_count: The total number of currently running job
     tasks on the compute node. This includes Job Manager tasks and normal
     tasks, but not Job Preparation, Job Release or Start tasks.
    :type running_tasks_count: int
    :param total_tasks_succeeded: The total number of job tasks which
     completed successfully (with exitCode 0) on the compute node. This
     includes Job Manager tasks and normal tasks, but not Job Preparation, Job
     Release or Start tasks.
    :type total_tasks_succeeded: int
    :param recent_tasks: A list of tasks whose state has recently changed.
     This property is present only if at least one task has run on this node
     since it was assigned to the pool.
    :type recent_tasks: list[~azure.batch.models.TaskInformation]
    :param start_task: The task specified to run on the compute node as it
     joins the pool.
    :type start_task: ~azure.batch.models.StartTask
    :param start_task_info: Runtime information about the execution of the
     start task on the compute node.
    :type start_task_info: ~azure.batch.models.StartTaskInformation
    :param certificate_references: The list of certificates installed on the
     compute node. For Windows compute nodes, the Batch service installs the
     certificates to the specified certificate store and location. For Linux
     compute nodes, the certificates are stored in a directory inside the task
     working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is
     supplied to the task to query for this location. For certificates with
     visibility of 'remoteUser', a 'certs' directory is created in the user's
     home directory (e.g., /home/{user-name}/certs) and certificates are placed
     in that directory.
    :type certificate_references:
     list[~azure.batch.models.CertificateReference]
    :param errors: The list of errors that are currently being encountered by
     the compute node.
    :type errors: list[~azure.batch.models.ComputeNodeError]
    :param is_dedicated: Whether this compute node is a dedicated node. If
     false, the node is a low-priority node.
    :type is_dedicated: bool
    :param endpoint_configuration: The endpoint configuration for the compute
     node.
    :type endpoint_configuration:
     ~azure.batch.models.ComputeNodeEndpointConfiguration
    :param node_agent_info: Information about the node agent version and the
     time the node upgraded to a new version.
    :type node_agent_info: ~azure.batch.models.NodeAgentInformation
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'state': {'key': 'state', 'type': 'ComputeNodeState'},
        'scheduling_state': {'key': 'schedulingState', 'type': 'SchedulingState'},
        'state_transition_time': {'key': 'stateTransitionTime', 'type': 'iso-8601'},
        'last_boot_time': {'key': 'lastBootTime', 'type': 'iso-8601'},
        'allocation_time': {'key': 'allocationTime', 'type': 'iso-8601'},
        'ip_address': {'key': 'ipAddress', 'type': 'str'},
        'affinity_id': {'key': 'affinityId', 'type': 'str'},
        'vm_size': {'key': 'vmSize', 'type': 'str'},
        'total_tasks_run': {'key': 'totalTasksRun', 'type': 'int'},
        'running_tasks_count': {'key': 'runningTasksCount', 'type': 'int'},
        'total_tasks_succeeded': {'key': 'totalTasksSucceeded', 'type': 'int'},
        'recent_tasks': {'key': 'recentTasks', 'type': '[TaskInformation]'},
        'start_task': {'key': 'startTask', 'type': 'StartTask'},
        'start_task_info': {'key': 'startTaskInfo', 'type': 'StartTaskInformation'},
        'certificate_references': {'key': 'certificateReferences', 'type': '[CertificateReference]'},
        'errors': {'key': 'errors', 'type': '[ComputeNodeError]'},
        'is_dedicated': {'key': 'isDedicated', 'type': 'bool'},
        'endpoint_configuration': {'key': 'endpointConfiguration', 'type': 'ComputeNodeEndpointConfiguration'},
        'node_agent_info': {'key': 'nodeAgentInfo', 'type': 'NodeAgentInformation'},
    }

    def __init__(self, **kwargs):
        super(ComputeNode, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.url = kwargs.get('url', None)
        self.state = kwargs.get('state', None)
        self.scheduling_state = kwargs.get('scheduling_state', None)
        self.state_transition_time = kwargs.get('state_transition_time', None)
        self.last_boot_time = kwargs.get('last_boot_time', None)
        self.allocation_time = kwargs.get('allocation_time', None)
        self.ip_address = kwargs.get('ip_address', None)
        self.affinity_id = kwargs.get('affinity_id', None)
        self.vm_size = kwargs.get('vm_size', None)
        self.total_tasks_run = kwargs.get('total_tasks_run', None)
        self.running_tasks_count = kwargs.get('running_tasks_count', None)
        self.total_tasks_succeeded = kwargs.get('total_tasks_succeeded', None)
        self.recent_tasks = kwargs.get('recent_tasks', None)
        self.start_task = kwargs.get('start_task', None)
        self.start_task_info = kwargs.get('start_task_info', None)
        self.certificate_references = kwargs.get('certificate_references', None)
        self.errors = kwargs.get('errors', None)
        self.is_dedicated = kwargs.get('is_dedicated', None)
        self.endpoint_configuration = kwargs.get('endpoint_configuration', None)
        self.node_agent_info = kwargs.get('node_agent_info', None)


class ComputeNodeAddUserOptions(Model):
    """Additional parameters for add_user operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(ComputeNodeAddUserOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)


class ComputeNodeDeleteUserOptions(Model):
    """Additional parameters for delete_user operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(ComputeNodeDeleteUserOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)


class ComputeNodeDisableSchedulingOptions(Model):
    """Additional parameters for disable_scheduling operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(ComputeNodeDisableSchedulingOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)


class ComputeNodeEnableSchedulingOptions(Model):
    """Additional parameters for enable_scheduling operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(ComputeNodeEnableSchedulingOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)


class ComputeNodeEndpointConfiguration(Model):
    """The endpoint configuration for the compute node.

    All required parameters must be populated in order to send to Azure.

    :param inbound_endpoints: Required. The list of inbound endpoints that are
     accessible on the compute node.
    :type inbound_endpoints: list[~azure.batch.models.InboundEndpoint]
    """

    _validation = {
        'inbound_endpoints': {'required': True},
    }

    _attribute_map = {
        'inbound_endpoints': {'key': 'inboundEndpoints', 'type': '[InboundEndpoint]'},
    }

    def __init__(self, **kwargs):
        super(ComputeNodeEndpointConfiguration, self).__init__(**kwargs)
        self.inbound_endpoints = kwargs.get('inbound_endpoints', None)


class ComputeNodeError(Model):
    """An error encountered by a compute node.

    :param code: An identifier for the compute node error. Codes are invariant
     and are intended to be consumed programmatically.
    :type code: str
    :param message: A message describing the compute node error, intended to
     be suitable for display in a user interface.
    :type message: str
    :param error_details: The list of additional error details related to the
     compute node error.
    :type error_details: list[~azure.batch.models.NameValuePair]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'error_details': {'key': 'errorDetails', 'type': '[NameValuePair]'},
    }

    def __init__(self, **kwargs):
        super(ComputeNodeError, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.error_details = kwargs.get('error_details', None)


class ComputeNodeGetOptions(Model):
    """Additional parameters for get operation.

    :param select: An OData $select clause.
    :type select: str
    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    """

    _attribute_map = {
        'select': {'key': '', 'type': 'str'},
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(ComputeNodeGetOptions, self).__init__(**kwargs)
        self.select = kwargs.get('select', None)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)


class ComputeNodeGetRemoteDesktopOptions(Model):
    """Additional parameters for get_remote_desktop operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(ComputeNodeGetRemoteDesktopOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)


class ComputeNodeGetRemoteLoginSettingsOptions(Model):
    """Additional parameters for get_remote_login_settings operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(ComputeNodeGetRemoteLoginSettingsOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)


class ComputeNodeGetRemoteLoginSettingsResult(Model):
    """The remote login settings for a compute node.

    All required parameters must be populated in order to send to Azure.

    :param remote_login_ip_address: Required. The IP address used for remote
     login to the compute node.
    :type remote_login_ip_address: str
    :param remote_login_port: Required. The port used for remote login to the
     compute node.
    :type remote_login_port: int
    """

    _validation = {
        'remote_login_ip_address': {'required': True},
        'remote_login_port': {'required': True},
    }

    _attribute_map = {
        'remote_login_ip_address': {'key': 'remoteLoginIPAddress', 'type': 'str'},
        'remote_login_port': {'key': 'remoteLoginPort', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(ComputeNodeGetRemoteLoginSettingsResult, self).__init__(**kwargs)
        self.remote_login_ip_address = kwargs.get('remote_login_ip_address', None)
        self.remote_login_port = kwargs.get('remote_login_port', None)


class ComputeNodeInformation(Model):
    """Information about the compute node on which a task ran.

    :param affinity_id: An identifier for the compute node on which the task
     ran, which can be passed when adding a task to request that the task be
     scheduled on this compute node.
    :type affinity_id: str
    :param node_url: The URL of the node on which the task ran. .
    :type node_url: str
    :param pool_id: The ID of the pool on which the task ran.
    :type pool_id: str
    :param node_id: The ID of the node on which the task ran.
    :type node_id: str
    :param task_root_directory: The root directory of the task on the compute
     node.
    :type task_root_directory: str
    :param task_root_directory_url: The URL to the root directory of the task
     on the compute node.
    :type task_root_directory_url: str
    """

    _attribute_map = {
        'affinity_id': {'key': 'affinityId', 'type': 'str'},
        'node_url': {'key': 'nodeUrl', 'type': 'str'},
        'pool_id': {'key': 'poolId', 'type': 'str'},
        'node_id': {'key': 'nodeId', 'type': 'str'},
        'task_root_directory': {'key': 'taskRootDirectory', 'type': 'str'},
        'task_root_directory_url': {'key': 'taskRootDirectoryUrl', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ComputeNodeInformation, self).__init__(**kwargs)
        self.affinity_id = kwargs.get('affinity_id', None)
        self.node_url = kwargs.get('node_url', None)
        self.pool_id = kwargs.get('pool_id', None)
        self.node_id = kwargs.get('node_id', None)
        self.task_root_directory = kwargs.get('task_root_directory', None)
        self.task_root_directory_url = kwargs.get('task_root_directory_url', None)


class ComputeNodeListOptions(Model):
    """Additional parameters for list operation.

    :param filter: An OData $filter clause. For more information on
     constructing this filter, see
     https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-nodes-in-a-pool.
    :type filter: str
    :param select: An OData $select clause.
    :type select: str
    :param max_results: The maximum number of items to return in the response.
     A maximum of 1000 nodes can be returned. Default value: 1000 .
    :type max_results: int
    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    """

    _attribute_map = {
        'filter': {'key': '', 'type': 'str'},
        'select': {'key': '', 'type': 'str'},
        'max_results': {'key': '', 'type': 'int'},
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(ComputeNodeListOptions, self).__init__(**kwargs)
        self.filter = kwargs.get('filter', None)
        self.select = kwargs.get('select', None)
        self.max_results = kwargs.get('max_results', 1000)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)


class ComputeNodeRebootOptions(Model):
    """Additional parameters for reboot operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(ComputeNodeRebootOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)


class ComputeNodeReimageOptions(Model):
    """Additional parameters for reimage operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(ComputeNodeReimageOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)


class ComputeNodeUpdateUserOptions(Model):
    """Additional parameters for update_user operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(ComputeNodeUpdateUserOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)


class ComputeNodeUploadBatchServiceLogsOptions(Model):
    """Additional parameters for upload_batch_service_logs operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(ComputeNodeUploadBatchServiceLogsOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)


class ComputeNodeUser(Model):
    """A user account for RDP or SSH access on a compute node.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The user name of the account.
    :type name: str
    :param is_admin: Whether the account should be an administrator on the
     compute node. The default value is false.
    :type is_admin: bool
    :param expiry_time: The time at which the account should expire. If
     omitted, the default is 1 day from the current time. For Linux compute
     nodes, the expiryTime has a precision up to a day.
    :type expiry_time: datetime
    :param password: The password of the account. The password is required for
     Windows nodes (those created with 'cloudServiceConfiguration', or created
     with 'virtualMachineConfiguration' using a Windows image reference). For
     Linux compute nodes, the password can optionally be specified along with
     the sshPublicKey property.
    :type password: str
    :param ssh_public_key: The SSH public key that can be used for remote
     login to the compute node. The public key should be compatible with
     OpenSSH encoding and should be base 64 encoded. This property can be
     specified only for Linux nodes. If this is specified for a Windows node,
     then the Batch service rejects the request; if you are calling the REST
     API directly, the HTTP status code is 400 (Bad Request).
    :type ssh_public_key: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'is_admin': {'key': 'isAdmin', 'type': 'bool'},
        'expiry_time': {'key': 'expiryTime', 'type': 'iso-8601'},
        'password': {'key': 'password', 'type': 'str'},
        'ssh_public_key': {'key': 'sshPublicKey', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ComputeNodeUser, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.is_admin = kwargs.get('is_admin', None)
        self.expiry_time = kwargs.get('expiry_time', None)
        self.password = kwargs.get('password', None)
        self.ssh_public_key = kwargs.get('ssh_public_key', None)


class ContainerConfiguration(Model):
    """The configuration for container-enabled pools.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar type: Required. The container technology to be used.  Default value:
     "dockerCompatible" .
    :vartype type: str
    :param container_image_names: The collection of container image names.
     This is the full image reference, as would be specified to "docker pull".
     An image will be sourced from the default Docker registry unless the image
     is fully qualified with an alternative registry.
    :type container_image_names: list[str]
    :param container_registries: Additional private registries from which
     containers can be pulled. If any images must be downloaded from a private
     registry which requires credentials, then those credentials must be
     provided here.
    :type container_registries: list[~azure.batch.models.ContainerRegistry]
    """

    _validation = {
        'type': {'required': True, 'constant': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'container_image_names': {'key': 'containerImageNames', 'type': '[str]'},
        'container_registries': {'key': 'containerRegistries', 'type': '[ContainerRegistry]'},
    }

    type = "dockerCompatible"

    def __init__(self, **kwargs):
        super(ContainerConfiguration, self).__init__(**kwargs)
        self.container_image_names = kwargs.get('container_image_names', None)
        self.container_registries = kwargs.get('container_registries', None)


class ContainerRegistry(Model):
    """A private container registry.

    All required parameters must be populated in order to send to Azure.

    :param registry_server: The registry URL. If omitted, the default is
     "docker.io".
    :type registry_server: str
    :param user_name: Required. The user name to log into the registry server.
    :type user_name: str
    :param password: Required. The password to log into the registry server.
    :type password: str
    """

    _validation = {
        'user_name': {'required': True},
        'password': {'required': True},
    }

    _attribute_map = {
        'registry_server': {'key': 'registryServer', 'type': 'str'},
        'user_name': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ContainerRegistry, self).__init__(**kwargs)
        self.registry_server = kwargs.get('registry_server', None)
        self.user_name = kwargs.get('user_name', None)
        self.password = kwargs.get('password', None)


class DataDisk(Model):
    """Settings which will be used by the data disks associated to compute nodes
    in the pool.

    All required parameters must be populated in order to send to Azure.

    :param lun: Required. The logical unit number. The lun is used to uniquely
     identify each data disk. If attaching multiple disks, each should have a
     distinct lun.
    :type lun: int
    :param caching: The type of caching to be enabled for the data disks. The
     default value for caching is readwrite. For information about the caching
     options see:
     https://blogs.msdn.microsoft.com/windowsazurestorage/2012/06/27/exploring-windows-azure-drives-disks-and-images/.
     Possible values include: 'none', 'readOnly', 'readWrite'
    :type caching: str or ~azure.batch.models.CachingType
    :param disk_size_gb: Required. The initial disk size in gigabytes.
    :type disk_size_gb: int
    :param storage_account_type: The storage account type to be used for the
     data disk. If omitted, the default is "standard_lrs". Possible values
     include: 'StandardLRS', 'PremiumLRS'
    :type storage_account_type: str or ~azure.batch.models.StorageAccountType
    """

    _validation = {
        'lun': {'required': True},
        'disk_size_gb': {'required': True},
    }

    _attribute_map = {
        'lun': {'key': 'lun', 'type': 'int'},
        'caching': {'key': 'caching', 'type': 'CachingType'},
        'disk_size_gb': {'key': 'diskSizeGB', 'type': 'int'},
        'storage_account_type': {'key': 'storageAccountType', 'type': 'StorageAccountType'},
    }

    def __init__(self, **kwargs):
        super(DataDisk, self).__init__(**kwargs)
        self.lun = kwargs.get('lun', None)
        self.caching = kwargs.get('caching', None)
        self.disk_size_gb = kwargs.get('disk_size_gb', None)
        self.storage_account_type = kwargs.get('storage_account_type', None)


class DeleteCertificateError(Model):
    """An error encountered by the Batch service when deleting a certificate.

    :param code: An identifier for the certificate deletion error. Codes are
     invariant and are intended to be consumed programmatically.
    :type code: str
    :param message: A message describing the certificate deletion error,
     intended to be suitable for display in a user interface.
    :type message: str
    :param values: A list of additional error details related to the
     certificate deletion error. This list includes details such as the active
     pools and nodes referencing this certificate. However, if a large number
     of resources reference the certificate, the list contains only about the
     first hundred.
    :type values: list[~azure.batch.models.NameValuePair]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'values': {'key': 'values', 'type': '[NameValuePair]'},
    }

    def __init__(self, **kwargs):
        super(DeleteCertificateError, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.values = kwargs.get('values', None)


class EnvironmentSetting(Model):
    """An environment variable to be set on a task process.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the environment variable.
    :type name: str
    :param value: The value of the environment variable.
    :type value: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EnvironmentSetting, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)


class ErrorMessage(Model):
    """An error message received in an Azure Batch error response.

    :param lang: The language code of the error message.
    :type lang: str
    :param value: The text of the message.
    :type value: str
    """

    _attribute_map = {
        'lang': {'key': 'lang', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ErrorMessage, self).__init__(**kwargs)
        self.lang = kwargs.get('lang', None)
        self.value = kwargs.get('value', None)


class ExitCodeMapping(Model):
    """How the Batch service should respond if a task exits with a particular exit
    code.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. A process exit code.
    :type code: int
    :param exit_options: Required. How the Batch service should respond if the
     task exits with this exit code.
    :type exit_options: ~azure.batch.models.ExitOptions
    """

    _validation = {
        'code': {'required': True},
        'exit_options': {'required': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'int'},
        'exit_options': {'key': 'exitOptions', 'type': 'ExitOptions'},
    }

    def __init__(self, **kwargs):
        super(ExitCodeMapping, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.exit_options = kwargs.get('exit_options', None)


class ExitCodeRangeMapping(Model):
    """A range of exit codes and how the Batch service should respond to exit
    codes within that range.

    All required parameters must be populated in order to send to Azure.

    :param start: Required. The first exit code in the range.
    :type start: int
    :param end: Required. The last exit code in the range.
    :type end: int
    :param exit_options: Required. How the Batch service should respond if the
     task exits with an exit code in the range start to end (inclusive).
    :type exit_options: ~azure.batch.models.ExitOptions
    """

    _validation = {
        'start': {'required': True},
        'end': {'required': True},
        'exit_options': {'required': True},
    }

    _attribute_map = {
        'start': {'key': 'start', 'type': 'int'},
        'end': {'key': 'end', 'type': 'int'},
        'exit_options': {'key': 'exitOptions', 'type': 'ExitOptions'},
    }

    def __init__(self, **kwargs):
        super(ExitCodeRangeMapping, self).__init__(**kwargs)
        self.start = kwargs.get('start', None)
        self.end = kwargs.get('end', None)
        self.exit_options = kwargs.get('exit_options', None)


class ExitConditions(Model):
    """Specifies how the Batch service should respond when the task completes.

    :param exit_codes: A list of individual task exit codes and how the Batch
     service should respond to them.
    :type exit_codes: list[~azure.batch.models.ExitCodeMapping]
    :param exit_code_ranges: A list of task exit code ranges and how the Batch
     service should respond to them.
    :type exit_code_ranges: list[~azure.batch.models.ExitCodeRangeMapping]
    :param pre_processing_error: How the Batch service should respond if the
     task fails to start due to an error.
    :type pre_processing_error: ~azure.batch.models.ExitOptions
    :param file_upload_error: How the Batch service should respond if a file
     upload error occurs. If the task exited with an exit code that was
     specified via exitCodes or exitCodeRanges, and then encountered a file
     upload error, then the action specified by the exit code takes precedence.
    :type file_upload_error: ~azure.batch.models.ExitOptions
    :param default: How the Batch service should respond if the task fails
     with an exit condition not covered by any of the other properties. This
     value is used if the task exits with any nonzero exit code not listed in
     the exitCodes or exitCodeRanges collection, with a pre-processing error if
     the preProcessingError property is not present, or with a file upload
     error if the fileUploadError property is not present. If you want
     non-default behavior on exit code 0, you must list it explicitly using the
     exitCodes or exitCodeRanges collection.
    :type default: ~azure.batch.models.ExitOptions
    """

    _attribute_map = {
        'exit_codes': {'key': 'exitCodes', 'type': '[ExitCodeMapping]'},
        'exit_code_ranges': {'key': 'exitCodeRanges', 'type': '[ExitCodeRangeMapping]'},
        'pre_processing_error': {'key': 'preProcessingError', 'type': 'ExitOptions'},
        'file_upload_error': {'key': 'fileUploadError', 'type': 'ExitOptions'},
        'default': {'key': 'default', 'type': 'ExitOptions'},
    }

    def __init__(self, **kwargs):
        super(ExitConditions, self).__init__(**kwargs)
        self.exit_codes = kwargs.get('exit_codes', None)
        self.exit_code_ranges = kwargs.get('exit_code_ranges', None)
        self.pre_processing_error = kwargs.get('pre_processing_error', None)
        self.file_upload_error = kwargs.get('file_upload_error', None)
        self.default = kwargs.get('default', None)


class ExitOptions(Model):
    """Specifies how the Batch service responds to a particular exit condition.

    :param job_action: An action to take on the job containing the task, if
     the task completes with the given exit condition and the job's
     onTaskFailed property is 'performExitOptionsJobAction'. The default is
     none for exit code 0 and terminate for all other exit conditions. If the
     job's onTaskFailed property is noaction, then specifying this property
     returns an error and the add task request fails with an invalid property
     value error; if you are calling the REST API directly, the HTTP status
     code is 400 (Bad Request). Possible values include: 'none', 'disable',
     'terminate'
    :type job_action: str or ~azure.batch.models.JobAction
    :param dependency_action: An action that the Batch service performs on
     tasks that depend on this task. The default is 'satisfy' for exit code 0,
     and 'block' for all other exit conditions. If the job's
     usesTaskDependencies property is set to false, then specifying the
     dependencyAction property returns an error and the add task request fails
     with an invalid property value error; if you are calling the REST API
     directly, the HTTP status code is 400  (Bad Request). Possible values
     include: 'satisfy', 'block'
    :type dependency_action: str or ~azure.batch.models.DependencyAction
    """

    _attribute_map = {
        'job_action': {'key': 'jobAction', 'type': 'JobAction'},
        'dependency_action': {'key': 'dependencyAction', 'type': 'DependencyAction'},
    }

    def __init__(self, **kwargs):
        super(ExitOptions, self).__init__(**kwargs)
        self.job_action = kwargs.get('job_action', None)
        self.dependency_action = kwargs.get('dependency_action', None)


class FileDeleteFromComputeNodeOptions(Model):
    """Additional parameters for delete_from_compute_node operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(FileDeleteFromComputeNodeOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)


class FileDeleteFromTaskOptions(Model):
    """Additional parameters for delete_from_task operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(FileDeleteFromTaskOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)


class FileGetFromComputeNodeOptions(Model):
    """Additional parameters for get_from_compute_node operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    :param ocp_range: The byte range to be retrieved. The default is to
     retrieve the entire file. The format is bytes=startRange-endRange.
    :type ocp_range: str
    :param if_modified_since: A timestamp indicating the last modified time of
     the resource known to the client. The operation will be performed only if
     the resource on the service has been modified since the specified time.
    :type if_modified_since: datetime
    :param if_unmodified_since: A timestamp indicating the last modified time
     of the resource known to the client. The operation will be performed only
     if the resource on the service has not been modified since the specified
     time.
    :type if_unmodified_since: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
        'ocp_range': {'key': '', 'type': 'str'},
        'if_modified_since': {'key': '', 'type': 'rfc-1123'},
        'if_unmodified_since': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(FileGetFromComputeNodeOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)
        self.ocp_range = kwargs.get('ocp_range', None)
        self.if_modified_since = kwargs.get('if_modified_since', None)
        self.if_unmodified_since = kwargs.get('if_unmodified_since', None)


class FileGetFromTaskOptions(Model):
    """Additional parameters for get_from_task operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    :param ocp_range: The byte range to be retrieved. The default is to
     retrieve the entire file. The format is bytes=startRange-endRange.
    :type ocp_range: str
    :param if_modified_since: A timestamp indicating the last modified time of
     the resource known to the client. The operation will be performed only if
     the resource on the service has been modified since the specified time.
    :type if_modified_since: datetime
    :param if_unmodified_since: A timestamp indicating the last modified time
     of the resource known to the client. The operation will be performed only
     if the resource on the service has not been modified since the specified
     time.
    :type if_unmodified_since: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
        'ocp_range': {'key': '', 'type': 'str'},
        'if_modified_since': {'key': '', 'type': 'rfc-1123'},
        'if_unmodified_since': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(FileGetFromTaskOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)
        self.ocp_range = kwargs.get('ocp_range', None)
        self.if_modified_since = kwargs.get('if_modified_since', None)
        self.if_unmodified_since = kwargs.get('if_unmodified_since', None)


class FileGetPropertiesFromComputeNodeOptions(Model):
    """Additional parameters for get_properties_from_compute_node operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    :param if_modified_since: A timestamp indicating the last modified time of
     the resource known to the client. The operation will be performed only if
     the resource on the service has been modified since the specified time.
    :type if_modified_since: datetime
    :param if_unmodified_since: A timestamp indicating the last modified time
     of the resource known to the client. The operation will be performed only
     if the resource on the service has not been modified since the specified
     time.
    :type if_unmodified_since: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
        'if_modified_since': {'key': '', 'type': 'rfc-1123'},
        'if_unmodified_since': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(FileGetPropertiesFromComputeNodeOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)
        self.if_modified_since = kwargs.get('if_modified_since', None)
        self.if_unmodified_since = kwargs.get('if_unmodified_since', None)


class FileGetPropertiesFromTaskOptions(Model):
    """Additional parameters for get_properties_from_task operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    :param if_modified_since: A timestamp indicating the last modified time of
     the resource known to the client. The operation will be performed only if
     the resource on the service has been modified since the specified time.
    :type if_modified_since: datetime
    :param if_unmodified_since: A timestamp indicating the last modified time
     of the resource known to the client. The operation will be performed only
     if the resource on the service has not been modified since the specified
     time.
    :type if_unmodified_since: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
        'if_modified_since': {'key': '', 'type': 'rfc-1123'},
        'if_unmodified_since': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(FileGetPropertiesFromTaskOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)
        self.if_modified_since = kwargs.get('if_modified_since', None)
        self.if_unmodified_since = kwargs.get('if_unmodified_since', None)


class FileListFromComputeNodeOptions(Model):
    """Additional parameters for list_from_compute_node operation.

    :param filter: An OData $filter clause. For more information on
     constructing this filter, see
     https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-compute-node-files.
    :type filter: str
    :param max_results: The maximum number of items to return in the response.
     A maximum of 1000 files can be returned. Default value: 1000 .
    :type max_results: int
    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    """

    _attribute_map = {
        'filter': {'key': '', 'type': 'str'},
        'max_results': {'key': '', 'type': 'int'},
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(FileListFromComputeNodeOptions, self).__init__(**kwargs)
        self.filter = kwargs.get('filter', None)
        self.max_results = kwargs.get('max_results', 1000)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)


class FileListFromTaskOptions(Model):
    """Additional parameters for list_from_task operation.

    :param filter: An OData $filter clause. For more information on
     constructing this filter, see
     https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-task-files.
    :type filter: str
    :param max_results: The maximum number of items to return in the response.
     A maximum of 1000 files can be returned. Default value: 1000 .
    :type max_results: int
    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    """

    _attribute_map = {
        'filter': {'key': '', 'type': 'str'},
        'max_results': {'key': '', 'type': 'int'},
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(FileListFromTaskOptions, self).__init__(**kwargs)
        self.filter = kwargs.get('filter', None)
        self.max_results = kwargs.get('max_results', 1000)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)


class FileProperties(Model):
    """The properties of a file on a compute node.

    All required parameters must be populated in order to send to Azure.

    :param creation_time: The file creation time. The creation time is not
     returned for files on Linux compute nodes.
    :type creation_time: datetime
    :param last_modified: Required. The time at which the file was last
     modified.
    :type last_modified: datetime
    :param content_length: Required. The length of the file.
    :type content_length: long
    :param content_type: The content type of the file.
    :type content_type: str
    :param file_mode: The file mode attribute in octal format. The file mode
     is returned only for files on Linux compute nodes.
    :type file_mode: str
    """

    _validation = {
        'last_modified': {'required': True},
        'content_length': {'required': True},
    }

    _attribute_map = {
        'creation_time': {'key': 'creationTime', 'type': 'iso-8601'},
        'last_modified': {'key': 'lastModified', 'type': 'iso-8601'},
        'content_length': {'key': 'contentLength', 'type': 'long'},
        'content_type': {'key': 'contentType', 'type': 'str'},
        'file_mode': {'key': 'fileMode', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(FileProperties, self).__init__(**kwargs)
        self.creation_time = kwargs.get('creation_time', None)
        self.last_modified = kwargs.get('last_modified', None)
        self.content_length = kwargs.get('content_length', None)
        self.content_type = kwargs.get('content_type', None)
        self.file_mode = kwargs.get('file_mode', None)


class ImageReference(Model):
    """A reference to an Azure Virtual Machines Marketplace image or a custom
    Azure Virtual Machine image. To get the list of all Azure Marketplace image
    references verified by Azure Batch, see the 'List node agent SKUs'
    operation.

    :param publisher: The publisher of the Azure Virtual Machines Marketplace
     image. For example, Canonical or MicrosoftWindowsServer.
    :type publisher: str
    :param offer: The offer type of the Azure Virtual Machines Marketplace
     image. For example, UbuntuServer or WindowsServer.
    :type offer: str
    :param sku: The SKU of the Azure Virtual Machines Marketplace image. For
     example, 14.04.0-LTS or 2012-R2-Datacenter.
    :type sku: str
    :param version: The version of the Azure Virtual Machines Marketplace
     image. A value of 'latest' can be specified to select the latest version
     of an image. If omitted, the default is 'latest'.
    :type version: str
    :param virtual_machine_image_id: The ARM resource identifier of the
     virtual machine image. Computes nodes of the pool will be created using
     this custom image. This is of the form
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroup}/providers/Microsoft.Compute/images/{imageName}.
     This property is mutually exclusive with other ImageReference properties.
     The virtual machine image must be in the same region and subscription as
     the Azure Batch account. For more details, see
     https://docs.microsoft.com/azure/batch/batch-custom-images.
    :type virtual_machine_image_id: str
    """

    _attribute_map = {
        'publisher': {'key': 'publisher', 'type': 'str'},
        'offer': {'key': 'offer', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'virtual_machine_image_id': {'key': 'virtualMachineImageId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ImageReference, self).__init__(**kwargs)
        self.publisher = kwargs.get('publisher', None)
        self.offer = kwargs.get('offer', None)
        self.sku = kwargs.get('sku', None)
        self.version = kwargs.get('version', None)
        self.virtual_machine_image_id = kwargs.get('virtual_machine_image_id', None)


class InboundEndpoint(Model):
    """An inbound endpoint on a compute node.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the endpoint.
    :type name: str
    :param protocol: Required. The protocol of the endpoint. Possible values
     include: 'tcp', 'udp'
    :type protocol: str or ~azure.batch.models.InboundEndpointProtocol
    :param public_ip_address: Required. The public IP address of the compute
     node.
    :type public_ip_address: str
    :param public_fqdn: Required. The public fully qualified domain name for
     the compute node.
    :type public_fqdn: str
    :param frontend_port: Required. The public port number of the endpoint.
    :type frontend_port: int
    :param backend_port: Required. The backend port number of the endpoint.
    :type backend_port: int
    """

    _validation = {
        'name': {'required': True},
        'protocol': {'required': True},
        'public_ip_address': {'required': True},
        'public_fqdn': {'required': True},
        'frontend_port': {'required': True},
        'backend_port': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'InboundEndpointProtocol'},
        'public_ip_address': {'key': 'publicIPAddress', 'type': 'str'},
        'public_fqdn': {'key': 'publicFQDN', 'type': 'str'},
        'frontend_port': {'key': 'frontendPort', 'type': 'int'},
        'backend_port': {'key': 'backendPort', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(InboundEndpoint, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.protocol = kwargs.get('protocol', None)
        self.public_ip_address = kwargs.get('public_ip_address', None)
        self.public_fqdn = kwargs.get('public_fqdn', None)
        self.frontend_port = kwargs.get('frontend_port', None)
        self.backend_port = kwargs.get('backend_port', None)


class InboundNATPool(Model):
    """A inbound NAT pool that can be used to address specific ports on compute
    nodes in a Batch pool externally.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the endpoint. The name must be unique
     within a Batch pool, can contain letters, numbers, underscores, periods,
     and hyphens. Names must start with a letter or number, must end with a
     letter, number, or underscore, and cannot exceed 77 characters.  If any
     invalid values are provided the request fails with HTTP status code 400.
    :type name: str
    :param protocol: Required. The protocol of the endpoint. Possible values
     include: 'tcp', 'udp'
    :type protocol: str or ~azure.batch.models.InboundEndpointProtocol
    :param backend_port: Required. The port number on the compute node. This
     must be unique within a Batch pool. Acceptable values are between 1 and
     65535 except for 22, 3389, 29876 and 29877 as these are reserved. If any
     reserved values are provided the request fails with HTTP status code 400.
    :type backend_port: int
    :param frontend_port_range_start: Required. The first port number in the
     range of external ports that will be used to provide inbound access to the
     backendPort on individual compute nodes. Acceptable values range between 1
     and 65534 except ports from 50000 to 55000 which are reserved. All ranges
     within a pool must be distinct and cannot overlap. Each range must contain
     at least 40 ports. If any reserved or overlapping values are provided the
     request fails with HTTP status code 400.
    :type frontend_port_range_start: int
    :param frontend_port_range_end: Required. The last port number in the
     range of external ports that will be used to provide inbound access to the
     backendPort on individual compute nodes. Acceptable values range between 1
     and 65534 except ports from 50000 to 55000 which are reserved by the Batch
     service. All ranges within a pool must be distinct and cannot overlap.
     Each range must contain at least 40 ports. If any reserved or overlapping
     values are provided the request fails with HTTP status code 400.
    :type frontend_port_range_end: int
    :param network_security_group_rules: A list of network security group
     rules that will be applied to the endpoint. The maximum number of rules
     that can be specified across all the endpoints on a Batch pool is 25. If
     no network security group rules are specified, a default rule will be
     created to allow inbound access to the specified backendPort. If the
     maximum number of network security group rules is exceeded the request
     fails with HTTP status code 400.
    :type network_security_group_rules:
     list[~azure.batch.models.NetworkSecurityGroupRule]
    """

    _validation = {
        'name': {'required': True},
        'protocol': {'required': True},
        'backend_port': {'required': True},
        'frontend_port_range_start': {'required': True},
        'frontend_port_range_end': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'protocol': {'key': 'protocol', 'type': 'InboundEndpointProtocol'},
        'backend_port': {'key': 'backendPort', 'type': 'int'},
        'frontend_port_range_start': {'key': 'frontendPortRangeStart', 'type': 'int'},
        'frontend_port_range_end': {'key': 'frontendPortRangeEnd', 'type': 'int'},
        'network_security_group_rules': {'key': 'networkSecurityGroupRules', 'type': '[NetworkSecurityGroupRule]'},
    }

    def __init__(self, **kwargs):
        super(InboundNATPool, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.protocol = kwargs.get('protocol', None)
        self.backend_port = kwargs.get('backend_port', None)
        self.frontend_port_range_start = kwargs.get('frontend_port_range_start', None)
        self.frontend_port_range_end = kwargs.get('frontend_port_range_end', None)
        self.network_security_group_rules = kwargs.get('network_security_group_rules', None)


class JobAddOptions(Model):
    """Additional parameters for add operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(JobAddOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)


class JobAddParameter(Model):
    """An Azure Batch job to add.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. A string that uniquely identifies the job within the
     account. The ID can contain any combination of alphanumeric characters
     including hyphens and underscores, and cannot contain more than 64
     characters. The ID is case-preserving and case-insensitive (that is, you
     may not have two IDs within an account that differ only by case).
    :type id: str
    :param display_name: The display name for the job. The display name need
     not be unique and can contain any Unicode characters up to a maximum
     length of 1024.
    :type display_name: str
    :param priority: The priority of the job. Priority values can range from
     -1000 to 1000, with -1000 being the lowest priority and 1000 being the
     highest priority. The default value is 0.
    :type priority: int
    :param constraints: The execution constraints for the job.
    :type constraints: ~azure.batch.models.JobConstraints
    :param job_manager_task: Details of a Job Manager task to be launched when
     the job is started. If the job does not specify a Job Manager task, the
     user must explicitly add tasks to the job. If the job does specify a Job
     Manager task, the Batch service creates the Job Manager task when the job
     is created, and will try to schedule the Job Manager task before
     scheduling other tasks in the job. The Job Manager task's typical purpose
     is to control and/or monitor job execution, for example by deciding what
     additional tasks to run, determining when the work is complete, etc.
     (However, a Job Manager task is not restricted to these activities - it is
     a fully-fledged task in the system and perform whatever actions are
     required for the job.) For example, a Job Manager task might download a
     file specified as a parameter, analyze the contents of that file and
     submit additional tasks based on those contents.
    :type job_manager_task: ~azure.batch.models.JobManagerTask
    :param job_preparation_task: The Job Preparation task. If a job has a Job
     Preparation task, the Batch service will run the Job Preparation task on a
     compute node before starting any tasks of that job on that compute node.
    :type job_preparation_task: ~azure.batch.models.JobPreparationTask
    :param job_release_task: The Job Release task. A Job Release task cannot
     be specified without also specifying a Job Preparation task for the job.
     The Batch service runs the Job Release task on the compute nodes that have
     run the Job Preparation task. The primary purpose of the Job Release task
     is to undo changes to compute nodes made by the Job Preparation task.
     Example activities include deleting local files, or shutting down services
     that were started as part of job preparation.
    :type job_release_task: ~azure.batch.models.JobReleaseTask
    :param common_environment_settings: The list of common environment
     variable settings. These environment variables are set for all tasks in
     the job (including the Job Manager, Job Preparation and Job Release
     tasks). Individual tasks can override an environment setting specified
     here by specifying the same setting name with a different value.
    :type common_environment_settings:
     list[~azure.batch.models.EnvironmentSetting]
    :param pool_info: Required. The pool on which the Batch service runs the
     job's tasks.
    :type pool_info: ~azure.batch.models.PoolInformation
    :param on_all_tasks_complete: The action the Batch service should take
     when all tasks in the job are in the completed state. Note that if a job
     contains no tasks, then all tasks are considered complete. This option is
     therefore most commonly used with a Job Manager task; if you want to use
     automatic job termination without a Job Manager, you should initially set
     onAllTasksComplete to noaction and update the job properties to set
     onAllTasksComplete to terminatejob once you have finished adding tasks.
     The default is noaction. Possible values include: 'noAction',
     'terminateJob'
    :type on_all_tasks_complete: str or ~azure.batch.models.OnAllTasksComplete
    :param on_task_failure: The action the Batch service should take when any
     task in the job fails. A task is considered to have failed if has a
     failureInfo. A failureInfo is set if the task completes with a non-zero
     exit code after exhausting its retry count, or if there was an error
     starting the task, for example due to a resource file download error. The
     default is noaction. Possible values include: 'noAction',
     'performExitOptionsJobAction'
    :type on_task_failure: str or ~azure.batch.models.OnTaskFailure
    :param metadata: A list of name-value pairs associated with the job as
     metadata. The Batch service does not assign any meaning to metadata; it is
     solely for the use of user code.
    :type metadata: list[~azure.batch.models.MetadataItem]
    :param uses_task_dependencies: Whether tasks in the job can define
     dependencies on each other. The default is false.
    :type uses_task_dependencies: bool
    :param network_configuration: The network configuration for the job.
    :type network_configuration: ~azure.batch.models.JobNetworkConfiguration
    """

    _validation = {
        'id': {'required': True},
        'pool_info': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'int'},
        'constraints': {'key': 'constraints', 'type': 'JobConstraints'},
        'job_manager_task': {'key': 'jobManagerTask', 'type': 'JobManagerTask'},
        'job_preparation_task': {'key': 'jobPreparationTask', 'type': 'JobPreparationTask'},
        'job_release_task': {'key': 'jobReleaseTask', 'type': 'JobReleaseTask'},
        'common_environment_settings': {'key': 'commonEnvironmentSettings', 'type': '[EnvironmentSetting]'},
        'pool_info': {'key': 'poolInfo', 'type': 'PoolInformation'},
        'on_all_tasks_complete': {'key': 'onAllTasksComplete', 'type': 'OnAllTasksComplete'},
        'on_task_failure': {'key': 'onTaskFailure', 'type': 'OnTaskFailure'},
        'metadata': {'key': 'metadata', 'type': '[MetadataItem]'},
        'uses_task_dependencies': {'key': 'usesTaskDependencies', 'type': 'bool'},
        'network_configuration': {'key': 'networkConfiguration', 'type': 'JobNetworkConfiguration'},
    }

    def __init__(self, **kwargs):
        super(JobAddParameter, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.display_name = kwargs.get('display_name', None)
        self.priority = kwargs.get('priority', None)
        self.constraints = kwargs.get('constraints', None)
        self.job_manager_task = kwargs.get('job_manager_task', None)
        self.job_preparation_task = kwargs.get('job_preparation_task', None)
        self.job_release_task = kwargs.get('job_release_task', None)
        self.common_environment_settings = kwargs.get('common_environment_settings', None)
        self.pool_info = kwargs.get('pool_info', None)
        self.on_all_tasks_complete = kwargs.get('on_all_tasks_complete', None)
        self.on_task_failure = kwargs.get('on_task_failure', None)
        self.metadata = kwargs.get('metadata', None)
        self.uses_task_dependencies = kwargs.get('uses_task_dependencies', None)
        self.network_configuration = kwargs.get('network_configuration', None)


class JobConstraints(Model):
    """The execution constraints for a job.

    :param max_wall_clock_time: The maximum elapsed time that the job may run,
     measured from the time the job is created. If the job does not complete
     within the time limit, the Batch service terminates it and any tasks that
     are still running. In this case, the termination reason will be
     MaxWallClockTimeExpiry. If this property is not specified, there is no
     time limit on how long the job may run.
    :type max_wall_clock_time: timedelta
    :param max_task_retry_count: The maximum number of times each task may be
     retried. The Batch service retries a task if its exit code is nonzero.
     Note that this value specifically controls the number of retries. The
     Batch service will try each task once, and may then retry up to this
     limit. For example, if the maximum retry count is 3, Batch tries a task up
     to 4 times (one initial try and 3 retries). If the maximum retry count is
     0, the Batch service does not retry tasks. If the maximum retry count is
     -1, the Batch service retries tasks without limit. The default value is 0
     (no retries).
    :type max_task_retry_count: int
    """

    _attribute_map = {
        'max_wall_clock_time': {'key': 'maxWallClockTime', 'type': 'duration'},
        'max_task_retry_count': {'key': 'maxTaskRetryCount', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(JobConstraints, self).__init__(**kwargs)
        self.max_wall_clock_time = kwargs.get('max_wall_clock_time', None)
        self.max_task_retry_count = kwargs.get('max_task_retry_count', None)


class JobDeleteOptions(Model):
    """Additional parameters for delete operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    :param if_match: An ETag value associated with the version of the resource
     known to the client. The operation will be performed only if the
     resource's current ETag on the service exactly matches the value specified
     by the client.
    :type if_match: str
    :param if_none_match: An ETag value associated with the version of the
     resource known to the client. The operation will be performed only if the
     resource's current ETag on the service does not match the value specified
     by the client.
    :type if_none_match: str
    :param if_modified_since: A timestamp indicating the last modified time of
     the resource known to the client. The operation will be performed only if
     the resource on the service has been modified since the specified time.
    :type if_modified_since: datetime
    :param if_unmodified_since: A timestamp indicating the last modified time
     of the resource known to the client. The operation will be performed only
     if the resource on the service has not been modified since the specified
     time.
    :type if_unmodified_since: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
        'if_match': {'key': '', 'type': 'str'},
        'if_none_match': {'key': '', 'type': 'str'},
        'if_modified_since': {'key': '', 'type': 'rfc-1123'},
        'if_unmodified_since': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(JobDeleteOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)
        self.if_match = kwargs.get('if_match', None)
        self.if_none_match = kwargs.get('if_none_match', None)
        self.if_modified_since = kwargs.get('if_modified_since', None)
        self.if_unmodified_since = kwargs.get('if_unmodified_since', None)


class JobDisableOptions(Model):
    """Additional parameters for disable operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    :param if_match: An ETag value associated with the version of the resource
     known to the client. The operation will be performed only if the
     resource's current ETag on the service exactly matches the value specified
     by the client.
    :type if_match: str
    :param if_none_match: An ETag value associated with the version of the
     resource known to the client. The operation will be performed only if the
     resource's current ETag on the service does not match the value specified
     by the client.
    :type if_none_match: str
    :param if_modified_since: A timestamp indicating the last modified time of
     the resource known to the client. The operation will be performed only if
     the resource on the service has been modified since the specified time.
    :type if_modified_since: datetime
    :param if_unmodified_since: A timestamp indicating the last modified time
     of the resource known to the client. The operation will be performed only
     if the resource on the service has not been modified since the specified
     time.
    :type if_unmodified_since: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
        'if_match': {'key': '', 'type': 'str'},
        'if_none_match': {'key': '', 'type': 'str'},
        'if_modified_since': {'key': '', 'type': 'rfc-1123'},
        'if_unmodified_since': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(JobDisableOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)
        self.if_match = kwargs.get('if_match', None)
        self.if_none_match = kwargs.get('if_none_match', None)
        self.if_modified_since = kwargs.get('if_modified_since', None)
        self.if_unmodified_since = kwargs.get('if_unmodified_since', None)


class JobDisableParameter(Model):
    """Options when disabling a job.

    All required parameters must be populated in order to send to Azure.

    :param disable_tasks: Required. What to do with active tasks associated
     with the job. Possible values include: 'requeue', 'terminate', 'wait'
    :type disable_tasks: str or ~azure.batch.models.DisableJobOption
    """

    _validation = {
        'disable_tasks': {'required': True},
    }

    _attribute_map = {
        'disable_tasks': {'key': 'disableTasks', 'type': 'DisableJobOption'},
    }

    def __init__(self, **kwargs):
        super(JobDisableParameter, self).__init__(**kwargs)
        self.disable_tasks = kwargs.get('disable_tasks', None)


class JobEnableOptions(Model):
    """Additional parameters for enable operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    :param if_match: An ETag value associated with the version of the resource
     known to the client. The operation will be performed only if the
     resource's current ETag on the service exactly matches the value specified
     by the client.
    :type if_match: str
    :param if_none_match: An ETag value associated with the version of the
     resource known to the client. The operation will be performed only if the
     resource's current ETag on the service does not match the value specified
     by the client.
    :type if_none_match: str
    :param if_modified_since: A timestamp indicating the last modified time of
     the resource known to the client. The operation will be performed only if
     the resource on the service has been modified since the specified time.
    :type if_modified_since: datetime
    :param if_unmodified_since: A timestamp indicating the last modified time
     of the resource known to the client. The operation will be performed only
     if the resource on the service has not been modified since the specified
     time.
    :type if_unmodified_since: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
        'if_match': {'key': '', 'type': 'str'},
        'if_none_match': {'key': '', 'type': 'str'},
        'if_modified_since': {'key': '', 'type': 'rfc-1123'},
        'if_unmodified_since': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(JobEnableOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)
        self.if_match = kwargs.get('if_match', None)
        self.if_none_match = kwargs.get('if_none_match', None)
        self.if_modified_since = kwargs.get('if_modified_since', None)
        self.if_unmodified_since = kwargs.get('if_unmodified_since', None)


class JobExecutionInformation(Model):
    """Contains information about the execution of a job in the Azure Batch
    service.

    All required parameters must be populated in order to send to Azure.

    :param start_time: Required. The start time of the job. This is the time
     at which the job was created.
    :type start_time: datetime
    :param end_time: The completion time of the job. This property is set only
     if the job is in the completed state.
    :type end_time: datetime
    :param pool_id: The ID of the pool to which this job is assigned. This
     element contains the actual pool where the job is assigned. When you get
     job details from the service, they also contain a poolInfo element, which
     contains the pool configuration data from when the job was added or
     updated. That poolInfo element may also contain a poolId element. If it
     does, the two IDs are the same. If it does not, it means the job ran on an
     auto pool, and this property contains the ID of that auto pool.
    :type pool_id: str
    :param scheduling_error: Details of any error encountered by the service
     in starting the job. This property is not set if there was no error
     starting the job.
    :type scheduling_error: ~azure.batch.models.JobSchedulingError
    :param terminate_reason: A string describing the reason the job ended.
     This property is set only if the job is in the completed state. If the
     Batch service terminates the job, it sets the reason as follows:
     JMComplete - the Job Manager task completed, and killJobOnCompletion was
     set to true. MaxWallClockTimeExpiry - the job reached its maxWallClockTime
     constraint. TerminateJobSchedule - the job ran as part of a schedule, and
     the schedule terminated. AllTasksComplete - the job's onAllTasksComplete
     attribute is set to terminatejob, and all tasks in the job are complete.
     TaskFailed - the job's onTaskFailure attribute is set to
     performExitOptionsJobAction, and a task in the job failed with an exit
     condition that specified a jobAction of terminatejob. Any other string is
     a user-defined reason specified in a call to the 'Terminate a job'
     operation.
    :type terminate_reason: str
    """

    _validation = {
        'start_time': {'required': True},
    }

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'pool_id': {'key': 'poolId', 'type': 'str'},
        'scheduling_error': {'key': 'schedulingError', 'type': 'JobSchedulingError'},
        'terminate_reason': {'key': 'terminateReason', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(JobExecutionInformation, self).__init__(**kwargs)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.pool_id = kwargs.get('pool_id', None)
        self.scheduling_error = kwargs.get('scheduling_error', None)
        self.terminate_reason = kwargs.get('terminate_reason', None)


class JobGetAllLifetimeStatisticsOptions(Model):
    """Additional parameters for get_all_lifetime_statistics operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(JobGetAllLifetimeStatisticsOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)


class JobGetOptions(Model):
    """Additional parameters for get operation.

    :param select: An OData $select clause.
    :type select: str
    :param expand: An OData $expand clause.
    :type expand: str
    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    :param if_match: An ETag value associated with the version of the resource
     known to the client. The operation will be performed only if the
     resource's current ETag on the service exactly matches the value specified
     by the client.
    :type if_match: str
    :param if_none_match: An ETag value associated with the version of the
     resource known to the client. The operation will be performed only if the
     resource's current ETag on the service does not match the value specified
     by the client.
    :type if_none_match: str
    :param if_modified_since: A timestamp indicating the last modified time of
     the resource known to the client. The operation will be performed only if
     the resource on the service has been modified since the specified time.
    :type if_modified_since: datetime
    :param if_unmodified_since: A timestamp indicating the last modified time
     of the resource known to the client. The operation will be performed only
     if the resource on the service has not been modified since the specified
     time.
    :type if_unmodified_since: datetime
    """

    _attribute_map = {
        'select': {'key': '', 'type': 'str'},
        'expand': {'key': '', 'type': 'str'},
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
        'if_match': {'key': '', 'type': 'str'},
        'if_none_match': {'key': '', 'type': 'str'},
        'if_modified_since': {'key': '', 'type': 'rfc-1123'},
        'if_unmodified_since': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(JobGetOptions, self).__init__(**kwargs)
        self.select = kwargs.get('select', None)
        self.expand = kwargs.get('expand', None)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)
        self.if_match = kwargs.get('if_match', None)
        self.if_none_match = kwargs.get('if_none_match', None)
        self.if_modified_since = kwargs.get('if_modified_since', None)
        self.if_unmodified_since = kwargs.get('if_unmodified_since', None)


class JobGetTaskCountsOptions(Model):
    """Additional parameters for get_task_counts operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(JobGetTaskCountsOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)


class JobListFromJobScheduleOptions(Model):
    """Additional parameters for list_from_job_schedule operation.

    :param filter: An OData $filter clause. For more information on
     constructing this filter, see
     https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-jobs-in-a-job-schedule.
    :type filter: str
    :param select: An OData $select clause.
    :type select: str
    :param expand: An OData $expand clause.
    :type expand: str
    :param max_results: The maximum number of items to return in the response.
     A maximum of 1000 jobs can be returned. Default value: 1000 .
    :type max_results: int
    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    """

    _attribute_map = {
        'filter': {'key': '', 'type': 'str'},
        'select': {'key': '', 'type': 'str'},
        'expand': {'key': '', 'type': 'str'},
        'max_results': {'key': '', 'type': 'int'},
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(JobListFromJobScheduleOptions, self).__init__(**kwargs)
        self.filter = kwargs.get('filter', None)
        self.select = kwargs.get('select', None)
        self.expand = kwargs.get('expand', None)
        self.max_results = kwargs.get('max_results', 1000)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)


class JobListOptions(Model):
    """Additional parameters for list operation.

    :param filter: An OData $filter clause. For more information on
     constructing this filter, see
     https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-jobs.
    :type filter: str
    :param select: An OData $select clause.
    :type select: str
    :param expand: An OData $expand clause.
    :type expand: str
    :param max_results: The maximum number of items to return in the response.
     A maximum of 1000 jobs can be returned. Default value: 1000 .
    :type max_results: int
    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    """

    _attribute_map = {
        'filter': {'key': '', 'type': 'str'},
        'select': {'key': '', 'type': 'str'},
        'expand': {'key': '', 'type': 'str'},
        'max_results': {'key': '', 'type': 'int'},
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(JobListOptions, self).__init__(**kwargs)
        self.filter = kwargs.get('filter', None)
        self.select = kwargs.get('select', None)
        self.expand = kwargs.get('expand', None)
        self.max_results = kwargs.get('max_results', 1000)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)


class JobListPreparationAndReleaseTaskStatusOptions(Model):
    """Additional parameters for list_preparation_and_release_task_status
    operation.

    :param filter: An OData $filter clause. For more information on
     constructing this filter, see
     https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-job-preparation-and-release-status.
    :type filter: str
    :param select: An OData $select clause.
    :type select: str
    :param max_results: The maximum number of items to return in the response.
     A maximum of 1000 tasks can be returned. Default value: 1000 .
    :type max_results: int
    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    """

    _attribute_map = {
        'filter': {'key': '', 'type': 'str'},
        'select': {'key': '', 'type': 'str'},
        'max_results': {'key': '', 'type': 'int'},
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(JobListPreparationAndReleaseTaskStatusOptions, self).__init__(**kwargs)
        self.filter = kwargs.get('filter', None)
        self.select = kwargs.get('select', None)
        self.max_results = kwargs.get('max_results', 1000)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)


class JobManagerTask(Model):
    """Specifies details of a Job Manager task.

    The Job Manager task is automatically started when the job is created. The
    Batch service tries to schedule the Job Manager task before any other tasks
    in the job. When shrinking a pool, the Batch service tries to preserve
    compute nodes where Job Manager tasks are running for as long as possible
    (that is, nodes running 'normal' tasks are removed before nodes running Job
    Manager tasks). When a Job Manager task fails and needs to be restarted,
    the system tries to schedule it at the highest priority. If there are no
    idle nodes available, the system may terminate one of the running tasks in
    the pool and return it to the queue in order to make room for the Job
    Manager task to restart. Note that a Job Manager task in one job does not
    have priority over tasks in other jobs. Across jobs, only job level
    priorities are observed. For example, if a Job Manager in a priority 0 job
    needs to be restarted, it will not displace tasks of a priority 1 job.
    Batch will retry tasks when a recovery operation is triggered on a compute
    node. Examples of recovery operations include (but are not limited to) when
    an unhealthy compute node is rebooted or a compute node disappeared due to
    host failure. Retries due to recovery operations are independent of and are
    not counted against the maxTaskRetryCount. Even if the maxTaskRetryCount is
    0, an internal retry due to a recovery operation may occur. Because of
    this, all tasks should be idempotent. This means tasks need to tolerate
    being interrupted and restarted without causing any corruption or duplicate
    data. The best practice for long running tasks is to use some form of
    checkpointing.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. A string that uniquely identifies the Job Manager
     task within the job. The ID can contain any combination of alphanumeric
     characters including hyphens and underscores and cannot contain more than
     64 characters.
    :type id: str
    :param display_name: The display name of the Job Manager task. It need not
     be unique and can contain any Unicode characters up to a maximum length of
     1024.
    :type display_name: str
    :param command_line: Required. The command line of the Job Manager task.
     The command line does not run under a shell, and therefore cannot take
     advantage of shell features such as environment variable expansion. If you
     want to take advantage of such features, you should invoke the shell in
     the command line, for example using "cmd /c MyCommand" in Windows or
     "/bin/sh -c MyCommand" in Linux. If the command line refers to file paths,
     it should use a relative path (relative to the task working directory), or
     use the Batch provided environment variable
     (https://docs.microsoft.com/en-us/azure/batch/batch-compute-node-environment-variables).
    :type command_line: str
    :param container_settings: The settings for the container under which the
     Job Manager task runs. If the pool that will run this task has
     containerConfiguration set, this must be set as well. If the pool that
     will run this task doesn't have containerConfiguration set, this must not
     be set. When this is specified, all directories recursively below the
     AZ_BATCH_NODE_ROOT_DIR (the root of Azure Batch directories on the node)
     are mapped into the container, all task environment variables are mapped
     into the container, and the task command line is executed in the
     container.
    :type container_settings: ~azure.batch.models.TaskContainerSettings
    :param resource_files: A list of files that the Batch service will
     download to the compute node before running the command line. Files listed
     under this element are located in the task's working directory. There is a
     maximum size for the list of resource files.  When the max size is
     exceeded, the request will fail and the response error code will be
     RequestEntityTooLarge. If this occurs, the collection of ResourceFiles
     must be reduced in size. This can be achieved using .zip files,
     Application Packages, or Docker Containers.
    :type resource_files: list[~azure.batch.models.ResourceFile]
    :param output_files: A list of files that the Batch service will upload
     from the compute node after running the command line. For multi-instance
     tasks, the files will only be uploaded from the compute node on which the
     primary task is executed.
    :type output_files: list[~azure.batch.models.OutputFile]
    :param environment_settings: A list of environment variable settings for
     the Job Manager task.
    :type environment_settings: list[~azure.batch.models.EnvironmentSetting]
    :param constraints: Constraints that apply to the Job Manager task.
    :type constraints: ~azure.batch.models.TaskConstraints
    :param kill_job_on_completion: Whether completion of the Job Manager task
     signifies completion of the entire job. If true, when the Job Manager task
     completes, the Batch service marks the job as complete. If any tasks are
     still running at this time (other than Job Release), those tasks are
     terminated. If false, the completion of the Job Manager task does not
     affect the job status. In this case, you should either use the
     onAllTasksComplete attribute to terminate the job, or have a client or
     user terminate the job explicitly. An example of this is if the Job
     Manager creates a set of tasks but then takes no further role in their
     execution. The default value is true. If you are using the
     onAllTasksComplete and onTaskFailure attributes to control job lifetime,
     and using the Job Manager task only to create the tasks for the job (not
     to monitor progress), then it is important to set killJobOnCompletion to
     false.
    :type kill_job_on_completion: bool
    :param user_identity: The user identity under which the Job Manager task
     runs. If omitted, the task runs as a non-administrative user unique to the
     task.
    :type user_identity: ~azure.batch.models.UserIdentity
    :param run_exclusive: Whether the Job Manager task requires exclusive use
     of the compute node where it runs. If true, no other tasks will run on the
     same compute node for as long as the Job Manager is running. If false,
     other tasks can run simultaneously with the Job Manager on a compute node.
     The Job Manager task counts normally against the node's concurrent task
     limit, so this is only relevant if the node allows multiple concurrent
     tasks. The default value is true.
    :type run_exclusive: bool
    :param application_package_references: A list of application packages that
     the Batch service will deploy to the compute node before running the
     command line. Application packages are downloaded and deployed to a shared
     directory, not the task working directory. Therefore, if a referenced
     package is already on the compute node, and is up to date, then it is not
     re-downloaded; the existing copy on the compute node is used. If a
     referenced application package cannot be installed, for example because
     the package has been deleted or because download failed, the task fails.
    :type application_package_references:
     list[~azure.batch.models.ApplicationPackageReference]
    :param authentication_token_settings: The settings for an authentication
     token that the task can use to perform Batch service operations. If this
     property is set, the Batch service provides the task with an
     authentication token which can be used to authenticate Batch service
     operations without requiring an account access key. The token is provided
     via the AZ_BATCH_AUTHENTICATION_TOKEN environment variable. The operations
     that the task can carry out using the token depend on the settings. For
     example, a task can request job permissions in order to add other tasks to
     the job, or check the status of the job or of other tasks under the job.
    :type authentication_token_settings:
     ~azure.batch.models.AuthenticationTokenSettings
    :param allow_low_priority_node: Whether the Job Manager task may run on a
     low-priority compute node. The default value is true.
    :type allow_low_priority_node: bool
    """

    _validation = {
        'id': {'required': True},
        'command_line': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'command_line': {'key': 'commandLine', 'type': 'str'},
        'container_settings': {'key': 'containerSettings', 'type': 'TaskContainerSettings'},
        'resource_files': {'key': 'resourceFiles', 'type': '[ResourceFile]'},
        'output_files': {'key': 'outputFiles', 'type': '[OutputFile]'},
        'environment_settings': {'key': 'environmentSettings', 'type': '[EnvironmentSetting]'},
        'constraints': {'key': 'constraints', 'type': 'TaskConstraints'},
        'kill_job_on_completion': {'key': 'killJobOnCompletion', 'type': 'bool'},
        'user_identity': {'key': 'userIdentity', 'type': 'UserIdentity'},
        'run_exclusive': {'key': 'runExclusive', 'type': 'bool'},
        'application_package_references': {'key': 'applicationPackageReferences', 'type': '[ApplicationPackageReference]'},
        'authentication_token_settings': {'key': 'authenticationTokenSettings', 'type': 'AuthenticationTokenSettings'},
        'allow_low_priority_node': {'key': 'allowLowPriorityNode', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(JobManagerTask, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.display_name = kwargs.get('display_name', None)
        self.command_line = kwargs.get('command_line', None)
        self.container_settings = kwargs.get('container_settings', None)
        self.resource_files = kwargs.get('resource_files', None)
        self.output_files = kwargs.get('output_files', None)
        self.environment_settings = kwargs.get('environment_settings', None)
        self.constraints = kwargs.get('constraints', None)
        self.kill_job_on_completion = kwargs.get('kill_job_on_completion', None)
        self.user_identity = kwargs.get('user_identity', None)
        self.run_exclusive = kwargs.get('run_exclusive', None)
        self.application_package_references = kwargs.get('application_package_references', None)
        self.authentication_token_settings = kwargs.get('authentication_token_settings', None)
        self.allow_low_priority_node = kwargs.get('allow_low_priority_node', None)


class JobNetworkConfiguration(Model):
    """The network configuration for the job.

    All required parameters must be populated in order to send to Azure.

    :param subnet_id: Required. The ARM resource identifier of the virtual
     network subnet which nodes running tasks from the job will join for the
     duration of the task. This is only supported for jobs running on
     VirtualMachineConfiguration pools. This is of the form
     /subscriptions/{subscription}/resourceGroups/{group}/providers/{provider}/virtualNetworks/{network}/subnets/{subnet}.
     The virtual network must be in the same region and subscription as the
     Azure Batch account. The specified subnet should have enough free IP
     addresses to accommodate the number of nodes which will run tasks from the
     job. For more details, see
     https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration.
    :type subnet_id: str
    """

    _validation = {
        'subnet_id': {'required': True},
    }

    _attribute_map = {
        'subnet_id': {'key': 'subnetId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(JobNetworkConfiguration, self).__init__(**kwargs)
        self.subnet_id = kwargs.get('subnet_id', None)


class JobPatchOptions(Model):
    """Additional parameters for patch operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    :param if_match: An ETag value associated with the version of the resource
     known to the client. The operation will be performed only if the
     resource's current ETag on the service exactly matches the value specified
     by the client.
    :type if_match: str
    :param if_none_match: An ETag value associated with the version of the
     resource known to the client. The operation will be performed only if the
     resource's current ETag on the service does not match the value specified
     by the client.
    :type if_none_match: str
    :param if_modified_since: A timestamp indicating the last modified time of
     the resource known to the client. The operation will be performed only if
     the resource on the service has been modified since the specified time.
    :type if_modified_since: datetime
    :param if_unmodified_since: A timestamp indicating the last modified time
     of the resource known to the client. The operation will be performed only
     if the resource on the service has not been modified since the specified
     time.
    :type if_unmodified_since: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
        'if_match': {'key': '', 'type': 'str'},
        'if_none_match': {'key': '', 'type': 'str'},
        'if_modified_since': {'key': '', 'type': 'rfc-1123'},
        'if_unmodified_since': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(JobPatchOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)
        self.if_match = kwargs.get('if_match', None)
        self.if_none_match = kwargs.get('if_none_match', None)
        self.if_modified_since = kwargs.get('if_modified_since', None)
        self.if_unmodified_since = kwargs.get('if_unmodified_since', None)


class JobPatchParameter(Model):
    """The set of changes to be made to a job.

    :param priority: The priority of the job. Priority values can range from
     -1000 to 1000, with -1000 being the lowest priority and 1000 being the
     highest priority. If omitted, the priority of the job is left unchanged.
    :type priority: int
    :param on_all_tasks_complete: The action the Batch service should take
     when all tasks in the job are in the completed state. If omitted, the
     completion behavior is left unchanged. You may not change the value from
     terminatejob to noaction - that is, once you have engaged automatic job
     termination, you cannot turn it off again. If you try to do this, the
     request fails with an 'invalid property value' error response; if you are
     calling the REST API directly, the HTTP status code is 400 (Bad Request).
     Possible values include: 'noAction', 'terminateJob'
    :type on_all_tasks_complete: str or ~azure.batch.models.OnAllTasksComplete
    :param constraints: The execution constraints for the job. If omitted, the
     existing execution constraints are left unchanged.
    :type constraints: ~azure.batch.models.JobConstraints
    :param pool_info: The pool on which the Batch service runs the job's
     tasks. You may change the pool for a job only when the job is disabled.
     The Patch Job call will fail if you include the poolInfo element and the
     job is not disabled. If you specify an autoPoolSpecification specification
     in the poolInfo, only the keepAlive property can be updated, and then only
     if the auto pool has a poolLifetimeOption of job. If omitted, the job
     continues to run on its current pool.
    :type pool_info: ~azure.batch.models.PoolInformation
    :param metadata: A list of name-value pairs associated with the job as
     metadata. If omitted, the existing job metadata is left unchanged.
    :type metadata: list[~azure.batch.models.MetadataItem]
    """

    _attribute_map = {
        'priority': {'key': 'priority', 'type': 'int'},
        'on_all_tasks_complete': {'key': 'onAllTasksComplete', 'type': 'OnAllTasksComplete'},
        'constraints': {'key': 'constraints', 'type': 'JobConstraints'},
        'pool_info': {'key': 'poolInfo', 'type': 'PoolInformation'},
        'metadata': {'key': 'metadata', 'type': '[MetadataItem]'},
    }

    def __init__(self, **kwargs):
        super(JobPatchParameter, self).__init__(**kwargs)
        self.priority = kwargs.get('priority', None)
        self.on_all_tasks_complete = kwargs.get('on_all_tasks_complete', None)
        self.constraints = kwargs.get('constraints', None)
        self.pool_info = kwargs.get('pool_info', None)
        self.metadata = kwargs.get('metadata', None)


class JobPreparationAndReleaseTaskExecutionInformation(Model):
    """The status of the Job Preparation and Job Release tasks on a compute node.

    :param pool_id: The ID of the pool containing the compute node to which
     this entry refers.
    :type pool_id: str
    :param node_id: The ID of the compute node to which this entry refers.
    :type node_id: str
    :param node_url: The URL of the compute node to which this entry refers.
    :type node_url: str
    :param job_preparation_task_execution_info: Information about the
     execution status of the Job Preparation task on this compute node.
    :type job_preparation_task_execution_info:
     ~azure.batch.models.JobPreparationTaskExecutionInformation
    :param job_release_task_execution_info: Information about the execution
     status of the Job Release task on this compute node. This property is set
     only if the Job Release task has run on the node.
    :type job_release_task_execution_info:
     ~azure.batch.models.JobReleaseTaskExecutionInformation
    """

    _attribute_map = {
        'pool_id': {'key': 'poolId', 'type': 'str'},
        'node_id': {'key': 'nodeId', 'type': 'str'},
        'node_url': {'key': 'nodeUrl', 'type': 'str'},
        'job_preparation_task_execution_info': {'key': 'jobPreparationTaskExecutionInfo', 'type': 'JobPreparationTaskExecutionInformation'},
        'job_release_task_execution_info': {'key': 'jobReleaseTaskExecutionInfo', 'type': 'JobReleaseTaskExecutionInformation'},
    }

    def __init__(self, **kwargs):
        super(JobPreparationAndReleaseTaskExecutionInformation, self).__init__(**kwargs)
        self.pool_id = kwargs.get('pool_id', None)
        self.node_id = kwargs.get('node_id', None)
        self.node_url = kwargs.get('node_url', None)
        self.job_preparation_task_execution_info = kwargs.get('job_preparation_task_execution_info', None)
        self.job_release_task_execution_info = kwargs.get('job_release_task_execution_info', None)


class JobPreparationTask(Model):
    """A Job Preparation task to run before any tasks of the job on any given
    compute node.

    You can use Job Preparation to prepare a compute node to run tasks for the
    job. Activities commonly performed in Job Preparation include: Downloading
    common resource files used by all the tasks in the job. The Job Preparation
    task can download these common resource files to the shared location on the
    compute node. (AZ_BATCH_NODE_ROOT_DIR\shared), or starting a local service
    on the compute node so that all tasks of that job can communicate with it.
    If the Job Preparation task fails (that is, exhausts its retry count before
    exiting with exit code 0), Batch will not run tasks of this job on the
    compute node. The node remains ineligible to run tasks of this job until it
    is reimaged. The node remains active and can be used for other jobs. The
    Job Preparation task can run multiple times on the same compute node.
    Therefore, you should write the Job Preparation task to handle
    re-execution. If the compute node is rebooted, the Job Preparation task is
    run again on the node before scheduling any other task of the job, if
    rerunOnNodeRebootAfterSuccess is true or if the Job Preparation task did
    not previously complete. If the compute node is reimaged, the Job
    Preparation task is run again before scheduling any task of the job. Batch
    will retry tasks when a recovery operation is triggered on a compute node.
    Examples of recovery operations include (but are not limited to) when an
    unhealthy compute node is rebooted or a compute node disappeared due to
    host failure. Retries due to recovery operations are independent of and are
    not counted against the maxTaskRetryCount. Even if the maxTaskRetryCount is
    0, an internal retry due to a recovery operation may occur. Because of
    this, all tasks should be idempotent. This means tasks need to tolerate
    being interrupted and restarted without causing any corruption or duplicate
    data. The best practice for long running tasks is to use some form of
    checkpointing.

    All required parameters must be populated in order to send to Azure.

    :param id: A string that uniquely identifies the Job Preparation task
     within the job. The ID can contain any combination of alphanumeric
     characters including hyphens and underscores and cannot contain more than
     64 characters. If you do not specify this property, the Batch service
     assigns a default value of 'jobpreparation'. No other task in the job can
     have the same ID as the Job Preparation task. If you try to submit a task
     with the same id, the Batch service rejects the request with error code
     TaskIdSameAsJobPreparationTask; if you are calling the REST API directly,
     the HTTP status code is 409 (Conflict).
    :type id: str
    :param command_line: Required. The command line of the Job Preparation
     task. The command line does not run under a shell, and therefore cannot
     take advantage of shell features such as environment variable expansion.
     If you want to take advantage of such features, you should invoke the
     shell in the command line, for example using "cmd /c MyCommand" in Windows
     or "/bin/sh -c MyCommand" in Linux. If the command line refers to file
     paths, it should use a relative path (relative to the task working
     directory), or use the Batch provided environment variable
     (https://docs.microsoft.com/en-us/azure/batch/batch-compute-node-environment-variables).
    :type command_line: str
    :param container_settings: The settings for the container under which the
     Job Preparation task runs. When this is specified, all directories
     recursively below the AZ_BATCH_NODE_ROOT_DIR (the root of Azure Batch
     directories on the node) are mapped into the container, all task
     environment variables are mapped into the container, and the task command
     line is executed in the container.
    :type container_settings: ~azure.batch.models.TaskContainerSettings
    :param resource_files: A list of files that the Batch service will
     download to the compute node before running the command line. Files listed
     under this element are located in the task's working directory.  There is
     a maximum size for the list of resource files.  When the max size is
     exceeded, the request will fail and the response error code will be
     RequestEntityTooLarge. If this occurs, the collection of ResourceFiles
     must be reduced in size. This can be achieved using .zip files,
     Application Packages, or Docker Containers.
    :type resource_files: list[~azure.batch.models.ResourceFile]
    :param environment_settings: A list of environment variable settings for
     the Job Preparation task.
    :type environment_settings: list[~azure.batch.models.EnvironmentSetting]
    :param constraints: Constraints that apply to the Job Preparation task.
    :type constraints: ~azure.batch.models.TaskConstraints
    :param wait_for_success: Whether the Batch service should wait for the Job
     Preparation task to complete successfully before scheduling any other
     tasks of the job on the compute node. A Job Preparation task has completed
     successfully if it exits with exit code 0. If true and the Job Preparation
     task fails on a compute node, the Batch service retries the Job
     Preparation task up to its maximum retry count (as specified in the
     constraints element). If the task has still not completed successfully
     after all retries, then the Batch service will not schedule tasks of the
     job to the compute node. The compute node remains active and eligible to
     run tasks of other jobs. If false, the Batch service will not wait for the
     Job Preparation task to complete. In this case, other tasks of the job can
     start executing on the compute node while the Job Preparation task is
     still running; and even if the Job Preparation task fails, new tasks will
     continue to be scheduled on the node. The default value is true.
    :type wait_for_success: bool
    :param user_identity: The user identity under which the Job Preparation
     task runs. If omitted, the task runs as a non-administrative user unique
     to the task on Windows nodes, or a a non-administrative user unique to the
     pool on Linux nodes.
    :type user_identity: ~azure.batch.models.UserIdentity
    :param rerun_on_node_reboot_after_success: Whether the Batch service
     should rerun the Job Preparation task after a compute node reboots. The
     Job Preparation task is always rerun if a compute node is reimaged, or if
     the Job Preparation task did not complete (e.g. because the reboot
     occurred while the task was running). Therefore, you should always write a
     Job Preparation task to be idempotent and to behave correctly if run
     multiple times. The default value is true.
    :type rerun_on_node_reboot_after_success: bool
    """

    _validation = {
        'command_line': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'command_line': {'key': 'commandLine', 'type': 'str'},
        'container_settings': {'key': 'containerSettings', 'type': 'TaskContainerSettings'},
        'resource_files': {'key': 'resourceFiles', 'type': '[ResourceFile]'},
        'environment_settings': {'key': 'environmentSettings', 'type': '[EnvironmentSetting]'},
        'constraints': {'key': 'constraints', 'type': 'TaskConstraints'},
        'wait_for_success': {'key': 'waitForSuccess', 'type': 'bool'},
        'user_identity': {'key': 'userIdentity', 'type': 'UserIdentity'},
        'rerun_on_node_reboot_after_success': {'key': 'rerunOnNodeRebootAfterSuccess', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(JobPreparationTask, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.command_line = kwargs.get('command_line', None)
        self.container_settings = kwargs.get('container_settings', None)
        self.resource_files = kwargs.get('resource_files', None)
        self.environment_settings = kwargs.get('environment_settings', None)
        self.constraints = kwargs.get('constraints', None)
        self.wait_for_success = kwargs.get('wait_for_success', None)
        self.user_identity = kwargs.get('user_identity', None)
        self.rerun_on_node_reboot_after_success = kwargs.get('rerun_on_node_reboot_after_success', None)


class JobPreparationTaskExecutionInformation(Model):
    """Contains information about the execution of a Job Preparation task on a
    compute node.

    All required parameters must be populated in order to send to Azure.

    :param start_time: Required. The time at which the task started running.
     If the task has been restarted or retried, this is the most recent time at
     which the task started running.
    :type start_time: datetime
    :param end_time: The time at which the Job Preparation task completed.
     This property is set only if the task is in the Completed state.
    :type end_time: datetime
    :param state: Required. The current state of the Job Preparation task on
     the compute node. Possible values include: 'running', 'completed'
    :type state: str or ~azure.batch.models.JobPreparationTaskState
    :param task_root_directory: The root directory of the Job Preparation task
     on the compute node. You can use this path to retrieve files created by
     the task, such as log files.
    :type task_root_directory: str
    :param task_root_directory_url: The URL to the root directory of the Job
     Preparation task on the compute node.
    :type task_root_directory_url: str
    :param exit_code: The exit code of the program specified on the task
     command line. This parameter is returned only if the task is in the
     completed state. The exit code for a process reflects the specific
     convention implemented by the application developer for that process. If
     you use the exit code value to make decisions in your code, be sure that
     you know the exit code convention used by the application process. Note
     that the exit code may also be generated by the compute node operating
     system, such as when a process is forcibly terminated.
    :type exit_code: int
    :param container_info: Information about the container under which the
     task is executing. This property is set only if the task runs in a
     container context.
    :type container_info:
     ~azure.batch.models.TaskContainerExecutionInformation
    :param failure_info: Information describing the task failure, if any. This
     property is set only if the task is in the completed state and encountered
     a failure.
    :type failure_info: ~azure.batch.models.TaskFailureInformation
    :param retry_count: Required. The number of times the task has been
     retried by the Batch service. Task application failures (non-zero exit
     code) are retried, pre-processing errors (the task could not be run) and
     file upload errors are not retried. The Batch service will retry the task
     up to the limit specified by the constraints. Task application failures
     (non-zero exit code) are retried, pre-processing errors (the task could
     not be run) and file upload errors are not retried. The Batch service will
     retry the task up to the limit specified by the constraints.
    :type retry_count: int
    :param last_retry_time: The most recent time at which a retry of the Job
     Preparation task started running. This property is set only if the task
     was retried (i.e. retryCount is nonzero). If present, this is typically
     the same as startTime, but may be different if the task has been restarted
     for reasons other than retry; for example, if the compute node was
     rebooted during a retry, then the startTime is updated but the
     lastRetryTime is not.
    :type last_retry_time: datetime
    :param result: The result of the task execution. If the value is 'failed',
     then the details of the failure can be found in the failureInfo property.
     Possible values include: 'success', 'failure'
    :type result: str or ~azure.batch.models.TaskExecutionResult
    """

    _validation = {
        'start_time': {'required': True},
        'state': {'required': True},
        'retry_count': {'required': True},
    }

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'state': {'key': 'state', 'type': 'JobPreparationTaskState'},
        'task_root_directory': {'key': 'taskRootDirectory', 'type': 'str'},
        'task_root_directory_url': {'key': 'taskRootDirectoryUrl', 'type': 'str'},
        'exit_code': {'key': 'exitCode', 'type': 'int'},
        'container_info': {'key': 'containerInfo', 'type': 'TaskContainerExecutionInformation'},
        'failure_info': {'key': 'failureInfo', 'type': 'TaskFailureInformation'},
        'retry_count': {'key': 'retryCount', 'type': 'int'},
        'last_retry_time': {'key': 'lastRetryTime', 'type': 'iso-8601'},
        'result': {'key': 'result', 'type': 'TaskExecutionResult'},
    }

    def __init__(self, **kwargs):
        super(JobPreparationTaskExecutionInformation, self).__init__(**kwargs)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.state = kwargs.get('state', None)
        self.task_root_directory = kwargs.get('task_root_directory', None)
        self.task_root_directory_url = kwargs.get('task_root_directory_url', None)
        self.exit_code = kwargs.get('exit_code', None)
        self.container_info = kwargs.get('container_info', None)
        self.failure_info = kwargs.get('failure_info', None)
        self.retry_count = kwargs.get('retry_count', None)
        self.last_retry_time = kwargs.get('last_retry_time', None)
        self.result = kwargs.get('result', None)


class JobReleaseTask(Model):
    """A Job Release task to run on job completion on any compute node where the
    job has run.

    The Job Release task runs when the job ends, because of one of the
    following: The user calls the Terminate Job API, or the Delete Job API
    while the job is still active, the job's maximum wall clock time constraint
    is reached, and the job is still active, or the job's Job Manager task
    completed, and the job is configured to terminate when the Job Manager
    completes. The Job Release task runs on each compute node where tasks of
    the job have run and the Job Preparation task ran and completed. If you
    reimage a compute node after it has run the Job Preparation task, and the
    job ends without any further tasks of the job running on that compute node
    (and hence the Job Preparation task does not re-run), then the Job Release
    task does not run on that node. If a compute node reboots while the Job
    Release task is still running, the Job Release task runs again when the
    compute node starts up. The job is not marked as complete until all Job
    Release tasks have completed. The Job Release task runs in the background.
    It does not occupy a scheduling slot; that is, it does not count towards
    the maxTasksPerNode limit specified on the pool.

    All required parameters must be populated in order to send to Azure.

    :param id: A string that uniquely identifies the Job Release task within
     the job. The ID can contain any combination of alphanumeric characters
     including hyphens and underscores and cannot contain more than 64
     characters. If you do not specify this property, the Batch service assigns
     a default value of 'jobrelease'. No other task in the job can have the
     same ID as the Job Release task. If you try to submit a task with the same
     id, the Batch service rejects the request with error code
     TaskIdSameAsJobReleaseTask; if you are calling the REST API directly, the
     HTTP status code is 409 (Conflict).
    :type id: str
    :param command_line: Required. The command line of the Job Release task.
     The command line does not run under a shell, and therefore cannot take
     advantage of shell features such as environment variable expansion. If you
     want to take advantage of such features, you should invoke the shell in
     the command line, for example using "cmd /c MyCommand" in Windows or
     "/bin/sh -c MyCommand" in Linux. If the command line refers to file paths,
     it should use a relative path (relative to the task working directory), or
     use the Batch provided environment variable
     (https://docs.microsoft.com/en-us/azure/batch/batch-compute-node-environment-variables).
    :type command_line: str
    :param container_settings: The settings for the container under which the
     Job Release task runs. When this is specified, all directories recursively
     below the AZ_BATCH_NODE_ROOT_DIR (the root of Azure Batch directories on
     the node) are mapped into the container, all task environment variables
     are mapped into the container, and the task command line is executed in
     the container.
    :type container_settings: ~azure.batch.models.TaskContainerSettings
    :param resource_files: A list of files that the Batch service will
     download to the compute node before running the command line.  There is a
     maximum size for the list of resource files.  When the max size is
     exceeded, the request will fail and the response error code will be
     RequestEntityTooLarge. If this occurs, the collection of ResourceFiles
     must be reduced in size. This can be achieved using .zip files,
     Application Packages, or Docker Containers. Files listed under this
     element are located in the task's working directory.
    :type resource_files: list[~azure.batch.models.ResourceFile]
    :param environment_settings: A list of environment variable settings for
     the Job Release task.
    :type environment_settings: list[~azure.batch.models.EnvironmentSetting]
    :param max_wall_clock_time: The maximum elapsed time that the Job Release
     task may run on a given compute node, measured from the time the task
     starts. If the task does not complete within the time limit, the Batch
     service terminates it. The default value is 15 minutes. You may not
     specify a timeout longer than 15 minutes. If you do, the Batch service
     rejects it with an error; if you are calling the REST API directly, the
     HTTP status code is 400 (Bad Request).
    :type max_wall_clock_time: timedelta
    :param retention_time: The minimum time to retain the task directory for
     the Job Release task on the compute node. After this time, the Batch
     service may delete the task directory and all its contents. The default is
     7 days, i.e. the task directory will be retained for 7 days unless the
     compute node is removed or the job is deleted.
    :type retention_time: timedelta
    :param user_identity: The user identity under which the Job Release task
     runs. If omitted, the task runs as a non-administrative user unique to the
     task.
    :type user_identity: ~azure.batch.models.UserIdentity
    """

    _validation = {
        'command_line': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'command_line': {'key': 'commandLine', 'type': 'str'},
        'container_settings': {'key': 'containerSettings', 'type': 'TaskContainerSettings'},
        'resource_files': {'key': 'resourceFiles', 'type': '[ResourceFile]'},
        'environment_settings': {'key': 'environmentSettings', 'type': '[EnvironmentSetting]'},
        'max_wall_clock_time': {'key': 'maxWallClockTime', 'type': 'duration'},
        'retention_time': {'key': 'retentionTime', 'type': 'duration'},
        'user_identity': {'key': 'userIdentity', 'type': 'UserIdentity'},
    }

    def __init__(self, **kwargs):
        super(JobReleaseTask, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.command_line = kwargs.get('command_line', None)
        self.container_settings = kwargs.get('container_settings', None)
        self.resource_files = kwargs.get('resource_files', None)
        self.environment_settings = kwargs.get('environment_settings', None)
        self.max_wall_clock_time = kwargs.get('max_wall_clock_time', None)
        self.retention_time = kwargs.get('retention_time', None)
        self.user_identity = kwargs.get('user_identity', None)


class JobReleaseTaskExecutionInformation(Model):
    """Contains information about the execution of a Job Release task on a compute
    node.

    All required parameters must be populated in order to send to Azure.

    :param start_time: Required. The time at which the task started running.
     If the task has been restarted or retried, this is the most recent time at
     which the task started running.
    :type start_time: datetime
    :param end_time: The time at which the Job Release task completed. This
     property is set only if the task is in the Completed state.
    :type end_time: datetime
    :param state: Required. The current state of the Job Release task on the
     compute node. Possible values include: 'running', 'completed'
    :type state: str or ~azure.batch.models.JobReleaseTaskState
    :param task_root_directory: The root directory of the Job Release task on
     the compute node. You can use this path to retrieve files created by the
     task, such as log files.
    :type task_root_directory: str
    :param task_root_directory_url: The URL to the root directory of the Job
     Release task on the compute node.
    :type task_root_directory_url: str
    :param exit_code: The exit code of the program specified on the task
     command line. This parameter is returned only if the task is in the
     completed state. The exit code for a process reflects the specific
     convention implemented by the application developer for that process. If
     you use the exit code value to make decisions in your code, be sure that
     you know the exit code convention used by the application process. Note
     that the exit code may also be generated by the compute node operating
     system, such as when a process is forcibly terminated.
    :type exit_code: int
    :param container_info: Information about the container under which the
     task is executing. This property is set only if the task runs in a
     container context.
    :type container_info:
     ~azure.batch.models.TaskContainerExecutionInformation
    :param failure_info: Information describing the task failure, if any. This
     property is set only if the task is in the completed state and encountered
     a failure.
    :type failure_info: ~azure.batch.models.TaskFailureInformation
    :param result: The result of the task execution. If the value is 'failed',
     then the details of the failure can be found in the failureInfo property.
     Possible values include: 'success', 'failure'
    :type result: str or ~azure.batch.models.TaskExecutionResult
    """

    _validation = {
        'start_time': {'required': True},
        'state': {'required': True},
    }

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'state': {'key': 'state', 'type': 'JobReleaseTaskState'},
        'task_root_directory': {'key': 'taskRootDirectory', 'type': 'str'},
        'task_root_directory_url': {'key': 'taskRootDirectoryUrl', 'type': 'str'},
        'exit_code': {'key': 'exitCode', 'type': 'int'},
        'container_info': {'key': 'containerInfo', 'type': 'TaskContainerExecutionInformation'},
        'failure_info': {'key': 'failureInfo', 'type': 'TaskFailureInformation'},
        'result': {'key': 'result', 'type': 'TaskExecutionResult'},
    }

    def __init__(self, **kwargs):
        super(JobReleaseTaskExecutionInformation, self).__init__(**kwargs)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.state = kwargs.get('state', None)
        self.task_root_directory = kwargs.get('task_root_directory', None)
        self.task_root_directory_url = kwargs.get('task_root_directory_url', None)
        self.exit_code = kwargs.get('exit_code', None)
        self.container_info = kwargs.get('container_info', None)
        self.failure_info = kwargs.get('failure_info', None)
        self.result = kwargs.get('result', None)


class JobScheduleAddOptions(Model):
    """Additional parameters for add operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(JobScheduleAddOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)


class JobScheduleAddParameter(Model):
    """A job schedule that allows recurring jobs by specifying when to run jobs
    and a specification used to create each job.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. A string that uniquely identifies the schedule within
     the account. The ID can contain any combination of alphanumeric characters
     including hyphens and underscores, and cannot contain more than 64
     characters. The ID is case-preserving and case-insensitive (that is, you
     may not have two IDs within an account that differ only by case).
    :type id: str
    :param display_name: The display name for the schedule. The display name
     need not be unique and can contain any Unicode characters up to a maximum
     length of 1024.
    :type display_name: str
    :param schedule: Required. The schedule according to which jobs will be
     created.
    :type schedule: ~azure.batch.models.Schedule
    :param job_specification: Required. The details of the jobs to be created
     on this schedule.
    :type job_specification: ~azure.batch.models.JobSpecification
    :param metadata: A list of name-value pairs associated with the schedule
     as metadata. The Batch service does not assign any meaning to metadata; it
     is solely for the use of user code.
    :type metadata: list[~azure.batch.models.MetadataItem]
    """

    _validation = {
        'id': {'required': True},
        'schedule': {'required': True},
        'job_specification': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'schedule': {'key': 'schedule', 'type': 'Schedule'},
        'job_specification': {'key': 'jobSpecification', 'type': 'JobSpecification'},
        'metadata': {'key': 'metadata', 'type': '[MetadataItem]'},
    }

    def __init__(self, **kwargs):
        super(JobScheduleAddParameter, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.display_name = kwargs.get('display_name', None)
        self.schedule = kwargs.get('schedule', None)
        self.job_specification = kwargs.get('job_specification', None)
        self.metadata = kwargs.get('metadata', None)


class JobScheduleDeleteOptions(Model):
    """Additional parameters for delete operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    :param if_match: An ETag value associated with the version of the resource
     known to the client. The operation will be performed only if the
     resource's current ETag on the service exactly matches the value specified
     by the client.
    :type if_match: str
    :param if_none_match: An ETag value associated with the version of the
     resource known to the client. The operation will be performed only if the
     resource's current ETag on the service does not match the value specified
     by the client.
    :type if_none_match: str
    :param if_modified_since: A timestamp indicating the last modified time of
     the resource known to the client. The operation will be performed only if
     the resource on the service has been modified since the specified time.
    :type if_modified_since: datetime
    :param if_unmodified_since: A timestamp indicating the last modified time
     of the resource known to the client. The operation will be performed only
     if the resource on the service has not been modified since the specified
     time.
    :type if_unmodified_since: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
        'if_match': {'key': '', 'type': 'str'},
        'if_none_match': {'key': '', 'type': 'str'},
        'if_modified_since': {'key': '', 'type': 'rfc-1123'},
        'if_unmodified_since': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(JobScheduleDeleteOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)
        self.if_match = kwargs.get('if_match', None)
        self.if_none_match = kwargs.get('if_none_match', None)
        self.if_modified_since = kwargs.get('if_modified_since', None)
        self.if_unmodified_since = kwargs.get('if_unmodified_since', None)


class JobScheduleDisableOptions(Model):
    """Additional parameters for disable operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    :param if_match: An ETag value associated with the version of the resource
     known to the client. The operation will be performed only if the
     resource's current ETag on the service exactly matches the value specified
     by the client.
    :type if_match: str
    :param if_none_match: An ETag value associated with the version of the
     resource known to the client. The operation will be performed only if the
     resource's current ETag on the service does not match the value specified
     by the client.
    :type if_none_match: str
    :param if_modified_since: A timestamp indicating the last modified time of
     the resource known to the client. The operation will be performed only if
     the resource on the service has been modified since the specified time.
    :type if_modified_since: datetime
    :param if_unmodified_since: A timestamp indicating the last modified time
     of the resource known to the client. The operation will be performed only
     if the resource on the service has not been modified since the specified
     time.
    :type if_unmodified_since: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
        'if_match': {'key': '', 'type': 'str'},
        'if_none_match': {'key': '', 'type': 'str'},
        'if_modified_since': {'key': '', 'type': 'rfc-1123'},
        'if_unmodified_since': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(JobScheduleDisableOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)
        self.if_match = kwargs.get('if_match', None)
        self.if_none_match = kwargs.get('if_none_match', None)
        self.if_modified_since = kwargs.get('if_modified_since', None)
        self.if_unmodified_since = kwargs.get('if_unmodified_since', None)


class JobScheduleEnableOptions(Model):
    """Additional parameters for enable operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    :param if_match: An ETag value associated with the version of the resource
     known to the client. The operation will be performed only if the
     resource's current ETag on the service exactly matches the value specified
     by the client.
    :type if_match: str
    :param if_none_match: An ETag value associated with the version of the
     resource known to the client. The operation will be performed only if the
     resource's current ETag on the service does not match the value specified
     by the client.
    :type if_none_match: str
    :param if_modified_since: A timestamp indicating the last modified time of
     the resource known to the client. The operation will be performed only if
     the resource on the service has been modified since the specified time.
    :type if_modified_since: datetime
    :param if_unmodified_since: A timestamp indicating the last modified time
     of the resource known to the client. The operation will be performed only
     if the resource on the service has not been modified since the specified
     time.
    :type if_unmodified_since: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
        'if_match': {'key': '', 'type': 'str'},
        'if_none_match': {'key': '', 'type': 'str'},
        'if_modified_since': {'key': '', 'type': 'rfc-1123'},
        'if_unmodified_since': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(JobScheduleEnableOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)
        self.if_match = kwargs.get('if_match', None)
        self.if_none_match = kwargs.get('if_none_match', None)
        self.if_modified_since = kwargs.get('if_modified_since', None)
        self.if_unmodified_since = kwargs.get('if_unmodified_since', None)


class JobScheduleExecutionInformation(Model):
    """Contains information about jobs that have been and will be run under a job
    schedule.

    :param next_run_time: The next time at which a job will be created under
     this schedule. This property is meaningful only if the schedule is in the
     active state when the time comes around. For example, if the schedule is
     disabled, no job will be created at nextRunTime unless the job is enabled
     before then.
    :type next_run_time: datetime
    :param recent_job: Information about the most recent job under the job
     schedule. This property is present only if the at least one job has run
     under the schedule.
    :type recent_job: ~azure.batch.models.RecentJob
    :param end_time: The time at which the schedule ended. This property is
     set only if the job schedule is in the completed state.
    :type end_time: datetime
    """

    _attribute_map = {
        'next_run_time': {'key': 'nextRunTime', 'type': 'iso-8601'},
        'recent_job': {'key': 'recentJob', 'type': 'RecentJob'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(JobScheduleExecutionInformation, self).__init__(**kwargs)
        self.next_run_time = kwargs.get('next_run_time', None)
        self.recent_job = kwargs.get('recent_job', None)
        self.end_time = kwargs.get('end_time', None)


class JobScheduleExistsOptions(Model):
    """Additional parameters for exists operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    :param if_match: An ETag value associated with the version of the resource
     known to the client. The operation will be performed only if the
     resource's current ETag on the service exactly matches the value specified
     by the client.
    :type if_match: str
    :param if_none_match: An ETag value associated with the version of the
     resource known to the client. The operation will be performed only if the
     resource's current ETag on the service does not match the value specified
     by the client.
    :type if_none_match: str
    :param if_modified_since: A timestamp indicating the last modified time of
     the resource known to the client. The operation will be performed only if
     the resource on the service has been modified since the specified time.
    :type if_modified_since: datetime
    :param if_unmodified_since: A timestamp indicating the last modified time
     of the resource known to the client. The operation will be performed only
     if the resource on the service has not been modified since the specified
     time.
    :type if_unmodified_since: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
        'if_match': {'key': '', 'type': 'str'},
        'if_none_match': {'key': '', 'type': 'str'},
        'if_modified_since': {'key': '', 'type': 'rfc-1123'},
        'if_unmodified_since': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(JobScheduleExistsOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)
        self.if_match = kwargs.get('if_match', None)
        self.if_none_match = kwargs.get('if_none_match', None)
        self.if_modified_since = kwargs.get('if_modified_since', None)
        self.if_unmodified_since = kwargs.get('if_unmodified_since', None)


class JobScheduleGetOptions(Model):
    """Additional parameters for get operation.

    :param select: An OData $select clause.
    :type select: str
    :param expand: An OData $expand clause.
    :type expand: str
    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    :param if_match: An ETag value associated with the version of the resource
     known to the client. The operation will be performed only if the
     resource's current ETag on the service exactly matches the value specified
     by the client.
    :type if_match: str
    :param if_none_match: An ETag value associated with the version of the
     resource known to the client. The operation will be performed only if the
     resource's current ETag on the service does not match the value specified
     by the client.
    :type if_none_match: str
    :param if_modified_since: A timestamp indicating the last modified time of
     the resource known to the client. The operation will be performed only if
     the resource on the service has been modified since the specified time.
    :type if_modified_since: datetime
    :param if_unmodified_since: A timestamp indicating the last modified time
     of the resource known to the client. The operation will be performed only
     if the resource on the service has not been modified since the specified
     time.
    :type if_unmodified_since: datetime
    """

    _attribute_map = {
        'select': {'key': '', 'type': 'str'},
        'expand': {'key': '', 'type': 'str'},
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
        'if_match': {'key': '', 'type': 'str'},
        'if_none_match': {'key': '', 'type': 'str'},
        'if_modified_since': {'key': '', 'type': 'rfc-1123'},
        'if_unmodified_since': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(JobScheduleGetOptions, self).__init__(**kwargs)
        self.select = kwargs.get('select', None)
        self.expand = kwargs.get('expand', None)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)
        self.if_match = kwargs.get('if_match', None)
        self.if_none_match = kwargs.get('if_none_match', None)
        self.if_modified_since = kwargs.get('if_modified_since', None)
        self.if_unmodified_since = kwargs.get('if_unmodified_since', None)


class JobScheduleListOptions(Model):
    """Additional parameters for list operation.

    :param filter: An OData $filter clause. For more information on
     constructing this filter, see
     https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-job-schedules.
    :type filter: str
    :param select: An OData $select clause.
    :type select: str
    :param expand: An OData $expand clause.
    :type expand: str
    :param max_results: The maximum number of items to return in the response.
     A maximum of 1000 job schedules can be returned. Default value: 1000 .
    :type max_results: int
    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    """

    _attribute_map = {
        'filter': {'key': '', 'type': 'str'},
        'select': {'key': '', 'type': 'str'},
        'expand': {'key': '', 'type': 'str'},
        'max_results': {'key': '', 'type': 'int'},
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(JobScheduleListOptions, self).__init__(**kwargs)
        self.filter = kwargs.get('filter', None)
        self.select = kwargs.get('select', None)
        self.expand = kwargs.get('expand', None)
        self.max_results = kwargs.get('max_results', 1000)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)


class JobSchedulePatchOptions(Model):
    """Additional parameters for patch operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    :param if_match: An ETag value associated with the version of the resource
     known to the client. The operation will be performed only if the
     resource's current ETag on the service exactly matches the value specified
     by the client.
    :type if_match: str
    :param if_none_match: An ETag value associated with the version of the
     resource known to the client. The operation will be performed only if the
     resource's current ETag on the service does not match the value specified
     by the client.
    :type if_none_match: str
    :param if_modified_since: A timestamp indicating the last modified time of
     the resource known to the client. The operation will be performed only if
     the resource on the service has been modified since the specified time.
    :type if_modified_since: datetime
    :param if_unmodified_since: A timestamp indicating the last modified time
     of the resource known to the client. The operation will be performed only
     if the resource on the service has not been modified since the specified
     time.
    :type if_unmodified_since: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
        'if_match': {'key': '', 'type': 'str'},
        'if_none_match': {'key': '', 'type': 'str'},
        'if_modified_since': {'key': '', 'type': 'rfc-1123'},
        'if_unmodified_since': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(JobSchedulePatchOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)
        self.if_match = kwargs.get('if_match', None)
        self.if_none_match = kwargs.get('if_none_match', None)
        self.if_modified_since = kwargs.get('if_modified_since', None)
        self.if_unmodified_since = kwargs.get('if_unmodified_since', None)


class JobSchedulePatchParameter(Model):
    """The set of changes to be made to a job schedule.

    :param schedule: The schedule according to which jobs will be created. If
     you do not specify this element, the existing schedule is left unchanged.
    :type schedule: ~azure.batch.models.Schedule
    :param job_specification: The details of the jobs to be created on this
     schedule. Updates affect only jobs that are started after the update has
     taken place. Any currently active job continues with the older
     specification.
    :type job_specification: ~azure.batch.models.JobSpecification
    :param metadata: A list of name-value pairs associated with the job
     schedule as metadata. If you do not specify this element, existing
     metadata is left unchanged.
    :type metadata: list[~azure.batch.models.MetadataItem]
    """

    _attribute_map = {
        'schedule': {'key': 'schedule', 'type': 'Schedule'},
        'job_specification': {'key': 'jobSpecification', 'type': 'JobSpecification'},
        'metadata': {'key': 'metadata', 'type': '[MetadataItem]'},
    }

    def __init__(self, **kwargs):
        super(JobSchedulePatchParameter, self).__init__(**kwargs)
        self.schedule = kwargs.get('schedule', None)
        self.job_specification = kwargs.get('job_specification', None)
        self.metadata = kwargs.get('metadata', None)


class JobScheduleStatistics(Model):
    """Resource usage statistics for a job schedule.

    All required parameters must be populated in order to send to Azure.

    :param url: Required. The URL of the statistics.
    :type url: str
    :param start_time: Required. The start time of the time range covered by
     the statistics.
    :type start_time: datetime
    :param last_update_time: Required. The time at which the statistics were
     last updated. All statistics are limited to the range between startTime
     and lastUpdateTime.
    :type last_update_time: datetime
    :param user_cpu_time: Required. The total user mode CPU time (summed
     across all cores and all compute nodes) consumed by all tasks in all jobs
     created under the schedule.
    :type user_cpu_time: timedelta
    :param kernel_cpu_time: Required. The total kernel mode CPU time (summed
     across all cores and all compute nodes) consumed by all tasks in all jobs
     created under the schedule.
    :type kernel_cpu_time: timedelta
    :param wall_clock_time: Required. The total wall clock time of all the
     tasks in all the jobs created under the schedule. The wall clock time is
     the elapsed time from when the task started running on a compute node to
     when it finished (or to the last time the statistics were updated, if the
     task had not finished by then). If a task was retried, this includes the
     wall clock time of all the task retries.
    :type wall_clock_time: timedelta
    :param read_iops: Required. The total number of disk read operations made
     by all tasks in all jobs created under the schedule.
    :type read_iops: long
    :param write_iops: Required. The total number of disk write operations
     made by all tasks in all jobs created under the schedule.
    :type write_iops: long
    :param read_io_gi_b: Required. The total gibibytes read from disk by all
     tasks in all jobs created under the schedule.
    :type read_io_gi_b: float
    :param write_io_gi_b: Required. The total gibibytes written to disk by all
     tasks in all jobs created under the schedule.
    :type write_io_gi_b: float
    :param num_succeeded_tasks: Required. The total number of tasks
     successfully completed during the given time range in jobs created under
     the schedule. A task completes successfully if it returns exit code 0.
    :type num_succeeded_tasks: long
    :param num_failed_tasks: Required. The total number of tasks that failed
     during the given time range in jobs created under the schedule. A task
     fails if it exhausts its maximum retry count without returning exit code
     0.
    :type num_failed_tasks: long
    :param num_task_retries: Required. The total number of retries during the
     given time range on all tasks in all jobs created under the schedule.
    :type num_task_retries: long
    :param wait_time: Required. The total wait time of all tasks in all jobs
     created under the schedule. The wait time for a task is defined as the
     elapsed time between the creation of the task and the start of task
     execution. (If the task is retried due to failures, the wait time is the
     time to the most recent task execution.). This value is only reported in
     the account lifetime statistics; it is not included in the job statistics.
    :type wait_time: timedelta
    """

    _validation = {
        'url': {'required': True},
        'start_time': {'required': True},
        'last_update_time': {'required': True},
        'user_cpu_time': {'required': True},
        'kernel_cpu_time': {'required': True},
        'wall_clock_time': {'required': True},
        'read_iops': {'required': True},
        'write_iops': {'required': True},
        'read_io_gi_b': {'required': True},
        'write_io_gi_b': {'required': True},
        'num_succeeded_tasks': {'required': True},
        'num_failed_tasks': {'required': True},
        'num_task_retries': {'required': True},
        'wait_time': {'required': True},
    }

    _attribute_map = {
        'url': {'key': 'url', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'last_update_time': {'key': 'lastUpdateTime', 'type': 'iso-8601'},
        'user_cpu_time': {'key': 'userCPUTime', 'type': 'duration'},
        'kernel_cpu_time': {'key': 'kernelCPUTime', 'type': 'duration'},
        'wall_clock_time': {'key': 'wallClockTime', 'type': 'duration'},
        'read_iops': {'key': 'readIOps', 'type': 'long'},
        'write_iops': {'key': 'writeIOps', 'type': 'long'},
        'read_io_gi_b': {'key': 'readIOGiB', 'type': 'float'},
        'write_io_gi_b': {'key': 'writeIOGiB', 'type': 'float'},
        'num_succeeded_tasks': {'key': 'numSucceededTasks', 'type': 'long'},
        'num_failed_tasks': {'key': 'numFailedTasks', 'type': 'long'},
        'num_task_retries': {'key': 'numTaskRetries', 'type': 'long'},
        'wait_time': {'key': 'waitTime', 'type': 'duration'},
    }

    def __init__(self, **kwargs):
        super(JobScheduleStatistics, self).__init__(**kwargs)
        self.url = kwargs.get('url', None)
        self.start_time = kwargs.get('start_time', None)
        self.last_update_time = kwargs.get('last_update_time', None)
        self.user_cpu_time = kwargs.get('user_cpu_time', None)
        self.kernel_cpu_time = kwargs.get('kernel_cpu_time', None)
        self.wall_clock_time = kwargs.get('wall_clock_time', None)
        self.read_iops = kwargs.get('read_iops', None)
        self.write_iops = kwargs.get('write_iops', None)
        self.read_io_gi_b = kwargs.get('read_io_gi_b', None)
        self.write_io_gi_b = kwargs.get('write_io_gi_b', None)
        self.num_succeeded_tasks = kwargs.get('num_succeeded_tasks', None)
        self.num_failed_tasks = kwargs.get('num_failed_tasks', None)
        self.num_task_retries = kwargs.get('num_task_retries', None)
        self.wait_time = kwargs.get('wait_time', None)


class JobScheduleTerminateOptions(Model):
    """Additional parameters for terminate operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    :param if_match: An ETag value associated with the version of the resource
     known to the client. The operation will be performed only if the
     resource's current ETag on the service exactly matches the value specified
     by the client.
    :type if_match: str
    :param if_none_match: An ETag value associated with the version of the
     resource known to the client. The operation will be performed only if the
     resource's current ETag on the service does not match the value specified
     by the client.
    :type if_none_match: str
    :param if_modified_since: A timestamp indicating the last modified time of
     the resource known to the client. The operation will be performed only if
     the resource on the service has been modified since the specified time.
    :type if_modified_since: datetime
    :param if_unmodified_since: A timestamp indicating the last modified time
     of the resource known to the client. The operation will be performed only
     if the resource on the service has not been modified since the specified
     time.
    :type if_unmodified_since: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
        'if_match': {'key': '', 'type': 'str'},
        'if_none_match': {'key': '', 'type': 'str'},
        'if_modified_since': {'key': '', 'type': 'rfc-1123'},
        'if_unmodified_since': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(JobScheduleTerminateOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)
        self.if_match = kwargs.get('if_match', None)
        self.if_none_match = kwargs.get('if_none_match', None)
        self.if_modified_since = kwargs.get('if_modified_since', None)
        self.if_unmodified_since = kwargs.get('if_unmodified_since', None)


class JobScheduleUpdateOptions(Model):
    """Additional parameters for update operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    :param if_match: An ETag value associated with the version of the resource
     known to the client. The operation will be performed only if the
     resource's current ETag on the service exactly matches the value specified
     by the client.
    :type if_match: str
    :param if_none_match: An ETag value associated with the version of the
     resource known to the client. The operation will be performed only if the
     resource's current ETag on the service does not match the value specified
     by the client.
    :type if_none_match: str
    :param if_modified_since: A timestamp indicating the last modified time of
     the resource known to the client. The operation will be performed only if
     the resource on the service has been modified since the specified time.
    :type if_modified_since: datetime
    :param if_unmodified_since: A timestamp indicating the last modified time
     of the resource known to the client. The operation will be performed only
     if the resource on the service has not been modified since the specified
     time.
    :type if_unmodified_since: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
        'if_match': {'key': '', 'type': 'str'},
        'if_none_match': {'key': '', 'type': 'str'},
        'if_modified_since': {'key': '', 'type': 'rfc-1123'},
        'if_unmodified_since': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(JobScheduleUpdateOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)
        self.if_match = kwargs.get('if_match', None)
        self.if_none_match = kwargs.get('if_none_match', None)
        self.if_modified_since = kwargs.get('if_modified_since', None)
        self.if_unmodified_since = kwargs.get('if_unmodified_since', None)


class JobScheduleUpdateParameter(Model):
    """The set of changes to be made to a job schedule.

    All required parameters must be populated in order to send to Azure.

    :param schedule: Required. The schedule according to which jobs will be
     created. If you do not specify this element, it is equivalent to passing
     the default schedule: that is, a single job scheduled to run immediately.
    :type schedule: ~azure.batch.models.Schedule
    :param job_specification: Required. Details of the jobs to be created on
     this schedule. Updates affect only jobs that are started after the update
     has taken place. Any currently active job continues with the older
     specification.
    :type job_specification: ~azure.batch.models.JobSpecification
    :param metadata: A list of name-value pairs associated with the job
     schedule as metadata. If you do not specify this element, it takes the
     default value of an empty list; in effect, any existing metadata is
     deleted.
    :type metadata: list[~azure.batch.models.MetadataItem]
    """

    _validation = {
        'schedule': {'required': True},
        'job_specification': {'required': True},
    }

    _attribute_map = {
        'schedule': {'key': 'schedule', 'type': 'Schedule'},
        'job_specification': {'key': 'jobSpecification', 'type': 'JobSpecification'},
        'metadata': {'key': 'metadata', 'type': '[MetadataItem]'},
    }

    def __init__(self, **kwargs):
        super(JobScheduleUpdateParameter, self).__init__(**kwargs)
        self.schedule = kwargs.get('schedule', None)
        self.job_specification = kwargs.get('job_specification', None)
        self.metadata = kwargs.get('metadata', None)


class JobSchedulingError(Model):
    """An error encountered by the Batch service when scheduling a job.

    All required parameters must be populated in order to send to Azure.

    :param category: Required. The category of the job scheduling error.
     Possible values include: 'userError', 'serverError'
    :type category: str or ~azure.batch.models.ErrorCategory
    :param code: An identifier for the job scheduling error. Codes are
     invariant and are intended to be consumed programmatically.
    :type code: str
    :param message: A message describing the job scheduling error, intended to
     be suitable for display in a user interface.
    :type message: str
    :param details: A list of additional error details related to the
     scheduling error.
    :type details: list[~azure.batch.models.NameValuePair]
    """

    _validation = {
        'category': {'required': True},
    }

    _attribute_map = {
        'category': {'key': 'category', 'type': 'ErrorCategory'},
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[NameValuePair]'},
    }

    def __init__(self, **kwargs):
        super(JobSchedulingError, self).__init__(**kwargs)
        self.category = kwargs.get('category', None)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.details = kwargs.get('details', None)


class JobSpecification(Model):
    """Specifies details of the jobs to be created on a schedule.

    All required parameters must be populated in order to send to Azure.

    :param priority: The priority of jobs created under this schedule.
     Priority values can range from -1000 to 1000, with -1000 being the lowest
     priority and 1000 being the highest priority. The default value is 0. This
     priority is used as the default for all jobs under the job schedule. You
     can update a job's priority after it has been created using by using the
     update job API.
    :type priority: int
    :param display_name: The display name for jobs created under this
     schedule. The name need not be unique and can contain any Unicode
     characters up to a maximum length of 1024.
    :type display_name: str
    :param uses_task_dependencies: Whether tasks in the job can define
     dependencies on each other. The default is false.
    :type uses_task_dependencies: bool
    :param on_all_tasks_complete: The action the Batch service should take
     when all tasks in a job created under this schedule are in the completed
     state. Note that if a job contains no tasks, then all tasks are considered
     complete. This option is therefore most commonly used with a Job Manager
     task; if you want to use automatic job termination without a Job Manager,
     you should initially set onAllTasksComplete to noaction and update the job
     properties to set onAllTasksComplete to terminatejob once you have
     finished adding tasks. The default is noaction. Possible values include:
     'noAction', 'terminateJob'
    :type on_all_tasks_complete: str or ~azure.batch.models.OnAllTasksComplete
    :param on_task_failure: The action the Batch service should take when any
     task fails in a job created under this schedule. A task is considered to
     have failed if it have failed if has a failureInfo. A failureInfo is set
     if the task completes with a non-zero exit code after exhausting its retry
     count, or if there was an error starting the task, for example due to a
     resource file download error. The default is noaction. Possible values
     include: 'noAction', 'performExitOptionsJobAction'
    :type on_task_failure: str or ~azure.batch.models.OnTaskFailure
    :param network_configuration: The network configuration for the job.
    :type network_configuration: ~azure.batch.models.JobNetworkConfiguration
    :param constraints: The execution constraints for jobs created under this
     schedule.
    :type constraints: ~azure.batch.models.JobConstraints
    :param job_manager_task: The details of a Job Manager task to be launched
     when a job is started under this schedule. If the job does not specify a
     Job Manager task, the user must explicitly add tasks to the job using the
     Task API. If the job does specify a Job Manager task, the Batch service
     creates the Job Manager task when the job is created, and will try to
     schedule the Job Manager task before scheduling other tasks in the job.
    :type job_manager_task: ~azure.batch.models.JobManagerTask
    :param job_preparation_task: The Job Preparation task for jobs created
     under this schedule. If a job has a Job Preparation task, the Batch
     service will run the Job Preparation task on a compute node before
     starting any tasks of that job on that compute node.
    :type job_preparation_task: ~azure.batch.models.JobPreparationTask
    :param job_release_task: The Job Release task for jobs created under this
     schedule. The primary purpose of the Job Release task is to undo changes
     to compute nodes made by the Job Preparation task. Example activities
     include deleting local files, or shutting down services that were started
     as part of job preparation. A Job Release task cannot be specified without
     also specifying a Job Preparation task for the job. The Batch service runs
     the Job Release task on the compute nodes that have run the Job
     Preparation task.
    :type job_release_task: ~azure.batch.models.JobReleaseTask
    :param common_environment_settings: A list of common environment variable
     settings. These environment variables are set for all tasks in jobs
     created under this schedule (including the Job Manager, Job Preparation
     and Job Release tasks). Individual tasks can override an environment
     setting specified here by specifying the same setting name with a
     different value.
    :type common_environment_settings:
     list[~azure.batch.models.EnvironmentSetting]
    :param pool_info: Required. The pool on which the Batch service runs the
     tasks of jobs created under this schedule.
    :type pool_info: ~azure.batch.models.PoolInformation
    :param metadata: A list of name-value pairs associated with each job
     created under this schedule as metadata. The Batch service does not assign
     any meaning to metadata; it is solely for the use of user code.
    :type metadata: list[~azure.batch.models.MetadataItem]
    """

    _validation = {
        'pool_info': {'required': True},
    }

    _attribute_map = {
        'priority': {'key': 'priority', 'type': 'int'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'uses_task_dependencies': {'key': 'usesTaskDependencies', 'type': 'bool'},
        'on_all_tasks_complete': {'key': 'onAllTasksComplete', 'type': 'OnAllTasksComplete'},
        'on_task_failure': {'key': 'onTaskFailure', 'type': 'OnTaskFailure'},
        'network_configuration': {'key': 'networkConfiguration', 'type': 'JobNetworkConfiguration'},
        'constraints': {'key': 'constraints', 'type': 'JobConstraints'},
        'job_manager_task': {'key': 'jobManagerTask', 'type': 'JobManagerTask'},
        'job_preparation_task': {'key': 'jobPreparationTask', 'type': 'JobPreparationTask'},
        'job_release_task': {'key': 'jobReleaseTask', 'type': 'JobReleaseTask'},
        'common_environment_settings': {'key': 'commonEnvironmentSettings', 'type': '[EnvironmentSetting]'},
        'pool_info': {'key': 'poolInfo', 'type': 'PoolInformation'},
        'metadata': {'key': 'metadata', 'type': '[MetadataItem]'},
    }

    def __init__(self, **kwargs):
        super(JobSpecification, self).__init__(**kwargs)
        self.priority = kwargs.get('priority', None)
        self.display_name = kwargs.get('display_name', None)
        self.uses_task_dependencies = kwargs.get('uses_task_dependencies', None)
        self.on_all_tasks_complete = kwargs.get('on_all_tasks_complete', None)
        self.on_task_failure = kwargs.get('on_task_failure', None)
        self.network_configuration = kwargs.get('network_configuration', None)
        self.constraints = kwargs.get('constraints', None)
        self.job_manager_task = kwargs.get('job_manager_task', None)
        self.job_preparation_task = kwargs.get('job_preparation_task', None)
        self.job_release_task = kwargs.get('job_release_task', None)
        self.common_environment_settings = kwargs.get('common_environment_settings', None)
        self.pool_info = kwargs.get('pool_info', None)
        self.metadata = kwargs.get('metadata', None)


class JobStatistics(Model):
    """Resource usage statistics for a job.

    All required parameters must be populated in order to send to Azure.

    :param url: Required. The URL of the statistics.
    :type url: str
    :param start_time: Required. The start time of the time range covered by
     the statistics.
    :type start_time: datetime
    :param last_update_time: Required. The time at which the statistics were
     last updated. All statistics are limited to the range between startTime
     and lastUpdateTime.
    :type last_update_time: datetime
    :param user_cpu_time: Required. The total user mode CPU time (summed
     across all cores and all compute nodes) consumed by all tasks in the job.
    :type user_cpu_time: timedelta
    :param kernel_cpu_time: Required. The total kernel mode CPU time (summed
     across all cores and all compute nodes) consumed by all tasks in the job.
    :type kernel_cpu_time: timedelta
    :param wall_clock_time: Required. The total wall clock time of all tasks
     in the job.  The wall clock time is the elapsed time from when the task
     started running on a compute node to when it finished (or to the last time
     the statistics were updated, if the task had not finished by then). If a
     task was retried, this includes the wall clock time of all the task
     retries.
    :type wall_clock_time: timedelta
    :param read_iops: Required. The total number of disk read operations made
     by all tasks in the job.
    :type read_iops: long
    :param write_iops: Required. The total number of disk write operations
     made by all tasks in the job.
    :type write_iops: long
    :param read_io_gi_b: Required. The total amount of data in GiB read from
     disk by all tasks in the job.
    :type read_io_gi_b: float
    :param write_io_gi_b: Required. The total amount of data in GiB written to
     disk by all tasks in the job.
    :type write_io_gi_b: float
    :param num_succeeded_tasks: Required. The total number of tasks
     successfully completed in the job during the given time range. A task
     completes successfully if it returns exit code 0.
    :type num_succeeded_tasks: long
    :param num_failed_tasks: Required. The total number of tasks in the job
     that failed during the given time range. A task fails if it exhausts its
     maximum retry count without returning exit code 0.
    :type num_failed_tasks: long
    :param num_task_retries: Required. The total number of retries on all the
     tasks in the job during the given time range.
    :type num_task_retries: long
    :param wait_time: Required. The total wait time of all tasks in the job.
     The wait time for a task is defined as the elapsed time between the
     creation of the task and the start of task execution. (If the task is
     retried due to failures, the wait time is the time to the most recent task
     execution.) This value is only reported in the account lifetime
     statistics; it is not included in the job statistics.
    :type wait_time: timedelta
    """

    _validation = {
        'url': {'required': True},
        'start_time': {'required': True},
        'last_update_time': {'required': True},
        'user_cpu_time': {'required': True},
        'kernel_cpu_time': {'required': True},
        'wall_clock_time': {'required': True},
        'read_iops': {'required': True},
        'write_iops': {'required': True},
        'read_io_gi_b': {'required': True},
        'write_io_gi_b': {'required': True},
        'num_succeeded_tasks': {'required': True},
        'num_failed_tasks': {'required': True},
        'num_task_retries': {'required': True},
        'wait_time': {'required': True},
    }

    _attribute_map = {
        'url': {'key': 'url', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'last_update_time': {'key': 'lastUpdateTime', 'type': 'iso-8601'},
        'user_cpu_time': {'key': 'userCPUTime', 'type': 'duration'},
        'kernel_cpu_time': {'key': 'kernelCPUTime', 'type': 'duration'},
        'wall_clock_time': {'key': 'wallClockTime', 'type': 'duration'},
        'read_iops': {'key': 'readIOps', 'type': 'long'},
        'write_iops': {'key': 'writeIOps', 'type': 'long'},
        'read_io_gi_b': {'key': 'readIOGiB', 'type': 'float'},
        'write_io_gi_b': {'key': 'writeIOGiB', 'type': 'float'},
        'num_succeeded_tasks': {'key': 'numSucceededTasks', 'type': 'long'},
        'num_failed_tasks': {'key': 'numFailedTasks', 'type': 'long'},
        'num_task_retries': {'key': 'numTaskRetries', 'type': 'long'},
        'wait_time': {'key': 'waitTime', 'type': 'duration'},
    }

    def __init__(self, **kwargs):
        super(JobStatistics, self).__init__(**kwargs)
        self.url = kwargs.get('url', None)
        self.start_time = kwargs.get('start_time', None)
        self.last_update_time = kwargs.get('last_update_time', None)
        self.user_cpu_time = kwargs.get('user_cpu_time', None)
        self.kernel_cpu_time = kwargs.get('kernel_cpu_time', None)
        self.wall_clock_time = kwargs.get('wall_clock_time', None)
        self.read_iops = kwargs.get('read_iops', None)
        self.write_iops = kwargs.get('write_iops', None)
        self.read_io_gi_b = kwargs.get('read_io_gi_b', None)
        self.write_io_gi_b = kwargs.get('write_io_gi_b', None)
        self.num_succeeded_tasks = kwargs.get('num_succeeded_tasks', None)
        self.num_failed_tasks = kwargs.get('num_failed_tasks', None)
        self.num_task_retries = kwargs.get('num_task_retries', None)
        self.wait_time = kwargs.get('wait_time', None)


class JobTerminateOptions(Model):
    """Additional parameters for terminate operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    :param if_match: An ETag value associated with the version of the resource
     known to the client. The operation will be performed only if the
     resource's current ETag on the service exactly matches the value specified
     by the client.
    :type if_match: str
    :param if_none_match: An ETag value associated with the version of the
     resource known to the client. The operation will be performed only if the
     resource's current ETag on the service does not match the value specified
     by the client.
    :type if_none_match: str
    :param if_modified_since: A timestamp indicating the last modified time of
     the resource known to the client. The operation will be performed only if
     the resource on the service has been modified since the specified time.
    :type if_modified_since: datetime
    :param if_unmodified_since: A timestamp indicating the last modified time
     of the resource known to the client. The operation will be performed only
     if the resource on the service has not been modified since the specified
     time.
    :type if_unmodified_since: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
        'if_match': {'key': '', 'type': 'str'},
        'if_none_match': {'key': '', 'type': 'str'},
        'if_modified_since': {'key': '', 'type': 'rfc-1123'},
        'if_unmodified_since': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(JobTerminateOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)
        self.if_match = kwargs.get('if_match', None)
        self.if_none_match = kwargs.get('if_none_match', None)
        self.if_modified_since = kwargs.get('if_modified_since', None)
        self.if_unmodified_since = kwargs.get('if_unmodified_since', None)


class JobTerminateParameter(Model):
    """Options when terminating a job.

    :param terminate_reason: The text you want to appear as the job's
     TerminateReason. The default is 'UserTerminate'.
    :type terminate_reason: str
    """

    _attribute_map = {
        'terminate_reason': {'key': 'terminateReason', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(JobTerminateParameter, self).__init__(**kwargs)
        self.terminate_reason = kwargs.get('terminate_reason', None)


class JobUpdateOptions(Model):
    """Additional parameters for update operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    :param if_match: An ETag value associated with the version of the resource
     known to the client. The operation will be performed only if the
     resource's current ETag on the service exactly matches the value specified
     by the client.
    :type if_match: str
    :param if_none_match: An ETag value associated with the version of the
     resource known to the client. The operation will be performed only if the
     resource's current ETag on the service does not match the value specified
     by the client.
    :type if_none_match: str
    :param if_modified_since: A timestamp indicating the last modified time of
     the resource known to the client. The operation will be performed only if
     the resource on the service has been modified since the specified time.
    :type if_modified_since: datetime
    :param if_unmodified_since: A timestamp indicating the last modified time
     of the resource known to the client. The operation will be performed only
     if the resource on the service has not been modified since the specified
     time.
    :type if_unmodified_since: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
        'if_match': {'key': '', 'type': 'str'},
        'if_none_match': {'key': '', 'type': 'str'},
        'if_modified_since': {'key': '', 'type': 'rfc-1123'},
        'if_unmodified_since': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(JobUpdateOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)
        self.if_match = kwargs.get('if_match', None)
        self.if_none_match = kwargs.get('if_none_match', None)
        self.if_modified_since = kwargs.get('if_modified_since', None)
        self.if_unmodified_since = kwargs.get('if_unmodified_since', None)


class JobUpdateParameter(Model):
    """The set of changes to be made to a job.

    All required parameters must be populated in order to send to Azure.

    :param priority: The priority of the job. Priority values can range from
     -1000 to 1000, with -1000 being the lowest priority and 1000 being the
     highest priority. If omitted, it is set to the default value 0.
    :type priority: int
    :param constraints: The execution constraints for the job. If omitted, the
     constraints are cleared.
    :type constraints: ~azure.batch.models.JobConstraints
    :param pool_info: Required. The pool on which the Batch service runs the
     job's tasks. You may change the pool for a job only when the job is
     disabled. The Update Job call will fail if you include the poolInfo
     element and the job is not disabled. If you specify an
     autoPoolSpecification specification in the poolInfo, only the keepAlive
     property can be updated, and then only if the auto pool has a
     poolLifetimeOption of job.
    :type pool_info: ~azure.batch.models.PoolInformation
    :param metadata: A list of name-value pairs associated with the job as
     metadata. If omitted, it takes the default value of an empty list; in
     effect, any existing metadata is deleted.
    :type metadata: list[~azure.batch.models.MetadataItem]
    :param on_all_tasks_complete: The action the Batch service should take
     when all tasks in the job are in the completed state. If omitted, the
     completion behavior is set to noaction. If the current value is
     terminatejob, this is an error because a job's completion behavior may not
     be changed from terminatejob to noaction. You may not change the value
     from terminatejob to noaction - that is, once you have engaged automatic
     job termination, you cannot turn it off again. If you try to do this, the
     request fails and Batch returns status code 400 (Bad Request) and an
     'invalid property value' error response. If you do not specify this
     element in a PUT request, it is equivalent to passing noaction. This is an
     error if the current value is terminatejob. Possible values include:
     'noAction', 'terminateJob'
    :type on_all_tasks_complete: str or ~azure.batch.models.OnAllTasksComplete
    """

    _validation = {
        'pool_info': {'required': True},
    }

    _attribute_map = {
        'priority': {'key': 'priority', 'type': 'int'},
        'constraints': {'key': 'constraints', 'type': 'JobConstraints'},
        'pool_info': {'key': 'poolInfo', 'type': 'PoolInformation'},
        'metadata': {'key': 'metadata', 'type': '[MetadataItem]'},
        'on_all_tasks_complete': {'key': 'onAllTasksComplete', 'type': 'OnAllTasksComplete'},
    }

    def __init__(self, **kwargs):
        super(JobUpdateParameter, self).__init__(**kwargs)
        self.priority = kwargs.get('priority', None)
        self.constraints = kwargs.get('constraints', None)
        self.pool_info = kwargs.get('pool_info', None)
        self.metadata = kwargs.get('metadata', None)
        self.on_all_tasks_complete = kwargs.get('on_all_tasks_complete', None)


class LinuxUserConfiguration(Model):
    """Properties used to create a user account on a Linux node.

    :param uid: The user ID of the user account. The uid and gid properties
     must be specified together or not at all. If not specified the underlying
     operating system picks the uid.
    :type uid: int
    :param gid: The group ID for the user account. The uid and gid properties
     must be specified together or not at all. If not specified the underlying
     operating system picks the gid.
    :type gid: int
    :param ssh_private_key: The SSH private key for the user account. The
     private key must not be password protected. The private key is used to
     automatically configure asymmetric-key based authentication for SSH
     between nodes in a Linux pool when the pool's enableInterNodeCommunication
     property is true (it is ignored if enableInterNodeCommunication is false).
     It does this by placing the key pair into the user's .ssh directory. If
     not specified, password-less SSH is not configured between nodes (no
     modification of the user's .ssh directory is done).
    :type ssh_private_key: str
    """

    _attribute_map = {
        'uid': {'key': 'uid', 'type': 'int'},
        'gid': {'key': 'gid', 'type': 'int'},
        'ssh_private_key': {'key': 'sshPrivateKey', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(LinuxUserConfiguration, self).__init__(**kwargs)
        self.uid = kwargs.get('uid', None)
        self.gid = kwargs.get('gid', None)
        self.ssh_private_key = kwargs.get('ssh_private_key', None)


class MetadataItem(Model):
    """A name-value pair associated with a Batch service resource.

    The Batch service does not assign any meaning to this metadata; it is
    solely for the use of user code.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the metadata item.
    :type name: str
    :param value: Required. The value of the metadata item.
    :type value: str
    """

    _validation = {
        'name': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(MetadataItem, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)


class MultiInstanceSettings(Model):
    """Settings which specify how to run a multi-instance task.

    Multi-instance tasks are commonly used to support MPI tasks.

    All required parameters must be populated in order to send to Azure.

    :param number_of_instances: The number of compute nodes required by the
     task. If omitted, the default is 1.
    :type number_of_instances: int
    :param coordination_command_line: Required. The command line to run on all
     the compute nodes to enable them to coordinate when the primary runs the
     main task command. A typical coordination command line launches a
     background service and verifies that the service is ready to process
     inter-node messages.
    :type coordination_command_line: str
    :param common_resource_files: A list of files that the Batch service will
     download before running the coordination command line. The difference
     between common resource files and task resource files is that common
     resource files are downloaded for all subtasks including the primary,
     whereas task resource files are downloaded only for the primary. Also note
     that these resource files are not downloaded to the task working
     directory, but instead are downloaded to the task root directory (one
     directory above the working directory).  There is a maximum size for the
     list of resource files.  When the max size is exceeded, the request will
     fail and the response error code will be RequestEntityTooLarge. If this
     occurs, the collection of ResourceFiles must be reduced in size. This can
     be achieved using .zip files, Application Packages, or Docker Containers.
    :type common_resource_files: list[~azure.batch.models.ResourceFile]
    """

    _validation = {
        'coordination_command_line': {'required': True},
    }

    _attribute_map = {
        'number_of_instances': {'key': 'numberOfInstances', 'type': 'int'},
        'coordination_command_line': {'key': 'coordinationCommandLine', 'type': 'str'},
        'common_resource_files': {'key': 'commonResourceFiles', 'type': '[ResourceFile]'},
    }

    def __init__(self, **kwargs):
        super(MultiInstanceSettings, self).__init__(**kwargs)
        self.number_of_instances = kwargs.get('number_of_instances', None)
        self.coordination_command_line = kwargs.get('coordination_command_line', None)
        self.common_resource_files = kwargs.get('common_resource_files', None)


class NameValuePair(Model):
    """Represents a name-value pair.

    :param name: The name in the name-value pair.
    :type name: str
    :param value: The value in the name-value pair.
    :type value: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NameValuePair, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.value = kwargs.get('value', None)


class NetworkConfiguration(Model):
    """The network configuration for a pool.

    :param subnet_id: The ARM resource identifier of the virtual network
     subnet which the compute nodes of the pool will join. This is of the form
     /subscriptions/{subscription}/resourceGroups/{group}/providers/{provider}/virtualNetworks/{network}/subnets/{subnet}.
     The virtual network must be in the same region and subscription as the
     Azure Batch account. The specified subnet should have enough free IP
     addresses to accommodate the number of nodes in the pool. If the subnet
     doesn't have enough free IP addresses, the pool will partially allocate
     compute nodes, and a resize error will occur. For pools created with
     virtualMachineConfiguration only ARM virtual networks
     ('Microsoft.Network/virtualNetworks') are supported, but for pools created
     with cloudServiceConfiguration both ARM and classic virtual networks are
     supported. For more details, see:
     https://docs.microsoft.com/en-us/azure/batch/batch-api-basics#virtual-network-vnet-and-firewall-configuration
    :type subnet_id: str
    :param dynamic_vnet_assignment_scope: The scope of dynamic vnet
     assignment. Possible values include: 'none', 'job'
    :type dynamic_vnet_assignment_scope: str or
     ~azure.batch.models.DynamicVNetAssignmentScope
    :param endpoint_configuration: The configuration for endpoints on compute
     nodes in the Batch pool. Pool endpoint configuration is only supported on
     pools with the virtualMachineConfiguration property.
    :type endpoint_configuration:
     ~azure.batch.models.PoolEndpointConfiguration
    """

    _attribute_map = {
        'subnet_id': {'key': 'subnetId', 'type': 'str'},
        'dynamic_vnet_assignment_scope': {'key': 'dynamicVNetAssignmentScope', 'type': 'DynamicVNetAssignmentScope'},
        'endpoint_configuration': {'key': 'endpointConfiguration', 'type': 'PoolEndpointConfiguration'},
    }

    def __init__(self, **kwargs):
        super(NetworkConfiguration, self).__init__(**kwargs)
        self.subnet_id = kwargs.get('subnet_id', None)
        self.dynamic_vnet_assignment_scope = kwargs.get('dynamic_vnet_assignment_scope', None)
        self.endpoint_configuration = kwargs.get('endpoint_configuration', None)


class NetworkSecurityGroupRule(Model):
    """A network security group rule to apply to an inbound endpoint.

    All required parameters must be populated in order to send to Azure.

    :param priority: Required. The priority for this rule. Priorities within a
     pool must be unique and are evaluated in order of priority. The lower the
     number the higher the priority. For example, rules could be specified with
     order numbers of 150, 250, and 350. The rule with the order number of 150
     takes precedence over the rule that has an order of 250. Allowed
     priorities are 150 to 3500. If any reserved or duplicate values are
     provided the request fails with HTTP status code 400.
    :type priority: int
    :param access: Required. The action that should be taken for a specified
     IP address, subnet range or tag. Possible values include: 'allow', 'deny'
    :type access: str or ~azure.batch.models.NetworkSecurityGroupRuleAccess
    :param source_address_prefix: Required. The source address prefix or tag
     to match for the rule. Valid values are a single IP address (i.e.
     10.10.10.10), IP subnet (i.e. 192.168.1.0/24), default tag, or * (for all
     addresses).  If any other values are provided the request fails with HTTP
     status code 400.
    :type source_address_prefix: str
    """

    _validation = {
        'priority': {'required': True},
        'access': {'required': True},
        'source_address_prefix': {'required': True},
    }

    _attribute_map = {
        'priority': {'key': 'priority', 'type': 'int'},
        'access': {'key': 'access', 'type': 'NetworkSecurityGroupRuleAccess'},
        'source_address_prefix': {'key': 'sourceAddressPrefix', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NetworkSecurityGroupRule, self).__init__(**kwargs)
        self.priority = kwargs.get('priority', None)
        self.access = kwargs.get('access', None)
        self.source_address_prefix = kwargs.get('source_address_prefix', None)


class NodeAgentInformation(Model):
    """Information about the node agent.

    The Batch node agent is a program that runs on each node in the pool and
    provides Batch capability on the compute node.

    All required parameters must be populated in order to send to Azure.

    :param version: Required. The version of the Batch node agent running on
     the compute node. This version number can be checked against the node
     agent release notes located at
     https://github.com/Azure/Batch/blob/master/changelogs/nodeagent/CHANGELOG.md.
    :type version: str
    :param last_update_time: Required. The time when the node agent was
     updated on the compute node. This is the most recent time that the node
     agent was updated to a new version.
    :type last_update_time: datetime
    """

    _validation = {
        'version': {'required': True},
        'last_update_time': {'required': True},
    }

    _attribute_map = {
        'version': {'key': 'version', 'type': 'str'},
        'last_update_time': {'key': 'lastUpdateTime', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(NodeAgentInformation, self).__init__(**kwargs)
        self.version = kwargs.get('version', None)
        self.last_update_time = kwargs.get('last_update_time', None)


class NodeAgentSku(Model):
    """A node agent SKU supported by the Batch service.

    The Batch node agent is a program that runs on each node in the pool, and
    provides the command-and-control interface between the node and the Batch
    service. There are different implementations of the node agent, known as
    SKUs, for different operating systems.

    :param id: The ID of the node agent SKU.
    :type id: str
    :param verified_image_references: The list of Azure Marketplace images
     verified to be compatible with this node agent SKU. This collection is not
     exhaustive (the node agent may be compatible with other images).
    :type verified_image_references: list[~azure.batch.models.ImageReference]
    :param os_type: The type of operating system (e.g. Windows or Linux)
     compatible with the node agent SKU. Possible values include: 'linux',
     'windows'
    :type os_type: str or ~azure.batch.models.OSType
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'verified_image_references': {'key': 'verifiedImageReferences', 'type': '[ImageReference]'},
        'os_type': {'key': 'osType', 'type': 'OSType'},
    }

    def __init__(self, **kwargs):
        super(NodeAgentSku, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.verified_image_references = kwargs.get('verified_image_references', None)
        self.os_type = kwargs.get('os_type', None)


class NodeCounts(Model):
    """The number of nodes in each node state.

    All required parameters must be populated in order to send to Azure.

    :param creating: Required. The number of nodes in the creating state.
    :type creating: int
    :param idle: Required. The number of nodes in the idle state.
    :type idle: int
    :param offline: Required. The number of nodes in the offline state.
    :type offline: int
    :param preempted: Required. The number of nodes in the preempted state.
    :type preempted: int
    :param rebooting: Required. The count of nodes in the rebooting state.
    :type rebooting: int
    :param reimaging: Required. The number of nodes in the reimaging state.
    :type reimaging: int
    :param running: Required. The number of nodes in the running state.
    :type running: int
    :param starting: Required. The number of nodes in the starting state.
    :type starting: int
    :param start_task_failed: Required. The number of nodes in the
     startTaskFailed state.
    :type start_task_failed: int
    :param leaving_pool: Required. The number of nodes in the leavingPool
     state.
    :type leaving_pool: int
    :param unknown: Required. The number of nodes in the unknown state.
    :type unknown: int
    :param unusable: Required. The number of nodes in the unusable state.
    :type unusable: int
    :param waiting_for_start_task: Required. The number of nodes in the
     waitingForStartTask state.
    :type waiting_for_start_task: int
    :param total: Required. The total number of nodes.
    :type total: int
    """

    _validation = {
        'creating': {'required': True},
        'idle': {'required': True},
        'offline': {'required': True},
        'preempted': {'required': True},
        'rebooting': {'required': True},
        'reimaging': {'required': True},
        'running': {'required': True},
        'starting': {'required': True},
        'start_task_failed': {'required': True},
        'leaving_pool': {'required': True},
        'unknown': {'required': True},
        'unusable': {'required': True},
        'waiting_for_start_task': {'required': True},
        'total': {'required': True},
    }

    _attribute_map = {
        'creating': {'key': 'creating', 'type': 'int'},
        'idle': {'key': 'idle', 'type': 'int'},
        'offline': {'key': 'offline', 'type': 'int'},
        'preempted': {'key': 'preempted', 'type': 'int'},
        'rebooting': {'key': 'rebooting', 'type': 'int'},
        'reimaging': {'key': 'reimaging', 'type': 'int'},
        'running': {'key': 'running', 'type': 'int'},
        'starting': {'key': 'starting', 'type': 'int'},
        'start_task_failed': {'key': 'startTaskFailed', 'type': 'int'},
        'leaving_pool': {'key': 'leavingPool', 'type': 'int'},
        'unknown': {'key': 'unknown', 'type': 'int'},
        'unusable': {'key': 'unusable', 'type': 'int'},
        'waiting_for_start_task': {'key': 'waitingForStartTask', 'type': 'int'},
        'total': {'key': 'total', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(NodeCounts, self).__init__(**kwargs)
        self.creating = kwargs.get('creating', None)
        self.idle = kwargs.get('idle', None)
        self.offline = kwargs.get('offline', None)
        self.preempted = kwargs.get('preempted', None)
        self.rebooting = kwargs.get('rebooting', None)
        self.reimaging = kwargs.get('reimaging', None)
        self.running = kwargs.get('running', None)
        self.starting = kwargs.get('starting', None)
        self.start_task_failed = kwargs.get('start_task_failed', None)
        self.leaving_pool = kwargs.get('leaving_pool', None)
        self.unknown = kwargs.get('unknown', None)
        self.unusable = kwargs.get('unusable', None)
        self.waiting_for_start_task = kwargs.get('waiting_for_start_task', None)
        self.total = kwargs.get('total', None)


class NodeDisableSchedulingParameter(Model):
    """Options for disabling scheduling on a compute node.

    :param node_disable_scheduling_option: What to do with currently running
     tasks when disabling task scheduling on the compute node. The default
     value is requeue. Possible values include: 'requeue', 'terminate',
     'taskCompletion'
    :type node_disable_scheduling_option: str or
     ~azure.batch.models.DisableComputeNodeSchedulingOption
    """

    _attribute_map = {
        'node_disable_scheduling_option': {'key': 'nodeDisableSchedulingOption', 'type': 'DisableComputeNodeSchedulingOption'},
    }

    def __init__(self, **kwargs):
        super(NodeDisableSchedulingParameter, self).__init__(**kwargs)
        self.node_disable_scheduling_option = kwargs.get('node_disable_scheduling_option', None)


class NodeFile(Model):
    """Information about a file or directory on a compute node.

    :param name: The file path.
    :type name: str
    :param url: The URL of the file.
    :type url: str
    :param is_directory: Whether the object represents a directory.
    :type is_directory: bool
    :param properties: The file properties.
    :type properties: ~azure.batch.models.FileProperties
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
        'is_directory': {'key': 'isDirectory', 'type': 'bool'},
        'properties': {'key': 'properties', 'type': 'FileProperties'},
    }

    def __init__(self, **kwargs):
        super(NodeFile, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.url = kwargs.get('url', None)
        self.is_directory = kwargs.get('is_directory', None)
        self.properties = kwargs.get('properties', None)


class NodeRebootParameter(Model):
    """Options for rebooting a compute node.

    :param node_reboot_option: When to reboot the compute node and what to do
     with currently running tasks. The default value is requeue. Possible
     values include: 'requeue', 'terminate', 'taskCompletion', 'retainedData'
    :type node_reboot_option: str or
     ~azure.batch.models.ComputeNodeRebootOption
    """

    _attribute_map = {
        'node_reboot_option': {'key': 'nodeRebootOption', 'type': 'ComputeNodeRebootOption'},
    }

    def __init__(self, **kwargs):
        super(NodeRebootParameter, self).__init__(**kwargs)
        self.node_reboot_option = kwargs.get('node_reboot_option', None)


class NodeReimageParameter(Model):
    """Options for reimaging a compute node.

    :param node_reimage_option: When to reimage the compute node and what to
     do with currently running tasks. The default value is requeue. Possible
     values include: 'requeue', 'terminate', 'taskCompletion', 'retainedData'
    :type node_reimage_option: str or
     ~azure.batch.models.ComputeNodeReimageOption
    """

    _attribute_map = {
        'node_reimage_option': {'key': 'nodeReimageOption', 'type': 'ComputeNodeReimageOption'},
    }

    def __init__(self, **kwargs):
        super(NodeReimageParameter, self).__init__(**kwargs)
        self.node_reimage_option = kwargs.get('node_reimage_option', None)


class NodeRemoveParameter(Model):
    """Options for removing compute nodes from a pool.

    All required parameters must be populated in order to send to Azure.

    :param node_list: Required. A list containing the IDs of the compute nodes
     to be removed from the specified pool.
    :type node_list: list[str]
    :param resize_timeout: The timeout for removal of compute nodes to the
     pool. The default value is 15 minutes. The minimum value is 5 minutes. If
     you specify a value less than 5 minutes, the Batch service returns an
     error; if you are calling the REST API directly, the HTTP status code is
     400 (Bad Request).
    :type resize_timeout: timedelta
    :param node_deallocation_option: Determines what to do with a node and its
     running task(s) after it has been selected for deallocation. The default
     value is requeue. Possible values include: 'requeue', 'terminate',
     'taskCompletion', 'retainedData'
    :type node_deallocation_option: str or
     ~azure.batch.models.ComputeNodeDeallocationOption
    """

    _validation = {
        'node_list': {'required': True, 'max_items': 100},
    }

    _attribute_map = {
        'node_list': {'key': 'nodeList', 'type': '[str]'},
        'resize_timeout': {'key': 'resizeTimeout', 'type': 'duration'},
        'node_deallocation_option': {'key': 'nodeDeallocationOption', 'type': 'ComputeNodeDeallocationOption'},
    }

    def __init__(self, **kwargs):
        super(NodeRemoveParameter, self).__init__(**kwargs)
        self.node_list = kwargs.get('node_list', None)
        self.resize_timeout = kwargs.get('resize_timeout', None)
        self.node_deallocation_option = kwargs.get('node_deallocation_option', None)


class NodeUpdateUserParameter(Model):
    """The set of changes to be made to a user account on a node.

    :param password: The password of the account. The password is required for
     Windows nodes (those created with 'cloudServiceConfiguration', or created
     with 'virtualMachineConfiguration' using a Windows image reference). For
     Linux compute nodes, the password can optionally be specified along with
     the sshPublicKey property. If omitted, any existing password is removed.
    :type password: str
    :param expiry_time: The time at which the account should expire. If
     omitted, the default is 1 day from the current time. For Linux compute
     nodes, the expiryTime has a precision up to a day.
    :type expiry_time: datetime
    :param ssh_public_key: The SSH public key that can be used for remote
     login to the compute node. The public key should be compatible with
     OpenSSH encoding and should be base 64 encoded. This property can be
     specified only for Linux nodes. If this is specified for a Windows node,
     then the Batch service rejects the request; if you are calling the REST
     API directly, the HTTP status code is 400 (Bad Request). If omitted, any
     existing SSH public key is removed.
    :type ssh_public_key: str
    """

    _attribute_map = {
        'password': {'key': 'password', 'type': 'str'},
        'expiry_time': {'key': 'expiryTime', 'type': 'iso-8601'},
        'ssh_public_key': {'key': 'sshPublicKey', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NodeUpdateUserParameter, self).__init__(**kwargs)
        self.password = kwargs.get('password', None)
        self.expiry_time = kwargs.get('expiry_time', None)
        self.ssh_public_key = kwargs.get('ssh_public_key', None)


class OutputFile(Model):
    """A specification for uploading files from an Azure Batch node to another
    location after the Batch service has finished executing the task process.

    All required parameters must be populated in order to send to Azure.

    :param file_pattern: Required. A pattern indicating which file(s) to
     upload. Both relative and absolute paths are supported. Relative paths are
     relative to the task working directory. The following wildcards are
     supported: * matches 0 or more characters (for example pattern abc* would
     match abc or abcdef), ** matches any directory, ? matches any single
     character, [abc] matches one character in the brackets, and [a-c] matches
     one character in the range. Brackets can include a negation to match any
     character not specified (for example [!abc] matches any character but a,
     b, or c). If a file name starts with "." it is ignored by default but may
     be matched by specifying it explicitly (for example *.gif will not match
     .a.gif, but .*.gif will). A simple example: **\\*.txt matches any file
     that does not start in '.' and ends with .txt in the task working
     directory or any subdirectory. If the filename contains a wildcard
     character it can be escaped using brackets (for example abc[*] would match
     a file named abc*). Note that both \\ and / are treated as directory
     separators on Windows, but only / is on Linux. Environment variables
     (%var% on Windows or $var on Linux) are expanded prior to the pattern
     being applied.
    :type file_pattern: str
    :param destination: Required. The destination for the output file(s).
    :type destination: ~azure.batch.models.OutputFileDestination
    :param upload_options: Required. Additional options for the upload
     operation, including under what conditions to perform the upload.
    :type upload_options: ~azure.batch.models.OutputFileUploadOptions
    """

    _validation = {
        'file_pattern': {'required': True},
        'destination': {'required': True},
        'upload_options': {'required': True},
    }

    _attribute_map = {
        'file_pattern': {'key': 'filePattern', 'type': 'str'},
        'destination': {'key': 'destination', 'type': 'OutputFileDestination'},
        'upload_options': {'key': 'uploadOptions', 'type': 'OutputFileUploadOptions'},
    }

    def __init__(self, **kwargs):
        super(OutputFile, self).__init__(**kwargs)
        self.file_pattern = kwargs.get('file_pattern', None)
        self.destination = kwargs.get('destination', None)
        self.upload_options = kwargs.get('upload_options', None)


class OutputFileBlobContainerDestination(Model):
    """Specifies a file upload destination within an Azure blob storage container.

    All required parameters must be populated in order to send to Azure.

    :param path: The destination blob or virtual directory within the Azure
     Storage container. If filePattern refers to a specific file (i.e. contains
     no wildcards), then path is the name of the blob to which to upload that
     file. If filePattern contains one or more wildcards (and therefore may
     match multiple files), then path is the name of the blob virtual directory
     (which is prepended to each blob name) to which to upload the file(s). If
     omitted, file(s) are uploaded to the root of the container with a blob
     name matching their file name.
    :type path: str
    :param container_url: Required. The URL of the container within Azure Blob
     Storage to which to upload the file(s). The URL must include a Shared
     Access Signature (SAS) granting write permissions to the container.
    :type container_url: str
    """

    _validation = {
        'container_url': {'required': True},
    }

    _attribute_map = {
        'path': {'key': 'path', 'type': 'str'},
        'container_url': {'key': 'containerUrl', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OutputFileBlobContainerDestination, self).__init__(**kwargs)
        self.path = kwargs.get('path', None)
        self.container_url = kwargs.get('container_url', None)


class OutputFileDestination(Model):
    """The destination to which a file should be uploaded.

    :param container: A location in Azure blob storage to which files are
     uploaded.
    :type container: ~azure.batch.models.OutputFileBlobContainerDestination
    """

    _attribute_map = {
        'container': {'key': 'container', 'type': 'OutputFileBlobContainerDestination'},
    }

    def __init__(self, **kwargs):
        super(OutputFileDestination, self).__init__(**kwargs)
        self.container = kwargs.get('container', None)


class OutputFileUploadOptions(Model):
    """Details about an output file upload operation, including under what
    conditions to perform the upload.

    All required parameters must be populated in order to send to Azure.

    :param upload_condition: Required. The conditions under which the task
     output file or set of files should be uploaded. The default is
     taskcompletion. Possible values include: 'taskSuccess', 'taskFailure',
     'taskCompletion'
    :type upload_condition: str or
     ~azure.batch.models.OutputFileUploadCondition
    """

    _validation = {
        'upload_condition': {'required': True},
    }

    _attribute_map = {
        'upload_condition': {'key': 'uploadCondition', 'type': 'OutputFileUploadCondition'},
    }

    def __init__(self, **kwargs):
        super(OutputFileUploadOptions, self).__init__(**kwargs)
        self.upload_condition = kwargs.get('upload_condition', None)


class PoolAddOptions(Model):
    """Additional parameters for add operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(PoolAddOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)


class PoolAddParameter(Model):
    """A pool in the Azure Batch service to add.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. A string that uniquely identifies the pool within the
     account. The ID can contain any combination of alphanumeric characters
     including hyphens and underscores, and cannot contain more than 64
     characters. The ID is case-preserving and case-insensitive (that is, you
     may not have two pool IDs within an account that differ only by case).
    :type id: str
    :param display_name: The display name for the pool. The display name need
     not be unique and can contain any Unicode characters up to a maximum
     length of 1024.
    :type display_name: str
    :param vm_size: Required. The size of virtual machines in the pool. All
     virtual machines in a pool are the same size. For information about
     available sizes of virtual machines for Cloud Services pools (pools
     created with cloudServiceConfiguration), see Sizes for Cloud Services
     (https://azure.microsoft.com/documentation/articles/cloud-services-sizes-specs/).
     Batch supports all Cloud Services VM sizes except ExtraSmall, A1V2 and
     A2V2. For information about available VM sizes for pools using images from
     the Virtual Machines Marketplace (pools created with
     virtualMachineConfiguration) see Sizes for Virtual Machines (Linux)
     (https://azure.microsoft.com/documentation/articles/virtual-machines-linux-sizes/)
     or Sizes for Virtual Machines (Windows)
     (https://azure.microsoft.com/documentation/articles/virtual-machines-windows-sizes/).
     Batch supports all Azure VM sizes except STANDARD_A0 and those with
     premium storage (STANDARD_GS, STANDARD_DS, and STANDARD_DSV2 series).
    :type vm_size: str
    :param cloud_service_configuration: The cloud service configuration for
     the pool. This property and virtualMachineConfiguration are mutually
     exclusive and one of the properties must be specified. This property
     cannot be specified if the Batch account was created with its
     poolAllocationMode property set to 'UserSubscription'.
    :type cloud_service_configuration:
     ~azure.batch.models.CloudServiceConfiguration
    :param virtual_machine_configuration: The virtual machine configuration
     for the pool. This property and cloudServiceConfiguration are mutually
     exclusive and one of the properties must be specified.
    :type virtual_machine_configuration:
     ~azure.batch.models.VirtualMachineConfiguration
    :param resize_timeout: The timeout for allocation of compute nodes to the
     pool. This timeout applies only to manual scaling; it has no effect when
     enableAutoScale is set to true. The default value is 15 minutes. The
     minimum value is 5 minutes. If you specify a value less than 5 minutes,
     the Batch service returns an error; if you are calling the REST API
     directly, the HTTP status code is 400 (Bad Request).
    :type resize_timeout: timedelta
    :param target_dedicated_nodes: The desired number of dedicated compute
     nodes in the pool. This property must not be specified if enableAutoScale
     is set to true. If enableAutoScale is set to false, then you must set
     either targetDedicatedNodes, targetLowPriorityNodes, or both.
    :type target_dedicated_nodes: int
    :param target_low_priority_nodes: The desired number of low-priority
     compute nodes in the pool. This property must not be specified if
     enableAutoScale is set to true. If enableAutoScale is set to false, then
     you must set either targetDedicatedNodes, targetLowPriorityNodes, or both.
    :type target_low_priority_nodes: int
    :param enable_auto_scale: Whether the pool size should automatically
     adjust over time. If false, at least one of targetDedicateNodes and
     targetLowPriorityNodes must be specified. If true, the autoScaleFormula
     property is required and the pool automatically resizes according to the
     formula. The default value is false.
    :type enable_auto_scale: bool
    :param auto_scale_formula: A formula for the desired number of compute
     nodes in the pool. This property must not be specified if enableAutoScale
     is set to false. It is required if enableAutoScale is set to true. The
     formula is checked for validity before the pool is created. If the formula
     is not valid, the Batch service rejects the request with detailed error
     information. For more information about specifying this formula, see
     'Automatically scale compute nodes in an Azure Batch pool'
     (https://azure.microsoft.com/documentation/articles/batch-automatic-scaling/).
    :type auto_scale_formula: str
    :param auto_scale_evaluation_interval: The time interval at which to
     automatically adjust the pool size according to the autoscale formula. The
     default value is 15 minutes. The minimum and maximum value are 5 minutes
     and 168 hours respectively. If you specify a value less than 5 minutes or
     greater than 168 hours, the Batch service returns an error; if you are
     calling the REST API directly, the HTTP status code is 400 (Bad Request).
    :type auto_scale_evaluation_interval: timedelta
    :param enable_inter_node_communication: Whether the pool permits direct
     communication between nodes. Enabling inter-node communication limits the
     maximum size of the pool due to deployment restrictions on the nodes of
     the pool. This may result in the pool not reaching its desired size. The
     default value is false.
    :type enable_inter_node_communication: bool
    :param network_configuration: The network configuration for the pool.
    :type network_configuration: ~azure.batch.models.NetworkConfiguration
    :param start_task: A task specified to run on each compute node as it
     joins the pool. The task runs when the node is added to the pool or when
     the node is restarted.
    :type start_task: ~azure.batch.models.StartTask
    :param certificate_references: The list of certificates to be installed on
     each compute node in the pool. For Windows compute nodes, the Batch
     service installs the certificates to the specified certificate store and
     location. For Linux compute nodes, the certificates are stored in a
     directory inside the task working directory and an environment variable
     AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this
     location. For certificates with visibility of 'remoteUser', a 'certs'
     directory is created in the user's home directory (e.g.,
     /home/{user-name}/certs) and certificates are placed in that directory.
    :type certificate_references:
     list[~azure.batch.models.CertificateReference]
    :param application_package_references: The list of application packages to
     be installed on each compute node in the pool.
    :type application_package_references:
     list[~azure.batch.models.ApplicationPackageReference]
    :param application_licenses: The list of application licenses the Batch
     service will make available on each compute node in the pool. The list of
     application licenses must be a subset of available Batch service
     application licenses. If a license is requested which is not supported,
     pool creation will fail.
    :type application_licenses: list[str]
    :param max_tasks_per_node: The maximum number of tasks that can run
     concurrently on a single compute node in the pool. The default value is 1.
     The maximum value of this setting depends on the size of the compute nodes
     in the pool (the vmSize setting).
    :type max_tasks_per_node: int
    :param task_scheduling_policy: How tasks are distributed across compute
     nodes in a pool.
    :type task_scheduling_policy: ~azure.batch.models.TaskSchedulingPolicy
    :param user_accounts: The list of user accounts to be created on each node
     in the pool.
    :type user_accounts: list[~azure.batch.models.UserAccount]
    :param metadata: A list of name-value pairs associated with the pool as
     metadata. The Batch service does not assign any meaning to metadata; it is
     solely for the use of user code.
    :type metadata: list[~azure.batch.models.MetadataItem]
    """

    _validation = {
        'id': {'required': True},
        'vm_size': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'vm_size': {'key': 'vmSize', 'type': 'str'},
        'cloud_service_configuration': {'key': 'cloudServiceConfiguration', 'type': 'CloudServiceConfiguration'},
        'virtual_machine_configuration': {'key': 'virtualMachineConfiguration', 'type': 'VirtualMachineConfiguration'},
        'resize_timeout': {'key': 'resizeTimeout', 'type': 'duration'},
        'target_dedicated_nodes': {'key': 'targetDedicatedNodes', 'type': 'int'},
        'target_low_priority_nodes': {'key': 'targetLowPriorityNodes', 'type': 'int'},
        'enable_auto_scale': {'key': 'enableAutoScale', 'type': 'bool'},
        'auto_scale_formula': {'key': 'autoScaleFormula', 'type': 'str'},
        'auto_scale_evaluation_interval': {'key': 'autoScaleEvaluationInterval', 'type': 'duration'},
        'enable_inter_node_communication': {'key': 'enableInterNodeCommunication', 'type': 'bool'},
        'network_configuration': {'key': 'networkConfiguration', 'type': 'NetworkConfiguration'},
        'start_task': {'key': 'startTask', 'type': 'StartTask'},
        'certificate_references': {'key': 'certificateReferences', 'type': '[CertificateReference]'},
        'application_package_references': {'key': 'applicationPackageReferences', 'type': '[ApplicationPackageReference]'},
        'application_licenses': {'key': 'applicationLicenses', 'type': '[str]'},
        'max_tasks_per_node': {'key': 'maxTasksPerNode', 'type': 'int'},
        'task_scheduling_policy': {'key': 'taskSchedulingPolicy', 'type': 'TaskSchedulingPolicy'},
        'user_accounts': {'key': 'userAccounts', 'type': '[UserAccount]'},
        'metadata': {'key': 'metadata', 'type': '[MetadataItem]'},
    }

    def __init__(self, **kwargs):
        super(PoolAddParameter, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.display_name = kwargs.get('display_name', None)
        self.vm_size = kwargs.get('vm_size', None)
        self.cloud_service_configuration = kwargs.get('cloud_service_configuration', None)
        self.virtual_machine_configuration = kwargs.get('virtual_machine_configuration', None)
        self.resize_timeout = kwargs.get('resize_timeout', None)
        self.target_dedicated_nodes = kwargs.get('target_dedicated_nodes', None)
        self.target_low_priority_nodes = kwargs.get('target_low_priority_nodes', None)
        self.enable_auto_scale = kwargs.get('enable_auto_scale', None)
        self.auto_scale_formula = kwargs.get('auto_scale_formula', None)
        self.auto_scale_evaluation_interval = kwargs.get('auto_scale_evaluation_interval', None)
        self.enable_inter_node_communication = kwargs.get('enable_inter_node_communication', None)
        self.network_configuration = kwargs.get('network_configuration', None)
        self.start_task = kwargs.get('start_task', None)
        self.certificate_references = kwargs.get('certificate_references', None)
        self.application_package_references = kwargs.get('application_package_references', None)
        self.application_licenses = kwargs.get('application_licenses', None)
        self.max_tasks_per_node = kwargs.get('max_tasks_per_node', None)
        self.task_scheduling_policy = kwargs.get('task_scheduling_policy', None)
        self.user_accounts = kwargs.get('user_accounts', None)
        self.metadata = kwargs.get('metadata', None)


class PoolDeleteOptions(Model):
    """Additional parameters for delete operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    :param if_match: An ETag value associated with the version of the resource
     known to the client. The operation will be performed only if the
     resource's current ETag on the service exactly matches the value specified
     by the client.
    :type if_match: str
    :param if_none_match: An ETag value associated with the version of the
     resource known to the client. The operation will be performed only if the
     resource's current ETag on the service does not match the value specified
     by the client.
    :type if_none_match: str
    :param if_modified_since: A timestamp indicating the last modified time of
     the resource known to the client. The operation will be performed only if
     the resource on the service has been modified since the specified time.
    :type if_modified_since: datetime
    :param if_unmodified_since: A timestamp indicating the last modified time
     of the resource known to the client. The operation will be performed only
     if the resource on the service has not been modified since the specified
     time.
    :type if_unmodified_since: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
        'if_match': {'key': '', 'type': 'str'},
        'if_none_match': {'key': '', 'type': 'str'},
        'if_modified_since': {'key': '', 'type': 'rfc-1123'},
        'if_unmodified_since': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(PoolDeleteOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)
        self.if_match = kwargs.get('if_match', None)
        self.if_none_match = kwargs.get('if_none_match', None)
        self.if_modified_since = kwargs.get('if_modified_since', None)
        self.if_unmodified_since = kwargs.get('if_unmodified_since', None)


class PoolDisableAutoScaleOptions(Model):
    """Additional parameters for disable_auto_scale operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(PoolDisableAutoScaleOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)


class PoolEnableAutoScaleOptions(Model):
    """Additional parameters for enable_auto_scale operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    :param if_match: An ETag value associated with the version of the resource
     known to the client. The operation will be performed only if the
     resource's current ETag on the service exactly matches the value specified
     by the client.
    :type if_match: str
    :param if_none_match: An ETag value associated with the version of the
     resource known to the client. The operation will be performed only if the
     resource's current ETag on the service does not match the value specified
     by the client.
    :type if_none_match: str
    :param if_modified_since: A timestamp indicating the last modified time of
     the resource known to the client. The operation will be performed only if
     the resource on the service has been modified since the specified time.
    :type if_modified_since: datetime
    :param if_unmodified_since: A timestamp indicating the last modified time
     of the resource known to the client. The operation will be performed only
     if the resource on the service has not been modified since the specified
     time.
    :type if_unmodified_since: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
        'if_match': {'key': '', 'type': 'str'},
        'if_none_match': {'key': '', 'type': 'str'},
        'if_modified_since': {'key': '', 'type': 'rfc-1123'},
        'if_unmodified_since': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(PoolEnableAutoScaleOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)
        self.if_match = kwargs.get('if_match', None)
        self.if_none_match = kwargs.get('if_none_match', None)
        self.if_modified_since = kwargs.get('if_modified_since', None)
        self.if_unmodified_since = kwargs.get('if_unmodified_since', None)


class PoolEnableAutoScaleParameter(Model):
    """Options for enabling automatic scaling on a pool.

    :param auto_scale_formula: The formula for the desired number of compute
     nodes in the pool. The formula is checked for validity before it is
     applied to the pool. If the formula is not valid, the Batch service
     rejects the request with detailed error information. For more information
     about specifying this formula, see Automatically scale compute nodes in an
     Azure Batch pool
     (https://azure.microsoft.com/en-us/documentation/articles/batch-automatic-scaling).
    :type auto_scale_formula: str
    :param auto_scale_evaluation_interval: The time interval at which to
     automatically adjust the pool size according to the autoscale formula. The
     default value is 15 minutes. The minimum and maximum value are 5 minutes
     and 168 hours respectively. If you specify a value less than 5 minutes or
     greater than 168 hours, the Batch service rejects the request with an
     invalid property value error; if you are calling the REST API directly,
     the HTTP status code is 400 (Bad Request). If you specify a new interval,
     then the existing autoscale evaluation schedule will be stopped and a new
     autoscale evaluation schedule will be started, with its starting time
     being the time when this request was issued.
    :type auto_scale_evaluation_interval: timedelta
    """

    _attribute_map = {
        'auto_scale_formula': {'key': 'autoScaleFormula', 'type': 'str'},
        'auto_scale_evaluation_interval': {'key': 'autoScaleEvaluationInterval', 'type': 'duration'},
    }

    def __init__(self, **kwargs):
        super(PoolEnableAutoScaleParameter, self).__init__(**kwargs)
        self.auto_scale_formula = kwargs.get('auto_scale_formula', None)
        self.auto_scale_evaluation_interval = kwargs.get('auto_scale_evaluation_interval', None)


class PoolEndpointConfiguration(Model):
    """The endpoint configuration for a pool.

    All required parameters must be populated in order to send to Azure.

    :param inbound_nat_pools: Required. A list of inbound NAT pools that can
     be used to address specific ports on an individual compute node
     externally. The maximum number of inbound NAT pools per Batch pool is 5.
     If the maximum number of inbound NAT pools is exceeded the request fails
     with HTTP status code 400.
    :type inbound_nat_pools: list[~azure.batch.models.InboundNATPool]
    """

    _validation = {
        'inbound_nat_pools': {'required': True},
    }

    _attribute_map = {
        'inbound_nat_pools': {'key': 'inboundNATPools', 'type': '[InboundNATPool]'},
    }

    def __init__(self, **kwargs):
        super(PoolEndpointConfiguration, self).__init__(**kwargs)
        self.inbound_nat_pools = kwargs.get('inbound_nat_pools', None)


class PoolEvaluateAutoScaleOptions(Model):
    """Additional parameters for evaluate_auto_scale operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(PoolEvaluateAutoScaleOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)


class PoolEvaluateAutoScaleParameter(Model):
    """Options for evaluating an automatic scaling formula on a pool.

    All required parameters must be populated in order to send to Azure.

    :param auto_scale_formula: Required. The formula for the desired number of
     compute nodes in the pool. The formula is validated and its results
     calculated, but it is not applied to the pool. To apply the formula to the
     pool, 'Enable automatic scaling on a pool'. For more information about
     specifying this formula, see Automatically scale compute nodes in an Azure
     Batch pool
     (https://azure.microsoft.com/en-us/documentation/articles/batch-automatic-scaling).
    :type auto_scale_formula: str
    """

    _validation = {
        'auto_scale_formula': {'required': True},
    }

    _attribute_map = {
        'auto_scale_formula': {'key': 'autoScaleFormula', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PoolEvaluateAutoScaleParameter, self).__init__(**kwargs)
        self.auto_scale_formula = kwargs.get('auto_scale_formula', None)


class PoolExistsOptions(Model):
    """Additional parameters for exists operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    :param if_match: An ETag value associated with the version of the resource
     known to the client. The operation will be performed only if the
     resource's current ETag on the service exactly matches the value specified
     by the client.
    :type if_match: str
    :param if_none_match: An ETag value associated with the version of the
     resource known to the client. The operation will be performed only if the
     resource's current ETag on the service does not match the value specified
     by the client.
    :type if_none_match: str
    :param if_modified_since: A timestamp indicating the last modified time of
     the resource known to the client. The operation will be performed only if
     the resource on the service has been modified since the specified time.
    :type if_modified_since: datetime
    :param if_unmodified_since: A timestamp indicating the last modified time
     of the resource known to the client. The operation will be performed only
     if the resource on the service has not been modified since the specified
     time.
    :type if_unmodified_since: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
        'if_match': {'key': '', 'type': 'str'},
        'if_none_match': {'key': '', 'type': 'str'},
        'if_modified_since': {'key': '', 'type': 'rfc-1123'},
        'if_unmodified_since': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(PoolExistsOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)
        self.if_match = kwargs.get('if_match', None)
        self.if_none_match = kwargs.get('if_none_match', None)
        self.if_modified_since = kwargs.get('if_modified_since', None)
        self.if_unmodified_since = kwargs.get('if_unmodified_since', None)


class PoolGetAllLifetimeStatisticsOptions(Model):
    """Additional parameters for get_all_lifetime_statistics operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(PoolGetAllLifetimeStatisticsOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)


class PoolGetOptions(Model):
    """Additional parameters for get operation.

    :param select: An OData $select clause.
    :type select: str
    :param expand: An OData $expand clause.
    :type expand: str
    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    :param if_match: An ETag value associated with the version of the resource
     known to the client. The operation will be performed only if the
     resource's current ETag on the service exactly matches the value specified
     by the client.
    :type if_match: str
    :param if_none_match: An ETag value associated with the version of the
     resource known to the client. The operation will be performed only if the
     resource's current ETag on the service does not match the value specified
     by the client.
    :type if_none_match: str
    :param if_modified_since: A timestamp indicating the last modified time of
     the resource known to the client. The operation will be performed only if
     the resource on the service has been modified since the specified time.
    :type if_modified_since: datetime
    :param if_unmodified_since: A timestamp indicating the last modified time
     of the resource known to the client. The operation will be performed only
     if the resource on the service has not been modified since the specified
     time.
    :type if_unmodified_since: datetime
    """

    _attribute_map = {
        'select': {'key': '', 'type': 'str'},
        'expand': {'key': '', 'type': 'str'},
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
        'if_match': {'key': '', 'type': 'str'},
        'if_none_match': {'key': '', 'type': 'str'},
        'if_modified_since': {'key': '', 'type': 'rfc-1123'},
        'if_unmodified_since': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(PoolGetOptions, self).__init__(**kwargs)
        self.select = kwargs.get('select', None)
        self.expand = kwargs.get('expand', None)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)
        self.if_match = kwargs.get('if_match', None)
        self.if_none_match = kwargs.get('if_none_match', None)
        self.if_modified_since = kwargs.get('if_modified_since', None)
        self.if_unmodified_since = kwargs.get('if_unmodified_since', None)


class PoolInformation(Model):
    """Specifies how a job should be assigned to a pool.

    :param pool_id: The ID of an existing pool. All the tasks of the job will
     run on the specified pool. You must ensure that the pool referenced by
     this property exists. If the pool does not exist at the time the Batch
     service tries to schedule a job, no tasks for the job will run until you
     create a pool with that id. Note that the Batch service will not reject
     the job request; it will simply not run tasks until the pool exists. You
     must specify either the pool ID or the auto pool specification, but not
     both.
    :type pool_id: str
    :param auto_pool_specification: Characteristics for a temporary 'auto
     pool'. The Batch service will create this auto pool when the job is
     submitted. If auto pool creation fails, the Batch service moves the job to
     a completed state, and the pool creation error is set in the job's
     scheduling error property. The Batch service manages the lifetime (both
     creation and, unless keepAlive is specified, deletion) of the auto pool.
     Any user actions that affect the lifetime of the auto pool while the job
     is active will result in unexpected behavior. You must specify either the
     pool ID or the auto pool specification, but not both.
    :type auto_pool_specification: ~azure.batch.models.AutoPoolSpecification
    """

    _attribute_map = {
        'pool_id': {'key': 'poolId', 'type': 'str'},
        'auto_pool_specification': {'key': 'autoPoolSpecification', 'type': 'AutoPoolSpecification'},
    }

    def __init__(self, **kwargs):
        super(PoolInformation, self).__init__(**kwargs)
        self.pool_id = kwargs.get('pool_id', None)
        self.auto_pool_specification = kwargs.get('auto_pool_specification', None)


class PoolListOptions(Model):
    """Additional parameters for list operation.

    :param filter: An OData $filter clause. For more information on
     constructing this filter, see
     https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-pools.
    :type filter: str
    :param select: An OData $select clause.
    :type select: str
    :param expand: An OData $expand clause.
    :type expand: str
    :param max_results: The maximum number of items to return in the response.
     A maximum of 1000 pools can be returned. Default value: 1000 .
    :type max_results: int
    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    """

    _attribute_map = {
        'filter': {'key': '', 'type': 'str'},
        'select': {'key': '', 'type': 'str'},
        'expand': {'key': '', 'type': 'str'},
        'max_results': {'key': '', 'type': 'int'},
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(PoolListOptions, self).__init__(**kwargs)
        self.filter = kwargs.get('filter', None)
        self.select = kwargs.get('select', None)
        self.expand = kwargs.get('expand', None)
        self.max_results = kwargs.get('max_results', 1000)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)


class PoolListUsageMetricsOptions(Model):
    """Additional parameters for list_usage_metrics operation.

    :param start_time: The earliest time from which to include metrics. This
     must be at least two and a half hours before the current time. If not
     specified this defaults to the start time of the last aggregation interval
     currently available.
    :type start_time: datetime
    :param end_time: The latest time from which to include metrics. This must
     be at least two hours before the current time. If not specified this
     defaults to the end time of the last aggregation interval currently
     available.
    :type end_time: datetime
    :param filter: An OData $filter clause. For more information on
     constructing this filter, see
     https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-account-usage-metrics.
    :type filter: str
    :param max_results: The maximum number of items to return in the response.
     A maximum of 1000 results will be returned. Default value: 1000 .
    :type max_results: int
    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    """

    _attribute_map = {
        'start_time': {'key': '', 'type': 'iso-8601'},
        'end_time': {'key': '', 'type': 'iso-8601'},
        'filter': {'key': '', 'type': 'str'},
        'max_results': {'key': '', 'type': 'int'},
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(PoolListUsageMetricsOptions, self).__init__(**kwargs)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.filter = kwargs.get('filter', None)
        self.max_results = kwargs.get('max_results', 1000)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)


class PoolNodeCounts(Model):
    """The number of nodes in each state for a pool.

    All required parameters must be populated in order to send to Azure.

    :param pool_id: Required. The ID of the pool.
    :type pool_id: str
    :param dedicated: The number of dedicated nodes in each state.
    :type dedicated: ~azure.batch.models.NodeCounts
    :param low_priority: The number of low priority nodes in each state.
    :type low_priority: ~azure.batch.models.NodeCounts
    """

    _validation = {
        'pool_id': {'required': True},
    }

    _attribute_map = {
        'pool_id': {'key': 'poolId', 'type': 'str'},
        'dedicated': {'key': 'dedicated', 'type': 'NodeCounts'},
        'low_priority': {'key': 'lowPriority', 'type': 'NodeCounts'},
    }

    def __init__(self, **kwargs):
        super(PoolNodeCounts, self).__init__(**kwargs)
        self.pool_id = kwargs.get('pool_id', None)
        self.dedicated = kwargs.get('dedicated', None)
        self.low_priority = kwargs.get('low_priority', None)


class PoolPatchOptions(Model):
    """Additional parameters for patch operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    :param if_match: An ETag value associated with the version of the resource
     known to the client. The operation will be performed only if the
     resource's current ETag on the service exactly matches the value specified
     by the client.
    :type if_match: str
    :param if_none_match: An ETag value associated with the version of the
     resource known to the client. The operation will be performed only if the
     resource's current ETag on the service does not match the value specified
     by the client.
    :type if_none_match: str
    :param if_modified_since: A timestamp indicating the last modified time of
     the resource known to the client. The operation will be performed only if
     the resource on the service has been modified since the specified time.
    :type if_modified_since: datetime
    :param if_unmodified_since: A timestamp indicating the last modified time
     of the resource known to the client. The operation will be performed only
     if the resource on the service has not been modified since the specified
     time.
    :type if_unmodified_since: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
        'if_match': {'key': '', 'type': 'str'},
        'if_none_match': {'key': '', 'type': 'str'},
        'if_modified_since': {'key': '', 'type': 'rfc-1123'},
        'if_unmodified_since': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(PoolPatchOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)
        self.if_match = kwargs.get('if_match', None)
        self.if_none_match = kwargs.get('if_none_match', None)
        self.if_modified_since = kwargs.get('if_modified_since', None)
        self.if_unmodified_since = kwargs.get('if_unmodified_since', None)


class PoolPatchParameter(Model):
    """The set of changes to be made to a pool.

    :param start_task: A task to run on each compute node as it joins the
     pool. The task runs when the node is added to the pool or when the node is
     restarted. If this element is present, it overwrites any existing start
     task. If omitted, any existing start task is left unchanged.
    :type start_task: ~azure.batch.models.StartTask
    :param certificate_references: A list of certificates to be installed on
     each compute node in the pool. If this element is present, it replaces any
     existing certificate references configured on the pool. If omitted, any
     existing certificate references are left unchanged. For Windows compute
     nodes, the Batch service installs the certificates to the specified
     certificate store and location. For Linux compute nodes, the certificates
     are stored in a directory inside the task working directory and an
     environment variable AZ_BATCH_CERTIFICATES_DIR is supplied to the task to
     query for this location. For certificates with visibility of 'remoteUser',
     a 'certs' directory is created in the user's home directory (e.g.,
     /home/{user-name}/certs) and certificates are placed in that directory.
    :type certificate_references:
     list[~azure.batch.models.CertificateReference]
    :param application_package_references: A list of application packages to
     be installed on each compute node in the pool. Changes to application
     package references affect all new compute nodes joining the pool, but do
     not affect compute nodes that are already in the pool until they are
     rebooted or reimaged. If this element is present, it replaces any existing
     application package references. If you specify an empty collection, then
     all application package references are removed from the pool. If omitted,
     any existing application package references are left unchanged.
    :type application_package_references:
     list[~azure.batch.models.ApplicationPackageReference]
    :param metadata: A list of name-value pairs associated with the pool as
     metadata. If this element is present, it replaces any existing metadata
     configured on the pool. If you specify an empty collection, any metadata
     is removed from the pool. If omitted, any existing metadata is left
     unchanged.
    :type metadata: list[~azure.batch.models.MetadataItem]
    """

    _attribute_map = {
        'start_task': {'key': 'startTask', 'type': 'StartTask'},
        'certificate_references': {'key': 'certificateReferences', 'type': '[CertificateReference]'},
        'application_package_references': {'key': 'applicationPackageReferences', 'type': '[ApplicationPackageReference]'},
        'metadata': {'key': 'metadata', 'type': '[MetadataItem]'},
    }

    def __init__(self, **kwargs):
        super(PoolPatchParameter, self).__init__(**kwargs)
        self.start_task = kwargs.get('start_task', None)
        self.certificate_references = kwargs.get('certificate_references', None)
        self.application_package_references = kwargs.get('application_package_references', None)
        self.metadata = kwargs.get('metadata', None)


class PoolRemoveNodesOptions(Model):
    """Additional parameters for remove_nodes operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    :param if_match: An ETag value associated with the version of the resource
     known to the client. The operation will be performed only if the
     resource's current ETag on the service exactly matches the value specified
     by the client.
    :type if_match: str
    :param if_none_match: An ETag value associated with the version of the
     resource known to the client. The operation will be performed only if the
     resource's current ETag on the service does not match the value specified
     by the client.
    :type if_none_match: str
    :param if_modified_since: A timestamp indicating the last modified time of
     the resource known to the client. The operation will be performed only if
     the resource on the service has been modified since the specified time.
    :type if_modified_since: datetime
    :param if_unmodified_since: A timestamp indicating the last modified time
     of the resource known to the client. The operation will be performed only
     if the resource on the service has not been modified since the specified
     time.
    :type if_unmodified_since: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
        'if_match': {'key': '', 'type': 'str'},
        'if_none_match': {'key': '', 'type': 'str'},
        'if_modified_since': {'key': '', 'type': 'rfc-1123'},
        'if_unmodified_since': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(PoolRemoveNodesOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)
        self.if_match = kwargs.get('if_match', None)
        self.if_none_match = kwargs.get('if_none_match', None)
        self.if_modified_since = kwargs.get('if_modified_since', None)
        self.if_unmodified_since = kwargs.get('if_unmodified_since', None)


class PoolResizeOptions(Model):
    """Additional parameters for resize operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    :param if_match: An ETag value associated with the version of the resource
     known to the client. The operation will be performed only if the
     resource's current ETag on the service exactly matches the value specified
     by the client.
    :type if_match: str
    :param if_none_match: An ETag value associated with the version of the
     resource known to the client. The operation will be performed only if the
     resource's current ETag on the service does not match the value specified
     by the client.
    :type if_none_match: str
    :param if_modified_since: A timestamp indicating the last modified time of
     the resource known to the client. The operation will be performed only if
     the resource on the service has been modified since the specified time.
    :type if_modified_since: datetime
    :param if_unmodified_since: A timestamp indicating the last modified time
     of the resource known to the client. The operation will be performed only
     if the resource on the service has not been modified since the specified
     time.
    :type if_unmodified_since: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
        'if_match': {'key': '', 'type': 'str'},
        'if_none_match': {'key': '', 'type': 'str'},
        'if_modified_since': {'key': '', 'type': 'rfc-1123'},
        'if_unmodified_since': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(PoolResizeOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)
        self.if_match = kwargs.get('if_match', None)
        self.if_none_match = kwargs.get('if_none_match', None)
        self.if_modified_since = kwargs.get('if_modified_since', None)
        self.if_unmodified_since = kwargs.get('if_unmodified_since', None)


class PoolResizeParameter(Model):
    """Options for changing the size of a pool.

    :param target_dedicated_nodes: The desired number of dedicated compute
     nodes in the pool.
    :type target_dedicated_nodes: int
    :param target_low_priority_nodes: The desired number of low-priority
     compute nodes in the pool.
    :type target_low_priority_nodes: int
    :param resize_timeout: The timeout for allocation of compute nodes to the
     pool or removal of compute nodes from the pool. The default value is 15
     minutes. The minimum value is 5 minutes. If you specify a value less than
     5 minutes, the Batch service returns an error; if you are calling the REST
     API directly, the HTTP status code is 400 (Bad Request).
    :type resize_timeout: timedelta
    :param node_deallocation_option: Determines what to do with a node and its
     running task(s) if the pool size is decreasing. The default value is
     requeue. Possible values include: 'requeue', 'terminate',
     'taskCompletion', 'retainedData'
    :type node_deallocation_option: str or
     ~azure.batch.models.ComputeNodeDeallocationOption
    """

    _attribute_map = {
        'target_dedicated_nodes': {'key': 'targetDedicatedNodes', 'type': 'int'},
        'target_low_priority_nodes': {'key': 'targetLowPriorityNodes', 'type': 'int'},
        'resize_timeout': {'key': 'resizeTimeout', 'type': 'duration'},
        'node_deallocation_option': {'key': 'nodeDeallocationOption', 'type': 'ComputeNodeDeallocationOption'},
    }

    def __init__(self, **kwargs):
        super(PoolResizeParameter, self).__init__(**kwargs)
        self.target_dedicated_nodes = kwargs.get('target_dedicated_nodes', None)
        self.target_low_priority_nodes = kwargs.get('target_low_priority_nodes', None)
        self.resize_timeout = kwargs.get('resize_timeout', None)
        self.node_deallocation_option = kwargs.get('node_deallocation_option', None)


class PoolSpecification(Model):
    """Specification for creating a new pool.

    All required parameters must be populated in order to send to Azure.

    :param display_name: The display name for the pool. The display name need
     not be unique and can contain any Unicode characters up to a maximum
     length of 1024.
    :type display_name: str
    :param vm_size: Required. The size of the virtual machines in the pool.
     All virtual machines in a pool are the same size. For information about
     available sizes of virtual machines in pools, see Choose a VM size for
     compute nodes in an Azure Batch pool
     (https://docs.microsoft.com/azure/batch/batch-pool-vm-sizes).
    :type vm_size: str
    :param cloud_service_configuration: The cloud service configuration for
     the pool. This property must be specified if the pool needs to be created
     with Azure PaaS VMs. This property and virtualMachineConfiguration are
     mutually exclusive and one of the properties must be specified. If neither
     is specified then the Batch service returns an error; if you are calling
     the REST API directly, the HTTP status code is 400 (Bad Request). This
     property cannot be specified if the Batch account was created with its
     poolAllocationMode property set to 'UserSubscription'.
    :type cloud_service_configuration:
     ~azure.batch.models.CloudServiceConfiguration
    :param virtual_machine_configuration: The virtual machine configuration
     for the pool. This property must be specified if the pool needs to be
     created with Azure IaaS VMs. This property and cloudServiceConfiguration
     are mutually exclusive and one of the properties must be specified. If
     neither is specified then the Batch service returns an error; if you are
     calling the REST API directly, the HTTP status code is 400 (Bad Request).
    :type virtual_machine_configuration:
     ~azure.batch.models.VirtualMachineConfiguration
    :param max_tasks_per_node: The maximum number of tasks that can run
     concurrently on a single compute node in the pool. The default value is 1.
     The maximum value of this setting depends on the size of the compute nodes
     in the pool (the vmSize setting).
    :type max_tasks_per_node: int
    :param task_scheduling_policy: How tasks are distributed across compute
     nodes in a pool.
    :type task_scheduling_policy: ~azure.batch.models.TaskSchedulingPolicy
    :param resize_timeout: The timeout for allocation of compute nodes to the
     pool. This timeout applies only to manual scaling; it has no effect when
     enableAutoScale is set to true. The default value is 15 minutes. The
     minimum value is 5 minutes. If you specify a value less than 5 minutes,
     the Batch service rejects the request with an error; if you are calling
     the REST API directly, the HTTP status code is 400 (Bad Request).
    :type resize_timeout: timedelta
    :param target_dedicated_nodes: The desired number of dedicated compute
     nodes in the pool. This property must not be specified if enableAutoScale
     is set to true. If enableAutoScale is set to false, then you must set
     either targetDedicatedNodes, targetLowPriorityNodes, or both.
    :type target_dedicated_nodes: int
    :param target_low_priority_nodes: The desired number of low-priority
     compute nodes in the pool. This property must not be specified if
     enableAutoScale is set to true. If enableAutoScale is set to false, then
     you must set either targetDedicatedNodes, targetLowPriorityNodes, or both.
    :type target_low_priority_nodes: int
    :param enable_auto_scale: Whether the pool size should automatically
     adjust over time. If false, at least one of targetDedicateNodes and
     targetLowPriorityNodes must be specified. If true, the autoScaleFormula
     element is required. The pool automatically resizes according to the
     formula. The default value is false.
    :type enable_auto_scale: bool
    :param auto_scale_formula: The formula for the desired number of compute
     nodes in the pool. This property must not be specified if enableAutoScale
     is set to false. It is required if enableAutoScale is set to true. The
     formula is checked for validity before the pool is created. If the formula
     is not valid, the Batch service rejects the request with detailed error
     information.
    :type auto_scale_formula: str
    :param auto_scale_evaluation_interval: The time interval at which to
     automatically adjust the pool size according to the autoscale formula. The
     default value is 15 minutes. The minimum and maximum value are 5 minutes
     and 168 hours respectively. If you specify a value less than 5 minutes or
     greater than 168 hours, the Batch service rejects the request with an
     invalid property value error; if you are calling the REST API directly,
     the HTTP status code is 400 (Bad Request).
    :type auto_scale_evaluation_interval: timedelta
    :param enable_inter_node_communication: Whether the pool permits direct
     communication between nodes. Enabling inter-node communication limits the
     maximum size of the pool due to deployment restrictions on the nodes of
     the pool. This may result in the pool not reaching its desired size. The
     default value is false.
    :type enable_inter_node_communication: bool
    :param network_configuration: The network configuration for the pool.
    :type network_configuration: ~azure.batch.models.NetworkConfiguration
    :param start_task: A task to run on each compute node as it joins the
     pool. The task runs when the node is added to the pool or when the node is
     restarted.
    :type start_task: ~azure.batch.models.StartTask
    :param certificate_references: A list of certificates to be installed on
     each compute node in the pool. For Windows compute nodes, the Batch
     service installs the certificates to the specified certificate store and
     location. For Linux compute nodes, the certificates are stored in a
     directory inside the task working directory and an environment variable
     AZ_BATCH_CERTIFICATES_DIR is supplied to the task to query for this
     location. For certificates with visibility of 'remoteUser', a 'certs'
     directory is created in the user's home directory (e.g.,
     /home/{user-name}/certs) and certificates are placed in that directory.
    :type certificate_references:
     list[~azure.batch.models.CertificateReference]
    :param application_package_references: The list of application packages to
     be installed on each compute node in the pool.
    :type application_package_references:
     list[~azure.batch.models.ApplicationPackageReference]
    :param application_licenses: The list of application licenses the Batch
     service will make available on each compute node in the pool. The list of
     application licenses must be a subset of available Batch service
     application licenses. If a license is requested which is not supported,
     pool creation will fail. The permitted licenses available on the pool are
     'maya', 'vray', '3dsmax', 'arnold'. An additional charge applies for each
     application license added to the pool.
    :type application_licenses: list[str]
    :param user_accounts: The list of user accounts to be created on each node
     in the pool.
    :type user_accounts: list[~azure.batch.models.UserAccount]
    :param metadata: A list of name-value pairs associated with the pool as
     metadata. The Batch service does not assign any meaning to metadata; it is
     solely for the use of user code.
    :type metadata: list[~azure.batch.models.MetadataItem]
    """

    _validation = {
        'vm_size': {'required': True},
    }

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'vm_size': {'key': 'vmSize', 'type': 'str'},
        'cloud_service_configuration': {'key': 'cloudServiceConfiguration', 'type': 'CloudServiceConfiguration'},
        'virtual_machine_configuration': {'key': 'virtualMachineConfiguration', 'type': 'VirtualMachineConfiguration'},
        'max_tasks_per_node': {'key': 'maxTasksPerNode', 'type': 'int'},
        'task_scheduling_policy': {'key': 'taskSchedulingPolicy', 'type': 'TaskSchedulingPolicy'},
        'resize_timeout': {'key': 'resizeTimeout', 'type': 'duration'},
        'target_dedicated_nodes': {'key': 'targetDedicatedNodes', 'type': 'int'},
        'target_low_priority_nodes': {'key': 'targetLowPriorityNodes', 'type': 'int'},
        'enable_auto_scale': {'key': 'enableAutoScale', 'type': 'bool'},
        'auto_scale_formula': {'key': 'autoScaleFormula', 'type': 'str'},
        'auto_scale_evaluation_interval': {'key': 'autoScaleEvaluationInterval', 'type': 'duration'},
        'enable_inter_node_communication': {'key': 'enableInterNodeCommunication', 'type': 'bool'},
        'network_configuration': {'key': 'networkConfiguration', 'type': 'NetworkConfiguration'},
        'start_task': {'key': 'startTask', 'type': 'StartTask'},
        'certificate_references': {'key': 'certificateReferences', 'type': '[CertificateReference]'},
        'application_package_references': {'key': 'applicationPackageReferences', 'type': '[ApplicationPackageReference]'},
        'application_licenses': {'key': 'applicationLicenses', 'type': '[str]'},
        'user_accounts': {'key': 'userAccounts', 'type': '[UserAccount]'},
        'metadata': {'key': 'metadata', 'type': '[MetadataItem]'},
    }

    def __init__(self, **kwargs):
        super(PoolSpecification, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)
        self.vm_size = kwargs.get('vm_size', None)
        self.cloud_service_configuration = kwargs.get('cloud_service_configuration', None)
        self.virtual_machine_configuration = kwargs.get('virtual_machine_configuration', None)
        self.max_tasks_per_node = kwargs.get('max_tasks_per_node', None)
        self.task_scheduling_policy = kwargs.get('task_scheduling_policy', None)
        self.resize_timeout = kwargs.get('resize_timeout', None)
        self.target_dedicated_nodes = kwargs.get('target_dedicated_nodes', None)
        self.target_low_priority_nodes = kwargs.get('target_low_priority_nodes', None)
        self.enable_auto_scale = kwargs.get('enable_auto_scale', None)
        self.auto_scale_formula = kwargs.get('auto_scale_formula', None)
        self.auto_scale_evaluation_interval = kwargs.get('auto_scale_evaluation_interval', None)
        self.enable_inter_node_communication = kwargs.get('enable_inter_node_communication', None)
        self.network_configuration = kwargs.get('network_configuration', None)
        self.start_task = kwargs.get('start_task', None)
        self.certificate_references = kwargs.get('certificate_references', None)
        self.application_package_references = kwargs.get('application_package_references', None)
        self.application_licenses = kwargs.get('application_licenses', None)
        self.user_accounts = kwargs.get('user_accounts', None)
        self.metadata = kwargs.get('metadata', None)


class PoolStatistics(Model):
    """Contains utilization and resource usage statistics for the lifetime of a
    pool.

    All required parameters must be populated in order to send to Azure.

    :param url: Required. The URL for the statistics.
    :type url: str
    :param start_time: Required. The start time of the time range covered by
     the statistics.
    :type start_time: datetime
    :param last_update_time: Required. The time at which the statistics were
     last updated. All statistics are limited to the range between startTime
     and lastUpdateTime.
    :type last_update_time: datetime
    :param usage_stats: Statistics related to pool usage, such as the amount
     of core-time used.
    :type usage_stats: ~azure.batch.models.UsageStatistics
    :param resource_stats: Statistics related to resource consumption by
     compute nodes in the pool.
    :type resource_stats: ~azure.batch.models.ResourceStatistics
    """

    _validation = {
        'url': {'required': True},
        'start_time': {'required': True},
        'last_update_time': {'required': True},
    }

    _attribute_map = {
        'url': {'key': 'url', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'last_update_time': {'key': 'lastUpdateTime', 'type': 'iso-8601'},
        'usage_stats': {'key': 'usageStats', 'type': 'UsageStatistics'},
        'resource_stats': {'key': 'resourceStats', 'type': 'ResourceStatistics'},
    }

    def __init__(self, **kwargs):
        super(PoolStatistics, self).__init__(**kwargs)
        self.url = kwargs.get('url', None)
        self.start_time = kwargs.get('start_time', None)
        self.last_update_time = kwargs.get('last_update_time', None)
        self.usage_stats = kwargs.get('usage_stats', None)
        self.resource_stats = kwargs.get('resource_stats', None)


class PoolStopResizeOptions(Model):
    """Additional parameters for stop_resize operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    :param if_match: An ETag value associated with the version of the resource
     known to the client. The operation will be performed only if the
     resource's current ETag on the service exactly matches the value specified
     by the client.
    :type if_match: str
    :param if_none_match: An ETag value associated with the version of the
     resource known to the client. The operation will be performed only if the
     resource's current ETag on the service does not match the value specified
     by the client.
    :type if_none_match: str
    :param if_modified_since: A timestamp indicating the last modified time of
     the resource known to the client. The operation will be performed only if
     the resource on the service has been modified since the specified time.
    :type if_modified_since: datetime
    :param if_unmodified_since: A timestamp indicating the last modified time
     of the resource known to the client. The operation will be performed only
     if the resource on the service has not been modified since the specified
     time.
    :type if_unmodified_since: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
        'if_match': {'key': '', 'type': 'str'},
        'if_none_match': {'key': '', 'type': 'str'},
        'if_modified_since': {'key': '', 'type': 'rfc-1123'},
        'if_unmodified_since': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(PoolStopResizeOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)
        self.if_match = kwargs.get('if_match', None)
        self.if_none_match = kwargs.get('if_none_match', None)
        self.if_modified_since = kwargs.get('if_modified_since', None)
        self.if_unmodified_since = kwargs.get('if_unmodified_since', None)


class PoolUpdatePropertiesOptions(Model):
    """Additional parameters for update_properties operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(PoolUpdatePropertiesOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)


class PoolUpdatePropertiesParameter(Model):
    """The set of changes to be made to a pool.

    All required parameters must be populated in order to send to Azure.

    :param start_task: A task to run on each compute node as it joins the
     pool. The task runs when the node is added to the pool or when the node is
     restarted. If this element is present, it overwrites any existing start
     task. If omitted, any existing start task is removed from the pool.
    :type start_task: ~azure.batch.models.StartTask
    :param certificate_references: Required. A list of certificates to be
     installed on each compute node in the pool. This list replaces any
     existing certificate references configured on the pool. If you specify an
     empty collection, any existing certificate references are removed from the
     pool. For Windows compute nodes, the Batch service installs the
     certificates to the specified certificate store and location. For Linux
     compute nodes, the certificates are stored in a directory inside the task
     working directory and an environment variable AZ_BATCH_CERTIFICATES_DIR is
     supplied to the task to query for this location. For certificates with
     visibility of 'remoteUser', a 'certs' directory is created in the user's
     home directory (e.g., /home/{user-name}/certs) and certificates are placed
     in that directory.
    :type certificate_references:
     list[~azure.batch.models.CertificateReference]
    :param application_package_references: Required. A list of application
     packages to be installed on each compute node in the pool. The list
     replaces any existing application package references on the pool. Changes
     to application package references affect all new compute nodes joining the
     pool, but do not affect compute nodes that are already in the pool until
     they are rebooted or reimaged. If omitted, or if you specify an empty
     collection, any existing application packages references are removed from
     the pool.
    :type application_package_references:
     list[~azure.batch.models.ApplicationPackageReference]
    :param metadata: Required. A list of name-value pairs associated with the
     pool as metadata. This list replaces any existing metadata configured on
     the pool. If omitted, or if you specify an empty collection, any existing
     metadata is removed from the pool.
    :type metadata: list[~azure.batch.models.MetadataItem]
    """

    _validation = {
        'certificate_references': {'required': True},
        'application_package_references': {'required': True},
        'metadata': {'required': True},
    }

    _attribute_map = {
        'start_task': {'key': 'startTask', 'type': 'StartTask'},
        'certificate_references': {'key': 'certificateReferences', 'type': '[CertificateReference]'},
        'application_package_references': {'key': 'applicationPackageReferences', 'type': '[ApplicationPackageReference]'},
        'metadata': {'key': 'metadata', 'type': '[MetadataItem]'},
    }

    def __init__(self, **kwargs):
        super(PoolUpdatePropertiesParameter, self).__init__(**kwargs)
        self.start_task = kwargs.get('start_task', None)
        self.certificate_references = kwargs.get('certificate_references', None)
        self.application_package_references = kwargs.get('application_package_references', None)
        self.metadata = kwargs.get('metadata', None)


class PoolUsageMetrics(Model):
    """Usage metrics for a pool across an aggregation interval.

    All required parameters must be populated in order to send to Azure.

    :param pool_id: Required. The ID of the pool whose metrics are aggregated
     in this entry.
    :type pool_id: str
    :param start_time: Required. The start time of the aggregation interval
     covered by this entry.
    :type start_time: datetime
    :param end_time: Required. The end time of the aggregation interval
     covered by this entry.
    :type end_time: datetime
    :param vm_size: Required. The size of virtual machines in the pool. All
     VMs in a pool are the same size. For information about available sizes of
     virtual machines in pools, see Choose a VM size for compute nodes in an
     Azure Batch pool
     (https://docs.microsoft.com/azure/batch/batch-pool-vm-sizes).
    :type vm_size: str
    :param total_core_hours: Required. The total core hours used in the pool
     during this aggregation interval.
    :type total_core_hours: float
    """

    _validation = {
        'pool_id': {'required': True},
        'start_time': {'required': True},
        'end_time': {'required': True},
        'vm_size': {'required': True},
        'total_core_hours': {'required': True},
    }

    _attribute_map = {
        'pool_id': {'key': 'poolId', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'vm_size': {'key': 'vmSize', 'type': 'str'},
        'total_core_hours': {'key': 'totalCoreHours', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(PoolUsageMetrics, self).__init__(**kwargs)
        self.pool_id = kwargs.get('pool_id', None)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.vm_size = kwargs.get('vm_size', None)
        self.total_core_hours = kwargs.get('total_core_hours', None)


class RecentJob(Model):
    """Information about the most recent job to run under the job schedule.

    :param id: The ID of the job.
    :type id: str
    :param url: The URL of the job.
    :type url: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'url': {'key': 'url', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(RecentJob, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.url = kwargs.get('url', None)


class ResizeError(Model):
    """An error that occurred when resizing a pool.

    :param code: An identifier for the pool resize error. Codes are invariant
     and are intended to be consumed programmatically.
    :type code: str
    :param message: A message describing the pool resize error, intended to be
     suitable for display in a user interface.
    :type message: str
    :param values: A list of additional error details related to the pool
     resize error.
    :type values: list[~azure.batch.models.NameValuePair]
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'values': {'key': 'values', 'type': '[NameValuePair]'},
    }

    def __init__(self, **kwargs):
        super(ResizeError, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.values = kwargs.get('values', None)


class ResourceFile(Model):
    """A single file or multiple files to be downloaded to a compute node.

    :param auto_storage_container_name: The storage container name in the auto
     storage account. The autoStorageContainerName, storageContainerUrl and
     httpUrl properties are mutually exclusive and one of them must be
     specified.
    :type auto_storage_container_name: str
    :param storage_container_url: The URL of the blob container within Azure
     Blob Storage. The autoStorageContainerName, storageContainerUrl and
     httpUrl properties are mutually exclusive and one of them must be
     specified. This URL must be readable and listable using anonymous access;
     that is, the Batch service does not present any credentials when
     downloading blobs from the container. There are two ways to get such a URL
     for a container in Azure storage: include a Shared Access Signature (SAS)
     granting read and list permissions on the container, or set the ACL for
     the container to allow public access.
    :type storage_container_url: str
    :param http_url: The URL of the file to download. The
     autoStorageContainerName, storageContainerUrl and httpUrl properties are
     mutually exclusive and one of them must be specified. If the URL points to
     Azure Blob Storage, it must be readable using anonymous access; that is,
     the Batch service does not present any credentials when downloading the
     blob. There are two ways to get such a URL for a blob in Azure storage:
     include a Shared Access Signature (SAS) granting read permissions on the
     blob, or set the ACL for the blob or its container to allow public access.
    :type http_url: str
    :param blob_prefix: The blob prefix to use when downloading blobs from an
     Azure Storage container. Only the blobs whose names begin with the
     specified prefix will be downloaded. The property is valid only when
     autoStorageContainerName or storageContainerUrl is used. This prefix can
     be a partial filename or a subdirectory. If a prefix is not specified, all
     the files in the container will be downloaded.
    :type blob_prefix: str
    :param file_path: The location on the compute node to which to download
     the file(s), relative to the task's working directory. If the httpUrl
     property is specified, the filePath is required and describes the path
     which the file will be downloaded to, including the filename. Otherwise,
     if the autoStorageContainerName or storageContainerUrl property is
     specified, filePath is optional and is the directory to download the files
     to. In the case where filePath is used as a directory, any directory
     structure already associated with the input data will be retained in full
     and appended to the specified filePath directory. The specified relative
     path cannot break out of the task's working directory (for example by
     using '..').
    :type file_path: str
    :param file_mode: The file permission mode attribute in octal format. This
     property applies only to files being downloaded to Linux compute nodes. It
     will be ignored if it is specified for a resourceFile which will be
     downloaded to a Windows node. If this property is not specified for a
     Linux node, then a default value of 0770 is applied to the file.
    :type file_mode: str
    """

    _attribute_map = {
        'auto_storage_container_name': {'key': 'autoStorageContainerName', 'type': 'str'},
        'storage_container_url': {'key': 'storageContainerUrl', 'type': 'str'},
        'http_url': {'key': 'httpUrl', 'type': 'str'},
        'blob_prefix': {'key': 'blobPrefix', 'type': 'str'},
        'file_path': {'key': 'filePath', 'type': 'str'},
        'file_mode': {'key': 'fileMode', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ResourceFile, self).__init__(**kwargs)
        self.auto_storage_container_name = kwargs.get('auto_storage_container_name', None)
        self.storage_container_url = kwargs.get('storage_container_url', None)
        self.http_url = kwargs.get('http_url', None)
        self.blob_prefix = kwargs.get('blob_prefix', None)
        self.file_path = kwargs.get('file_path', None)
        self.file_mode = kwargs.get('file_mode', None)


class ResourceStatistics(Model):
    """Statistics related to resource consumption by compute nodes in a pool.

    All required parameters must be populated in order to send to Azure.

    :param start_time: Required. The start time of the time range covered by
     the statistics.
    :type start_time: datetime
    :param last_update_time: Required. The time at which the statistics were
     last updated. All statistics are limited to the range between startTime
     and lastUpdateTime.
    :type last_update_time: datetime
    :param avg_cpu_percentage: Required. The average CPU usage across all
     nodes in the pool (percentage per node).
    :type avg_cpu_percentage: float
    :param avg_memory_gi_b: Required. The average memory usage in GiB across
     all nodes in the pool.
    :type avg_memory_gi_b: float
    :param peak_memory_gi_b: Required. The peak memory usage in GiB across all
     nodes in the pool.
    :type peak_memory_gi_b: float
    :param avg_disk_gi_b: Required. The average used disk space in GiB across
     all nodes in the pool.
    :type avg_disk_gi_b: float
    :param peak_disk_gi_b: Required. The peak used disk space in GiB across
     all nodes in the pool.
    :type peak_disk_gi_b: float
    :param disk_read_iops: Required. The total number of disk read operations
     across all nodes in the pool.
    :type disk_read_iops: long
    :param disk_write_iops: Required. The total number of disk write
     operations across all nodes in the pool.
    :type disk_write_iops: long
    :param disk_read_gi_b: Required. The total amount of data in GiB of disk
     reads across all nodes in the pool.
    :type disk_read_gi_b: float
    :param disk_write_gi_b: Required. The total amount of data in GiB of disk
     writes across all nodes in the pool.
    :type disk_write_gi_b: float
    :param network_read_gi_b: Required. The total amount of data in GiB of
     network reads across all nodes in the pool.
    :type network_read_gi_b: float
    :param network_write_gi_b: Required. The total amount of data in GiB of
     network writes across all nodes in the pool.
    :type network_write_gi_b: float
    """

    _validation = {
        'start_time': {'required': True},
        'last_update_time': {'required': True},
        'avg_cpu_percentage': {'required': True},
        'avg_memory_gi_b': {'required': True},
        'peak_memory_gi_b': {'required': True},
        'avg_disk_gi_b': {'required': True},
        'peak_disk_gi_b': {'required': True},
        'disk_read_iops': {'required': True},
        'disk_write_iops': {'required': True},
        'disk_read_gi_b': {'required': True},
        'disk_write_gi_b': {'required': True},
        'network_read_gi_b': {'required': True},
        'network_write_gi_b': {'required': True},
    }

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'last_update_time': {'key': 'lastUpdateTime', 'type': 'iso-8601'},
        'avg_cpu_percentage': {'key': 'avgCPUPercentage', 'type': 'float'},
        'avg_memory_gi_b': {'key': 'avgMemoryGiB', 'type': 'float'},
        'peak_memory_gi_b': {'key': 'peakMemoryGiB', 'type': 'float'},
        'avg_disk_gi_b': {'key': 'avgDiskGiB', 'type': 'float'},
        'peak_disk_gi_b': {'key': 'peakDiskGiB', 'type': 'float'},
        'disk_read_iops': {'key': 'diskReadIOps', 'type': 'long'},
        'disk_write_iops': {'key': 'diskWriteIOps', 'type': 'long'},
        'disk_read_gi_b': {'key': 'diskReadGiB', 'type': 'float'},
        'disk_write_gi_b': {'key': 'diskWriteGiB', 'type': 'float'},
        'network_read_gi_b': {'key': 'networkReadGiB', 'type': 'float'},
        'network_write_gi_b': {'key': 'networkWriteGiB', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(ResourceStatistics, self).__init__(**kwargs)
        self.start_time = kwargs.get('start_time', None)
        self.last_update_time = kwargs.get('last_update_time', None)
        self.avg_cpu_percentage = kwargs.get('avg_cpu_percentage', None)
        self.avg_memory_gi_b = kwargs.get('avg_memory_gi_b', None)
        self.peak_memory_gi_b = kwargs.get('peak_memory_gi_b', None)
        self.avg_disk_gi_b = kwargs.get('avg_disk_gi_b', None)
        self.peak_disk_gi_b = kwargs.get('peak_disk_gi_b', None)
        self.disk_read_iops = kwargs.get('disk_read_iops', None)
        self.disk_write_iops = kwargs.get('disk_write_iops', None)
        self.disk_read_gi_b = kwargs.get('disk_read_gi_b', None)
        self.disk_write_gi_b = kwargs.get('disk_write_gi_b', None)
        self.network_read_gi_b = kwargs.get('network_read_gi_b', None)
        self.network_write_gi_b = kwargs.get('network_write_gi_b', None)


class Schedule(Model):
    """The schedule according to which jobs will be created.

    :param do_not_run_until: The earliest time at which any job may be created
     under this job schedule. If you do not specify a doNotRunUntil time, the
     schedule becomes ready to create jobs immediately.
    :type do_not_run_until: datetime
    :param do_not_run_after: A time after which no job will be created under
     this job schedule. The schedule will move to the completed state as soon
     as this deadline is past and there is no active job under this job
     schedule. If you do not specify a doNotRunAfter time, and you are creating
     a recurring job schedule, the job schedule will remain active until you
     explicitly terminate it.
    :type do_not_run_after: datetime
    :param start_window: The time interval, starting from the time at which
     the schedule indicates a job should be created, within which a job must be
     created. If a job is not created within the startWindow interval, then the
     'opportunity' is lost; no job will be created until the next recurrence of
     the schedule. If the schedule is recurring, and the startWindow is longer
     than the recurrence interval, then this is equivalent to an infinite
     startWindow, because the job that is 'due' in one recurrenceInterval is
     not carried forward into the next recurrence interval. The default is
     infinite. The minimum value is 1 minute. If you specify a lower value, the
     Batch service rejects the schedule with an error; if you are calling the
     REST API directly, the HTTP status code is 400 (Bad Request).
    :type start_window: timedelta
    :param recurrence_interval: The time interval between the start times of
     two successive jobs under the job schedule. A job schedule can have at
     most one active job under it at any given time. Because a job schedule can
     have at most one active job under it at any given time, if it is time to
     create a new job under a job schedule, but the previous job is still
     running, the Batch service will not create the new job until the previous
     job finishes. If the previous job does not finish within the startWindow
     period of the new recurrenceInterval, then no new job will be scheduled
     for that interval. For recurring jobs, you should normally specify a
     jobManagerTask in the jobSpecification. If you do not use jobManagerTask,
     you will need an external process to monitor when jobs are created, add
     tasks to the jobs and terminate the jobs ready for the next recurrence.
     The default is that the schedule does not recur: one job is created,
     within the startWindow after the doNotRunUntil time, and the schedule is
     complete as soon as that job finishes. The minimum value is 1 minute. If
     you specify a lower value, the Batch service rejects the schedule with an
     error; if you are calling the REST API directly, the HTTP status code is
     400 (Bad Request).
    :type recurrence_interval: timedelta
    """

    _attribute_map = {
        'do_not_run_until': {'key': 'doNotRunUntil', 'type': 'iso-8601'},
        'do_not_run_after': {'key': 'doNotRunAfter', 'type': 'iso-8601'},
        'start_window': {'key': 'startWindow', 'type': 'duration'},
        'recurrence_interval': {'key': 'recurrenceInterval', 'type': 'duration'},
    }

    def __init__(self, **kwargs):
        super(Schedule, self).__init__(**kwargs)
        self.do_not_run_until = kwargs.get('do_not_run_until', None)
        self.do_not_run_after = kwargs.get('do_not_run_after', None)
        self.start_window = kwargs.get('start_window', None)
        self.recurrence_interval = kwargs.get('recurrence_interval', None)


class StartTask(Model):
    """A task which is run when a compute node joins a pool in the Azure Batch
    service, or when the compute node is rebooted or reimaged.

    Batch will retry tasks when a recovery operation is triggered on a compute
    node. Examples of recovery operations include (but are not limited to) when
    an unhealthy compute node is rebooted or a compute node disappeared due to
    host failure. Retries due to recovery operations are independent of and are
    not counted against the maxTaskRetryCount. Even if the maxTaskRetryCount is
    0, an internal retry due to a recovery operation may occur. Because of
    this, all tasks should be idempotent. This means tasks need to tolerate
    being interrupted and restarted without causing any corruption or duplicate
    data. The best practice for long running tasks is to use some form of
    checkpointing.

    All required parameters must be populated in order to send to Azure.

    :param command_line: Required. The command line of the start task. The
     command line does not run under a shell, and therefore cannot take
     advantage of shell features such as environment variable expansion. If you
     want to take advantage of such features, you should invoke the shell in
     the command line, for example using "cmd /c MyCommand" in Windows or
     "/bin/sh -c MyCommand" in Linux. If the command line refers to file paths,
     it should use a relative path (relative to the task working directory), or
     use the Batch provided environment variable
     (https://docs.microsoft.com/en-us/azure/batch/batch-compute-node-environment-variables).
    :type command_line: str
    :param container_settings: The settings for the container under which the
     start task runs. When this is specified, all directories recursively below
     the AZ_BATCH_NODE_ROOT_DIR (the root of Azure Batch directories on the
     node) are mapped into the container, all task environment variables are
     mapped into the container, and the task command line is executed in the
     container.
    :type container_settings: ~azure.batch.models.TaskContainerSettings
    :param resource_files: A list of files that the Batch service will
     download to the compute node before running the command line.  There is a
     maximum size for the list of resource files. When the max size is
     exceeded, the request will fail and the response error code will be
     RequestEntityTooLarge. If this occurs, the collection of ResourceFiles
     must be reduced in size. This can be achieved using .zip files,
     Application Packages, or Docker Containers. Files listed under this
     element are located in the task's working directory.
    :type resource_files: list[~azure.batch.models.ResourceFile]
    :param environment_settings: A list of environment variable settings for
     the start task.
    :type environment_settings: list[~azure.batch.models.EnvironmentSetting]
    :param user_identity: The user identity under which the start task runs.
     If omitted, the task runs as a non-administrative user unique to the task.
    :type user_identity: ~azure.batch.models.UserIdentity
    :param max_task_retry_count: The maximum number of times the task may be
     retried. The Batch service retries a task if its exit code is nonzero.
     Note that this value specifically controls the number of retries. The
     Batch service will try the task once, and may then retry up to this limit.
     For example, if the maximum retry count is 3, Batch tries the task up to 4
     times (one initial try and 3 retries). If the maximum retry count is 0,
     the Batch service does not retry the task. If the maximum retry count is
     -1, the Batch service retries the task without limit.
    :type max_task_retry_count: int
    :param wait_for_success: Whether the Batch service should wait for the
     start task to complete successfully (that is, to exit with exit code 0)
     before scheduling any tasks on the compute node. If true and the start
     task fails on a compute node, the Batch service retries the start task up
     to its maximum retry count (maxTaskRetryCount). If the task has still not
     completed successfully after all retries, then the Batch service marks the
     compute node unusable, and will not schedule tasks to it. This condition
     can be detected via the node state and failure info details. If false, the
     Batch service will not wait for the start task to complete. In this case,
     other tasks can start executing on the compute node while the start task
     is still running; and even if the start task fails, new tasks will
     continue to be scheduled on the node. The default is false.
    :type wait_for_success: bool
    """

    _validation = {
        'command_line': {'required': True},
    }

    _attribute_map = {
        'command_line': {'key': 'commandLine', 'type': 'str'},
        'container_settings': {'key': 'containerSettings', 'type': 'TaskContainerSettings'},
        'resource_files': {'key': 'resourceFiles', 'type': '[ResourceFile]'},
        'environment_settings': {'key': 'environmentSettings', 'type': '[EnvironmentSetting]'},
        'user_identity': {'key': 'userIdentity', 'type': 'UserIdentity'},
        'max_task_retry_count': {'key': 'maxTaskRetryCount', 'type': 'int'},
        'wait_for_success': {'key': 'waitForSuccess', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(StartTask, self).__init__(**kwargs)
        self.command_line = kwargs.get('command_line', None)
        self.container_settings = kwargs.get('container_settings', None)
        self.resource_files = kwargs.get('resource_files', None)
        self.environment_settings = kwargs.get('environment_settings', None)
        self.user_identity = kwargs.get('user_identity', None)
        self.max_task_retry_count = kwargs.get('max_task_retry_count', None)
        self.wait_for_success = kwargs.get('wait_for_success', None)


class StartTaskInformation(Model):
    """Information about a start task running on a compute node.

    All required parameters must be populated in order to send to Azure.

    :param state: Required. The state of the start task on the compute node.
     Possible values include: 'running', 'completed'
    :type state: str or ~azure.batch.models.StartTaskState
    :param start_time: Required. The time at which the start task started
     running. This value is reset every time the task is restarted or retried
     (that is, this is the most recent time at which the start task started
     running).
    :type start_time: datetime
    :param end_time: The time at which the start task stopped running. This is
     the end time of the most recent run of the start task, if that run has
     completed (even if that run failed and a retry is pending). This element
     is not present if the start task is currently running.
    :type end_time: datetime
    :param exit_code: The exit code of the program specified on the start task
     command line. This property is set only if the start task is in the
     completed state. In general, the exit code for a process reflects the
     specific convention implemented by the application developer for that
     process. If you use the exit code value to make decisions in your code, be
     sure that you know the exit code convention used by the application
     process. However, if the Batch service terminates the start task (due to
     timeout, or user termination via the API) you may see an operating
     system-defined exit code.
    :type exit_code: int
    :param container_info: Information about the container under which the
     task is executing. This property is set only if the task runs in a
     container context.
    :type container_info:
     ~azure.batch.models.TaskContainerExecutionInformation
    :param failure_info: Information describing the task failure, if any. This
     property is set only if the task is in the completed state and encountered
     a failure.
    :type failure_info: ~azure.batch.models.TaskFailureInformation
    :param retry_count: Required. The number of times the task has been
     retried by the Batch service. Task application failures (non-zero exit
     code) are retried, pre-processing errors (the task could not be run) and
     file upload errors are not retried. The Batch service will retry the task
     up to the limit specified by the constraints.
    :type retry_count: int
    :param last_retry_time: The most recent time at which a retry of the task
     started running. This element is present only if the task was retried
     (i.e. retryCount is nonzero). If present, this is typically the same as
     startTime, but may be different if the task has been restarted for reasons
     other than retry; for example, if the compute node was rebooted during a
     retry, then the startTime is updated but the lastRetryTime is not.
    :type last_retry_time: datetime
    :param result: The result of the task execution. If the value is 'failed',
     then the details of the failure can be found in the failureInfo property.
     Possible values include: 'success', 'failure'
    :type result: str or ~azure.batch.models.TaskExecutionResult
    """

    _validation = {
        'state': {'required': True},
        'start_time': {'required': True},
        'retry_count': {'required': True},
    }

    _attribute_map = {
        'state': {'key': 'state', 'type': 'StartTaskState'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'exit_code': {'key': 'exitCode', 'type': 'int'},
        'container_info': {'key': 'containerInfo', 'type': 'TaskContainerExecutionInformation'},
        'failure_info': {'key': 'failureInfo', 'type': 'TaskFailureInformation'},
        'retry_count': {'key': 'retryCount', 'type': 'int'},
        'last_retry_time': {'key': 'lastRetryTime', 'type': 'iso-8601'},
        'result': {'key': 'result', 'type': 'TaskExecutionResult'},
    }

    def __init__(self, **kwargs):
        super(StartTaskInformation, self).__init__(**kwargs)
        self.state = kwargs.get('state', None)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.exit_code = kwargs.get('exit_code', None)
        self.container_info = kwargs.get('container_info', None)
        self.failure_info = kwargs.get('failure_info', None)
        self.retry_count = kwargs.get('retry_count', None)
        self.last_retry_time = kwargs.get('last_retry_time', None)
        self.result = kwargs.get('result', None)


class SubtaskInformation(Model):
    """Information about an Azure Batch subtask.

    :param id: The ID of the subtask.
    :type id: int
    :param node_info: Information about the compute node on which the subtask
     ran.
    :type node_info: ~azure.batch.models.ComputeNodeInformation
    :param start_time: The time at which the subtask started running. If the
     subtask has been restarted or retried, this is the most recent time at
     which the subtask started running.
    :type start_time: datetime
    :param end_time: The time at which the subtask completed. This property is
     set only if the subtask is in the Completed state.
    :type end_time: datetime
    :param exit_code: The exit code of the program specified on the subtask
     command line. This property is set only if the subtask is in the completed
     state. In general, the exit code for a process reflects the specific
     convention implemented by the application developer for that process. If
     you use the exit code value to make decisions in your code, be sure that
     you know the exit code convention used by the application process.
     However, if the Batch service terminates the subtask (due to timeout, or
     user termination via the API) you may see an operating system-defined exit
     code.
    :type exit_code: int
    :param container_info: Information about the container under which the
     task is executing. This property is set only if the task runs in a
     container context.
    :type container_info:
     ~azure.batch.models.TaskContainerExecutionInformation
    :param failure_info: Information describing the task failure, if any. This
     property is set only if the task is in the completed state and encountered
     a failure.
    :type failure_info: ~azure.batch.models.TaskFailureInformation
    :param state: The current state of the subtask. Possible values include:
     'preparing', 'running', 'completed'
    :type state: str or ~azure.batch.models.SubtaskState
    :param state_transition_time: The time at which the subtask entered its
     current state.
    :type state_transition_time: datetime
    :param previous_state: The previous state of the subtask. This property is
     not set if the subtask is in its initial running state. Possible values
     include: 'preparing', 'running', 'completed'
    :type previous_state: str or ~azure.batch.models.SubtaskState
    :param previous_state_transition_time: The time at which the subtask
     entered its previous state. This property is not set if the subtask is in
     its initial running state.
    :type previous_state_transition_time: datetime
    :param result: The result of the task execution. If the value is 'failed',
     then the details of the failure can be found in the failureInfo property.
     Possible values include: 'success', 'failure'
    :type result: str or ~azure.batch.models.TaskExecutionResult
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'int'},
        'node_info': {'key': 'nodeInfo', 'type': 'ComputeNodeInformation'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'exit_code': {'key': 'exitCode', 'type': 'int'},
        'container_info': {'key': 'containerInfo', 'type': 'TaskContainerExecutionInformation'},
        'failure_info': {'key': 'failureInfo', 'type': 'TaskFailureInformation'},
        'state': {'key': 'state', 'type': 'SubtaskState'},
        'state_transition_time': {'key': 'stateTransitionTime', 'type': 'iso-8601'},
        'previous_state': {'key': 'previousState', 'type': 'SubtaskState'},
        'previous_state_transition_time': {'key': 'previousStateTransitionTime', 'type': 'iso-8601'},
        'result': {'key': 'result', 'type': 'TaskExecutionResult'},
    }

    def __init__(self, **kwargs):
        super(SubtaskInformation, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.node_info = kwargs.get('node_info', None)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.exit_code = kwargs.get('exit_code', None)
        self.container_info = kwargs.get('container_info', None)
        self.failure_info = kwargs.get('failure_info', None)
        self.state = kwargs.get('state', None)
        self.state_transition_time = kwargs.get('state_transition_time', None)
        self.previous_state = kwargs.get('previous_state', None)
        self.previous_state_transition_time = kwargs.get('previous_state_transition_time', None)
        self.result = kwargs.get('result', None)


class TaskAddCollectionOptions(Model):
    """Additional parameters for add_collection operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(TaskAddCollectionOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)


class TaskAddCollectionParameter(Model):
    """A collection of Azure Batch tasks to add.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The collection of tasks to add. The maximum count
     of tasks is 100. The total serialized size of this collection must be less
     than 1MB. If it is greater than 1MB (for example if each task has 100's of
     resource files or environment variables), the request will fail with code
     'RequestBodyTooLarge' and should be retried again with fewer tasks.
    :type value: list[~azure.batch.models.TaskAddParameter]
    """

    _validation = {
        'value': {'required': True, 'max_items': 100},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TaskAddParameter]'},
    }

    def __init__(self, **kwargs):
        super(TaskAddCollectionParameter, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class TaskAddCollectionResult(Model):
    """The result of adding a collection of tasks to a job.

    :param value: The results of the add task collection operation.
    :type value: list[~azure.batch.models.TaskAddResult]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[TaskAddResult]'},
    }

    def __init__(self, **kwargs):
        super(TaskAddCollectionResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)


class TaskAddOptions(Model):
    """Additional parameters for add operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(TaskAddOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)


class TaskAddParameter(Model):
    """An Azure Batch task to add.

    Batch will retry tasks when a recovery operation is triggered on a compute
    node. Examples of recovery operations include (but are not limited to) when
    an unhealthy compute node is rebooted or a compute node disappeared due to
    host failure. Retries due to recovery operations are independent of and are
    not counted against the maxTaskRetryCount. Even if the maxTaskRetryCount is
    0, an internal retry due to a recovery operation may occur. Because of
    this, all tasks should be idempotent. This means tasks need to tolerate
    being interrupted and restarted without causing any corruption or duplicate
    data. The best practice for long running tasks is to use some form of
    checkpointing.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. A string that uniquely identifies the task within the
     job. The ID can contain any combination of alphanumeric characters
     including hyphens and underscores, and cannot contain more than 64
     characters. The ID is case-preserving and case-insensitive (that is, you
     may not have two IDs within a job that differ only by case).
    :type id: str
    :param display_name: A display name for the task. The display name need
     not be unique and can contain any Unicode characters up to a maximum
     length of 1024.
    :type display_name: str
    :param command_line: Required. The command line of the task. For
     multi-instance tasks, the command line is executed as the primary task,
     after the primary task and all subtasks have finished executing the
     coordination command line. The command line does not run under a shell,
     and therefore cannot take advantage of shell features such as environment
     variable expansion. If you want to take advantage of such features, you
     should invoke the shell in the command line, for example using "cmd /c
     MyCommand" in Windows or "/bin/sh -c MyCommand" in Linux. If the command
     line refers to file paths, it should use a relative path (relative to the
     task working directory), or use the Batch provided environment variable
     (https://docs.microsoft.com/en-us/azure/batch/batch-compute-node-environment-variables).
    :type command_line: str
    :param container_settings: The settings for the container under which the
     task runs. If the pool that will run this task has containerConfiguration
     set, this must be set as well. If the pool that will run this task doesn't
     have containerConfiguration set, this must not be set. When this is
     specified, all directories recursively below the AZ_BATCH_NODE_ROOT_DIR
     (the root of Azure Batch directories on the node) are mapped into the
     container, all task environment variables are mapped into the container,
     and the task command line is executed in the container.
    :type container_settings: ~azure.batch.models.TaskContainerSettings
    :param exit_conditions: How the Batch service should respond when the task
     completes.
    :type exit_conditions: ~azure.batch.models.ExitConditions
    :param resource_files: A list of files that the Batch service will
     download to the compute node before running the command line. For
     multi-instance tasks, the resource files will only be downloaded to the
     compute node on which the primary task is executed. There is a maximum
     size for the list of resource files.  When the max size is exceeded, the
     request will fail and the response error code will be
     RequestEntityTooLarge. If this occurs, the collection of ResourceFiles
     must be reduced in size. This can be achieved using .zip files,
     Application Packages, or Docker Containers.
    :type resource_files: list[~azure.batch.models.ResourceFile]
    :param output_files: A list of files that the Batch service will upload
     from the compute node after running the command line. For multi-instance
     tasks, the files will only be uploaded from the compute node on which the
     primary task is executed.
    :type output_files: list[~azure.batch.models.OutputFile]
    :param environment_settings: A list of environment variable settings for
     the task.
    :type environment_settings: list[~azure.batch.models.EnvironmentSetting]
    :param affinity_info: A locality hint that can be used by the Batch
     service to select a compute node on which to start the new task.
    :type affinity_info: ~azure.batch.models.AffinityInformation
    :param constraints: The execution constraints that apply to this task. If
     you do not specify constraints, the maxTaskRetryCount is the
     maxTaskRetryCount specified for the job, the maxWallClockTime is infinite,
     and the retentionTime is 7 days.
    :type constraints: ~azure.batch.models.TaskConstraints
    :param user_identity: The user identity under which the task runs. If
     omitted, the task runs as a non-administrative user unique to the task.
    :type user_identity: ~azure.batch.models.UserIdentity
    :param multi_instance_settings: An object that indicates that the task is
     a multi-instance task, and contains information about how to run the
     multi-instance task.
    :type multi_instance_settings: ~azure.batch.models.MultiInstanceSettings
    :param depends_on: The tasks that this task depends on. This task will not
     be scheduled until all tasks that it depends on have completed
     successfully. If any of those tasks fail and exhaust their retry counts,
     this task will never be scheduled. If the job does not have
     usesTaskDependencies set to true, and this element is present, the request
     fails with error code TaskDependenciesNotSpecifiedOnJob.
    :type depends_on: ~azure.batch.models.TaskDependencies
    :param application_package_references: A list of application packages that
     the Batch service will deploy to the compute node before running the
     command line. Application packages are downloaded and deployed to a shared
     directory, not the task working directory. Therefore, if a referenced
     package is already on the compute node, and is up to date, then it is not
     re-downloaded; the existing copy on the compute node is used. If a
     referenced application package cannot be installed, for example because
     the package has been deleted or because download failed, the task fails.
    :type application_package_references:
     list[~azure.batch.models.ApplicationPackageReference]
    :param authentication_token_settings: The settings for an authentication
     token that the task can use to perform Batch service operations. If this
     property is set, the Batch service provides the task with an
     authentication token which can be used to authenticate Batch service
     operations without requiring an account access key. The token is provided
     via the AZ_BATCH_AUTHENTICATION_TOKEN environment variable. The operations
     that the task can carry out using the token depend on the settings. For
     example, a task can request job permissions in order to add other tasks to
     the job, or check the status of the job or of other tasks under the job.
    :type authentication_token_settings:
     ~azure.batch.models.AuthenticationTokenSettings
    """

    _validation = {
        'id': {'required': True},
        'command_line': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'command_line': {'key': 'commandLine', 'type': 'str'},
        'container_settings': {'key': 'containerSettings', 'type': 'TaskContainerSettings'},
        'exit_conditions': {'key': 'exitConditions', 'type': 'ExitConditions'},
        'resource_files': {'key': 'resourceFiles', 'type': '[ResourceFile]'},
        'output_files': {'key': 'outputFiles', 'type': '[OutputFile]'},
        'environment_settings': {'key': 'environmentSettings', 'type': '[EnvironmentSetting]'},
        'affinity_info': {'key': 'affinityInfo', 'type': 'AffinityInformation'},
        'constraints': {'key': 'constraints', 'type': 'TaskConstraints'},
        'user_identity': {'key': 'userIdentity', 'type': 'UserIdentity'},
        'multi_instance_settings': {'key': 'multiInstanceSettings', 'type': 'MultiInstanceSettings'},
        'depends_on': {'key': 'dependsOn', 'type': 'TaskDependencies'},
        'application_package_references': {'key': 'applicationPackageReferences', 'type': '[ApplicationPackageReference]'},
        'authentication_token_settings': {'key': 'authenticationTokenSettings', 'type': 'AuthenticationTokenSettings'},
    }

    def __init__(self, **kwargs):
        super(TaskAddParameter, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.display_name = kwargs.get('display_name', None)
        self.command_line = kwargs.get('command_line', None)
        self.container_settings = kwargs.get('container_settings', None)
        self.exit_conditions = kwargs.get('exit_conditions', None)
        self.resource_files = kwargs.get('resource_files', None)
        self.output_files = kwargs.get('output_files', None)
        self.environment_settings = kwargs.get('environment_settings', None)
        self.affinity_info = kwargs.get('affinity_info', None)
        self.constraints = kwargs.get('constraints', None)
        self.user_identity = kwargs.get('user_identity', None)
        self.multi_instance_settings = kwargs.get('multi_instance_settings', None)
        self.depends_on = kwargs.get('depends_on', None)
        self.application_package_references = kwargs.get('application_package_references', None)
        self.authentication_token_settings = kwargs.get('authentication_token_settings', None)


class TaskAddResult(Model):
    """Result for a single task added as part of an add task collection operation.

    All required parameters must be populated in order to send to Azure.

    :param status: Required. The status of the add task request. Possible
     values include: 'success', 'clientError', 'serverError'
    :type status: str or ~azure.batch.models.TaskAddStatus
    :param task_id: Required. The ID of the task for which this is the result.
    :type task_id: str
    :param e_tag: The ETag of the task, if the task was successfully added.
     You can use this to detect whether the task has changed between requests.
     In particular, you can be pass the ETag with an Update Task request to
     specify that your changes should take effect only if nobody else has
     modified the job in the meantime.
    :type e_tag: str
    :param last_modified: The last modified time of the task.
    :type last_modified: datetime
    :param location: The URL of the task, if the task was successfully added.
    :type location: str
    :param error: The error encountered while attempting to add the task.
    :type error: ~azure.batch.models.BatchError
    """

    _validation = {
        'status': {'required': True},
        'task_id': {'required': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'TaskAddStatus'},
        'task_id': {'key': 'taskId', 'type': 'str'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'last_modified': {'key': 'lastModified', 'type': 'iso-8601'},
        'location': {'key': 'location', 'type': 'str'},
        'error': {'key': 'error', 'type': 'BatchError'},
    }

    def __init__(self, **kwargs):
        super(TaskAddResult, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.task_id = kwargs.get('task_id', None)
        self.e_tag = kwargs.get('e_tag', None)
        self.last_modified = kwargs.get('last_modified', None)
        self.location = kwargs.get('location', None)
        self.error = kwargs.get('error', None)


class TaskConstraints(Model):
    """Execution constraints to apply to a task.

    :param max_wall_clock_time: The maximum elapsed time that the task may
     run, measured from the time the task starts. If the task does not complete
     within the time limit, the Batch service terminates it. If this is not
     specified, there is no time limit on how long the task may run.
    :type max_wall_clock_time: timedelta
    :param retention_time: The minimum time to retain the task directory on
     the compute node where it ran, from the time it completes execution. After
     this time, the Batch service may delete the task directory and all its
     contents. The default is 7 days, i.e. the task directory will be retained
     for 7 days unless the compute node is removed or the job is deleted.
    :type retention_time: timedelta
    :param max_task_retry_count: The maximum number of times the task may be
     retried. The Batch service retries a task if its exit code is nonzero.
     Note that this value specifically controls the number of retries for the
     task executable due to a nonzero exit code. The Batch service will try the
     task once, and may then retry up to this limit. For example, if the
     maximum retry count is 3, Batch tries the task up to 4 times (one initial
     try and 3 retries). If the maximum retry count is 0, the Batch service
     does not retry the task after the first attempt. If the maximum retry
     count is -1, the Batch service retries the task without limit.
    :type max_task_retry_count: int
    """

    _attribute_map = {
        'max_wall_clock_time': {'key': 'maxWallClockTime', 'type': 'duration'},
        'retention_time': {'key': 'retentionTime', 'type': 'duration'},
        'max_task_retry_count': {'key': 'maxTaskRetryCount', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(TaskConstraints, self).__init__(**kwargs)
        self.max_wall_clock_time = kwargs.get('max_wall_clock_time', None)
        self.retention_time = kwargs.get('retention_time', None)
        self.max_task_retry_count = kwargs.get('max_task_retry_count', None)


class TaskContainerExecutionInformation(Model):
    """Contains information about the container which a task is executing.

    :param container_id: The ID of the container.
    :type container_id: str
    :param state: The state of the container. This is the state of the
     container according to the Docker service. It is equivalent to the status
     field returned by "docker inspect".
    :type state: str
    :param error: Detailed error information about the container. This is the
     detailed error string from the Docker service, if available. It is
     equivalent to the error field returned by "docker inspect".
    :type error: str
    """

    _attribute_map = {
        'container_id': {'key': 'containerId', 'type': 'str'},
        'state': {'key': 'state', 'type': 'str'},
        'error': {'key': 'error', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(TaskContainerExecutionInformation, self).__init__(**kwargs)
        self.container_id = kwargs.get('container_id', None)
        self.state = kwargs.get('state', None)
        self.error = kwargs.get('error', None)


class TaskContainerSettings(Model):
    """The container settings for a task.

    All required parameters must be populated in order to send to Azure.

    :param container_run_options: Additional options to the container create
     command. These additional options are supplied as arguments to the "docker
     create" command, in addition to those controlled by the Batch Service.
    :type container_run_options: str
    :param image_name: Required. The image to use to create the container in
     which the task will run. This is the full image reference, as would be
     specified to "docker pull". If no tag is provided as part of the image
     name, the tag ":latest" is used as a default.
    :type image_name: str
    :param registry: The private registry which contains the container image.
     This setting can be omitted if was already provided at pool creation.
    :type registry: ~azure.batch.models.ContainerRegistry
    """

    _validation = {
        'image_name': {'required': True},
    }

    _attribute_map = {
        'container_run_options': {'key': 'containerRunOptions', 'type': 'str'},
        'image_name': {'key': 'imageName', 'type': 'str'},
        'registry': {'key': 'registry', 'type': 'ContainerRegistry'},
    }

    def __init__(self, **kwargs):
        super(TaskContainerSettings, self).__init__(**kwargs)
        self.container_run_options = kwargs.get('container_run_options', None)
        self.image_name = kwargs.get('image_name', None)
        self.registry = kwargs.get('registry', None)


class TaskCounts(Model):
    """The task counts for a job.

    All required parameters must be populated in order to send to Azure.

    :param active: Required. The number of tasks in the active state.
    :type active: int
    :param running: Required. The number of tasks in the running or preparing
     state.
    :type running: int
    :param completed: Required. The number of tasks in the completed state.
    :type completed: int
    :param succeeded: Required. The number of tasks which succeeded. A task
     succeeds if its result (found in the executionInfo property) is 'success'.
    :type succeeded: int
    :param failed: Required. The number of tasks which failed. A task fails if
     its result (found in the executionInfo property) is 'failure'.
    :type failed: int
    """

    _validation = {
        'active': {'required': True},
        'running': {'required': True},
        'completed': {'required': True},
        'succeeded': {'required': True},
        'failed': {'required': True},
    }

    _attribute_map = {
        'active': {'key': 'active', 'type': 'int'},
        'running': {'key': 'running', 'type': 'int'},
        'completed': {'key': 'completed', 'type': 'int'},
        'succeeded': {'key': 'succeeded', 'type': 'int'},
        'failed': {'key': 'failed', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(TaskCounts, self).__init__(**kwargs)
        self.active = kwargs.get('active', None)
        self.running = kwargs.get('running', None)
        self.completed = kwargs.get('completed', None)
        self.succeeded = kwargs.get('succeeded', None)
        self.failed = kwargs.get('failed', None)


class TaskDeleteOptions(Model):
    """Additional parameters for delete operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    :param if_match: An ETag value associated with the version of the resource
     known to the client. The operation will be performed only if the
     resource's current ETag on the service exactly matches the value specified
     by the client.
    :type if_match: str
    :param if_none_match: An ETag value associated with the version of the
     resource known to the client. The operation will be performed only if the
     resource's current ETag on the service does not match the value specified
     by the client.
    :type if_none_match: str
    :param if_modified_since: A timestamp indicating the last modified time of
     the resource known to the client. The operation will be performed only if
     the resource on the service has been modified since the specified time.
    :type if_modified_since: datetime
    :param if_unmodified_since: A timestamp indicating the last modified time
     of the resource known to the client. The operation will be performed only
     if the resource on the service has not been modified since the specified
     time.
    :type if_unmodified_since: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
        'if_match': {'key': '', 'type': 'str'},
        'if_none_match': {'key': '', 'type': 'str'},
        'if_modified_since': {'key': '', 'type': 'rfc-1123'},
        'if_unmodified_since': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(TaskDeleteOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)
        self.if_match = kwargs.get('if_match', None)
        self.if_none_match = kwargs.get('if_none_match', None)
        self.if_modified_since = kwargs.get('if_modified_since', None)
        self.if_unmodified_since = kwargs.get('if_unmodified_since', None)


class TaskDependencies(Model):
    """Specifies any dependencies of a task. Any task that is explicitly specified
    or within a dependency range must complete before the dependant task will
    be scheduled.

    :param task_ids: The list of task IDs that this task depends on. All tasks
     in this list must complete successfully before the dependent task can be
     scheduled. The taskIds collection is limited to 64000 characters total
     (i.e. the combined length of all task IDs). If the taskIds collection
     exceeds the maximum length, the Add Task request fails with error code
     TaskDependencyListTooLong. In this case consider using task ID ranges
     instead.
    :type task_ids: list[str]
    :param task_id_ranges: The list of task ID ranges that this task depends
     on. All tasks in all ranges must complete successfully before the
     dependent task can be scheduled.
    :type task_id_ranges: list[~azure.batch.models.TaskIdRange]
    """

    _attribute_map = {
        'task_ids': {'key': 'taskIds', 'type': '[str]'},
        'task_id_ranges': {'key': 'taskIdRanges', 'type': '[TaskIdRange]'},
    }

    def __init__(self, **kwargs):
        super(TaskDependencies, self).__init__(**kwargs)
        self.task_ids = kwargs.get('task_ids', None)
        self.task_id_ranges = kwargs.get('task_id_ranges', None)


class TaskExecutionInformation(Model):
    """Information about the execution of a task.

    All required parameters must be populated in order to send to Azure.

    :param start_time: The time at which the task started running. 'Running'
     corresponds to the running state, so if the task specifies resource files
     or application packages, then the start time reflects the time at which
     the task started downloading or deploying these. If the task has been
     restarted or retried, this is the most recent time at which the task
     started running. This property is present only for tasks that are in the
     running or completed state.
    :type start_time: datetime
    :param end_time: The time at which the task completed. This property is
     set only if the task is in the Completed state.
    :type end_time: datetime
    :param exit_code: The exit code of the program specified on the task
     command line. This property is set only if the task is in the completed
     state. In general, the exit code for a process reflects the specific
     convention implemented by the application developer for that process. If
     you use the exit code value to make decisions in your code, be sure that
     you know the exit code convention used by the application process.
     However, if the Batch service terminates the task (due to timeout, or user
     termination via the API) you may see an operating system-defined exit
     code.
    :type exit_code: int
    :param container_info: Information about the container under which the
     task is executing. This property is set only if the task runs in a
     container context.
    :type container_info:
     ~azure.batch.models.TaskContainerExecutionInformation
    :param failure_info: Information describing the task failure, if any. This
     property is set only if the task is in the completed state and encountered
     a failure.
    :type failure_info: ~azure.batch.models.TaskFailureInformation
    :param retry_count: Required. The number of times the task has been
     retried by the Batch service. Task application failures (non-zero exit
     code) are retried, pre-processing errors (the task could not be run) and
     file upload errors are not retried. The Batch service will retry the task
     up to the limit specified by the constraints.
    :type retry_count: int
    :param last_retry_time: The most recent time at which a retry of the task
     started running. This element is present only if the task was retried
     (i.e. retryCount is nonzero). If present, this is typically the same as
     startTime, but may be different if the task has been restarted for reasons
     other than retry; for example, if the compute node was rebooted during a
     retry, then the startTime is updated but the lastRetryTime is not.
    :type last_retry_time: datetime
    :param requeue_count: Required. The number of times the task has been
     requeued by the Batch service as the result of a user request. When the
     user removes nodes from a pool (by resizing/shrinking the pool) or when
     the job is being disabled, the user can specify that running tasks on the
     nodes be requeued for execution. This count tracks how many times the task
     has been requeued for these reasons.
    :type requeue_count: int
    :param last_requeue_time: The most recent time at which the task has been
     requeued by the Batch service as the result of a user request. This
     property is set only if the requeueCount is nonzero.
    :type last_requeue_time: datetime
    :param result: The result of the task execution. If the value is 'failed',
     then the details of the failure can be found in the failureInfo property.
     Possible values include: 'success', 'failure'
    :type result: str or ~azure.batch.models.TaskExecutionResult
    """

    _validation = {
        'retry_count': {'required': True},
        'requeue_count': {'required': True},
    }

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
        'exit_code': {'key': 'exitCode', 'type': 'int'},
        'container_info': {'key': 'containerInfo', 'type': 'TaskContainerExecutionInformation'},
        'failure_info': {'key': 'failureInfo', 'type': 'TaskFailureInformation'},
        'retry_count': {'key': 'retryCount', 'type': 'int'},
        'last_retry_time': {'key': 'lastRetryTime', 'type': 'iso-8601'},
        'requeue_count': {'key': 'requeueCount', 'type': 'int'},
        'last_requeue_time': {'key': 'lastRequeueTime', 'type': 'iso-8601'},
        'result': {'key': 'result', 'type': 'TaskExecutionResult'},
    }

    def __init__(self, **kwargs):
        super(TaskExecutionInformation, self).__init__(**kwargs)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)
        self.exit_code = kwargs.get('exit_code', None)
        self.container_info = kwargs.get('container_info', None)
        self.failure_info = kwargs.get('failure_info', None)
        self.retry_count = kwargs.get('retry_count', None)
        self.last_retry_time = kwargs.get('last_retry_time', None)
        self.requeue_count = kwargs.get('requeue_count', None)
        self.last_requeue_time = kwargs.get('last_requeue_time', None)
        self.result = kwargs.get('result', None)


class TaskFailureInformation(Model):
    """Information about a task failure.

    All required parameters must be populated in order to send to Azure.

    :param category: Required. The category of the task error. Possible values
     include: 'userError', 'serverError'
    :type category: str or ~azure.batch.models.ErrorCategory
    :param code: An identifier for the task error. Codes are invariant and are
     intended to be consumed programmatically.
    :type code: str
    :param message: A message describing the task error, intended to be
     suitable for display in a user interface.
    :type message: str
    :param details: A list of additional details related to the error.
    :type details: list[~azure.batch.models.NameValuePair]
    """

    _validation = {
        'category': {'required': True},
    }

    _attribute_map = {
        'category': {'key': 'category', 'type': 'ErrorCategory'},
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[NameValuePair]'},
    }

    def __init__(self, **kwargs):
        super(TaskFailureInformation, self).__init__(**kwargs)
        self.category = kwargs.get('category', None)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)
        self.details = kwargs.get('details', None)


class TaskGetOptions(Model):
    """Additional parameters for get operation.

    :param select: An OData $select clause.
    :type select: str
    :param expand: An OData $expand clause.
    :type expand: str
    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    :param if_match: An ETag value associated with the version of the resource
     known to the client. The operation will be performed only if the
     resource's current ETag on the service exactly matches the value specified
     by the client.
    :type if_match: str
    :param if_none_match: An ETag value associated with the version of the
     resource known to the client. The operation will be performed only if the
     resource's current ETag on the service does not match the value specified
     by the client.
    :type if_none_match: str
    :param if_modified_since: A timestamp indicating the last modified time of
     the resource known to the client. The operation will be performed only if
     the resource on the service has been modified since the specified time.
    :type if_modified_since: datetime
    :param if_unmodified_since: A timestamp indicating the last modified time
     of the resource known to the client. The operation will be performed only
     if the resource on the service has not been modified since the specified
     time.
    :type if_unmodified_since: datetime
    """

    _attribute_map = {
        'select': {'key': '', 'type': 'str'},
        'expand': {'key': '', 'type': 'str'},
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
        'if_match': {'key': '', 'type': 'str'},
        'if_none_match': {'key': '', 'type': 'str'},
        'if_modified_since': {'key': '', 'type': 'rfc-1123'},
        'if_unmodified_since': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(TaskGetOptions, self).__init__(**kwargs)
        self.select = kwargs.get('select', None)
        self.expand = kwargs.get('expand', None)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)
        self.if_match = kwargs.get('if_match', None)
        self.if_none_match = kwargs.get('if_none_match', None)
        self.if_modified_since = kwargs.get('if_modified_since', None)
        self.if_unmodified_since = kwargs.get('if_unmodified_since', None)


class TaskIdRange(Model):
    """A range of task IDs that a task can depend on. All tasks with IDs in the
    range must complete successfully before the dependent task can be
    scheduled.

    The start and end of the range are inclusive. For example, if a range has
    start 9 and end 12, then it represents tasks '9', '10', '11' and '12'.

    All required parameters must be populated in order to send to Azure.

    :param start: Required. The first task ID in the range.
    :type start: int
    :param end: Required. The last task ID in the range.
    :type end: int
    """

    _validation = {
        'start': {'required': True},
        'end': {'required': True},
    }

    _attribute_map = {
        'start': {'key': 'start', 'type': 'int'},
        'end': {'key': 'end', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(TaskIdRange, self).__init__(**kwargs)
        self.start = kwargs.get('start', None)
        self.end = kwargs.get('end', None)


class TaskInformation(Model):
    """Information about a task running on a compute node.

    All required parameters must be populated in order to send to Azure.

    :param task_url: The URL of the task.
    :type task_url: str
    :param job_id: The ID of the job to which the task belongs.
    :type job_id: str
    :param task_id: The ID of the task.
    :type task_id: str
    :param subtask_id: The ID of the subtask if the task is a multi-instance
     task.
    :type subtask_id: int
    :param task_state: Required. The current state of the task. Possible
     values include: 'active', 'preparing', 'running', 'completed'
    :type task_state: str or ~azure.batch.models.TaskState
    :param execution_info: Information about the execution of the task.
    :type execution_info: ~azure.batch.models.TaskExecutionInformation
    """

    _validation = {
        'task_state': {'required': True},
    }

    _attribute_map = {
        'task_url': {'key': 'taskUrl', 'type': 'str'},
        'job_id': {'key': 'jobId', 'type': 'str'},
        'task_id': {'key': 'taskId', 'type': 'str'},
        'subtask_id': {'key': 'subtaskId', 'type': 'int'},
        'task_state': {'key': 'taskState', 'type': 'TaskState'},
        'execution_info': {'key': 'executionInfo', 'type': 'TaskExecutionInformation'},
    }

    def __init__(self, **kwargs):
        super(TaskInformation, self).__init__(**kwargs)
        self.task_url = kwargs.get('task_url', None)
        self.job_id = kwargs.get('job_id', None)
        self.task_id = kwargs.get('task_id', None)
        self.subtask_id = kwargs.get('subtask_id', None)
        self.task_state = kwargs.get('task_state', None)
        self.execution_info = kwargs.get('execution_info', None)


class TaskListOptions(Model):
    """Additional parameters for list operation.

    :param filter: An OData $filter clause. For more information on
     constructing this filter, see
     https://docs.microsoft.com/en-us/rest/api/batchservice/odata-filters-in-batch#list-tasks.
    :type filter: str
    :param select: An OData $select clause.
    :type select: str
    :param expand: An OData $expand clause.
    :type expand: str
    :param max_results: The maximum number of items to return in the response.
     A maximum of 1000 tasks can be returned. Default value: 1000 .
    :type max_results: int
    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    """

    _attribute_map = {
        'filter': {'key': '', 'type': 'str'},
        'select': {'key': '', 'type': 'str'},
        'expand': {'key': '', 'type': 'str'},
        'max_results': {'key': '', 'type': 'int'},
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(TaskListOptions, self).__init__(**kwargs)
        self.filter = kwargs.get('filter', None)
        self.select = kwargs.get('select', None)
        self.expand = kwargs.get('expand', None)
        self.max_results = kwargs.get('max_results', 1000)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)


class TaskListSubtasksOptions(Model):
    """Additional parameters for list_subtasks operation.

    :param select: An OData $select clause.
    :type select: str
    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    """

    _attribute_map = {
        'select': {'key': '', 'type': 'str'},
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(TaskListSubtasksOptions, self).__init__(**kwargs)
        self.select = kwargs.get('select', None)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)


class TaskReactivateOptions(Model):
    """Additional parameters for reactivate operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    :param if_match: An ETag value associated with the version of the resource
     known to the client. The operation will be performed only if the
     resource's current ETag on the service exactly matches the value specified
     by the client.
    :type if_match: str
    :param if_none_match: An ETag value associated with the version of the
     resource known to the client. The operation will be performed only if the
     resource's current ETag on the service does not match the value specified
     by the client.
    :type if_none_match: str
    :param if_modified_since: A timestamp indicating the last modified time of
     the resource known to the client. The operation will be performed only if
     the resource on the service has been modified since the specified time.
    :type if_modified_since: datetime
    :param if_unmodified_since: A timestamp indicating the last modified time
     of the resource known to the client. The operation will be performed only
     if the resource on the service has not been modified since the specified
     time.
    :type if_unmodified_since: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
        'if_match': {'key': '', 'type': 'str'},
        'if_none_match': {'key': '', 'type': 'str'},
        'if_modified_since': {'key': '', 'type': 'rfc-1123'},
        'if_unmodified_since': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(TaskReactivateOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)
        self.if_match = kwargs.get('if_match', None)
        self.if_none_match = kwargs.get('if_none_match', None)
        self.if_modified_since = kwargs.get('if_modified_since', None)
        self.if_unmodified_since = kwargs.get('if_unmodified_since', None)


class TaskSchedulingPolicy(Model):
    """Specifies how tasks should be distributed across compute nodes.

    All required parameters must be populated in order to send to Azure.

    :param node_fill_type: Required. How tasks are distributed across compute
     nodes in a pool. Possible values include: 'spread', 'pack'
    :type node_fill_type: str or ~azure.batch.models.ComputeNodeFillType
    """

    _validation = {
        'node_fill_type': {'required': True},
    }

    _attribute_map = {
        'node_fill_type': {'key': 'nodeFillType', 'type': 'ComputeNodeFillType'},
    }

    def __init__(self, **kwargs):
        super(TaskSchedulingPolicy, self).__init__(**kwargs)
        self.node_fill_type = kwargs.get('node_fill_type', None)


class TaskStatistics(Model):
    """Resource usage statistics for a task.

    All required parameters must be populated in order to send to Azure.

    :param url: Required. The URL of the statistics.
    :type url: str
    :param start_time: Required. The start time of the time range covered by
     the statistics.
    :type start_time: datetime
    :param last_update_time: Required. The time at which the statistics were
     last updated. All statistics are limited to the range between startTime
     and lastUpdateTime.
    :type last_update_time: datetime
    :param user_cpu_time: Required. The total user mode CPU time (summed
     across all cores and all compute nodes) consumed by the task.
    :type user_cpu_time: timedelta
    :param kernel_cpu_time: Required. The total kernel mode CPU time (summed
     across all cores and all compute nodes) consumed by the task.
    :type kernel_cpu_time: timedelta
    :param wall_clock_time: Required. The total wall clock time of the task.
     The wall clock time is the elapsed time from when the task started running
     on a compute node to when it finished (or to the last time the statistics
     were updated, if the task had not finished by then). If the task was
     retried, this includes the wall clock time of all the task retries.
    :type wall_clock_time: timedelta
    :param read_iops: Required. The total number of disk read operations made
     by the task.
    :type read_iops: long
    :param write_iops: Required. The total number of disk write operations
     made by the task.
    :type write_iops: long
    :param read_io_gi_b: Required. The total gibibytes read from disk by the
     task.
    :type read_io_gi_b: float
    :param write_io_gi_b: Required. The total gibibytes written to disk by the
     task.
    :type write_io_gi_b: float
    :param wait_time: Required. The total wait time of the task. The wait time
     for a task is defined as the elapsed time between the creation of the task
     and the start of task execution. (If the task is retried due to failures,
     the wait time is the time to the most recent task execution.).
    :type wait_time: timedelta
    """

    _validation = {
        'url': {'required': True},
        'start_time': {'required': True},
        'last_update_time': {'required': True},
        'user_cpu_time': {'required': True},
        'kernel_cpu_time': {'required': True},
        'wall_clock_time': {'required': True},
        'read_iops': {'required': True},
        'write_iops': {'required': True},
        'read_io_gi_b': {'required': True},
        'write_io_gi_b': {'required': True},
        'wait_time': {'required': True},
    }

    _attribute_map = {
        'url': {'key': 'url', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'last_update_time': {'key': 'lastUpdateTime', 'type': 'iso-8601'},
        'user_cpu_time': {'key': 'userCPUTime', 'type': 'duration'},
        'kernel_cpu_time': {'key': 'kernelCPUTime', 'type': 'duration'},
        'wall_clock_time': {'key': 'wallClockTime', 'type': 'duration'},
        'read_iops': {'key': 'readIOps', 'type': 'long'},
        'write_iops': {'key': 'writeIOps', 'type': 'long'},
        'read_io_gi_b': {'key': 'readIOGiB', 'type': 'float'},
        'write_io_gi_b': {'key': 'writeIOGiB', 'type': 'float'},
        'wait_time': {'key': 'waitTime', 'type': 'duration'},
    }

    def __init__(self, **kwargs):
        super(TaskStatistics, self).__init__(**kwargs)
        self.url = kwargs.get('url', None)
        self.start_time = kwargs.get('start_time', None)
        self.last_update_time = kwargs.get('last_update_time', None)
        self.user_cpu_time = kwargs.get('user_cpu_time', None)
        self.kernel_cpu_time = kwargs.get('kernel_cpu_time', None)
        self.wall_clock_time = kwargs.get('wall_clock_time', None)
        self.read_iops = kwargs.get('read_iops', None)
        self.write_iops = kwargs.get('write_iops', None)
        self.read_io_gi_b = kwargs.get('read_io_gi_b', None)
        self.write_io_gi_b = kwargs.get('write_io_gi_b', None)
        self.wait_time = kwargs.get('wait_time', None)


class TaskTerminateOptions(Model):
    """Additional parameters for terminate operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    :param if_match: An ETag value associated with the version of the resource
     known to the client. The operation will be performed only if the
     resource's current ETag on the service exactly matches the value specified
     by the client.
    :type if_match: str
    :param if_none_match: An ETag value associated with the version of the
     resource known to the client. The operation will be performed only if the
     resource's current ETag on the service does not match the value specified
     by the client.
    :type if_none_match: str
    :param if_modified_since: A timestamp indicating the last modified time of
     the resource known to the client. The operation will be performed only if
     the resource on the service has been modified since the specified time.
    :type if_modified_since: datetime
    :param if_unmodified_since: A timestamp indicating the last modified time
     of the resource known to the client. The operation will be performed only
     if the resource on the service has not been modified since the specified
     time.
    :type if_unmodified_since: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
        'if_match': {'key': '', 'type': 'str'},
        'if_none_match': {'key': '', 'type': 'str'},
        'if_modified_since': {'key': '', 'type': 'rfc-1123'},
        'if_unmodified_since': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(TaskTerminateOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)
        self.if_match = kwargs.get('if_match', None)
        self.if_none_match = kwargs.get('if_none_match', None)
        self.if_modified_since = kwargs.get('if_modified_since', None)
        self.if_unmodified_since = kwargs.get('if_unmodified_since', None)


class TaskUpdateOptions(Model):
    """Additional parameters for update operation.

    :param timeout: The maximum time that the server can spend processing the
     request, in seconds. The default is 30 seconds. Default value: 30 .
    :type timeout: int
    :param client_request_id: The caller-generated request identity, in the
     form of a GUID with no decoration such as curly braces, e.g.
     9C4D50EE-2D56-4CD3-8152-34347DC9F2B0.
    :type client_request_id: str
    :param return_client_request_id: Whether the server should return the
     client-request-id in the response. Default value: False .
    :type return_client_request_id: bool
    :param ocp_date: The time the request was issued. Client libraries
     typically set this to the current system clock time; set it explicitly if
     you are calling the REST API directly.
    :type ocp_date: datetime
    :param if_match: An ETag value associated with the version of the resource
     known to the client. The operation will be performed only if the
     resource's current ETag on the service exactly matches the value specified
     by the client.
    :type if_match: str
    :param if_none_match: An ETag value associated with the version of the
     resource known to the client. The operation will be performed only if the
     resource's current ETag on the service does not match the value specified
     by the client.
    :type if_none_match: str
    :param if_modified_since: A timestamp indicating the last modified time of
     the resource known to the client. The operation will be performed only if
     the resource on the service has been modified since the specified time.
    :type if_modified_since: datetime
    :param if_unmodified_since: A timestamp indicating the last modified time
     of the resource known to the client. The operation will be performed only
     if the resource on the service has not been modified since the specified
     time.
    :type if_unmodified_since: datetime
    """

    _attribute_map = {
        'timeout': {'key': '', 'type': 'int'},
        'client_request_id': {'key': '', 'type': 'str'},
        'return_client_request_id': {'key': '', 'type': 'bool'},
        'ocp_date': {'key': '', 'type': 'rfc-1123'},
        'if_match': {'key': '', 'type': 'str'},
        'if_none_match': {'key': '', 'type': 'str'},
        'if_modified_since': {'key': '', 'type': 'rfc-1123'},
        'if_unmodified_since': {'key': '', 'type': 'rfc-1123'},
    }

    def __init__(self, **kwargs):
        super(TaskUpdateOptions, self).__init__(**kwargs)
        self.timeout = kwargs.get('timeout', 30)
        self.client_request_id = kwargs.get('client_request_id', None)
        self.return_client_request_id = kwargs.get('return_client_request_id', False)
        self.ocp_date = kwargs.get('ocp_date', None)
        self.if_match = kwargs.get('if_match', None)
        self.if_none_match = kwargs.get('if_none_match', None)
        self.if_modified_since = kwargs.get('if_modified_since', None)
        self.if_unmodified_since = kwargs.get('if_unmodified_since', None)


class TaskUpdateParameter(Model):
    """The set of changes to be made to a task.

    :param constraints: Constraints that apply to this task. If omitted, the
     task is given the default constraints. For multi-instance tasks, updating
     the retention time applies only to the primary task and not subtasks.
    :type constraints: ~azure.batch.models.TaskConstraints
    """

    _attribute_map = {
        'constraints': {'key': 'constraints', 'type': 'TaskConstraints'},
    }

    def __init__(self, **kwargs):
        super(TaskUpdateParameter, self).__init__(**kwargs)
        self.constraints = kwargs.get('constraints', None)


class UploadBatchServiceLogsConfiguration(Model):
    """The Azure Batch service log files upload configuration for a compute node.

    All required parameters must be populated in order to send to Azure.

    :param container_url: Required. The URL of the container within Azure Blob
     Storage to which to upload the Batch Service log file(s). The URL must
     include a Shared Access Signature (SAS) granting write permissions to the
     container. The SAS duration must allow enough time for the upload to
     finish. The start time for SAS is optional and recommended to not be
     specified.
    :type container_url: str
    :param start_time: Required. The start of the time range from which to
     upload Batch Service log file(s). Any log file containing a log message in
     the time range will be uploaded. This means that the operation might
     retrieve more logs than have been requested since the entire log file is
     always uploaded, but the operation should not retrieve fewer logs than
     have been requested.
    :type start_time: datetime
    :param end_time: The end of the time range from which to upload Batch
     Service log file(s). Any log file containing a log message in the time
     range will be uploaded. This means that the operation might retrieve more
     logs than have been requested since the entire log file is always
     uploaded, but the operation should not retrieve fewer logs than have been
     requested. If omitted, the default is to upload all logs available after
     the startTime.
    :type end_time: datetime
    """

    _validation = {
        'container_url': {'required': True},
        'start_time': {'required': True},
    }

    _attribute_map = {
        'container_url': {'key': 'containerUrl', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(UploadBatchServiceLogsConfiguration, self).__init__(**kwargs)
        self.container_url = kwargs.get('container_url', None)
        self.start_time = kwargs.get('start_time', None)
        self.end_time = kwargs.get('end_time', None)


class UploadBatchServiceLogsResult(Model):
    """The result of uploading Batch service log files from a specific compute
    node.

    All required parameters must be populated in order to send to Azure.

    :param virtual_directory_name: Required. The virtual directory within
     Azure Blob Storage container to which the Batch Service log file(s) will
     be uploaded. The virtual directory name is part of the blob name for each
     log file uploaded, and it is built based poolId, nodeId and a unique
     identifier.
    :type virtual_directory_name: str
    :param number_of_files_uploaded: Required. The number of log files which
     will be uploaded.
    :type number_of_files_uploaded: int
    """

    _validation = {
        'virtual_directory_name': {'required': True},
        'number_of_files_uploaded': {'required': True},
    }

    _attribute_map = {
        'virtual_directory_name': {'key': 'virtualDirectoryName', 'type': 'str'},
        'number_of_files_uploaded': {'key': 'numberOfFilesUploaded', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(UploadBatchServiceLogsResult, self).__init__(**kwargs)
        self.virtual_directory_name = kwargs.get('virtual_directory_name', None)
        self.number_of_files_uploaded = kwargs.get('number_of_files_uploaded', None)


class UsageStatistics(Model):
    """Statistics related to pool usage information.

    All required parameters must be populated in order to send to Azure.

    :param start_time: Required. The start time of the time range covered by
     the statistics.
    :type start_time: datetime
    :param last_update_time: Required. The time at which the statistics were
     last updated. All statistics are limited to the range between startTime
     and lastUpdateTime.
    :type last_update_time: datetime
    :param dedicated_core_time: Required. The aggregated wall-clock time of
     the dedicated compute node cores being part of the pool.
    :type dedicated_core_time: timedelta
    """

    _validation = {
        'start_time': {'required': True},
        'last_update_time': {'required': True},
        'dedicated_core_time': {'required': True},
    }

    _attribute_map = {
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'last_update_time': {'key': 'lastUpdateTime', 'type': 'iso-8601'},
        'dedicated_core_time': {'key': 'dedicatedCoreTime', 'type': 'duration'},
    }

    def __init__(self, **kwargs):
        super(UsageStatistics, self).__init__(**kwargs)
        self.start_time = kwargs.get('start_time', None)
        self.last_update_time = kwargs.get('last_update_time', None)
        self.dedicated_core_time = kwargs.get('dedicated_core_time', None)


class UserAccount(Model):
    """Properties used to create a user used to execute tasks on an Azure Batch
    node.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the user account.
    :type name: str
    :param password: Required. The password for the user account.
    :type password: str
    :param elevation_level: The elevation level of the user account. The
     default value is nonAdmin. Possible values include: 'nonAdmin', 'admin'
    :type elevation_level: str or ~azure.batch.models.ElevationLevel
    :param linux_user_configuration: The Linux-specific user configuration for
     the user account. This property is ignored if specified on a Windows pool.
     If not specified, the user is created with the default options.
    :type linux_user_configuration: ~azure.batch.models.LinuxUserConfiguration
    :param windows_user_configuration: The Windows-specific user configuration
     for the user account. This property can only be specified if the user is
     on a Windows pool. If not specified and on a Windows pool, the user is
     created with the default options.
    :type windows_user_configuration:
     ~azure.batch.models.WindowsUserConfiguration
    """

    _validation = {
        'name': {'required': True},
        'password': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'elevation_level': {'key': 'elevationLevel', 'type': 'ElevationLevel'},
        'linux_user_configuration': {'key': 'linuxUserConfiguration', 'type': 'LinuxUserConfiguration'},
        'windows_user_configuration': {'key': 'windowsUserConfiguration', 'type': 'WindowsUserConfiguration'},
    }

    def __init__(self, **kwargs):
        super(UserAccount, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.password = kwargs.get('password', None)
        self.elevation_level = kwargs.get('elevation_level', None)
        self.linux_user_configuration = kwargs.get('linux_user_configuration', None)
        self.windows_user_configuration = kwargs.get('windows_user_configuration', None)


class UserIdentity(Model):
    """The definition of the user identity under which the task is run.

    Specify either the userName or autoUser property, but not both.

    :param user_name: The name of the user identity under which the task is
     run. The userName and autoUser properties are mutually exclusive; you must
     specify one but not both.
    :type user_name: str
    :param auto_user: The auto user under which the task is run. The userName
     and autoUser properties are mutually exclusive; you must specify one but
     not both.
    :type auto_user: ~azure.batch.models.AutoUserSpecification
    """

    _attribute_map = {
        'user_name': {'key': 'username', 'type': 'str'},
        'auto_user': {'key': 'autoUser', 'type': 'AutoUserSpecification'},
    }

    def __init__(self, **kwargs):
        super(UserIdentity, self).__init__(**kwargs)
        self.user_name = kwargs.get('user_name', None)
        self.auto_user = kwargs.get('auto_user', None)


class VirtualMachineConfiguration(Model):
    """The configuration for compute nodes in a pool based on the Azure Virtual
    Machines infrastructure.

    All required parameters must be populated in order to send to Azure.

    :param image_reference: Required. A reference to the Azure Virtual
     Machines Marketplace image or the custom Virtual Machine image to use.
    :type image_reference: ~azure.batch.models.ImageReference
    :param node_agent_sku_id: Required. The SKU of the Batch node agent to be
     provisioned on compute nodes in the pool. The Batch node agent is a
     program that runs on each node in the pool, and provides the
     command-and-control interface between the node and the Batch service.
     There are different implementations of the node agent, known as SKUs, for
     different operating systems. You must specify a node agent SKU which
     matches the selected image reference. To get the list of supported node
     agent SKUs along with their list of verified image references, see the
     'List supported node agent SKUs' operation.
    :type node_agent_sku_id: str
    :param windows_configuration: Windows operating system settings on the
     virtual machine. This property must not be specified if the imageReference
     property specifies a Linux OS image.
    :type windows_configuration: ~azure.batch.models.WindowsConfiguration
    :param data_disks: The configuration for data disks attached to the
     comptue nodes in the pool. This property must be specified if the compute
     nodes in the pool need to have empty data disks attached to them. This
     cannot be updated. Each node gets its own disk (the disk is not a file
     share). Existing disks cannot be attached, each attached disk is empty.
     When the node is removed from the pool, the disk and all data associated
     with it is also deleted. The disk is not formatted after being attached,
     it must be formatted before use - for more information see
     https://docs.microsoft.com/en-us/azure/virtual-machines/linux/classic/attach-disk#initialize-a-new-data-disk-in-linux
     and
     https://docs.microsoft.com/en-us/azure/virtual-machines/windows/attach-disk-ps#add-an-empty-data-disk-to-a-virtual-machine.
    :type data_disks: list[~azure.batch.models.DataDisk]
    :param license_type: The type of on-premises license to be used when
     deploying the operating system. This only applies to images that contain
     the Windows operating system, and should only be used when you hold valid
     on-premises licenses for the nodes which will be deployed. If omitted, no
     on-premises licensing discount is applied. Values are:
     Windows_Server - The on-premises license is for Windows Server.
     Windows_Client - The on-premises license is for Windows Client.
    :type license_type: str
    :param container_configuration: The container configuration for the pool.
     If specified, setup is performed on each node in the pool to allow tasks
     to run in containers. All regular tasks and job manager tasks run on this
     pool must specify the containerSettings property, and all other tasks may
     specify it.
    :type container_configuration: ~azure.batch.models.ContainerConfiguration
    """

    _validation = {
        'image_reference': {'required': True},
        'node_agent_sku_id': {'required': True},
    }

    _attribute_map = {
        'image_reference': {'key': 'imageReference', 'type': 'ImageReference'},
        'node_agent_sku_id': {'key': 'nodeAgentSKUId', 'type': 'str'},
        'windows_configuration': {'key': 'windowsConfiguration', 'type': 'WindowsConfiguration'},
        'data_disks': {'key': 'dataDisks', 'type': '[DataDisk]'},
        'license_type': {'key': 'licenseType', 'type': 'str'},
        'container_configuration': {'key': 'containerConfiguration', 'type': 'ContainerConfiguration'},
    }

    def __init__(self, **kwargs):
        super(VirtualMachineConfiguration, self).__init__(**kwargs)
        self.image_reference = kwargs.get('image_reference', None)
        self.node_agent_sku_id = kwargs.get('node_agent_sku_id', None)
        self.windows_configuration = kwargs.get('windows_configuration', None)
        self.data_disks = kwargs.get('data_disks', None)
        self.license_type = kwargs.get('license_type', None)
        self.container_configuration = kwargs.get('container_configuration', None)


class WindowsConfiguration(Model):
    """Windows operating system settings to apply to the virtual machine.

    :param enable_automatic_updates: Whether automatic updates are enabled on
     the virtual machine. If omitted, the default value is true.
    :type enable_automatic_updates: bool
    """

    _attribute_map = {
        'enable_automatic_updates': {'key': 'enableAutomaticUpdates', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(WindowsConfiguration, self).__init__(**kwargs)
        self.enable_automatic_updates = kwargs.get('enable_automatic_updates', None)


class WindowsUserConfiguration(Model):
    """Properties used to create a user account on a Windows node.

    :param login_mode: The login mode for the user. The default value for
     VirtualMachineConfiguration pools is batch and for
     CloudServiceConfiguration pools is interactive. Possible values include:
     'batch', 'interactive'
    :type login_mode: str or ~azure.batch.models.LoginMode
    """

    _attribute_map = {
        'login_mode': {'key': 'loginMode', 'type': 'LoginMode'},
    }

    def __init__(self, **kwargs):
        super(WindowsUserConfiguration, self).__init__(**kwargs)
        self.login_mode = kwargs.get('login_mode', None)
