# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ApplicationInfoResponse(Model):
    """Response containing the Application Info.

    :param id: The ID (GUID) of the application.
    :type id: str
    :param name: The name of the application.
    :type name: str
    :param description: The description of the application.
    :type description: str
    :param culture: The culture of the application. For example, "en-us".
    :type culture: str
    :param usage_scenario: Defines the scenario for the new application.
     Optional. For example, IoT.
    :type usage_scenario: str
    :param domain: The domain for the new application. Optional. For example,
     Comics.
    :type domain: str
    :param versions_count: Amount of model versions within the application.
    :type versions_count: int
    :param created_date_time: The version's creation timestamp.
    :type created_date_time: str
    :param endpoints: The Runtime endpoint URL for this model version.
    :type endpoints: object
    :param endpoint_hits_count: Number of calls made to this endpoint.
    :type endpoint_hits_count: int
    :param active_version: The version ID currently marked as active.
    :type active_version: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'culture': {'key': 'culture', 'type': 'str'},
        'usage_scenario': {'key': 'usageScenario', 'type': 'str'},
        'domain': {'key': 'domain', 'type': 'str'},
        'versions_count': {'key': 'versionsCount', 'type': 'int'},
        'created_date_time': {'key': 'createdDateTime', 'type': 'str'},
        'endpoints': {'key': 'endpoints', 'type': 'object'},
        'endpoint_hits_count': {'key': 'endpointHitsCount', 'type': 'int'},
        'active_version': {'key': 'activeVersion', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, name: str=None, description: str=None, culture: str=None, usage_scenario: str=None, domain: str=None, versions_count: int=None, created_date_time: str=None, endpoints=None, endpoint_hits_count: int=None, active_version: str=None, **kwargs) -> None:
        super(ApplicationInfoResponse, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.description = description
        self.culture = culture
        self.usage_scenario = usage_scenario
        self.domain = domain
        self.versions_count = versions_count
        self.created_date_time = created_date_time
        self.endpoints = endpoints
        self.endpoint_hits_count = endpoint_hits_count
        self.active_version = active_version
