# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

try:
    from .image_object_py3 import ImageObject
    from .images_py3 import Images
    from .search_results_answer_py3 import SearchResultsAnswer
    from .query_py3 import Query
    from .answer_py3 import Answer
    from .media_object_py3 import MediaObject
    from .response_py3 import Response
    from .thing_py3 import Thing
    from .creative_work_py3 import CreativeWork
    from .identifiable_py3 import Identifiable
    from .error_py3 import Error
    from .error_response_py3 import ErrorResponse, ErrorResponseException
    from .web_page_py3 import WebPage
    from .response_base_py3 import ResponseBase
except (SyntaxError, ImportError):
    from .image_object import ImageObject
    from .images import Images
    from .search_results_answer import SearchResultsAnswer
    from .query import Query
    from .answer import Answer
    from .media_object import MediaObject
    from .response import Response
    from .thing import Thing
    from .creative_work import CreativeWork
    from .identifiable import Identifiable
    from .error import Error
    from .error_response import ErrorResponse, ErrorResponseException
    from .web_page import WebPage
    from .response_base import ResponseBase
from .custom_image_search_api_enums import (
    ErrorCode,
    ErrorSubCode,
    ImageAspect,
    ImageColor,
    Freshness,
    ImageContent,
    ImageType,
    ImageLicense,
    SafeSearch,
    ImageSize,
)

__all__ = [
    'ImageObject',
    'Images',
    'SearchResultsAnswer',
    'Query',
    'Answer',
    'MediaObject',
    'Response',
    'Thing',
    'CreativeWork',
    'Identifiable',
    'Error',
    'ErrorResponse', 'ErrorResponseException',
    'WebPage',
    'ResponseBase',
    'ErrorCode',
    'ErrorSubCode',
    'ImageAspect',
    'ImageColor',
    'Freshness',
    'ImageContent',
    'ImageType',
    'ImageLicense',
    'SafeSearch',
    'ImageSize',
]
