# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .search_results_answer import SearchResultsAnswer


class Images(SearchResultsAnswer):
    """Defines an image answer.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param _type: Required. Constant filled by server.
    :type _type: str
    :ivar id: A String identifier.
    :vartype id: str
    :ivar read_link: The URL that returns this resource.
    :vartype read_link: str
    :ivar web_search_url: The URL To Bing's search result for this item.
    :vartype web_search_url: str
    :ivar total_estimated_matches: The estimated number of webpages that are
     relevant to the query. Use this number along with the count and offset
     query parameters to page the results.
    :vartype total_estimated_matches: long
    :ivar next_offset: Used as part of deduping. Tells client the next offset
     that client should use in the next pagination request
    :vartype next_offset: int
    :param value: Required. A list of image objects that are relevant to the
     query. If there are no results, the List is empty.
    :type value:
     list[~azure.cognitiveservices.search.customimagesearch.models.ImageObject]
    """

    _validation = {
        '_type': {'required': True},
        'id': {'readonly': True},
        'read_link': {'readonly': True},
        'web_search_url': {'readonly': True},
        'total_estimated_matches': {'readonly': True},
        'next_offset': {'readonly': True},
        'value': {'required': True},
    }

    _attribute_map = {
        '_type': {'key': '_type', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'read_link': {'key': 'readLink', 'type': 'str'},
        'web_search_url': {'key': 'webSearchUrl', 'type': 'str'},
        'total_estimated_matches': {'key': 'totalEstimatedMatches', 'type': 'long'},
        'next_offset': {'key': 'nextOffset', 'type': 'int'},
        'value': {'key': 'value', 'type': '[ImageObject]'},
    }

    def __init__(self, **kwargs):
        super(Images, self).__init__(**kwargs)
        self.next_offset = None
        self.value = kwargs.get('value', None)
        self._type = 'Images'
