# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class DetectResult(Model):
    """Result of a DetectImage call.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar objects: An array of detected objects.
    :vartype objects:
     list[~azure.cognitiveservices.vision.computervision.models.DetectedObject]
    :param request_id: Id of the REST API request.
    :type request_id: str
    :param metadata:
    :type metadata:
     ~azure.cognitiveservices.vision.computervision.models.ImageMetadata
    """

    _validation = {
        'objects': {'readonly': True},
    }

    _attribute_map = {
        'objects': {'key': 'objects', 'type': '[DetectedObject]'},
        'request_id': {'key': 'requestId', 'type': 'str'},
        'metadata': {'key': 'metadata', 'type': 'ImageMetadata'},
    }

    def __init__(self, **kwargs):
        super(DetectResult, self).__init__(**kwargs)
        self.objects = None
        self.request_id = kwargs.get('request_id', None)
        self.metadata = kwargs.get('metadata', None)
