# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class DetectedBrand(Model):
    """A brand detected in an image.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: Label for the brand.
    :vartype name: str
    :ivar confidence: Confidence score of having observed the brand in the
     image, as a value ranging from 0 to 1.
    :vartype confidence: float
    :ivar rectangle: Approximate location of the detected brand.
    :vartype rectangle:
     ~azure.cognitiveservices.vision.computervision.models.BoundingRect
    """

    _validation = {
        'name': {'readonly': True},
        'confidence': {'readonly': True},
        'rectangle': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'confidence': {'key': 'confidence', 'type': 'float'},
        'rectangle': {'key': 'rectangle', 'type': 'BoundingRect'},
    }

    def __init__(self, **kwargs) -> None:
        super(DetectedBrand, self).__init__(**kwargs)
        self.name = None
        self.confidence = None
        self.rectangle = None
