# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class OperationStatus(Model):
    """Operation status object. Operation refers to the asynchronous backend task
    including taking a snapshot and applying a snapshot.

    All required parameters must be populated in order to send to Azure.

    :param status: Required. Operation status: notstarted, running, succeeded,
     failed. If the operation is requested and waiting to perform, the status
     is notstarted. If the operation is ongoing in backend, the status is
     running. Status succeeded means the operation is completed successfully,
     specifically for snapshot taking operation, it illustrates the snapshot is
     well taken and ready to apply, and for snapshot applying operation, it
     presents the target object has finished creating by the snapshot and ready
     to be used. Status failed is often caused by editing the source object
     while taking the snapshot or editing the target object while applying the
     snapshot before completion, see the field "message" to check the failure
     reason. Possible values include: 'notstarted', 'running', 'succeeded',
     'failed'
    :type status: str or
     ~azure.cognitiveservices.vision.face.models.OperationStatusType
    :param created_time: Required. A combined UTC date and time string that
     describes the time when the operation (take or apply a snapshot) is
     requested. E.g. 2018-12-25T11:41:02.2331413Z.
    :type created_time: datetime
    :param last_action_time: A combined UTC date and time string that
     describes the last time the operation (take or apply a snapshot) is
     actively migrating data. The lastActionTime will keep increasing until the
     operation finishes. E.g. 2018-12-25T11:51:27.8705696Z.
    :type last_action_time: datetime
    :param resource_location: When the operation succeeds successfully, for
     snapshot taking operation the snapshot id will be included in this field,
     and for snapshot applying operation, the path to get the target object
     will be returned in this field.
    :type resource_location: str
    :param message: Show failure message when operation fails (omitted when
     operation succeeds).
    :type message: str
    """

    _validation = {
        'status': {'required': True},
        'created_time': {'required': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'OperationStatusType'},
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'last_action_time': {'key': 'lastActionTime', 'type': 'iso-8601'},
        'resource_location': {'key': 'resourceLocation', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, *, status, created_time, last_action_time=None, resource_location: str=None, message: str=None, **kwargs) -> None:
        super(OperationStatus, self).__init__(**kwargs)
        self.status = status
        self.created_time = created_time
        self.last_action_time = last_action_time
        self.resource_location = resource_location
        self.message = message
