# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .tracked_resource import TrackedResource


class ArtifactSource(TrackedResource):
    """The resource that defines the source location where the artifacts are
    located.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives
    :type location: str
    :param source_type: Required. The type of artifact source used.
    :type source_type: str
    :param artifact_root: The path from the location that the 'authentication'
     property [say, a SAS URI to the blob container] refers to, to the location
     of the artifacts. This can be used to differentiate different versions of
     the artifacts. Or, different types of artifacts like binaries or
     templates. The location referenced by the authentication property
     concatenated with this optional artifactRoot path forms the artifact
     source location where the artifacts are expected to be found.
    :type artifact_root: str
    :param authentication: Required. The authentication method to use to
     access the artifact source.
    :type authentication: ~azure.mgmt.deploymentmanager.models.Authentication
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'source_type': {'required': True},
        'authentication': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'source_type': {'key': 'properties.sourceType', 'type': 'str'},
        'artifact_root': {'key': 'properties.artifactRoot', 'type': 'str'},
        'authentication': {'key': 'properties.authentication', 'type': 'Authentication'},
    }

    def __init__(self, **kwargs):
        super(ArtifactSource, self).__init__(**kwargs)
        self.source_type = kwargs.get('source_type', None)
        self.artifact_root = kwargs.get('artifact_root', None)
        self.authentication = kwargs.get('authentication', None)
