# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class RolloutPropertiesModel(Model):
    """Defines the properties of a rollout.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar status: The current status of the rollout.
    :vartype status: str
    :ivar total_retry_attempts: The cardinal count of total number of retries
     performed on the rollout at a given time.
    :vartype total_retry_attempts: int
    :ivar operation_info: Operational information of the rollout.
    :vartype operation_info:
     ~azure.mgmt.deploymentmanager.models.RolloutOperationInfo
    :ivar services: The detailed information on the services being deployed.
    :vartype services: list[~azure.mgmt.deploymentmanager.models.Service]
    """

    _validation = {
        'status': {'readonly': True},
        'total_retry_attempts': {'readonly': True},
        'operation_info': {'readonly': True},
        'services': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'total_retry_attempts': {'key': 'totalRetryAttempts', 'type': 'int'},
        'operation_info': {'key': 'operationInfo', 'type': 'RolloutOperationInfo'},
        'services': {'key': 'services', 'type': '[Service]'},
    }

    def __init__(self, **kwargs) -> None:
        super(RolloutPropertiesModel, self).__init__(**kwargs)
        self.status = None
        self.total_retry_attempts = None
        self.operation_info = None
        self.services = None
