# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class RolloutStep(Model):
    """Defines a specific step on a target service unit.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Name of the step.
    :type name: str
    :ivar status: Current state of the step.
    :vartype status: str
    :param step_group: The step group the current step is part of.
    :type step_group: str
    :ivar operation_info: Detailed information of specific action execution.
    :vartype operation_info:
     ~azure.mgmt.deploymentmanager.models.StepOperationInfo
    :ivar resource_operations: Set of resource operations that were performed,
     if any, on an Azure resource.
    :vartype resource_operations:
     list[~azure.mgmt.deploymentmanager.models.ResourceOperation]
    :ivar messages: Supplementary informative messages during rollout.
    :vartype messages: list[~azure.mgmt.deploymentmanager.models.Message]
    """

    _validation = {
        'name': {'required': True},
        'status': {'readonly': True},
        'operation_info': {'readonly': True},
        'resource_operations': {'readonly': True},
        'messages': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'step_group': {'key': 'stepGroup', 'type': 'str'},
        'operation_info': {'key': 'operationInfo', 'type': 'StepOperationInfo'},
        'resource_operations': {'key': 'resourceOperations', 'type': '[ResourceOperation]'},
        'messages': {'key': 'messages', 'type': '[Message]'},
    }

    def __init__(self, **kwargs):
        super(RolloutStep, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.status = None
        self.step_group = kwargs.get('step_group', None)
        self.operation_info = None
        self.resource_operations = None
        self.messages = None
