# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .tracked_resource import TrackedResource


class ServiceResource(TrackedResource):
    """The resource representation of a service in a service topology.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives
    :type location: str
    :param target_location: Required. The Azure location to which the
     resources in the service belong to or should be deployed to.
    :type target_location: str
    :param target_subscription_id: Required. The subscription to which the
     resources in the service belong to or should be deployed to.
    :type target_subscription_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'target_location': {'required': True},
        'target_subscription_id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'target_location': {'key': 'properties.targetLocation', 'type': 'str'},
        'target_subscription_id': {'key': 'properties.targetSubscriptionId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ServiceResource, self).__init__(**kwargs)
        self.target_location = kwargs.get('target_location', None)
        self.target_subscription_id = kwargs.get('target_subscription_id', None)
