# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ServiceUnitArtifacts(Model):
    """Defines the artifacts of a service unit.

    :param template_uri: The full URI of the ARM template file with the SAS
     token.
    :type template_uri: str
    :param parameters_uri: The full URI of the ARM parameters file with the
     SAS token.
    :type parameters_uri: str
    :param template_artifact_source_relative_path: The path to the ARM
     template file relative to the artifact source.
    :type template_artifact_source_relative_path: str
    :param parameters_artifact_source_relative_path: The path to the ARM
     parameters file relative to the artifact source.
    :type parameters_artifact_source_relative_path: str
    """

    _attribute_map = {
        'template_uri': {'key': 'templateUri', 'type': 'str'},
        'parameters_uri': {'key': 'parametersUri', 'type': 'str'},
        'template_artifact_source_relative_path': {'key': 'templateArtifactSourceRelativePath', 'type': 'str'},
        'parameters_artifact_source_relative_path': {'key': 'parametersArtifactSourceRelativePath', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ServiceUnitArtifacts, self).__init__(**kwargs)
        self.template_uri = kwargs.get('template_uri', None)
        self.parameters_uri = kwargs.get('parameters_uri', None)
        self.template_artifact_source_relative_path = kwargs.get('template_artifact_source_relative_path', None)
        self.parameters_artifact_source_relative_path = kwargs.get('parameters_artifact_source_relative_path', None)
