# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .sub_resource_py3 import SubResource


class FrontendEndpoint(SubResource):
    """A frontend endpoint used for routing.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param id: Resource ID.
    :type id: str
    :param host_name: The host name of the frontendEndpoint. Must be a domain
     name.
    :type host_name: str
    :param session_affinity_enabled_state: Whether to allow session affinity
     on this host. Valid options are 'Enabled' or 'Disabled'. Possible values
     include: 'Enabled', 'Disabled'
    :type session_affinity_enabled_state: str or
     ~azure.mgmt.frontdoor.models.SessionAffinityEnabledState
    :param session_affinity_ttl_seconds: UNUSED. This field will be ignored.
     The TTL to use in seconds for session affinity, if applicable.
    :type session_affinity_ttl_seconds: int
    :param web_application_firewall_policy_link: Defines the Web Application
     Firewall policy for each host (if applicable)
    :type web_application_firewall_policy_link:
     ~azure.mgmt.frontdoor.models.FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink
    :param resource_state: Resource status. Possible values include:
     'Creating', 'Enabling', 'Enabled', 'Disabling', 'Disabled', 'Deleting'
    :type resource_state: str or
     ~azure.mgmt.frontdoor.models.FrontDoorResourceState
    :ivar custom_https_provisioning_state: Provisioning status of Custom Https
     of the frontendEndpoint. Possible values include: 'Enabling', 'Enabled',
     'Disabling', 'Disabled', 'Failed'
    :vartype custom_https_provisioning_state: str or
     ~azure.mgmt.frontdoor.models.CustomHttpsProvisioningState
    :ivar custom_https_provisioning_substate: Provisioning substate shows the
     progress of custom HTTPS enabling/disabling process step by step. Possible
     values include: 'SubmittingDomainControlValidationRequest',
     'PendingDomainControlValidationREquestApproval',
     'DomainControlValidationRequestApproved',
     'DomainControlValidationRequestRejected',
     'DomainControlValidationRequestTimedOut', 'IssuingCertificate',
     'DeployingCertificate', 'CertificateDeployed', 'DeletingCertificate',
     'CertificateDeleted'
    :vartype custom_https_provisioning_substate: str or
     ~azure.mgmt.frontdoor.models.CustomHttpsProvisioningSubstate
    :ivar custom_https_configuration: The configuration specifying how to
     enable HTTPS
    :vartype custom_https_configuration:
     ~azure.mgmt.frontdoor.models.CustomHttpsConfiguration
    :param name: Resource name.
    :type name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'custom_https_provisioning_state': {'readonly': True},
        'custom_https_provisioning_substate': {'readonly': True},
        'custom_https_configuration': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'host_name': {'key': 'properties.hostName', 'type': 'str'},
        'session_affinity_enabled_state': {'key': 'properties.sessionAffinityEnabledState', 'type': 'str'},
        'session_affinity_ttl_seconds': {'key': 'properties.sessionAffinityTtlSeconds', 'type': 'int'},
        'web_application_firewall_policy_link': {'key': 'properties.webApplicationFirewallPolicyLink', 'type': 'FrontendEndpointUpdateParametersWebApplicationFirewallPolicyLink'},
        'resource_state': {'key': 'properties.resourceState', 'type': 'str'},
        'custom_https_provisioning_state': {'key': 'properties.customHttpsProvisioningState', 'type': 'str'},
        'custom_https_provisioning_substate': {'key': 'properties.customHttpsProvisioningSubstate', 'type': 'str'},
        'custom_https_configuration': {'key': 'properties.customHttpsConfiguration', 'type': 'CustomHttpsConfiguration'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, *, id: str=None, host_name: str=None, session_affinity_enabled_state=None, session_affinity_ttl_seconds: int=None, web_application_firewall_policy_link=None, resource_state=None, name: str=None, **kwargs) -> None:
        super(FrontendEndpoint, self).__init__(id=id, **kwargs)
        self.host_name = host_name
        self.session_affinity_enabled_state = session_affinity_enabled_state
        self.session_affinity_ttl_seconds = session_affinity_ttl_seconds
        self.web_application_firewall_policy_link = web_application_firewall_policy_link
        self.resource_state = resource_state
        self.custom_https_provisioning_state = None
        self.custom_https_provisioning_substate = None
        self.custom_https_configuration = None
        self.name = name
        self.type = None
