# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class MatchCondition1(Model):
    """Define match conditions.

    All required parameters must be populated in order to send to Azure.

    :param match_variable: Required. Match Variable. Possible values include:
     'RemoteAddr', 'RequestMethod', 'QueryString', 'PostArgs', 'RequestUri',
     'RequestHeader', 'RequestBody'
    :type match_variable: str or ~azure.mgmt.frontdoor.models.MatchCondition
    :param selector: Name of selector in RequestHeader or RequestBody to be
     matched
    :type selector: str
    :param operator: Required. Describes operator to be matched. Possible
     values include: 'Any', 'IPMatch', 'GeoMatch', 'Equal', 'Contains',
     'LessThan', 'GreaterThan', 'LessThanOrEqual', 'GreaterThanOrEqual',
     'BeginsWith', 'EndsWith'
    :type operator: str or ~azure.mgmt.frontdoor.models.Operator
    :param negate_condition: Describes if this is negate condition or not
    :type negate_condition: bool
    :param match_value: Required. Match value
    :type match_value: list[str]
    """

    _validation = {
        'match_variable': {'required': True},
        'operator': {'required': True},
        'match_value': {'required': True},
    }

    _attribute_map = {
        'match_variable': {'key': 'matchVariable', 'type': 'str'},
        'selector': {'key': 'selector', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'negate_condition': {'key': 'negateCondition', 'type': 'bool'},
        'match_value': {'key': 'matchValue', 'type': '[str]'},
    }

    def __init__(self, *, match_variable, operator, match_value, selector: str=None, negate_condition: bool=None, **kwargs) -> None:
        super(MatchCondition1, self).__init__(**kwargs)
        self.match_variable = match_variable
        self.selector = selector
        self.operator = operator
        self.negate_condition = negate_condition
        self.match_value = match_value
