# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class RoutingRuleUpdateParameters(Model):
    """Routing rules to apply to an endpoint.

    :param frontend_endpoints: Frontend endpoints associated with this rule
    :type frontend_endpoints: list[~azure.mgmt.frontdoor.models.SubResource]
    :param accepted_protocols: Protocol schemes to match for this rule
    :type accepted_protocols: list[str or
     ~azure.mgmt.frontdoor.models.FrontDoorProtocol]
    :param patterns_to_match: The route patterns of the rule.
    :type patterns_to_match: list[str]
    :param custom_forwarding_path: A custom path used to rewrite resource
     paths matched by this rule. Leave empty to use incoming path.
    :type custom_forwarding_path: str
    :param forwarding_protocol: Protocol this rule will use when forwarding
     traffic to backends. Possible values include: 'HttpOnly', 'HttpsOnly',
     'MatchRequest'
    :type forwarding_protocol: str or
     ~azure.mgmt.frontdoor.models.FrontDoorForwardingProtocol
    :param cache_configuration: The caching configuration associated with this
     rule.
    :type cache_configuration: ~azure.mgmt.frontdoor.models.CacheConfiguration
    :param backend_pool: A reference to the BackendPool which this rule routes
     to.
    :type backend_pool: ~azure.mgmt.frontdoor.models.SubResource
    :param enabled_state: Whether to enable use of this rule. Permitted values
     are 'Enabled' or 'Disabled'. Possible values include: 'Enabled',
     'Disabled'
    :type enabled_state: str or
     ~azure.mgmt.frontdoor.models.FrontDoorEnabledState
    """

    _attribute_map = {
        'frontend_endpoints': {'key': 'frontendEndpoints', 'type': '[SubResource]'},
        'accepted_protocols': {'key': 'acceptedProtocols', 'type': '[str]'},
        'patterns_to_match': {'key': 'patternsToMatch', 'type': '[str]'},
        'custom_forwarding_path': {'key': 'customForwardingPath', 'type': 'str'},
        'forwarding_protocol': {'key': 'forwardingProtocol', 'type': 'str'},
        'cache_configuration': {'key': 'cacheConfiguration', 'type': 'CacheConfiguration'},
        'backend_pool': {'key': 'backendPool', 'type': 'SubResource'},
        'enabled_state': {'key': 'enabledState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(RoutingRuleUpdateParameters, self).__init__(**kwargs)
        self.frontend_endpoints = kwargs.get('frontend_endpoints', None)
        self.accepted_protocols = kwargs.get('accepted_protocols', None)
        self.patterns_to_match = kwargs.get('patterns_to_match', None)
        self.custom_forwarding_path = kwargs.get('custom_forwarding_path', None)
        self.forwarding_protocol = kwargs.get('forwarding_protocol', None)
        self.cache_configuration = kwargs.get('cache_configuration', None)
        self.backend_pool = kwargs.get('backend_pool', None)
        self.enabled_state = kwargs.get('enabled_state', None)
