# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ContentKeyPolicyPlayReadyPlayRight(Model):
    """Configures the Play Right in the PlayReady license.

    All required parameters must be populated in order to send to Azure.

    :param first_play_expiration: The amount of time that the license is valid
     after the license is first used to play content.
    :type first_play_expiration: timedelta
    :param scms_restriction: Configures the Serial Copy Management System
     (SCMS) in the license. Must be between 0 and 3 inclusive.
    :type scms_restriction: int
    :param agc_and_color_stripe_restriction: Configures Automatic Gain Control
     (AGC) and Color Stripe in the license. Must be between 0 and 3 inclusive.
    :type agc_and_color_stripe_restriction: int
    :param explicit_analog_television_output_restriction: Configures the
     Explicit Analog Television Output Restriction in the license.
     Configuration data must be between 0 and 3 inclusive.
    :type explicit_analog_television_output_restriction:
     ~azure.mgmt.media.models.ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction
    :param digital_video_only_content_restriction: Required. Enables the Image
     Constraint For Analog Component Video Restriction in the license.
    :type digital_video_only_content_restriction: bool
    :param image_constraint_for_analog_component_video_restriction: Required.
     Enables the Image Constraint For Analog Component Video Restriction in the
     license.
    :type image_constraint_for_analog_component_video_restriction: bool
    :param image_constraint_for_analog_computer_monitor_restriction: Required.
     Enables the Image Constraint For Analog Component Video Restriction in the
     license.
    :type image_constraint_for_analog_computer_monitor_restriction: bool
    :param allow_passing_video_content_to_unknown_output: Required. Configures
     Unknown output handling settings of the license. Possible values include:
     'Unknown', 'NotAllowed', 'Allowed', 'AllowedWithVideoConstriction'
    :type allow_passing_video_content_to_unknown_output: str or
     ~azure.mgmt.media.models.ContentKeyPolicyPlayReadyUnknownOutputPassingOption
    :param uncompressed_digital_video_opl: Specifies the output protection
     level for uncompressed digital video.
    :type uncompressed_digital_video_opl: int
    :param compressed_digital_video_opl: Specifies the output protection level
     for compressed digital video.
    :type compressed_digital_video_opl: int
    :param analog_video_opl: Specifies the output protection level for
     compressed digital audio.
    :type analog_video_opl: int
    :param compressed_digital_audio_opl: Specifies the output protection level
     for compressed digital audio.
    :type compressed_digital_audio_opl: int
    :param uncompressed_digital_audio_opl: Specifies the output protection
     level for uncompressed digital audio.
    :type uncompressed_digital_audio_opl: int
    """

    _validation = {
        'digital_video_only_content_restriction': {'required': True},
        'image_constraint_for_analog_component_video_restriction': {'required': True},
        'image_constraint_for_analog_computer_monitor_restriction': {'required': True},
        'allow_passing_video_content_to_unknown_output': {'required': True},
    }

    _attribute_map = {
        'first_play_expiration': {'key': 'firstPlayExpiration', 'type': 'duration'},
        'scms_restriction': {'key': 'scmsRestriction', 'type': 'int'},
        'agc_and_color_stripe_restriction': {'key': 'agcAndColorStripeRestriction', 'type': 'int'},
        'explicit_analog_television_output_restriction': {'key': 'explicitAnalogTelevisionOutputRestriction', 'type': 'ContentKeyPolicyPlayReadyExplicitAnalogTelevisionRestriction'},
        'digital_video_only_content_restriction': {'key': 'digitalVideoOnlyContentRestriction', 'type': 'bool'},
        'image_constraint_for_analog_component_video_restriction': {'key': 'imageConstraintForAnalogComponentVideoRestriction', 'type': 'bool'},
        'image_constraint_for_analog_computer_monitor_restriction': {'key': 'imageConstraintForAnalogComputerMonitorRestriction', 'type': 'bool'},
        'allow_passing_video_content_to_unknown_output': {'key': 'allowPassingVideoContentToUnknownOutput', 'type': 'str'},
        'uncompressed_digital_video_opl': {'key': 'uncompressedDigitalVideoOpl', 'type': 'int'},
        'compressed_digital_video_opl': {'key': 'compressedDigitalVideoOpl', 'type': 'int'},
        'analog_video_opl': {'key': 'analogVideoOpl', 'type': 'int'},
        'compressed_digital_audio_opl': {'key': 'compressedDigitalAudioOpl', 'type': 'int'},
        'uncompressed_digital_audio_opl': {'key': 'uncompressedDigitalAudioOpl', 'type': 'int'},
    }

    def __init__(self, *, digital_video_only_content_restriction: bool, image_constraint_for_analog_component_video_restriction: bool, image_constraint_for_analog_computer_monitor_restriction: bool, allow_passing_video_content_to_unknown_output, first_play_expiration=None, scms_restriction: int=None, agc_and_color_stripe_restriction: int=None, explicit_analog_television_output_restriction=None, uncompressed_digital_video_opl: int=None, compressed_digital_video_opl: int=None, analog_video_opl: int=None, compressed_digital_audio_opl: int=None, uncompressed_digital_audio_opl: int=None, **kwargs) -> None:
        super(ContentKeyPolicyPlayReadyPlayRight, self).__init__(**kwargs)
        self.first_play_expiration = first_play_expiration
        self.scms_restriction = scms_restriction
        self.agc_and_color_stripe_restriction = agc_and_color_stripe_restriction
        self.explicit_analog_television_output_restriction = explicit_analog_television_output_restriction
        self.digital_video_only_content_restriction = digital_video_only_content_restriction
        self.image_constraint_for_analog_component_video_restriction = image_constraint_for_analog_component_video_restriction
        self.image_constraint_for_analog_computer_monitor_restriction = image_constraint_for_analog_computer_monitor_restriction
        self.allow_passing_video_content_to_unknown_output = allow_passing_video_content_to_unknown_output
        self.uncompressed_digital_video_opl = uncompressed_digital_video_opl
        self.compressed_digital_video_opl = compressed_digital_video_opl
        self.analog_video_opl = analog_video_opl
        self.compressed_digital_audio_opl = compressed_digital_audio_opl
        self.uncompressed_digital_audio_opl = uncompressed_digital_audio_opl
