# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class StreamingLocatorContentKey(Model):
    """Class for content key in Streaming Locator.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. ID of Content Key
    :type id: str
    :ivar type: Encryption type of Content Key. Possible values include:
     'CommonEncryptionCenc', 'CommonEncryptionCbcs', 'EnvelopeEncryption'
    :vartype type: str or
     ~azure.mgmt.media.models.StreamingLocatorContentKeyType
    :param label_reference_in_streaming_policy: Label of Content Key as
     specified in the Streaming Policy
    :type label_reference_in_streaming_policy: str
    :param value: Value of Content Key
    :type value: str
    :ivar policy_name: ContentKeyPolicy used by Content Key
    :vartype policy_name: str
    :ivar tracks: Tracks which use this Content Key
    :vartype tracks: list[~azure.mgmt.media.models.TrackSelection]
    """

    _validation = {
        'id': {'required': True},
        'type': {'readonly': True},
        'policy_name': {'readonly': True},
        'tracks': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'label_reference_in_streaming_policy': {'key': 'labelReferenceInStreamingPolicy', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
        'policy_name': {'key': 'policyName', 'type': 'str'},
        'tracks': {'key': 'tracks', 'type': '[TrackSelection]'},
    }

    def __init__(self, *, id: str, label_reference_in_streaming_policy: str=None, value: str=None, **kwargs) -> None:
        super(StreamingLocatorContentKey, self).__init__(**kwargs)
        self.id = id
        self.type = None
        self.label_reference_in_streaming_policy = label_reference_in_streaming_policy
        self.value = value
        self.policy_name = None
        self.tracks = None
