# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .action import Action


class AlertingAction(Action):
    """Specify action need to be taken when rule type is Alert.

    All required parameters must be populated in order to send to Azure.

    :param odatatype: Required. Constant filled by server.
    :type odatatype: str
    :param severity: Required. Severity of the alert. Possible values include:
     '0', '1', '2', '3', '4'
    :type severity: str or ~azure.mgmt.monitor.models.AlertSeverity
    :param azns_action: Azure action group reference.
    :type azns_action: ~azure.mgmt.monitor.models.AzNsActionGroup
    :param throttling_in_min: time (in minutes) for which Alerts should be
     throttled or suppressed.
    :type throttling_in_min: int
    :param trigger: Required. The trigger condition that results in the alert
     rule being.
    :type trigger: ~azure.mgmt.monitor.models.TriggerCondition
    """

    _validation = {
        'odatatype': {'required': True},
        'severity': {'required': True},
        'trigger': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': 'odata\\.type', 'type': 'str'},
        'severity': {'key': 'severity', 'type': 'str'},
        'azns_action': {'key': 'aznsAction', 'type': 'AzNsActionGroup'},
        'throttling_in_min': {'key': 'throttlingInMin', 'type': 'int'},
        'trigger': {'key': 'trigger', 'type': 'TriggerCondition'},
    }

    def __init__(self, **kwargs):
        super(AlertingAction, self).__init__(**kwargs)
        self.severity = kwargs.get('severity', None)
        self.azns_action = kwargs.get('azns_action', None)
        self.throttling_in_min = kwargs.get('throttling_in_min', None)
        self.trigger = kwargs.get('trigger', None)
        self.odatatype = 'Microsoft.WindowsAzure.Management.Monitoring.Alerts.Models.Microsoft.AppInsights.Nexus.DataContracts.Resources.ScheduledQueryRules.AlertingAction'
