# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .multi_metric_criteria_py3 import MultiMetricCriteria


class MetricCriteria(MultiMetricCriteria):
    """Criterion to filter metrics.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param criterion_type: Required. Constant filled by server.
    :type criterion_type: str
    :param name: Required. Name of the criteria.
    :type name: str
    :param metric_name: Required. Name of the metric.
    :type metric_name: str
    :param metric_namespace: Namespace of the metric.
    :type metric_namespace: str
    :param operator: Required. the criteria operator.
    :type operator: object
    :param time_aggregation: Required. the criteria time aggregation types.
    :type time_aggregation: object
    :param threshold: Required. the criteria threshold value that activates
     the alert.
    :type threshold: float
    :param dimensions: List of dimension conditions.
    :type dimensions: list[~azure.mgmt.monitor.models.MetricDimension]
    """

    _validation = {
        'criterion_type': {'required': True},
        'name': {'required': True},
        'metric_name': {'required': True},
        'operator': {'required': True},
        'time_aggregation': {'required': True},
        'threshold': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'criterion_type': {'key': 'criterionType', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'metric_name': {'key': 'metricName', 'type': 'str'},
        'metric_namespace': {'key': 'metricNamespace', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'object'},
        'time_aggregation': {'key': 'timeAggregation', 'type': 'object'},
        'threshold': {'key': 'threshold', 'type': 'float'},
        'dimensions': {'key': 'dimensions', 'type': '[MetricDimension]'},
    }

    def __init__(self, *, name: str, metric_name: str, operator, time_aggregation, threshold: float, additional_properties=None, metric_namespace: str=None, dimensions=None, **kwargs) -> None:
        super(MetricCriteria, self).__init__(additional_properties=additional_properties, **kwargs)
        self.name = name
        self.metric_name = metric_name
        self.metric_namespace = metric_namespace
        self.operator = operator
        self.time_aggregation = time_aggregation
        self.threshold = threshold
        self.dimensions = dimensions
        self.criterion_type = 'StaticThresholdCriterion'
