# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ActiveDirectory(Model):
    """Active Directory.

    :param active_directory_id: Id of the Active Directory
    :type active_directory_id: str
    :param username: Username of Active Directory domain administrator
    :type username: str
    :param password: Plain text password of Active Directory domain
     administrator
    :type password: str
    :param domain: Name of the Active Directory domain
    :type domain: str
    :param d_ns: Comma separated list of DNS server IP addresses for the
     Active Directory domain
    :type d_ns: str
    :param status: Status of the Active Directory
    :type status: str
    :param s_mb_server_name: NetBIOS name of the SMB server. This name will be
     registered as a computer account in the AD and used to mount volumes
    :type s_mb_server_name: str
    :param organizational_unit: The Organizational Unit (OU) within the
     Windows Active Directory
    :type organizational_unit: str
    """

    _attribute_map = {
        'active_directory_id': {'key': 'activeDirectoryId', 'type': 'str'},
        'username': {'key': 'username', 'type': 'str'},
        'password': {'key': 'password', 'type': 'str'},
        'domain': {'key': 'domain', 'type': 'str'},
        'd_ns': {'key': 'dNS', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        's_mb_server_name': {'key': 'sMBServerName', 'type': 'str'},
        'organizational_unit': {'key': 'organizationalUnit', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ActiveDirectory, self).__init__(**kwargs)
        self.active_directory_id = kwargs.get('active_directory_id', None)
        self.username = kwargs.get('username', None)
        self.password = kwargs.get('password', None)
        self.domain = kwargs.get('domain', None)
        self.d_ns = kwargs.get('d_ns', None)
        self.status = kwargs.get('status', None)
        self.s_mb_server_name = kwargs.get('s_mb_server_name', None)
        self.organizational_unit = kwargs.get('organizational_unit', None)
